/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.data;

import com.nxp.s32ds.cle.cdt.memory.spaces.base.MemorySpace;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class MemorySpaceLabelProvider
extends ColumnLabelProvider {
    private static final String FORMAT_ENABLED = "%s::%s::%s<0x%s>";
    private static final String FORMAT_DISABLED = "%s::%s::%s::Disabled";

    public String getText(Object element) {
        MemorySpace space = this.adapt(element);
        if (space != null) {
            if (space.isEnabled()) {
                return String.format(FORMAT_ENABLED, space.getDevice(), space.getCore(), space.getName(), space.getBaseAddress().toString(16));
            }
            return String.format(FORMAT_DISABLED, space.getDevice(), space.getCore(), space.getName());
        }
        return "";
    }

    private MemorySpace adapt(Object element) {
        if (element instanceof MemorySpace) {
            return (MemorySpace)element;
        }
        return null;
    }

    public Image getImage(Object element) {
        MemorySpace space = this.adapt(element);
        if (space != null) {
            if (space.isEnabled()) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_SYNCED");
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_SYNCED_DISABLED");
        }
        return null;
    }
}

