/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.integration.ddr;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.ddr.controller.DDRController;
import com.nxp.swtools.ddr.controller.DDRControllerWrapper;
import com.nxp.swtools.ddr.controller.DDRGuiController;
import com.nxp.swtools.ddr.model.DDRDataModel;
import com.nxp.swtools.ddr.report.DDRSummaryGenerator;
import com.nxp.swtools.expert.processordb.ExternalMcuDataHelper;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.IComponentInfo;
import com.nxp.swtools.mem.validation.IConfigProvider;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.integration.ddr.Messages;
import com.nxp.swtools.mem.validation.model.VModel;
import com.nxp.swtools.mem.validation.utils.PythonProcessUtilities;
import com.nxp.swtools.periphs.controller.APeriphController;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.resourcetables.model.config.AStructuredSettingConfig;
import com.nxp.swtools.resourcetables.model.config.ChildContext;
import com.nxp.swtools.resourcetables.model.config.ChildProviderHelper;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IConfigSetConfig;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.config.IStructuredSettingConfig;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.resourcetables.model.data.setting.ABaseModel;
import com.nxp.swtools.resourcetables.model.data.setting.SetSetting;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.utils.registers.RegisterInfo;
import com.nxp.swtools.utils.resources.DataDirectoryUtils;
import com.nxp.swtools.utils.scripting.api.IMcuInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.json.JSONException;
import org.json.JSONObject;

public class MemValDDRConfigProvider
implements IConfigProvider {
    private static final Logger LOGGER = LogManager.getLogger(MemValDDRConfigProvider.class);
    private static final String DDRC_COMPONENT_TYPE = "ddrc";
    final IControllerWrapper ddrControllerWrapper = DDRControllerWrapper.getInstance();
    @Nullable
    private IEventListener dataModelChangeListener;
    @Nullable
    private IEventListener settingChangeListener;

    public MemValDDRConfigProvider() {
        DDRController.getInstance().addListener(2048, event -> this.searchForCustomItems());
        DDRController.getInstance().addListener(4096, event -> MemValDDRConfigProvider.executePhyInitProcess());
        if (IConfigProvider.getConfigProviders().length > 1) {
            DDRController.getInstance().addListener(1, event -> ValidationContext.getInstance().setConfigController((IConfigProvider)this));
        }
    }

    public IComponentInfo getComponentInfo() {
        return new IComponentInfo(){

            public String getType() {
                CollectionsUtils.Pair currentComp;
                APeriphController controller = MemValDDRConfigProvider.this.ddrControllerWrapper.getController();
                if (controller instanceof DDRController && (currentComp = ((DDRController)controller).getDataModel().getCurrentComponent()) != null) {
                    return ((IComponentInstanceConfig)currentComp.getSecond()).getType();
                }
                return "";
            }

            public String getComponentId() {
                CollectionsUtils.Pair currentComp;
                APeriphController controller = MemValDDRConfigProvider.this.ddrControllerWrapper.getController();
                if (controller instanceof DDRController && (currentComp = ((DDRController)controller).getDataModel().getCurrentComponent()) != null) {
                    return ((IComponentInstanceConfig)currentComp.getSecond()).getComponentId();
                }
                return "";
            }

            public boolean isControllerInitializationRequired() {
                return true;
            }

            public String getName() {
                CollectionsUtils.Pair currentComp;
                APeriphController controller = MemValDDRConfigProvider.this.ddrControllerWrapper.getController();
                if (controller instanceof DDRController && (currentComp = ((DDRController)controller).getDataModel().getCurrentComponent()) != null) {
                    return ((IComponentInstanceConfig)currentComp.getSecond()).getName();
                }
                return "";
            }

            public boolean schemaVersionOlderThan(String textVersion) {
                CollectionsUtils.Pair currentComp;
                APeriphController controller = MemValDDRConfigProvider.this.ddrControllerWrapper.getController();
                if (controller instanceof DDRController && (currentComp = ((DDRController)controller).getDataModel().getCurrentComponent()) != null) {
                    return ((IComponentInstanceConfig)currentComp.getSecond()).getComponent().schemaVersionOlderThan(textVersion);
                }
                return false;
            }
        };
    }

    public String getConfigDataPath() {
        IMcuIdentification mcuIdent = SharedConfigurationFactory.getSharedConfigurationSingleton().getCommonConfig().getMcuIdentification();
        String dbFile = DataDirectoryUtils.getDbFile((IMcuIdentification)mcuIdent, (String)"validation_scripts");
        String dataDir = ExternalMcuDataHelper.getInstance().getExternalMcuDataDir(mcuIdent.getMcu(), mcuIdent.getSdkVersion(), "DDR");
        return dbFile.isEmpty() ? "" : String.valueOf(dataDir) + File.separator + dbFile + MemValDDRConfigProvider.getComponentType();
    }

    private static String getComponentType() {
        return SwToolsProduct.isUctProduct() ? "" : String.valueOf(File.separator) + DDRC_COMPONENT_TYPE;
    }

    public Map<String, String> getConfiguration(String configName) {
        CollectionsUtils.Pair currentComp;
        HashMap<String, String> map = new HashMap<String, String>();
        APeriphController controller = this.ddrControllerWrapper.getController();
        if (controller instanceof DDRController && (currentComp = ((DDRController)controller).getDataModel().getCurrentComponent()) != null) {
            List configSets = ((IComponentInstanceConfig)currentComp.getSecond()).getChildren();
            for (IConfigSetConfig cfgSet : configSets) {
                List settings = cfgSet.getChildren();
                for (ISettingConfig setting : settings) {
                    if (!(setting instanceof AStructuredSettingConfig)) continue;
                    List innerSettings = ChildProviderHelper.getAllSettings((IStructuredSettingConfig)((AStructuredSettingConfig)setting));
                    for (ISettingConfig innerSetting : innerSettings) {
                        String value = innerSetting.getValue().toString();
                        map.put(innerSetting.getName(), value);
                    }
                }
            }
        }
        return map;
    }

    public IMcuInfo getMCUInfo() {
        return this.ddrControllerWrapper.getController().getMcu();
    }

    private @Nullable IChild getPropertyNode(String id) {
        APeriphController controller = this.ddrControllerWrapper.getController();
        if (controller instanceof DDRController) {
            CollectionsUtils.Pair currentComp = ((DDRController)controller).getDataModel().getCurrentComponent();
            IComponentInstanceConfig component = null;
            if (currentComp != null) {
                component = (IComponentInstanceConfig)currentComp.getSecond();
            }
            if (component == null) {
                return null;
            }
            Optional anyConf = component.getConfigSets().values().stream().findAny();
            if (anyConf.isPresent()) {
                IConfigSetConfig configSetConfig = (IConfigSetConfig)anyConf.get();
                return ChildProviderHelper.getChild((ChildContext)configSetConfig.getChildContext(), (String)id);
            }
        }
        return null;
    }

    public List<@Nullable String> getPropertyRange(String id) {
        IChild propertyNode;
        APeriphController controller = this.ddrControllerWrapper.getController();
        if (controller instanceof DDRController && (propertyNode = this.getPropertyNode(id)) instanceof ScalarConfig && ((ScalarConfig)propertyNode).getType().equals((Object)ScalarConfig.Type.ENUM)) {
            List enumItems = ((ScalarConfig)propertyNode).getEnumItems();
            return (List)enumItems.stream().map(ABaseModel::getId).collect(CollectorsUtils.toList());
        }
        return new ArrayList<String>();
    }

    public @Nullable String getPropertyValue(String componentId, String id) {
        APeriphController controller = this.ddrControllerWrapper.getController();
        if (controller instanceof DDRController) {
            return ((DDRController)controller).getDataModel().getValueOf(componentId, id);
        }
        return null;
    }

    public @Nullable String getPropertyValueId(String id) {
        APeriphController controller = this.ddrControllerWrapper.getController();
        if (controller instanceof DDRController) {
            if (id.startsWith("register.ddrc.")) {
                return ((DDRController)controller).getDataModel().getRegisterData(id);
            }
            IChild propertyNode = this.getPropertyNode(id);
            if (propertyNode instanceof ScalarConfig) {
                return propertyNode.getValue().toString();
            }
        }
        return null;
    }

    public @Nullable String getPropertyEnumId(String id) {
        APeriphController controller = this.ddrControllerWrapper.getController();
        if (id.startsWith("register.ddrc.")) {
            return ((DDRController)controller).getDataModel().getRegisterData(id);
        }
        IChild propertyNode = this.getPropertyNode(id);
        if (propertyNode instanceof ScalarConfig) {
            if (((ScalarConfig)propertyNode).getType().equals((Object)ScalarConfig.Type.ENUM)) {
                for (SetSetting.Item enumItem : ((ScalarConfig)propertyNode).getEnumItems()) {
                    if (!propertyNode.getValue().toString().equals(enumItem.getId())) continue;
                    return enumItem.getId();
                }
            }
            return propertyNode.getValue().toString();
        }
        return null;
    }

    public List<Long[]> getDdrcConfigSeq() {
        APeriphController controller = this.ddrControllerWrapper.getController();
        if (controller instanceof DDRController) {
            return ((DDRController)controller).getDataModel().getDdrcConfigSeq();
        }
        return new ArrayList<Long[]>();
    }

    public boolean isEnabled() {
        APeriphController controller = this.ddrControllerWrapper.getController();
        if (controller instanceof DDRController) {
            return ((DDRController)controller).isOn() && !this.getConfigDataPath().isEmpty();
        }
        return false;
    }

    public void performBulkChange(Map<String, String> config) {
    }

    public void removeDataChangeListener() {
        IEventListener dataModelChangeListenerLoc = this.dataModelChangeListener;
        if (dataModelChangeListenerLoc != null) {
            this.ddrControllerWrapper.getController().removeListener(dataModelChangeListenerLoc);
        }
    }

    public void setDataChangeListener(IEventListener dataModelChangeListener) {
        this.dataModelChangeListener = dataModelChangeListener;
        int eventMask = 192;
        eventMask |= SwToolsProduct.isUctProduct() ? 256 : 4;
        if (IConfigProvider.getConfigProviders().length > 1) {
            eventMask |= 1;
        }
        this.ddrControllerWrapper.getController().addListener(eventMask, dataModelChangeListener);
    }

    public void removeSettingChangeListener() {
        IEventListener settingChangeListenerLoc = this.settingChangeListener;
        if (settingChangeListenerLoc != null) {
            this.ddrControllerWrapper.getController().removeListener(settingChangeListenerLoc);
        }
    }

    public void addSettingChangeListener(IEventListener settingChangeListener) {
        this.settingChangeListener = settingChangeListener;
        int eventMask = 32;
        this.ddrControllerWrapper.getController().addListener(eventMask, settingChangeListener);
    }

    public void updatePropertyValue(String name, String value, boolean handleChanges, boolean genCode) {
        IChild child;
        APeriphController controller = this.ddrControllerWrapper.getController();
        if (controller instanceof DDRController && (child = this.getPropertyNode(name)) instanceof ScalarConfig) {
            ((DDRController)controller).setValue((ScalarConfig)child, value, handleChanges, (Object)this);
            if (genCode) {
                ((DDRController)controller).fireListeners(new ToolEvent.Builder(32).setOriginator((Object)controller).build());
            }
        }
    }

    public List<String> getConfiguredComponentInstances() {
        APeriphController controller = this.ddrControllerWrapper.getController();
        if (controller instanceof DDRController) {
            return ((DDRController)controller).getDataModel().getAvailableComponents().keySet().stream().collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public @Nullable IComponentInstanceConfig getInstance(String name) {
        APeriphController controller = this.ddrControllerWrapper.getController();
        if (controller instanceof DDRController) {
            return (IComponentInstanceConfig)((DDRController)controller).getDataModel().getAvailableComponents().get(name);
        }
        return null;
    }

    public String getCurrentInstanceName() {
        CollectionsUtils.Pair currentComponent = DDRController.getInstance().getDataModel().getCurrentComponent();
        if (currentComponent != null) {
            return (String)currentComponent.getFirst();
        }
        return "";
    }

    public void refreshSourcesView() {
        DDRGuiController.getInstance().refreshSourceCodeView();
    }

    public @Nullable File getResourceFile(String fileName) {
        return DDRController.getInstance().getFileProvider().findScriptFile(fileName);
    }

    public @Nullable Map<String, RegisterInfo> getRegisters() {
        APeriphController controller = this.ddrControllerWrapper.getController();
        if (controller instanceof DDRController) {
            return ((DDRController)controller).getDataModel().getDdrRegisters();
        }
        return null;
    }

    public @NonNull IControllerWrapper getControllerWrapper() {
        return this.ddrControllerWrapper;
    }

    public byte[] getBinaryFileContent(String fileName) {
        File file = this.getResourceFile(fileName);
        if (file == null) {
            LOGGER.severe("Could not find the file:" + fileName + " in getBinaryFileContent()");
        } else if (file.exists()) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream fileContent = UtilsDecryption.getFileInputStream((File)file);){
                    int fileSize = (int)file.length();
                    byte[] bytesRead = new byte[fileSize];
                    int bytesNo = fileContent.read(bytesRead);
                    if (bytesNo != -1) {
                        return bytesRead;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOGGER.severe("Error while reading the file:" + file.getName() + e.getMessage());
            }
        } else {
            LOGGER.severe("The required file doesn't exists:" + file.getName());
        }
        return new byte[0];
    }

    public @NonNull String getConfigurationReport() {
        return DDRController.getInstance().getDataModel().getDdrHtmlReport();
    }

    public @NonNull String getCurrentDdrType() {
        return DDRSummaryGenerator.getCurrentDdrType();
    }

    public String getPerspectiveId() {
        return "com.nxp.swtools.ddr.perspective";
    }

    public void customPostValidationApplySelection(String parametersFilePath) {
        APeriphController controller = this.ddrControllerWrapper.getController();
        if (controller instanceof DDRController) {
            DDRController ddrController = (DDRController)controller;
            if (!ddrController.isOn() || ddrController.getDataModel().getAvailableComponents().isEmpty()) {
                return;
            }
            if (!Files.exists(Paths.get(parametersFilePath, new String[0]), new LinkOption[0])) {
                return;
            }
            String buffer = UtilsFile.readFileToString((String)parametersFilePath, (Charset)StandardCharsets.UTF_8, (String)UtilsText.platformEOL);
            if (buffer == null) {
                return;
            }
            try {
                JSONObject jsonObject = new JSONObject(buffer);
                Iterator iterator = jsonObject.keys();
                while (iterator.hasNext()) {
                    String attribute = String.valueOf(iterator.next());
                    String value = String.valueOf(jsonObject.get(attribute));
                    this.updatePropertyValue(attribute, value, false, false);
                }
                ddrController.fireListeners(new ToolEvent.Builder(32).setOriginator((Object)this).build());
            }
            catch (JSONException e) {
                LOGGER.severe("VREF info could not be applied due to error: " + e.getLocalizedMessage());
            }
        }
    }

    public String getReportLabel() {
        return Messages.ReportLabel;
    }

    public String getReportFileDialogTitle() {
        return Messages.ReportFileDialogTitle;
    }

    public String getFileReportName() {
        return Messages.DefaultFileReportName;
    }

    public Map<String, String> getPythonEnv() {
        return DDRController.getInstance().getDataModel().getPythonEnv();
    }

    private void searchForCustomItems() {
        VModel vModel = this.getVModel();
        if (vModel != null) {
            DDRDataModel dataModel = DDRController.getInstance().getDataModel();
            String generateCodeOption = vModel.getCustomOption("generate_code_option");
            String advancedModeOption = vModel.getCustomOption("advanced_mode_option");
            if (generateCodeOption != null) {
                dataModel.setGenerateItemPresent(Boolean.parseBoolean(generateCodeOption));
            }
            if (advancedModeOption != null) {
                dataModel.setAdvancedItemPresent(Boolean.parseBoolean(advancedModeOption));
            }
        }
    }

    private static void executePhyInitProcess() {
        String logFilePathStr = String.valueOf(Activator.getDefault().getConfigManager().getLogsFolder()) + File.separator + "phyinit_results.log";
        PythonProcessUtilities.createLogFile((String)logFilePathStr);
        PythonProcessUtilities.executePhyInitProcess();
    }
}

