/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.controller.application;

import com.nxp.swtools.common.utils.cmd.CmdSection;
import com.nxp.swtools.common.utils.cmd.ICmdApplication;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.efuse.controller.EfuseController;
import com.nxp.swtools.efuse.controller.report.EFuseSummaryGenerator;
import com.nxp.swtools.efuse.controller.utils.EfuseControllerUtils;
import com.nxp.swtools.efuse.xml.settings.HeaderSetting;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Set;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EfuseCmdApplication
implements ICmdApplication {
    private static final Logger LOGGER = LogManager.getLogger(EfuseCmdApplication.class);

    public boolean run(CmdSection cmdSection) {
        boolean result = true;
        Set keys = cmdSection.cmdMap.keySet();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            String operation;
            switch (operation = (String)iterator.next()) {
                case "-ExportConfig": {
                    HeaderSetting header;
                    String path = cmdSection.getOptionValue("-ExportConfig");
                    if (cmdSection.hasOption("-serial_boot") && (header = EfuseController.getInstance().getEfuseXmlConfig().getSerialBootHeader()) != null) {
                        header.setDisable(false);
                    }
                    if (path.isEmpty()) break;
                    result = EfuseCmdApplication.exportEfuseBinaryConfiguration(path);
                    if (result) {
                        LOGGER.info("[TOOL] Export of eFUSE binary configuration was completed successfully");
                        break;
                    }
                    LOGGER.severe("[TOOL] Export of eFUSE binary configuration failed");
                    break;
                }
                case "-ExportELF": {
                    String path = cmdSection.getOptionValue("-ExportELF");
                    if (path.isEmpty()) break;
                    result = EfuseCmdApplication.exportEfuseELFConfiguration(path);
                    if (result) {
                        LOGGER.info("[TOOL] Export of eFUSE ELF configuration was completed successfully");
                        break;
                    }
                    LOGGER.severe("[TOOL] Export of eFUSE ELF configuration failed");
                }
            }
        }
        return result;
    }

    private static boolean exportEfuseBinaryConfiguration(String path) {
        LOGGER.info("[TOOL] Exporting eFuse Binary Configuration ...");
        if (EfuseController.getInstance().getProblemsManager().hasEfuseToolErrors()) {
            LOGGER.log(Level.SEVERE, "[TOOL] Current configuration has errors! Only a valid configuration can be exported.");
            return false;
        }
        File selectedPath = new File(path);
        String pathToExport = "";
        if (selectedPath.exists() && selectedPath.isDirectory()) {
            pathToExport = String.valueOf(selectedPath.getAbsolutePath()) + File.separator + "eFuseBinary";
            return EfuseCmdApplication.writeEfuseBinaryConfigurationFile(pathToExport);
        }
        try {
            if ((selectedPath.exists() && selectedPath.isFile() || selectedPath.createNewFile()) && (pathToExport = selectedPath.getAbsolutePath()) != null) {
                return EfuseCmdApplication.writeEfuseBinaryConfigurationFile(pathToExport);
            }
        }
        catch (IOException exception) {
            LOGGER.log(Level.SEVERE, "[TOOL] Error while creating a new file during the eFUSE configuration export", exception);
        }
        return false;
    }

    private static boolean writeEfuseBinaryConfigurationFile(String selectedPath) {
        block24: {
            Object var4_8;
            File eFuseBinFile = new File(selectedPath);
            String htmlReportPath = UtilsText.safeString((String)new StringJoiner(File.separator).add(selectedPath.substring(0, selectedPath.lastIndexOf(File.separator))).add("efuse_report.html").toString());
            try {
                Throwable throwable = null;
                var4_8 = null;
                try (FileOutputStream htmlReportStream = new FileOutputStream(htmlReportPath);){
                    htmlReportStream.write(EFuseSummaryGenerator.getReportConfiguration().getBytes(Charset.forName("UTF-8")));
                    htmlReportStream.flush();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException err2) {
                LOGGER.log(Level.SEVERE, "[TOOL] Error while writing eFUSE HTML report file", err2);
            }
            Throwable err2 = null;
            var4_8 = null;
            FileOutputStream outputStream = new FileOutputStream(eFuseBinFile);
            try {
                outputStream.write(EfuseControllerUtils.getEfuseBinaryContent());
                outputStream.flush();
                if (outputStream == null) break block24;
            }
            catch (Throwable err2) {
                try {
                    try {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                        throw err2;
                    }
                    catch (Throwable throwable) {
                        if (err2 == null) {
                            err2 = throwable;
                        } else if (err2 != throwable) {
                            err2.addSuppressed(throwable);
                        }
                        throw err2;
                    }
                }
                catch (IOException err3) {
                    LOGGER.log(Level.SEVERE, "[TOOL] Error while writing eFUSE configuration binary file", err3);
                    return false;
                }
            }
            outputStream.close();
        }
        return true;
    }

    private static boolean exportEfuseELFConfiguration(String path) {
        LOGGER.info("[TOOL] Exporting eFuse ELF Configuration ...");
        if (EfuseController.getInstance().getProblemsManager().hasEfuseToolErrors()) {
            LOGGER.log(Level.SEVERE, "[TOOL] Current configuration has errors! Only a valid configuration can be exported.");
            return false;
        }
        File selectedPath = new File(path);
        String pathToExport = "";
        if (selectedPath.exists() && selectedPath.isDirectory()) {
            pathToExport = String.valueOf(selectedPath.getAbsolutePath()) + File.separator + "eFuseELF";
            return EfuseCmdApplication.writeEfuseELFConfigurationFile(pathToExport);
        }
        try {
            if ((selectedPath.exists() && selectedPath.isFile() || selectedPath.createNewFile()) && (pathToExport = selectedPath.getAbsolutePath()) != null) {
                return EfuseCmdApplication.writeEfuseELFConfigurationFile(pathToExport);
            }
        }
        catch (IOException exception) {
            LOGGER.log(Level.SEVERE, "[TOOL] Error while creating a new file during the eFUSE ELF configuration export", exception);
        }
        return false;
    }

    private static boolean writeEfuseELFConfigurationFile(String selectedPath) {
        block24: {
            Object var5_9;
            File eFuseBinFile = new File(selectedPath);
            String htmlPath = UtilsText.safeString((String)new StringJoiner(File.separator).add(selectedPath.substring(0, selectedPath.lastIndexOf(File.separator))).add("efuse_report.html").toString());
            File htmlReportFile = new File(htmlPath);
            try {
                Throwable throwable = null;
                var5_9 = null;
                try (FileOutputStream outputStreamReport = new FileOutputStream(htmlReportFile);){
                    outputStreamReport.write(EFuseSummaryGenerator.getReportConfiguration().getBytes(Charset.forName("UTF-8")));
                    outputStreamReport.flush();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException err2) {
                LOGGER.log(Level.SEVERE, "[TOOL] Error while writing eFUSE HTML report file", err2);
            }
            Throwable err2 = null;
            var5_9 = null;
            FileOutputStream outputStream = new FileOutputStream(eFuseBinFile);
            try {
                outputStream.write(EfuseControllerUtils.getElfApplicationContent());
                outputStream.flush();
                if (outputStream == null) break block24;
            }
            catch (Throwable err2) {
                try {
                    try {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                        throw err2;
                    }
                    catch (Throwable throwable) {
                        if (err2 == null) {
                            err2 = throwable;
                        } else if (err2 != throwable) {
                            err2.addSuppressed(throwable);
                        }
                        throw err2;
                    }
                }
                catch (IOException err3) {
                    LOGGER.log(Level.SEVERE, "[TOOL] Error while writing eFUSE ELF configuration file", err3);
                    return false;
                }
            }
            outputStream.close();
        }
        return true;
    }
}

