/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.controller.utils;

import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.efuse.controller.EfuseController;
import com.nxp.swtools.efuse.controller.utils.EfuseControllerUtils;
import com.nxp.swtools.efuse.model.FuseField;
import com.nxp.swtools.efuse.model.FuseWord;
import com.nxp.swtools.efuse.model.mcu.IEfuseMcu;
import com.nxp.swtools.efuse.model.utils.EfuseUtils;
import com.nxp.swtools.efuse.xml.settings.FuseStructSetting;
import com.nxp.swtools.efuse.xml.settings.MemberFuseStructSetting;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EfuseExpressions {
    public static final Pattern GET_FUSE_VALUE_EXPR_REGEX = Pattern.compile("(getFuseValue)\\((.*)\\)", 8);
    public static final Pattern GET_SETTING_VALUE_EXPR_REGEX = Pattern.compile("(getSettingValue)\\((.*)\\)", 8);
    public static final Pattern GET_LOCK_BITS_VALUE_EXPR_REGEX = Pattern.compile("(getLockBitsValue)\\((.*)\\)", 8);
    public static final Pattern ADD_FUSE_SETTINGS_VALUES_EXPR_REGEX = Pattern.compile("(addFuseSettingsValues)\\((.*)\\)", 8);

    public static long getLongValueFromExpression(String expression) {
        String exprString;
        long value = 0L;
        Matcher addFuseSettingsValuesMatcher = ADD_FUSE_SETTINGS_VALUES_EXPR_REGEX.matcher(expression);
        if (addFuseSettingsValuesMatcher.find() && addFuseSettingsValuesMatcher.groupCount() == 2 && (exprString = addFuseSettingsValuesMatcher.group(2)) != null) {
            String[] settings = exprString.split(",");
            int i = 0;
            while (i < settings.length) {
                String[] expressionComponents = settings[i].split(" ");
                switch (expressionComponents.length) {
                    case 1: {
                        value += EfuseExpressions.getFuseValue(expressionComponents[0]);
                        break;
                    }
                    case 3: {
                        String firstOperand = expressionComponents[0];
                        String operator = expressionComponents[1];
                        String secondOperand = expressionComponents[2];
                        value += EfuseUtils.getValueBasedOnBitOperation((long)EfuseExpressions.getFuseValue(firstOperand), (String)operator, (long)Integer.parseInt(secondOperand));
                    }
                }
                ++i;
            }
            return value;
        }
        Matcher fuseValueMatcher = GET_FUSE_VALUE_EXPR_REGEX.matcher(expression);
        if (fuseValueMatcher.find() && fuseValueMatcher.groupCount() == 2) {
            String fuseId = fuseValueMatcher.group(2);
            if (fuseId != null) {
                return EfuseExpressions.getFuseValue(fuseId);
            }
        } else {
            Matcher settingValueMatcher = GET_SETTING_VALUE_EXPR_REGEX.matcher(expression);
            if (settingValueMatcher.find() && settingValueMatcher.groupCount() == 2) {
                String settingId = settingValueMatcher.group(2);
                if (settingId != null) {
                    return EfuseExpressions.getSettingValue(settingId);
                }
            } else {
                String lockBitsFieldId;
                Matcher lockBitsValueMatcher = GET_LOCK_BITS_VALUE_EXPR_REGEX.matcher(expression);
                if (lockBitsValueMatcher.find() && lockBitsValueMatcher.groupCount() == 2 && (lockBitsFieldId = lockBitsValueMatcher.group(2)) != null) {
                    return EfuseExpressions.getLockBitsValue(lockBitsFieldId);
                }
            }
        }
        return value;
    }

    private static long getFuseValue(String fuseId) {
        long fuseValue = 0L;
        IEfuseMcu selectedMcu = EfuseController.getInstance().getEfuseMcu();
        FuseWord fuseWord = EfuseUtils.getFuseWordByID((List)selectedMcu.getAllFuseWords(), (String)fuseId);
        if (fuseWord != null) {
            return fuseWord.getValueToWrite();
        }
        return fuseValue;
    }

    private static long getSettingValue(String settingId) {
        ABaseUIComponentSetting componentSetting = EfuseControllerUtils.getUIComponentSettingById(settingId);
        if (componentSetting != null) {
            return componentSetting.getValueToWrite();
        }
        return 0L;
    }

    private static long getLockBitsValue(String lockBitsId) {
        IEfuseMcu selectedMcu = EfuseController.getInstance().getEfuseMcu();
        for (FuseWord fuseWord : selectedMcu.getAllFuseWords()) {
            FuseField lockBitsField = EfuseUtils.getFuseFieldByID((FuseWord)fuseWord, (String)lockBitsId);
            if (lockBitsField == null) continue;
            long shiftValue = lockBitsField.getXmlSetting().getOffset() - lockBitsField.getXmlSetting().getSizeValueInBits() + 1;
            return lockBitsField.getValueToWrite() << (int)shiftValue;
        }
        return 0L;
    }

    public static void setLockBitsFieldValue(FuseField lockBitsField, long fuseMemberValue) {
        long shiftValue = lockBitsField.getXmlSetting().getOffset() - lockBitsField.getXmlSetting().getSizeValueInBits() + 1;
        lockBitsField.setValueToWrite(fuseMemberValue >> (int)shiftValue);
    }

    public static boolean isFuseFieldLockSetting(FuseField fuseField, List<FuseWord> fuseWordList) {
        for (FuseWord word : fuseWordList) {
            FuseStructSetting fuseSetting = word.getXmlSetting().getFuseStructure();
            if (fuseSetting == null) continue;
            for (MemberFuseStructSetting setting : fuseSetting.getMembersList()) {
                String lockBitsFieldId;
                Matcher lockBitsValueMatcher = GET_LOCK_BITS_VALUE_EXPR_REGEX.matcher(setting.getValueExpression());
                if (!lockBitsValueMatcher.find() || lockBitsValueMatcher.groupCount() != 2 || (lockBitsFieldId = lockBitsValueMatcher.group(2)) == null || !lockBitsFieldId.equals(fuseField.getXmlSetting().getId())) continue;
                return true;
            }
        }
        return false;
    }
}

