/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.controller.utils;

import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.efuse.controller.EfuseController;
import com.nxp.swtools.efuse.controller.Messages;
import com.nxp.swtools.efuse.controller.utils.EfuseControllerUtils;
import com.nxp.swtools.efuse.model.EfuseEntity;
import com.nxp.swtools.efuse.model.FuseField;
import com.nxp.swtools.efuse.model.FuseWord;
import com.nxp.swtools.efuse.model.mcu.IEfuseMcu;
import com.nxp.swtools.efuse.model.utils.EfuseUtils;
import com.nxp.swtools.provider.configuration.storage.efuse.StorageEfuseConfiguration;
import com.nxp.swtools.provider.configuration.storage.efuse.StorageEfuseTool;
import com.nxp.swtools.provider.configuration.storage.efuse.StorageFuseField;
import com.nxp.swtools.provider.configuration.storage.efuse.StorageFuseWord;
import java.util.List;

public class StorageEfuseUtils {
    public static @Nullable StorageEfuseTool getStorageEfuseTool() {
        return EfuseController.getInstance().getSharedConfig().getTools().getEfuseTool();
    }

    public static @Nullable StorageEfuseConfiguration getStorageEfuseConfig() {
        StorageEfuseTool stEfuseTool = StorageEfuseUtils.getStorageEfuseTool();
        if (stEfuseTool != null) {
            return stEfuseTool.getEfuseConfiguration();
        }
        return null;
    }

    public static void initializeAllStorageFuseWords(IEfuseMcu selectedMcu, StorageEfuseTool stEfuseTool) {
        StorageEfuseConfiguration stEfuseConfig = stEfuseTool.getEfuseConfiguration();
        if (stEfuseConfig != null) {
            for (FuseWord fuseWord : selectedMcu.getAllFuseWords()) {
                StorageFuseWord stFuseWord = stEfuseConfig.getFuseWordById(fuseWord.getXmlSetting().getId());
                if (stFuseWord == null) {
                    stFuseWord = new StorageFuseWord();
                    stFuseWord.setId(fuseWord.getXmlSetting().getId());
                    stFuseWord.setName(fuseWord.getXmlSetting().getLabel());
                    stFuseWord.setValue("0x" + Long.toHexString(fuseWord.getValueToWrite()));
                    stEfuseConfig.getFuseWords().add(stFuseWord);
                    for (FuseField field : fuseWord.getFuseFields()) {
                        StorageFuseField stFuseField = stFuseWord.getFuseFieldById(field.getXmlSetting().getId());
                        if (stFuseField == null) {
                            stFuseField = new StorageFuseField();
                            stFuseField.setId(field.getXmlSetting().getId());
                            stFuseField.setName(field.getXmlSetting().getLabel());
                            stFuseField.setValue("0x" + Long.toHexString(field.getValueToWrite()));
                            stFuseWord.getFieldsList().add(stFuseField);
                            continue;
                        }
                        stFuseField.setValue("0x" + Long.toHexString(field.getValueToWrite()));
                    }
                    continue;
                }
                stFuseWord.setValue("0x" + Long.toHexString(fuseWord.getValueToWrite()));
            }
        }
    }

    public static void updateStorageEfuseconfig(IEfuseMcu mcu) {
        StorageEfuseConfiguration stEfuseConfig = StorageEfuseUtils.getStorageEfuseConfig();
        if (stEfuseConfig != null) {
            for (FuseWord fuseWord : mcu.getAllFuseWords()) {
                StorageFuseWord stFuseWord = stEfuseConfig.getFuseWordById(fuseWord.getXmlSetting().getId());
                if (stFuseWord == null) continue;
                stFuseWord.setValue("0x" + Long.toHexString(fuseWord.getValueToWrite()));
                for (FuseField fuseField : fuseWord.getFuseFields()) {
                    StorageFuseField stFuseField = stFuseWord.getFuseFieldById(fuseField.getXmlSetting().getId());
                    if (stFuseField == null) continue;
                    stFuseField.setValue("0x" + Long.toHexString(fuseField.getValueToWrite()));
                }
            }
        }
    }

    private static boolean updateStorageFuseField(FuseField fuseField) {
        long currentStorageValue;
        boolean storageChanged = false;
        StorageFuseField stFuseField = StorageEfuseUtils.getStorageFuseField(fuseField);
        if (stFuseField != null && (currentStorageValue = Long.decode(stFuseField.getValue()).longValue()) != fuseField.getValueToWrite()) {
            stFuseField.setValue("0x" + Long.toHexString(fuseField.getValueToWrite()));
            storageChanged = true;
        }
        return storageChanged;
    }

    private static boolean updateStorageFuseWord(FuseWord fuseWord) {
        long currentStorageValue;
        boolean storageChanged = false;
        StorageFuseWord stFuseWord = StorageEfuseUtils.getStorageFuseWord(fuseWord);
        if (stFuseWord != null && (currentStorageValue = Long.decode(stFuseWord.getValue()).longValue()) != fuseWord.getValueToWrite()) {
            stFuseWord.setValue("0x" + Long.toHexString(fuseWord.getValueToWrite()));
            storageChanged = true;
        }
        return storageChanged;
    }

    private static boolean updateStorageEccValues() {
        boolean storageChanged = false;
        IEfuseMcu selectedMcu = EfuseController.getInstance().getEfuseMcu();
        for (FuseWord fuseWord : selectedMcu.getAllFuseWords()) {
            StorageFuseWord stFuseWord = StorageEfuseUtils.getStorageFuseWord(fuseWord);
            boolean currentEccState = EfuseControllerUtils.isEccProtected(fuseWord);
            if (stFuseWord == null || currentEccState == stFuseWord.isEccProtected()) continue;
            stFuseWord.setEccProtected(currentEccState);
            storageChanged = true;
        }
        return storageChanged;
    }

    private static boolean updateStorageForFusesWithValueExpr() {
        boolean storageChanged = false;
        IEfuseMcu mcu = EfuseController.getInstance().getEfuseMcu();
        for (FuseWord fuseWord : mcu.getAllFuseWords()) {
            if (fuseWord.getXmlSetting().getValueExpression().isEmpty()) continue;
            EfuseControllerUtils.calculateFuseValueBasedOnExpression(fuseWord);
            StorageFuseWord stFuseWord = StorageEfuseUtils.getStorageFuseWord(fuseWord);
            if (stFuseWord == null || fuseWord.getValueToWrite() == Long.decode(stFuseWord.getValue()).longValue()) continue;
            stFuseWord.setValue("0x" + Long.toHexString(fuseWord.getValueToWrite()));
            storageChanged = true;
        }
        return storageChanged;
    }

    public static @Nullable StorageFuseField getStorageFuseField(FuseField fuseField) {
        StorageEfuseConfiguration stEfuseConfig;
        StorageEfuseTool stEfuseTool = StorageEfuseUtils.getStorageEfuseTool();
        if (stEfuseTool != null && (stEfuseConfig = stEfuseTool.getEfuseConfiguration()) != null) {
            for (StorageFuseWord stFuseWord : stEfuseConfig.getFuseWords()) {
                StorageFuseField stFuseField = stFuseWord.getFuseFieldById(fuseField.getXmlSetting().getId());
                if (stFuseField == null) continue;
                return stFuseField;
            }
        }
        return null;
    }

    public static @Nullable StorageFuseWord getStorageFuseWord(FuseWord fuseWord) {
        StorageEfuseConfiguration stEfuseConfig;
        StorageEfuseTool stEfuseTool = StorageEfuseUtils.getStorageEfuseTool();
        if (stEfuseTool != null && (stEfuseConfig = stEfuseTool.getEfuseConfiguration()) != null) {
            return stEfuseConfig.getFuseWordById(fuseWord.getXmlSetting().getId());
        }
        return null;
    }

    public static void updateStorageComponent(Object source, ABaseUIComponentSetting uiSetting) {
        EfuseController.getInstance().stateShouldUpdate(source, false);
        boolean storageChanged = StorageEfuseUtils.updateStorageComponent(uiSetting);
        EfuseController.getInstance().stateShouldUpdate(source, true);
        StorageEfuseConfiguration stEfuseConfig = StorageEfuseUtils.getStorageEfuseConfig();
        if (stEfuseConfig != null && storageChanged) {
            EfuseController.getInstance().handleSettingChange(4, source, null, Messages.Msg_ChangedEfuseConfig);
        }
    }

    public static boolean updateStorageComponent(ABaseUIComponentSetting uiSetting) {
        boolean storageChanged = false;
        EfuseEntity efuseEntity = EfuseControllerUtils.getEfuseEntity(uiSetting);
        if (efuseEntity != null) {
            FuseField associatedFuseField = efuseEntity.getFuseField();
            if (associatedFuseField != null) {
                storageChanged |= StorageEfuseUtils.updateStorageFuseField(associatedFuseField);
                EfuseControllerUtils.calculateFuseWordValue(associatedFuseField.getParent());
                storageChanged |= StorageEfuseUtils.updateStorageFuseWord(associatedFuseField.getParent());
            } else {
                FuseWord associatedFuseWord;
                storageChanged = efuseEntity.isEccField() ? (storageChanged |= StorageEfuseUtils.updateStorageEccValues()) : ((associatedFuseWord = efuseEntity.getParentFuseWord()) != null ? (storageChanged |= StorageEfuseUtils.updateStorageFuseWord(associatedFuseWord)) : (storageChanged |= StorageEfuseUtils.updateStorageForFusesWithValueExpr()));
            }
        }
        return storageChanged;
    }

    public static void updateStorageForAdvancedFuseWord(Object source, String fuseWordId) {
        boolean storageChanged = false;
        EfuseController.getInstance().stateShouldUpdate(source, false);
        IEfuseMcu mcu = EfuseController.getInstance().getEfuseMcu();
        FuseWord fuseWord = EfuseUtils.getFuseWordByID((List)mcu.getAllFuseWords(), (String)fuseWordId);
        if (fuseWord != null) {
            storageChanged |= StorageEfuseUtils.updateStorageFuseWord(fuseWord);
            for (FuseField fuseField : fuseWord.getFuseFields()) {
                storageChanged |= StorageEfuseUtils.updateStorageFuseField(fuseField);
            }
        }
        EfuseController.getInstance().stateShouldUpdate(source, true);
        if (storageChanged) {
            EfuseController.getInstance().handleSettingChange(4, source, null, Messages.Msg_ChangedEfuseConfig);
        }
    }
}

