/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.model.utils;

import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.utils.UctUtils;
import com.nxp.swtools.common.uct.validation.AValidatedTextField;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.efuse.model.EfuseEntity;
import com.nxp.swtools.efuse.model.FuseField;
import com.nxp.swtools.efuse.model.FuseWord;
import com.nxp.swtools.efuse.model.mcu.IEfuseMcu;
import com.nxp.swtools.efuse.xml.settings.FuseStructSetting;
import com.nxp.swtools.efuse.xml.settings.HeaderSetting;
import java.util.List;

public class EfuseUtils {
    private static boolean isSwitchingBetweenModesInProgress = false;
    private static Mode currentMode = Mode.STANDARD;
    private static boolean isImportProcessRunning = false;

    public static void calculateFuseValueBasedOnFields(FuseWord fuseWord) {
        if (!fuseWord.getFuseFields().isEmpty()) {
            long fuseValue = 0L;
            for (FuseField fuseField : fuseWord.getFuseFields()) {
                int fieldOffset = fuseField.getXmlSetting().getOffset();
                int fieldSize = fuseField.getXmlSetting().getSizeValueInBits();
                long fieldValueInWord = fuseField.getValueToWrite() << fieldOffset - fieldSize + 1;
                if ((fuseValue & fieldValueInWord) == fieldValueInWord) continue;
                fuseValue = fuseValue + fieldValueInWord & 0xFFFFFFFFFFFFFFFFL;
            }
            fuseWord.setValueToWrite(fuseValue);
        }
    }

    public static @Nullable FuseWord getFuseWordByID(List<FuseWord> allFuses, String id) {
        for (FuseWord fuseWord : allFuses) {
            if (!id.equalsIgnoreCase(fuseWord.getXmlSetting().getId())) continue;
            return fuseWord;
        }
        return null;
    }

    public static @Nullable FuseField getFuseFieldByID(FuseWord parentFuse, String id) {
        for (FuseField field : parentFuse.getFuseFields()) {
            if (!id.equalsIgnoreCase(field.getXmlSetting().getId())) continue;
            return field;
        }
        return null;
    }

    public static long getValueBasedOnBitOperation(long value, String operator, long mask) {
        switch (operator) {
            case "AND": {
                return value & mask;
            }
            case "OR": {
                return value | mask;
            }
            case "<<": {
                return value << (int)mask;
            }
            case ">>": {
                return value >> (int)mask;
            }
            case ">>>": {
                return value >>> (int)mask;
            }
        }
        return 0L;
    }

    public static byte[] extractBytesFromBinaryImage(byte[] binaryInput, int offset, int size) {
        byte[] extractedBytes = new byte[size];
        int i = 0;
        while (i < size) {
            extractedBytes[i] = binaryInput[offset + i];
            ++i;
        }
        return extractedBytes;
    }

    public static @Nullable ABaseUIComponentSetting getComponentSettingById(IEfuseMcu mcu, String id) {
        for (EfuseEntity efuseEntity : mcu.getAllEfuseEntities()) {
            if (!efuseEntity.getFuseFieldID().equals(id)) continue;
            return efuseEntity.getUIComponentSetting();
        }
        return null;
    }

    public static boolean isFuseFieldAssociatedWithMultipleComponents(IEfuseMcu mcu, String fuseFieldId) {
        return mcu.getAllEfuseEntities().stream().filter(c -> c.getFuseFieldID().equals(fuseFieldId)).count() > 1L;
    }

    public static @Nullable ABaseUIComponentSetting getComponentSettingByFuseWord(IEfuseMcu mcu, String id) {
        for (EfuseEntity efuseEntity : mcu.getAllEfuseEntities()) {
            if (!efuseEntity.getParentFuseWordID().equals(id) || efuseEntity.isEccField() || !efuseEntity.getFuseFieldID().isEmpty()) continue;
            return efuseEntity.getUIComponentSetting();
        }
        return null;
    }

    public static @Nullable ABaseUIComponentSetting getEccProtectedComponentSettingByFuseWord(IEfuseMcu mcu, String id) {
        for (EfuseEntity efuseEntity : mcu.getAllEfuseEntities()) {
            if (!efuseEntity.getParentFuseWordID().equals(id) || !efuseEntity.isEccField()) continue;
            return efuseEntity.getUIComponentSetting();
        }
        return null;
    }

    public static int getSizeOfEntireFusesStruct(IEfuseMcu selectedMcu) {
        int size = 0;
        HeaderSetting efuseHeader = selectedMcu.getEfuseXmlConfig().getHeader();
        if (efuseHeader != null) {
            size += efuseHeader.getSizeValueInBytes();
        }
        for (FuseWord fuseWord : selectedMcu.getAllFuseWords()) {
            FuseStructSetting fuseStruct = fuseWord.getXmlSetting().getFuseStructure();
            if (fuseStruct == null) continue;
            size += fuseStruct.getSizeValueInBytes();
        }
        return size;
    }

    public static void setSwitchingBetweenModes(boolean value) {
        isSwitchingBetweenModesInProgress = value;
    }

    public static boolean isSwitchingBetweenModesInProgress() {
        return isSwitchingBetweenModesInProgress;
    }

    public static void setCurrentMode(Mode mode) {
        currentMode = mode;
    }

    public static Mode getCurrentMode() {
        return currentMode;
    }

    public static long getFuseFieldValueFromFuseWord(FuseField fuseField, FuseWord fuseWord) {
        int offset = fuseField.getXmlSetting().getOffset();
        int size = fuseField.getXmlSetting().getSizeValueInBits();
        long mask = UctUtils.getBitsMaskValue((int)offset, (int)size);
        return (fuseWord.getValueToWrite() & mask) >> offset - size + 1;
    }

    public static void setIsImportProcessRunning(boolean value) {
        isImportProcessRunning = value;
    }

    public static boolean isImportProcessRunning() {
        return isImportProcessRunning;
    }

    public static boolean isTextFieldFormatValid(AValidatedTextField textField) {
        textField.validateTextfield();
        return !textField.getText().isEmpty() && textField.isFormatValid();
    }

    public static enum Mode {
        STANDARD("standard_mode"),
        ADVANCED("advanced_mode");

        private String tabId;

        private Mode(String tabId) {
            this.tabId = tabId;
        }

        public String getTabId() {
            return this.tabId;
        }
    }
}

