/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.debug.s32debugger.ui.fixes;

import com.nxp.s32ds.cle.debug.s32debugger.ResolverUtils;
import com.nxp.s32ds.cle.debug.s32debugger.S32DebuggerActivator;
import com.nxp.s32ds.cle.debug.s32debugger.internal.ui.ResolverMessages;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public abstract class S32DebuggerLaunchConfigurationGenericQuickFix
extends WorkbenchMarkerResolution {
    private final IMarker selectedMarker;
    private final String label;

    public S32DebuggerLaunchConfigurationGenericQuickFix(String label, IMarker marker) {
        this.label = label;
        this.selectedMarker = marker;
    }

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_BACK");
    }

    public String getLabel() {
        return this.label;
    }

    public void run(IMarker marker) {
        if (marker.getResource() instanceof IFile) {
            IFile launchConfigFile = (IFile)marker.getResource();
            if (!launchConfigFile.exists()) {
                S32DebuggerActivator.getInstance().logError(NLS.bind((String)ResolverMessages.S32DebuggerLaunchConfigurationFix_no_file, (Object)launchConfigFile.getName()));
                return;
            }
            Path backupPath = ResolverUtils.createBackUpLaunchFile((IFile)launchConfigFile);
            try {
                if (!this.getMarkerType().equals(marker.getType())) {
                    return;
                }
                this.resolveLaunchConfiguration(launchConfigFile);
                marker.delete();
                if (backupPath != null) {
                    ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)backupPath).delete(true, null);
                }
            }
            catch (CoreException ce) {
                S32DebuggerActivator.getInstance().log(ce.getStatus());
            }
        }
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        ArrayList<IMarker> lstMarkers = new ArrayList<IMarker>();
        IProject selectedProject = this.selectedMarker.getResource().getProject();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            try {
                IProject curProject;
                if (marker.exists() && !marker.equals((Object)this.selectedMarker) && this.getMarkerType().equals(marker.getType()) && (curProject = marker.getResource().getProject()) != null && curProject.equals((Object)selectedProject)) {
                    lstMarkers.add(marker);
                }
            }
            catch (CoreException ce) {
                S32DebuggerActivator.getInstance().log(ce.getStatus());
            }
            ++n2;
        }
        IMarker[] result = lstMarkers.toArray(new IMarker[lstMarkers.size()]);
        return result;
    }

    protected IProject getProject() {
        return this.selectedMarker.getResource().getProject();
    }

    protected abstract void resolveLaunchConfiguration(IFile var1) throws CoreException;

    protected abstract String getMarkerType();
}

