/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.asr.convertor;

import com.nxp.swtools.asr.convertor.AsrImporterHelper;
import com.nxp.swtools.asr.convertor.ClocksImporterHelper;
import com.nxp.swtools.asr.convertor.ImportEpcResultEnum;
import com.nxp.swtools.asr.convertor.PinsImporterHelper;
import com.nxp.swtools.asr.epc.model.ArPackageNode;
import com.nxp.swtools.asr.epc.model.AsrPinsMapping;
import com.nxp.swtools.asr.epc.model.CompuMethod;
import com.nxp.swtools.asr.epc.model.CompuScale;
import com.nxp.swtools.asr.epc.model.EcucContainerValue;
import com.nxp.swtools.asr.epc.model.EcucNumericalParamValue;
import com.nxp.swtools.asr.epc.model.EcucReferenceValue;
import com.nxp.swtools.asr.epc.model.EcucTextualParamValue;
import com.nxp.swtools.asr.epc.model.ElementsNode;
import com.nxp.swtools.asr.epc.model.EpcConfig;
import com.nxp.swtools.asr.epc.model.FunctionalProperty;
import com.nxp.swtools.asr.epc.model.ModuleConfigNode;
import com.nxp.swtools.asr.epc.model.ParameterValues;
import com.nxp.swtools.asr.epc.model.PeripheralsClocksMappings;
import com.nxp.swtools.asr.epc.model.PinMapping;
import com.nxp.swtools.asr.epc.model.PinMode;
import com.nxp.swtools.asr.epc.model.PostBuildVariantCondition;
import com.nxp.swtools.asr.epc.model.PostBuildVariantCriterion;
import com.nxp.swtools.asr.epc.model.PostBuildVariantCriterionValue;
import com.nxp.swtools.asr.epc.model.PostBuildVariantCriterionValueSet;
import com.nxp.swtools.asr.epc.model.PostBuildVariantCriterionValueSetRef;
import com.nxp.swtools.asr.epc.model.PredefinedVariant;
import com.nxp.swtools.asr.epc.model.SreOption;
import com.nxp.swtools.asr.epc.model.ValueRef;
import com.nxp.swtools.asr.epc.model.VariationPoint;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.model.config.PeriphsProfile;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksConfiguration;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsStructuredSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsArraySetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsComponentInstance;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsConfigSet;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsFuncGroup;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsScalarSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsStructSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsTool;
import com.nxp.swtools.provider.configuration.storage.pins.StoragePinsFunction;
import com.nxp.swtools.provider.configuration.storage.pins.StorageRoutedPin;
import com.nxp.swtools.resourcetables.model.config.ArrayConfig;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.config.IConfigSetConfig;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.resourcetables.model.config.StructConfig;
import com.nxp.swtools.resourcetables.model.data.IConfigSet;
import com.nxp.swtools.resourcetables.model.data.IConfigurationComponent;
import com.nxp.swtools.resourcetables.model.data.Mode;
import com.nxp.swtools.resourcetables.model.data.setting.ArraySetting;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.model.data.setting.StructSetting;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EpcToPeriphConvertor {
    private List<EpcConfig> epcConfigs;
    ISharedConfiguration sharedConfig;
    boolean checkVersion = true;
    private boolean importAsNew;
    private static final Logger LOGGER = LogManager.getLogger(EpcToPeriphConvertor.class);
    private Map<String, Boolean> parsedModules = new HashMap<String, Boolean>();
    private StoragePeriphsFuncGroup currentVariant = new StoragePeriphsFuncGroup();
    private StorageClocksConfiguration currentClockConfiguration = new StorageClocksConfiguration();
    private static Set<String> populatedVariantSettings = new HashSet<String>();
    private List<String> variantsToImport = new ArrayList<String>();

    public EpcToPeriphConvertor(List<EpcConfig> epcConfigs, ISharedConfiguration targetConfig, boolean checkVersion, boolean importAsNew) {
        this.epcConfigs = epcConfigs;
        this.sharedConfig = targetConfig;
        this.checkVersion = checkVersion;
        this.importAsNew = importAsNew;
    }

    public ImportEpcResultEnum convertEpc() {
        PeripheralsClocksMappings.loadClocksPeripheralsMappingFile();
        AsrPinsMapping.loadPinsPeripheralsMappingFile();
        if (this.hasVariants()) {
            this.populateGlobalConfigSet();
        }
        if (this.importAsNew) {
            ClocksImporterHelper.clearClockConfigurations(this.sharedConfig);
            PinsImporterHelper.clearPinsFunctions(this.sharedConfig);
        }
        for (EpcConfig epcConfig : this.epcConfigs) {
            List<ArPackageNode> arPackages = epcConfig.getPackages();
            for (ArPackageNode arPackage : arPackages) {
                this.parseArPackage(arPackage, "");
            }
        }
        if (!this.parsedModules.isEmpty() && this.parsedModules.values().stream().allMatch(v -> v.equals(Boolean.FALSE)) && !this.checkVersion) {
            return ImportEpcResultEnum.FAIL_NO_MODULES;
        }
        if (this.hasVariants() && this.getFunctionalGroupsStorage().isEmpty()) {
            return ImportEpcResultEnum.FAIL_NO_VARIANTS;
        }
        if (this.checkVersion && !this.parsedModules.isEmpty() && this.parsedModules.values().stream().allMatch(v -> v.equals(Boolean.FALSE))) {
            return ImportEpcResultEnum.FAIL_CHECK_ECUC_MODULE_DEF;
        }
        AsrImporterHelper.getInstance().setClearArPackageDoc(false);
        SharedConfigurationFactory.applyNewConfig((ISharedConfiguration)this.sharedConfig, (ISharedConfiguration)this.sharedConfig, (ConfigChangeReason)ConfigChangeReason.LOAD_CONFIG);
        return ImportEpcResultEnum.SUCCESS;
    }

    private void populateGlobalConfigSet() {
        List<ArPackageNode> variantPackages = this.getVariantPackages();
        HashSet<PostBuildVariantCriterion> postBuildVariantCriterions = new HashSet<PostBuildVariantCriterion>();
        HashSet<CompuMethod> compuMethods = new HashSet<CompuMethod>();
        HashSet<PredefinedVariant> predefinedVariants = new HashSet<PredefinedVariant>();
        HashSet<PostBuildVariantCriterionValueSet> postBuildVariantCriterionValues = new HashSet<PostBuildVariantCriterionValueSet>();
        this.addCriterionInformationsToSets(postBuildVariantCriterions, compuMethods, variantPackages);
        this.addPredefinedVariantInformationToSets(predefinedVariants, postBuildVariantCriterionValues, variantPackages);
        this.populateCriterions(postBuildVariantCriterions, compuMethods);
        this.populatePredefinedVariants(predefinedVariants, postBuildVariantCriterionValues, postBuildVariantCriterions, compuMethods);
    }

    private void parseArPackage(ArPackageNode arPackageNode, String packageName) {
        packageName = packageName.isEmpty() ? arPackageNode.getShortName() : String.valueOf(packageName) + "/" + arPackageNode.getShortName();
        List<ArPackageNode> packages = arPackageNode.getArPackages();
        if (!packages.isEmpty()) {
            for (ArPackageNode packageNode : packages) {
                this.parseArPackage(packageNode, packageName);
            }
        } else {
            List<ModuleConfigNode> moduleConfNodes = arPackageNode.getElements().getModuleConfigs();
            for (ModuleConfigNode moduleConfNode : moduleConfNodes) {
                String oldPackageName = String.valueOf(packageName) + "/" + moduleConfNode.getShortName() + "/";
                for (StoragePeriphsFuncGroup group : this.getFunctionalGroupsStorage()) {
                    this.setCurrentVariant(group);
                    this.parseModuleConfigNodeForGroup(moduleConfNode, oldPackageName, group);
                }
            }
        }
    }

    private void parseModuleConfigNodeForGroup(ModuleConfigNode moduleConfNode, String oldPackageName, StoragePeriphsFuncGroup group) {
        if (this.parseModuleConfigNode(moduleConfNode, oldPackageName, group)) {
            this.parsedModules.put(oldPackageName, Boolean.TRUE);
            populatedVariantSettings.clear();
            LOGGER.log(Level.INFO, "Configuration was imported for the module: " + oldPackageName);
        } else {
            this.parsedModules.put(oldPackageName, Boolean.FALSE);
            LOGGER.log(Level.INFO, "Configuration couldn't be imported for the module: " + oldPackageName);
        }
    }

    private static String getSettingId(String definitionRef) {
        if (definitionRef.isEmpty()) {
            return definitionRef;
        }
        String[] defRefVals = definitionRef.split("/");
        return defRefVals[defRefVals.length - 1];
    }

    private boolean parseModuleConfigNode(ModuleConfigNode moduleConfNode, String packageName, StoragePeriphsFuncGroup group) {
        String modulePath = moduleConfNode.getDefinitionRef().getValue();
        String configSetId = EpcToPeriphConvertor.getSettingId(modulePath);
        String moduleName = moduleConfNode.getShortName();
        List components = Controller.getInstance().getComponentsByConfigSet(configSetId);
        if (components.isEmpty()) {
            LOGGER.log(Level.SEVERE, "Components with " + configSetId + " config_set couldn't be found for the selected MCU.");
            return false;
        }
        if (components.size() > 1) {
            LOGGER.log(Level.WARNING, "Multiple components with the same config set id was found: " + modulePath);
        }
        boolean match = false;
        for (IConfigurationComponent component : components) {
            ISetting configTimeChild;
            Mode usedMode = null;
            for (Mode mode : component.getScenarios()) {
                if (!mode.getConfigSetRefs().contains(configSetId)) continue;
                usedMode = mode;
                break;
            }
            if (usedMode == null) continue;
            String instanceName = component.getId();
            StoragePeriphsComponentInstance storageComponentInstance = new StoragePeriphsComponentInstance();
            storageComponentInstance.setName(instanceName);
            storageComponentInstance.setType(component.getId());
            storageComponentInstance.setMode(usedMode.getId());
            storageComponentInstance.setUUID(UUID.randomUUID().toString());
            IConfigSet configSet = component.getConfigSet(configSetId);
            if (configSet == null) continue;
            IContext profileContext = Controller.getInstance().getProfile().getExpressionContext();
            Object buildNumber = configSet.getOptionValue("path", profileContext);
            if (this.checkVersion && !modulePath.equals(buildNumber)) {
                LOGGER.log(Level.SEVERE, String.format("Current module build number, %1$s, doesn't match with the one from the: component with id \"%2$s\" and \"%3$s\" config_set.", modulePath, component.getId(), configSet.getId()));
                continue;
            }
            match = true;
            group.addInstance(storageComponentInstance);
            String newPackageName = String.valueOf(component.getId()) + "/" + moduleName + "/";
            StoragePeriphsConfigSet stConfigSet = new StoragePeriphsConfigSet();
            storageComponentInstance.getConfig_sets().add(stConfigSet);
            stConfigSet.setName(configSetId);
            ISetting nameSetting = configSet.find(new String[]{"Name"});
            if (nameSetting != null) {
                this.createSettingStorage(nameSetting, (AStoragePeriphsStructuredSetting)stConfigSet, moduleName, false, null, stConfigSet.getName());
            }
            if ((configTimeChild = configSet.find(new String[]{"ConfigTimeSupport"})) != null && configTimeChild.getTypeName().equals("struct")) {
                ISetting child;
                String postBuildVariantUsed;
                ISetting child2;
                StructSetting structSetting = (StructSetting)configTimeChild;
                StoragePeriphsStructSetting stStrSetting = new StoragePeriphsStructSetting();
                stConfigSet.addSetting((AStoragePeriphsSetting)stStrSetting);
                stStrSetting.setName(structSetting.getId());
                String implConfigVariant = moduleConfNode.getImplConfigVariant();
                if (implConfigVariant != null && (child2 = structSetting.getSetting("IMPLEMENTATION_CONFIG_VARIANT")) != null) {
                    this.createSettingStorage(child2, (AStoragePeriphsStructuredSetting)stStrSetting, implConfigVariant, false, null, structSetting.getId());
                }
                if ((postBuildVariantUsed = moduleConfNode.getPostBuildVariantUsed()) != null && (child = structSetting.getSetting("POST_BUILD_VARIANT_USED")) != null) {
                    this.createSettingStorage(child, (AStoragePeriphsStructuredSetting)stStrSetting, postBuildVariantUsed, false, null, structSetting.getId());
                }
            }
            List<EcucContainerValue> containers = moduleConfNode.getContainers();
            HashMap<String, AStoragePeriphsStructuredSetting> arraysInModule = new HashMap<String, AStoragePeriphsStructuredSetting>();
            for (EcucContainerValue ecucContainerValue : containers) {
                String settingId = EpcToPeriphConvertor.getSettingId(ecucContainerValue.getDefinitionRef().getValue());
                ISetting containerChild = configSet.find(new String[]{settingId});
                if (containerChild != null) {
                    this.createEcucContainerSettingStorage(containerChild, (AStoragePeriphsStructuredSetting)stConfigSet, ecucContainerValue, false, packageName, newPackageName, arraysInModule);
                    continue;
                }
                LOGGER.log(Level.SEVERE, String.valueOf(ecucContainerValue.getDefinitionRef().getValue()) + " couldn't be found in the current configuration");
            }
        }
        return match;
    }

    private void createEcucContainerSettingStorage(ISetting setting, AStoragePeriphsStructuredSetting parentStorage, EcucContainerValue ecucContainerValue, boolean inArray, String oldPackageName, String newPackageName, Map<String, AStoragePeriphsStructuredSetting> arraysInParent) {
        switch (setting.getTypeName()) {
            case "struct": {
                ISetting nameSetting;
                boolean isChoiceContainer;
                StructSetting structSetting = (StructSetting)setting;
                StoragePeriphsStructSetting structStorage = new StoragePeriphsStructSetting();
                if (!inArray) {
                    structStorage.setName(setting.getId());
                }
                VariationPoint variationPoint = ecucContainerValue.getVariationPoint();
                String populatedSettingId = String.valueOf(parentStorage.getName()) + "." + setting.getId() + "." + this.getCurrentVariant().getName();
                if (variationPoint != null) {
                    if (EpcToPeriphConvertor.isCriterionMatchingWithVariationPoint(variationPoint, this.getCurrentVariant().getName())) {
                        parentStorage.addSetting((AStoragePeriphsSetting)structStorage);
                        populatedVariantSettings.add(populatedSettingId);
                    }
                } else if (!populatedVariantSettings.contains(populatedSettingId)) {
                    parentStorage.addSetting((AStoragePeriphsSetting)structStorage);
                }
                if ((isChoiceContainer = ecucContainerValue.getDefinitionRef().getDestinationRef().equals("ECUC-CHOICE-CONTAINER-DEF")) && !ecucContainerValue.getSubContainers().isEmpty()) {
                    ISetting choiceSetting = structSetting.getSetting("Choice");
                    if (choiceSetting != null) {
                        this.createSettingStorage(choiceSetting, (AStoragePeriphsStructuredSetting)structStorage, EpcToPeriphConvertor.getSettingId(ecucContainerValue.getSubContainers().get(0).getDefinitionRef().getValue()), false, null, setting.getId());
                    } else {
                        LOGGER.log(Level.SEVERE, "Choice setting couldn't be found for " + ecucContainerValue.getDefinitionRef().getValue());
                    }
                }
                if ((nameSetting = structSetting.getSetting("Name")) != null) {
                    this.createSettingStorage(nameSetting, (AStoragePeriphsStructuredSetting)structStorage, ecucContainerValue.getShortName(), false, ecucContainerValue.getVariationPoint(), setting.getId());
                } else {
                    LOGGER.log(Level.SEVERE, "Name setting couldn't be found for " + ecucContainerValue.getDefinitionRef().getValue());
                }
                ParameterValues paramVals = ecucContainerValue.getParameterValues();
                if (paramVals != null) {
                    this.parseParametersSection(paramVals, structSetting, (AStoragePeriphsStructuredSetting)structStorage);
                }
                this.parseReferenceSection(ecucContainerValue.getEcucRefValues(), structSetting, (AStoragePeriphsStructuredSetting)structStorage, oldPackageName, newPackageName);
                this.parseSubContainersSection(ecucContainerValue.getSubContainers(), structSetting, (AStoragePeriphsStructuredSetting)structStorage, oldPackageName, newPackageName);
                break;
            }
            case "array": {
                String name = String.valueOf(ecucContainerValue.getShortName()) + "_" + this.getCurrentVariant().getName();
                String settingId = EpcToPeriphConvertor.getSettingId(ecucContainerValue.getDefinitionRef().getValue());
                StorageClocksConfiguration clockConfig = ClocksImporterHelper.getOrCreateClockConfiguration(this.sharedConfig, settingId, name);
                if (clockConfig != null) {
                    this.setCurrentClockConfiguration(clockConfig);
                }
                if (settingId.equals("PortContainer")) {
                    this.populatePinsStorage(ecucContainerValue, settingId, name);
                }
                AStoragePeriphsStructuredSetting arrayStorage = EpcToPeriphConvertor.getArrayStorage(setting.getId(), arraysInParent, parentStorage);
                ArraySetting arraySetting = (ArraySetting)setting;
                ISetting arrayType = arraySetting.getReferenceType();
                this.createEcucContainerSettingStorage(arrayType, arrayStorage, ecucContainerValue, true, oldPackageName, newPackageName, new HashMap<String, AStoragePeriphsStructuredSetting>());
                break;
            }
            default: {
                LOGGER.log(Level.WARNING, String.valueOf(ecucContainerValue.getDefinitionRef().getValue()) + " container with unknown type: " + setting.getTypeName());
            }
        }
    }

    private void populatePinsStorage(EcucContainerValue ecucContainer, String settingId, String name) {
        StoragePinsFunction function = PinsImporterHelper.getOrCreateStoragePinsFunction(this.sharedConfig, settingId, name);
        AsrPinsMapping mapping = AsrImporterHelper.getInstance().getPeripheralsPinsMapping();
        if (function != null && mapping != null) {
            List<EcucContainerValue> pinContainers = ecucContainer.getSubContainers();
            for (EcucContainerValue pinContainer : pinContainers) {
                String currentVariantName;
                VariationPoint variationPoint;
                SreOption sreOption;
                String currentVariantName2;
                VariationPoint variationPoint2;
                FunctionalProperty property;
                String paramSettingId;
                PinMode pinMode;
                String foreignPinMode;
                PinMapping pinMapping;
                ParameterValues parameterValues = pinContainer.getParameterValues();
                if (parameterValues == null) continue;
                List<EcucTextualParamValue> textualValues = parameterValues.getEcucTextualParamVals();
                List<EcucNumericalParamValue> numericalValues = parameterValues.getEcucNumericalParamVals();
                int pinMscr = PinsImporterHelper.getPinMscr(numericalValues);
                if (pinMscr == -1 || (pinMapping = mapping.getPinMappingByMscr(pinMscr)) == null || (foreignPinMode = PinsImporterHelper.getPinMode(textualValues)) == null || (pinMode = pinMapping.findPinModeByForeignValue(foreignPinMode)) == null) continue;
                String peripheral = pinMode.getCtPeripheral();
                String signal = pinMode.getCtSignal();
                String pinName = pinMapping.getName();
                if (!pinMode.getCtChannel().isEmpty()) {
                    signal = String.valueOf(signal) + "," + " " + pinMode.getCtChannel();
                }
                StorageRoutedPin routedPin = new StorageRoutedPin(peripheral, signal, "", pinName);
                for (EcucTextualParamValue textualValue : textualValues) {
                    paramSettingId = EpcToPeriphConvertor.getSettingId(textualValue.getDefinitionRef().getValue());
                    property = mapping.findFunctionalPropertyByForeignId(paramSettingId);
                    if (property != null) {
                        variationPoint2 = textualValue.getVariationPoint();
                        currentVariantName2 = this.getCurrentVariant().getName();
                        if (variationPoint2 != null) {
                            if (!EpcToPeriphConvertor.isCriterionMatchingWithVariationPoint(variationPoint2, currentVariantName2)) continue;
                            PinsImporterHelper.addPinFeatureFromProperty(routedPin, property, textualValue.getValue());
                            continue;
                        }
                        PinsImporterHelper.addPinFeatureFromProperty(routedPin, property, textualValue.getValue());
                        continue;
                    }
                    sreOption = pinMapping.findSreOptionByForeignId(paramSettingId);
                    if (sreOption == null) continue;
                    variationPoint = textualValue.getVariationPoint();
                    currentVariantName = this.getCurrentVariant().getName();
                    if (variationPoint != null) {
                        if (!EpcToPeriphConvertor.isCriterionMatchingWithVariationPoint(variationPoint, currentVariantName)) continue;
                        PinsImporterHelper.addPinFeatureFromSreOption(routedPin, sreOption, textualValue.getValue());
                        continue;
                    }
                    PinsImporterHelper.addPinFeatureFromSreOption(routedPin, sreOption, textualValue.getValue());
                }
                for (EcucNumericalParamValue numericalValue : numericalValues) {
                    paramSettingId = EpcToPeriphConvertor.getSettingId(numericalValue.getDefinitionRef().getValue());
                    property = mapping.findFunctionalPropertyByForeignId(paramSettingId);
                    if (property != null) {
                        variationPoint2 = numericalValue.getVariationPoint();
                        currentVariantName2 = this.getCurrentVariant().getName();
                        if (variationPoint2 != null) {
                            if (!EpcToPeriphConvertor.isCriterionMatchingWithVariationPoint(variationPoint2, currentVariantName2)) continue;
                            PinsImporterHelper.addPinFeatureFromProperty(routedPin, property, numericalValue.getValue());
                            continue;
                        }
                        PinsImporterHelper.addPinFeatureFromProperty(routedPin, property, numericalValue.getValue());
                        continue;
                    }
                    sreOption = pinMapping.findSreOptionByForeignId(paramSettingId);
                    if (sreOption == null) continue;
                    variationPoint = numericalValue.getVariationPoint();
                    currentVariantName = this.getCurrentVariant().getName();
                    if (variationPoint != null) {
                        if (!EpcToPeriphConvertor.isCriterionMatchingWithVariationPoint(variationPoint, currentVariantName)) continue;
                        PinsImporterHelper.addPinFeatureFromSreOption(routedPin, sreOption, numericalValue.getValue());
                        continue;
                    }
                    PinsImporterHelper.addPinFeatureFromSreOption(routedPin, sreOption, numericalValue.getValue());
                }
                function.getPinsList().add(routedPin);
            }
        }
    }

    private void createSettingStorage(ISetting setting, AStoragePeriphsStructuredSetting parentStorage, String value, boolean arrayType, @Nullable VariationPoint variationPoint, String parentName) {
        switch (setting.getTypeName()) {
            case "info": {
                this.createClockSettingStorage(setting, value, variationPoint);
                break;
            }
            case "string": 
            case "enum": 
            case "float": 
            case "dynamic_enum": 
            case "integer": {
                this.addSettingToStorage(setting, parentStorage, value, arrayType, variationPoint, "dynamic_enum", parentName);
                this.createClockSettingStorage(setting, value, variationPoint);
                break;
            }
            case "bool": {
                this.addSettingToStorage(setting, parentStorage, value, arrayType, variationPoint, "bool", parentName);
                this.createClockSettingStorage(setting, value, variationPoint);
                break;
            }
            default: {
                LOGGER.log(Level.WARNING, String.valueOf(setting.getId()) + " setting with unknown type: " + setting.getTypeName());
            }
        }
    }

    private static AStoragePeriphsStructuredSetting getArrayStorage(String arrayId, Map<String, AStoragePeriphsStructuredSetting> arraysContainer, AStoragePeriphsStructuredSetting parentStorage) {
        AStoragePeriphsStructuredSetting stArraySetting = arraysContainer.get(arrayId);
        if (stArraySetting == null) {
            stArraySetting = new StoragePeriphsArraySetting();
            parentStorage.addSetting((AStoragePeriphsSetting)stArraySetting);
            stArraySetting.setName(arrayId);
            arraysContainer.put(arrayId, stArraySetting);
        }
        return stArraySetting;
    }

    private void createNotStructuredSettingStorage(String settingId, String settingValue, ISetting setting, AStoragePeriphsStructuredSetting parentStorage, Map<String, AStoragePeriphsStructuredSetting> arraysContainer, @Nullable VariationPoint variationPoint) {
        if (setting.getTypeName().equals("array")) {
            AStoragePeriphsStructuredSetting arrayStorage = EpcToPeriphConvertor.getArrayStorage(settingId, arraysContainer, parentStorage);
            ArraySetting arraySetting = (ArraySetting)setting;
            ISetting arrayType = arraySetting.getReferenceType();
            this.createSettingStorage(arrayType, arrayStorage, settingValue, true, variationPoint, parentStorage.getName());
        } else {
            this.createSettingStorage(setting, parentStorage, settingValue, false, variationPoint, parentStorage.getName());
        }
    }

    private void parseParametersSection(ParameterValues paramSection, StructSetting parentSetting, AStoragePeriphsStructuredSetting parentStorage) {
        HashMap<String, AStoragePeriphsStructuredSetting> arraysInContainer = new HashMap<String, AStoragePeriphsStructuredSetting>();
        for (EcucTextualParamValue textualParam : paramSection.getEcucTextualParamVals()) {
            this.parseValueElement(parentSetting, parentStorage, textualParam.getDefinitionRef().getValue(), textualParam.getValue(), arraysInContainer, textualParam, null);
        }
        arraysInContainer.clear();
        for (EcucNumericalParamValue numericalParam : paramSection.getEcucNumericalParamVals()) {
            this.parseValueElement(parentSetting, parentStorage, numericalParam.getDefinitionRef().getValue(), numericalParam.getValue(), arraysInContainer, null, numericalParam);
        }
    }

    private void parseReferenceSection(List<EcucReferenceValue> referenceValues, StructSetting structSetting, AStoragePeriphsStructuredSetting parentStorage, String oldPackageName, String newPackageName) {
        HashMap<String, AStoragePeriphsStructuredSetting> arraysInContainer = new HashMap<String, AStoragePeriphsStructuredSetting>();
        for (EcucReferenceValue refVal : referenceValues) {
            String settingId = EpcToPeriphConvertor.getSettingId(refVal.getDefinitionRef().getValue());
            ISetting structChild = structSetting.getSetting(settingId);
            if (structChild != null) {
                ValueRef valueRef = refVal.getValueRef();
                if (valueRef != null) {
                    String value = valueRef.getValue();
                    value = value.replaceFirst(oldPackageName, newPackageName);
                    this.createNotStructuredSettingStorage(settingId, value, structChild, parentStorage, arraysInContainer, refVal.getVariationPoint());
                    continue;
                }
                LOGGER.log(Level.WARNING, "Value for the current setting couldn't be found. Default value will be used for: " + refVal.getDefinitionRef().getValue());
                continue;
            }
            LOGGER.log(Level.SEVERE, String.valueOf(refVal.getDefinitionRef().getValue()) + " couldn't be found in the current configuration");
        }
    }

    private void parseSubContainersSection(List<EcucContainerValue> containers, StructSetting structSetting, AStoragePeriphsStructuredSetting parentStorage, String oldPackageName, String newPackageName) {
        HashMap<String, AStoragePeriphsStructuredSetting> arraysInParent = new HashMap<String, AStoragePeriphsStructuredSetting>();
        for (EcucContainerValue container : containers) {
            String settingId = EpcToPeriphConvertor.getSettingId(container.getDefinitionRef().getValue());
            ISetting structChild = structSetting.getSetting(settingId);
            if (structChild != null) {
                this.createEcucContainerSettingStorage(structChild, parentStorage, container, false, oldPackageName, newPackageName, arraysInParent);
                continue;
            }
            LOGGER.log(Level.SEVERE, String.valueOf(container.getDefinitionRef().getValue()) + " couldn't be found in the current configuration");
        }
    }

    private void parseValueElement(StructSetting parentSetting, AStoragePeriphsStructuredSetting parentStorage, String definitionValue, String value, Map<String, AStoragePeriphsStructuredSetting> arraysInContainer, @Nullable EcucTextualParamValue textualParam, @Nullable EcucNumericalParamValue numericalParam) {
        String settingId = EpcToPeriphConvertor.getSettingId(definitionValue);
        ISetting structChild = parentSetting.getSetting(settingId);
        VariationPoint variationPoint = null;
        if (textualParam != null) {
            variationPoint = textualParam.getVariationPoint();
        } else if (numericalParam != null) {
            variationPoint = numericalParam.getVariationPoint();
        }
        if (structChild != null) {
            this.createNotStructuredSettingStorage(settingId, value, structChild, parentStorage, arraysInContainer, variationPoint);
        } else {
            LOGGER.log(Level.SEVERE, String.valueOf(definitionValue) + " couldn't be found in the current configuration");
        }
    }

    private boolean hasVariants() {
        for (EpcConfig config : this.epcConfigs) {
            if (!config.hasVariants()) continue;
            return true;
        }
        return false;
    }

    private List<ArPackageNode> getVariantPackages() {
        HashSet<ArPackageNode> variantPackages = new HashSet<ArPackageNode>();
        for (EpcConfig config : this.epcConfigs) {
            List<ArPackageNode> packages = config.getPackages();
            if (packages.isEmpty()) continue;
            this.addVariantPackagesInSet(variantPackages, packages);
        }
        return new ArrayList<ArPackageNode>(variantPackages);
    }

    private void addVariantPackagesInSet(Set<ArPackageNode> variantPackages, List<ArPackageNode> packages) {
        for (ArPackageNode packageNode : packages) {
            List<ArPackageNode> packageArPackages;
            ElementsNode elements = packageNode.getElements();
            if (!(elements.getPredefinedVariants().isEmpty() && elements.getPostBuildVariantCriterionValueSets().isEmpty() && elements.getCompuMethods().isEmpty() && elements.getPostBuildVariantCriterions().isEmpty())) {
                variantPackages.add(packageNode);
            }
            if ((packageArPackages = packageNode.getArPackages()).isEmpty()) continue;
            this.addVariantPackagesInSet(variantPackages, packageArPackages);
        }
    }

    private void populateCriterions(Set<PostBuildVariantCriterion> variantCriterions, Set<CompuMethod> compuMethods) {
        IConfigSetConfig globalConfigSet;
        IComponentConfig systemComponent = Controller.getInstance().getProfile().getSystemComponentConfig();
        if (systemComponent != null && (globalConfigSet = systemComponent.getGlobalConfigSet()) != null) {
            globalConfigSet.setQuickSelection(null);
            this.populatePostBuildVariantCriterions(globalConfigSet, variantCriterions, compuMethods);
        }
    }

    private void populatePredefinedVariants(Set<PredefinedVariant> predefinedVariants, Set<PostBuildVariantCriterionValueSet> postBuildVariantCriterionValues, Set<PostBuildVariantCriterion> variantCriterions, Set<CompuMethod> compuMethods) {
        ArrayConfig predefinedVariantsArray;
        IConfigSetConfig globalConfigSet;
        PeriphsProfile profile = Controller.getInstance().getProfile();
        IComponentConfig systemComponent = profile.getSystemComponentConfig();
        if (this.importAsNew) {
            profile.clearFunctionalGroups();
        }
        if (systemComponent != null && (globalConfigSet = systemComponent.getGlobalConfigSet()) != null && (predefinedVariantsArray = EpcToPeriphConvertor.getArrayById(globalConfigSet, "PostBuildSelectable.PredefinedVariants")) != null) {
            if (this.importAsNew) {
                predefinedVariantsArray.removeAll();
            }
            for (PredefinedVariant predefinedVariant : predefinedVariants) {
                String name = predefinedVariant.getShortName();
                StoragePeriphsTool stPeriphs = this.sharedConfig.getTools().getPeripherals();
                StoragePeriphsFuncGroup variantToImport = this.getVariantWithName(name);
                if (variantToImport != null && !this.importAsNew && stPeriphs != null) {
                    stPeriphs.getFuncGroups().remove(variantToImport);
                }
                if (stPeriphs != null) {
                    StoragePeriphsFuncGroup variantStorage = EpcToPeriphConvertor.createFunctionalGroupStorage(name);
                    stPeriphs.getFuncGroups().add(variantStorage);
                    this.variantsToImport.add(variantStorage.getName());
                }
                ISettingConfig newPredefinedVariant = predefinedVariantsArray.addNewItem();
                EpcToPeriphConvertor.populateNewPredefinedVariant(newPredefinedVariant, name, predefinedVariant, variantCriterions, compuMethods, postBuildVariantCriterionValues);
            }
        }
    }

    private @Nullable StoragePeriphsFuncGroup getVariantWithName(String name) {
        StoragePeriphsTool stPeriphs = this.sharedConfig.getTools().getPeripherals();
        if (stPeriphs != null) {
            for (StoragePeriphsFuncGroup variant : stPeriphs.getFuncGroups()) {
                if (!name.equals(variant.getName())) continue;
                return variant;
            }
        }
        return null;
    }

    private static void populateNewPredefinedVariant(ISettingConfig newPredefinedVariant, String name, PredefinedVariant predefinedVariant, Set<PostBuildVariantCriterion> variantCriterions, Set<CompuMethod> compuMethods, Set<PostBuildVariantCriterionValueSet> postBuildVariantCriterionValues) {
        if (newPredefinedVariant instanceof StructConfig) {
            StructConfig newPredefinedVariantStruct = (StructConfig)newPredefinedVariant;
            IChild predefinedVariantNameSetting = newPredefinedVariantStruct.getChildById("Name");
            EpcToPeriphConvertor.setScalarConfigChildValue(predefinedVariantNameSetting, name);
            IChild criterionValues = newPredefinedVariantStruct.getChildById("PostBuildVariantCriterionValues");
            if (criterionValues instanceof ArrayConfig) {
                ArrayConfig criterionValuesArray = (ArrayConfig)criterionValues;
                List<PostBuildVariantCriterionValueSetRef> criterionValueSetRefs = predefinedVariant.getPostBuildVariantCriterionValuesSetRef();
                for (PostBuildVariantCriterionValueSetRef criterionValueSetRef : criterionValueSetRefs) {
                    IChild pathSetting = newPredefinedVariantStruct.getChildById("Path");
                    EpcToPeriphConvertor.setScalarConfigChildValue(pathSetting, EpcToPeriphConvertor.createVariantCriterionPath(criterionValueSetRef.getValue(), predefinedVariant.getShortName()));
                    String criterionValueSetName = EpcToPeriphConvertor.getSettingId(criterionValueSetRef.getValue());
                    List<PostBuildVariantCriterionValue> criterionValuesNodes = EpcToPeriphConvertor.getAssociatedCriterionValues(criterionValueSetName, postBuildVariantCriterionValues);
                    for (PostBuildVariantCriterionValue criterionValueNode : criterionValuesNodes) {
                        String criterionName = EpcToPeriphConvertor.getSettingId(criterionValueNode.getVariantCriterionRef().getValue());
                        String criterionValue = criterionValueNode.getValue();
                        EpcToPeriphConvertor.assignCriterionValue(variantCriterions, compuMethods, criterionValuesArray, criterionName, criterionValue);
                    }
                }
            }
        }
    }

    private static void assignCriterionValue(Set<PostBuildVariantCriterion> variantCriterions, Set<CompuMethod> compuMethods, ArrayConfig criterionValuesArray, String criterionName, String criterionValue) {
        for (IChild criterionValueArray : criterionValuesArray.getChildren()) {
            StructConfig criterionValueArrayStruct;
            IChild nameSetting;
            if (!(criterionValueArray instanceof StructConfig) || !((nameSetting = (criterionValueArrayStruct = (StructConfig)criterionValueArray).getChildById("Name")) instanceof ScalarConfig) || !nameSetting.getValue().toString().equals(criterionName)) continue;
            IChild valueSetting = criterionValueArrayStruct.getChildById("Value");
            EpcToPeriphConvertor.setScalarConfigChildValue(valueSetting, EpcToPeriphConvertor.getCriterionMappingValue(variantCriterions, compuMethods, criterionName, criterionValue));
        }
    }

    private static String getCriterionMappingValue(Set<PostBuildVariantCriterion> variantCriterions, Set<CompuMethod> compuMethods, String criterionName, String criterionValue) {
        for (PostBuildVariantCriterion criterion : variantCriterions) {
            String compuMethodRef = criterion.getCompuMethodRef().getValue();
            String compuMethodName = EpcToPeriphConvertor.getSettingId(compuMethodRef);
            CompuMethod compuMethod = EpcToPeriphConvertor.getAssociatedCompuMethod(compuMethodName, compuMethods);
            if (compuMethod == null) continue;
            List<CompuScale> compuScales = compuMethod.getCompuInternalToPhys().getCompuScales();
            for (CompuScale compuScale : compuScales) {
                String compuMethodVT = compuScale.getCompuConst().getVt();
                String lowerLimit = compuScale.getLowerLimit().getValue();
                if (!criterion.getShortName().equals(criterionName) || !criterionValue.equals(lowerLimit)) continue;
                return compuMethodVT.isEmpty() ? lowerLimit : String.valueOf(lowerLimit) + ":" + compuMethodVT;
            }
        }
        return "Not referred";
    }

    private static List<PostBuildVariantCriterionValue> getAssociatedCriterionValues(String criterionValueSetName, Set<PostBuildVariantCriterionValueSet> postBuildVariantCriterionValues) {
        for (PostBuildVariantCriterionValueSet criterionValueSet : postBuildVariantCriterionValues) {
            if (!criterionValueSetName.equals(criterionValueSet.getShortName())) continue;
            return criterionValueSet.getPostBuildVariantCriteriosValues();
        }
        return Collections.emptyList();
    }

    private static StoragePeriphsFuncGroup createFunctionalGroupStorage(String name) {
        StoragePeriphsFuncGroup groupStorage = new StoragePeriphsFuncGroup();
        groupStorage.setName(name);
        groupStorage.setDescription("");
        groupStorage.setCalledFromInit(false);
        return groupStorage;
    }

    private void populatePostBuildVariantCriterions(IConfigSetConfig globalConfigSet, Set<PostBuildVariantCriterion> variantCriterions, Set<CompuMethod> compuMethods) {
        ArrayConfig criterionsArray = EpcToPeriphConvertor.getArrayById(globalConfigSet, "Criterions.PostBuildVariantCriterions");
        if (criterionsArray != null) {
            for (PostBuildVariantCriterion criterion : variantCriterions) {
                ISettingConfig newCriterion = criterionsArray.addNewItem();
                if (!(newCriterion instanceof StructConfig)) continue;
                StructConfig newCriterionStruct = (StructConfig)newCriterion;
                IChild nameSetting = newCriterionStruct.getChildById("Name");
                IChild pathSetting = newCriterionStruct.getChildById("Path");
                EpcToPeriphConvertor.setScalarConfigChildValue(nameSetting, criterion.getShortName());
                String compuMethodRef = criterion.getCompuMethodRef().getValue();
                String criterionPath = EpcToPeriphConvertor.createVariantCriterionPath(compuMethodRef, criterion.getShortName());
                if (!this.importAsNew) {
                    EpcToPeriphConvertor.removeCriterionIfExists(criterionsArray, criterionPath);
                }
                EpcToPeriphConvertor.setScalarConfigChildValue(pathSetting, criterionPath);
                String compuMethodName = EpcToPeriphConvertor.getSettingId(compuMethodRef);
                CompuMethod compuMethod = EpcToPeriphConvertor.getAssociatedCompuMethod(compuMethodName, compuMethods);
                if (compuMethod == null) continue;
                EpcToPeriphConvertor.populateNewCompuMethod(compuMethod, newCriterionStruct);
            }
        }
    }

    private static void populateNewCompuMethod(CompuMethod compuMethod, StructConfig newCriterionStruct) {
        List<CompuScale> compuScales = compuMethod.getCompuInternalToPhys().getCompuScales();
        for (CompuScale compuScale : compuScales) {
            ISettingConfig newCompuMethod;
            IChild compuMethodsArray = newCriterionStruct.getChildById("CompuMethods");
            if (!(compuMethodsArray instanceof ArrayConfig) || !((newCompuMethod = ((ArrayConfig)compuMethodsArray).addNewItem()) instanceof StructConfig)) continue;
            StructConfig newCompuMethodStruct = (StructConfig)newCompuMethod;
            String compuMethodValue = compuScale.getLowerLimit().getValue();
            String compuMethodVT = compuScale.getCompuConst().getVt();
            IChild compuMethodNameSetting = newCompuMethodStruct.getChildById("Name");
            EpcToPeriphConvertor.setScalarConfigChildValue(compuMethodNameSetting, compuMethodVT);
            IChild compuMethodValueSetting = newCompuMethodStruct.getChildById("Value");
            EpcToPeriphConvertor.setScalarConfigChildValue(compuMethodValueSetting, compuMethodValue);
        }
    }

    private static void setScalarConfigChildValue(@Nullable IChild child, String value) {
        if (child instanceof ScalarConfig) {
            ((ScalarConfig)child).setValue(value);
        }
    }

    private static @Nullable CompuMethod getAssociatedCompuMethod(String compuMethodName, Set<CompuMethod> compuMethods) {
        for (CompuMethod compuMethod : compuMethods) {
            if (!compuMethodName.equals(compuMethod.getShortName())) continue;
            return compuMethod;
        }
        return null;
    }

    private void addCriterionInformationsToSets(Set<PostBuildVariantCriterion> postBuildVariantCriterions, Set<CompuMethod> compuMethods, List<ArPackageNode> variantPackages) {
        for (ArPackageNode packageNode : variantPackages) {
            List<ArPackageNode> packageArPackages;
            List<CompuMethod> compuMetodsLoc;
            List<PostBuildVariantCriterion> variantCriterionsLoc = packageNode.getElements().getPostBuildVariantCriterions();
            if (!variantCriterionsLoc.isEmpty()) {
                postBuildVariantCriterions.addAll(variantCriterionsLoc);
            }
            if (!(compuMetodsLoc = packageNode.getElements().getCompuMethods()).isEmpty()) {
                compuMethods.addAll(compuMetodsLoc);
            }
            if ((packageArPackages = packageNode.getArPackages()).isEmpty()) continue;
            this.addCriterionInformationsToSets(postBuildVariantCriterions, compuMethods, packageArPackages);
        }
    }

    private void addPredefinedVariantInformationToSets(Set<PredefinedVariant> predefinedVariants, Set<PostBuildVariantCriterionValueSet> postBuildVariantCriterionValues, List<ArPackageNode> variantPackages) {
        for (ArPackageNode packageNode : variantPackages) {
            List<ArPackageNode> packageArPackages;
            List<PostBuildVariantCriterionValueSet> postBuildVariantCriterionValuesLoc;
            List<PredefinedVariant> predefinedVariantsLoc = packageNode.getElements().getPredefinedVariants();
            if (!predefinedVariantsLoc.isEmpty()) {
                predefinedVariants.addAll(predefinedVariantsLoc);
            }
            if (!(postBuildVariantCriterionValuesLoc = packageNode.getElements().getPostBuildVariantCriterionValueSets()).isEmpty()) {
                postBuildVariantCriterionValues.addAll(postBuildVariantCriterionValuesLoc);
            }
            if ((packageArPackages = packageNode.getArPackages()).isEmpty()) continue;
            this.addPredefinedVariantInformationToSets(predefinedVariants, postBuildVariantCriterionValues, packageArPackages);
        }
    }

    private static boolean isCriterionMatchingWithVariationPoint(VariationPoint variationPoint, String variantName) {
        Map<String, String> criterionValues = EpcToPeriphConvertor.getCriterionValuesForVariant(variantName);
        boolean matching = true;
        for (PostBuildVariantCondition condition : variationPoint.getPostBuildVariantConditions()) {
            String criterionName = EpcToPeriphConvertor.getSettingId(condition.getMatchingCriterionRef().getValue());
            String associatedCriterionValue = criterionValues.get(criterionName);
            if (associatedCriterionValue == null) continue;
            matching &= associatedCriterionValue.equals(condition.getValue());
        }
        return matching;
    }

    private void addSettingToStorage(ISetting setting, AStoragePeriphsStructuredSetting parentStorage, String value, boolean arrayType, @Nullable VariationPoint variationPoint, String type, String parentName) {
        StoragePeriphsScalarSetting stScalarSetting = new StoragePeriphsScalarSetting();
        if (!arrayType) {
            stScalarSetting.setName(setting.getId());
        }
        String currentVariantName = this.getCurrentVariant().getName();
        String populatedSettingId = String.valueOf(parentName) + "." + setting.getId() + "." + currentVariantName;
        if ("bool".equals(type)) {
            String string = value = value.equals("1") ? Boolean.TRUE.toString() : Boolean.valueOf(value).toString();
        }
        if (variationPoint != null) {
            if (EpcToPeriphConvertor.isCriterionMatchingWithVariationPoint(variationPoint, currentVariantName)) {
                stScalarSetting.setValue(value);
                populatedVariantSettings.add(populatedSettingId);
                parentStorage.addSetting((AStoragePeriphsSetting)stScalarSetting);
            }
        } else if (!populatedVariantSettings.contains(populatedSettingId)) {
            stScalarSetting.setValue(value);
            parentStorage.addSetting((AStoragePeriphsSetting)stScalarSetting);
        }
    }

    private static Map<String, String> getCriterionValuesForVariant(String variantName) {
        ArrayConfig predefinedVariantsArray;
        IConfigSetConfig globalCfgSet;
        HashMap<String, String> result = new HashMap<String, String>();
        IComponentConfig systemComponent = Controller.getInstance().getProfile().getSystemComponentConfig();
        if (systemComponent != null && (globalCfgSet = systemComponent.getGlobalConfigSet()) != null && (predefinedVariantsArray = EpcToPeriphConvertor.getArrayById(globalCfgSet, "PostBuildSelectable.PredefinedVariants")) != null) {
            for (ISettingConfig variant : predefinedVariantsArray.getChildren()) {
                IChild criterionValues;
                StructConfig variantStruct;
                IChild nameSetting;
                if (!(variant instanceof StructConfig) || !((nameSetting = (variantStruct = (StructConfig)variant).getChildById("Name")) instanceof ScalarConfig) || !nameSetting.getValue().toString().equals(variantName) || !((criterionValues = variantStruct.getChildById("PostBuildVariantCriterionValues")) instanceof ArrayConfig)) continue;
                ArrayConfig criterionValuesArray = (ArrayConfig)criterionValues;
                for (ISettingConfig criterionValue : criterionValuesArray.getChildren()) {
                    if (!(criterionValue instanceof StructConfig)) continue;
                    StructConfig criterionStruct = (StructConfig)criterionValue;
                    IChild criterionNameSetting = criterionStruct.getChildById("Name");
                    IChild criterionValueSetting = criterionStruct.getChildById("Value");
                    if (criterionNameSetting == null || criterionValueSetting == null) continue;
                    result.put(criterionNameSetting.getValue().toString(), criterionValueSetting.getValue().toString().split(":")[0]);
                }
            }
        }
        return result;
    }

    private static @Nullable ArrayConfig getArrayById(IConfigSetConfig globalCfgSet, String id) {
        IChild predefinedVariants = globalCfgSet.getChildById(id);
        if (predefinedVariants instanceof ArrayConfig) {
            return (ArrayConfig)predefinedVariants;
        }
        LOGGER.log(Level.SEVERE, MessageFormat.format("[DATA] The array with ID {0} could not be obtained.", id));
        return null;
    }

    List<String> getVariantsToImport() {
        return this.variantsToImport;
    }

    private List<StoragePeriphsFuncGroup> getFunctionalGroupsStorage() {
        StoragePeriphsTool stPeriphs = this.sharedConfig.getTools().getPeripherals();
        if (stPeriphs != null) {
            return stPeriphs.getFuncGroups();
        }
        return Collections.emptyList();
    }

    private StoragePeriphsFuncGroup getCurrentVariant() {
        return this.currentVariant;
    }

    private void setCurrentVariant(StoragePeriphsFuncGroup variant) {
        this.currentVariant = variant;
    }

    private StorageClocksConfiguration getCurrentClockConfiguration() {
        return this.currentClockConfiguration;
    }

    private void setCurrentClockConfiguration(StorageClocksConfiguration currentClockConfiguration) {
        this.currentClockConfiguration = currentClockConfiguration;
    }

    private static String createVariantCriterionPath(String variantCriterionDest, String variantCriterionName) {
        return String.valueOf(variantCriterionDest.substring(0, variantCriterionDest.lastIndexOf("/") + 1)) + variantCriterionName;
    }

    private static void removeCriterionIfExists(ArrayConfig criterionsArray, String criterionPath) {
        ISettingConfig criterionToRemove = null;
        for (ISettingConfig criterion : criterionsArray.getChildren()) {
            ScalarConfig path;
            StructConfig criterionStruct;
            IChild pathSetting;
            if (!(criterion instanceof StructConfig) || !((pathSetting = (criterionStruct = (StructConfig)criterion).getChildById("Path")) instanceof ScalarConfig) || !(path = (ScalarConfig)pathSetting).getValue().toString().equals(criterionPath)) continue;
            criterionToRemove = criterion;
            break;
        }
        if (criterionToRemove != null) {
            criterionsArray.remove(criterionToRemove);
        }
    }

    private void createClockSettingStorage(ISetting setting, String value, @Nullable VariationPoint variationPoint) {
        if (setting.isOptionSet("clocksToolId")) {
            IContext profileContext = Controller.getInstance().getProfile().getExpressionContext();
            Object clockSettingId = setting.getOptionValue("clocksToolId", profileContext);
            Object clockSettingType = setting.getOptionValue("clocksSettingType", profileContext);
            if (clockSettingId instanceof String && clockSettingType instanceof String) {
                String stringClockSettingId = clockSettingId.toString();
                String stringClockSettingType = clockSettingType.toString();
                if ("bool".equals(setting.getTypeName())) {
                    String string = value = value.equals("1") ? Boolean.TRUE.toString() : Boolean.valueOf(value).toString();
                }
                if (variationPoint != null) {
                    String variantName = this.getCurrentVariant().getName();
                    if (EpcToPeriphConvertor.isCriterionMatchingWithVariationPoint(variationPoint, variantName)) {
                        ClocksImporterHelper.createAndStoreClockSetting(stringClockSettingId, value, this.getCurrentClockConfiguration(), stringClockSettingType);
                    }
                } else {
                    ClocksImporterHelper.createAndStoreClockSetting(stringClockSettingId, value, this.getCurrentClockConfiguration(), stringClockSettingType);
                }
            }
        }
    }
}

