/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.ui.navigator;

import com.nxp.s32ds.cle.cdt.project.configuration.core.ProjectConfigurationUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachDataHelper;
import com.nxp.s32ds.cle.cdt.sdk.core.filtering.ProjectCompatibleSdksFilter;
import com.nxp.s32ds.cle.cdt.sdk.core.module.SdkModulesHelper;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilter;
import com.nxp.s32ds.cle.cdt.sdk.ui.internal.navigator.SdkUiNavigatorActivator;
import com.nxp.s32ds.cle.cdt.sdk.ui.navigator.ExtendedIncludeRef;
import com.nxp.s32ds.cle.cdt.sdk.ui.navigator.IExtendedIncludeReference;
import com.nxp.s32ds.cle.ide.sdk.core.resource.SdkProjectResourcesUtils;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.environment.EnvironmentSdkCore;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.module.ModuleSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.resource.ResourceSdkCore;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.resource.ResourceSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.module.ModuleSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkKind;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IIncludeReference;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class SdkExplorerContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY = new Object[0];
    private ICProject project;
    private final Map<RefKey, IExtendedIncludeReference> extRefMap = new HashMap<RefKey, IExtendedIncludeReference>();

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.project = (ICProject)newInput;
    }

    public Object getParent(Object element) {
        return null;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ICProject) {
            return SdkExplorerContentProvider.getProjectChildElements((ICProject)parentElement);
        }
        if (parentElement instanceof SdkDescriptor) {
            return this.getSdkNodeChildElements((SdkDescriptor)parentElement);
        }
        if (parentElement instanceof ModuleSdkDescriptor) {
            SdkDescriptor refSdkDescriptor = SdkDescriptors.getSdkDescriptor((String)((ModuleSdkDescriptor)parentElement).getModuleSdkId());
            return this.sortToArray(new ArrayList<ICElement>(this.getICElements(refSdkDescriptor)));
        }
        if (parentElement instanceof ExtendedIncludeRef) {
            return this.getIncRefChildren((IExtendedIncludeReference)parentElement);
        }
        if (parentElement instanceof IParent) {
            return this.getICElements((IParent)parentElement);
        }
        return EMPTY;
    }

    private static Object[] getProjectChildElements(ICProject icProject) {
        List attachedSdks = SdkAttachDataHelper.getSdksAttachedToProject((IProject)icProject.getProject(), (boolean)false);
        ArrayList grouppedSdks = new ArrayList(attachedSdks);
        attachedSdks.stream().forEach(sdk -> {
            boolean bl = grouppedSdks.removeAll(SdkModulesHelper.getRefModulesSdksDescriptors((String)sdk.getId()));
        });
        return grouppedSdks.toArray();
    }

    private Object[] getSdkNodeChildElements(SdkDescriptor sdkDescriptor) {
        IConfiguration defaultConfig;
        IProject iProject = this.project.getProject();
        if (iProject.isAccessible() && (defaultConfig = ProjectConfigurationUtils.getDefaultConfiguration((IProject)iProject)) != null) {
            ArrayList<ICElement> children = new ArrayList<ICElement>();
            List modules = ModuleSdkDescriptors.getModuleSdkDescriptorsBySdkId((String)sdkDescriptor.getId());
            if (!modules.isEmpty()) {
                children.addAll(SdkModulesHelper.getRefModulesDescriptors((String)sdkDescriptor.getId(), (SdkFilter)new ProjectCompatibleSdksFilter(iProject)));
            } else {
                children.addAll(this.getICElements(sdkDescriptor));
            }
            return children.toArray();
        }
        return new Object[0];
    }

    private List<ICElement> getICElements(SdkDescriptor sdkDescriptor) {
        IProject iProject = this.project.getProject();
        if (!iProject.isAccessible() || sdkDescriptor == null) {
            return Collections.emptyList();
        }
        String defaultToolChainId = ProjectConfigurationUtils.getDefaultToolChainId((IProject)this.project.getProject());
        if (defaultToolChainId == null) {
            return Collections.emptyList();
        }
        ArrayList<ICElement> children = new ArrayList<ICElement>();
        String sdkId = sdkDescriptor.getId();
        List<IPath> headers = SdkExplorerContentProvider.getSdkHeaders(sdkId);
        IPath sdkBasePath = EnvironmentSdkCore.getResolvedSdkPath((String)sdkId);
        try {
            List sdkIncRefs = Arrays.stream(this.project.getIncludeReferences()).filter(incRef -> this.isSelectedInSDK((ICElement)incRef, headers, sdkDescriptor)).collect(Collectors.toList());
            if (sdkIncRefs.isEmpty()) {
                return Collections.emptyList();
            }
            HashMap<String, IExtendedIncludeReference> segments = new HashMap<String, IExtendedIncludeReference>();
            for (IIncludeReference ref : sdkIncRefs) {
                IExtendedInculdeReferenceCreator extInculdeReferenceCreator = (lpath, lref) -> this.extRefMap.computeIfAbsent(RefKey.create(lpath, lref), k -> new ExtendedIncludeRef(lpath, lref));
                this.processIncludeReference(ref, sdkBasePath, children, segments, headers, extInculdeReferenceCreator);
            }
        }
        catch (CModelException e) {
            SdkUiNavigatorActivator.getInstance().logError("C Model Exception", e);
        }
        return Arrays.asList(this.sortToArray(children));
    }

    private static List<IPath> getSdkHeaders(String sdkId) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkId((String)sdkId).stream().filter(resource -> ResourceSdkKind.HEADER_FOLDER == resource.getKind() || ResourceSdkKind.HEADER_FILE == resource.getKind()).map(resource -> Path.fromOSString((String)resource.getPath())).collect(Collectors.toList());
    }

    private Object[] getICElements(IParent parent) {
        ArrayList<IMethodDeclaration> children = new ArrayList<IMethodDeclaration>();
        try {
            children.addAll(parent.getChildrenOfType(79));
            children.addAll(parent.getChildrenOfType(61));
            children.addAll(parent.getChildrenOfType(65));
            children.addAll(parent.getChildrenOfType(83));
            children.addAll(parent.getChildrenOfType(82));
            List methods = parent.getChildrenOfType(70);
            methods.addAll(parent.getChildrenOfType(71));
            for (ICElement m : methods) {
                IMethodDeclaration md = (IMethodDeclaration)m;
                if (md.isConstructor() || md.isDestructor() || md.getVisibility() != ASTAccessVisibility.PUBLIC) continue;
                children.add(md);
            }
            children.addAll(parent.getChildrenOfType(74));
            children.addAll(parent.getChildrenOfType(73));
            children.addAll(parent.getChildrenOfType(89));
            children.addAll(parent.getChildrenOfType(88));
            children.addAll(parent.getChildrenOfType(63));
            children.addAll(parent.getChildrenOfType(81));
        }
        catch (CModelException e) {
            SdkUiNavigatorActivator.getInstance().logError("C Model Exception", e);
        }
        return children.toArray();
    }

    private boolean isSelectedInSDK(ICElement element, List<IPath> headers, SdkDescriptor sdk) {
        boolean isMatched = false;
        if (element instanceof ITranslationUnit) {
            isMatched = headers.stream().anyMatch(h -> this.isHeaderMatched((IPath)h, ((ITranslationUnit)element).getPath(), sdk));
        } else if (element instanceof IIncludeReference) {
            IIncludeReference ir = (IIncludeReference)element;
            try {
                ICElement[] iCElementArray = ir.getChildren();
                int n = iCElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICElement child = iCElementArray[n2];
                    if (!(child instanceof ITranslationUnit) || !(isMatched = this.isSelectedInSDK(child, headers, sdk))) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
            catch (CModelException cModelException) {}
        }
        return isMatched;
    }

    private boolean isHeaderMatched(IPath headerFilePath, IPath includeRefElementPath, SdkDescriptor sdk) {
        IPath location;
        IResource targetResource;
        Optional<ResourceSdkDescriptor> optional;
        boolean isMatched = headerFilePath.isPrefixOf(includeRefElementPath);
        if (!isMatched && (optional = ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkId((String)sdk.getId()).stream().filter(r -> (ResourceSdkKind.HEADER_FOLDER == r.getKind() || ResourceSdkKind.HEADER_FILE == r.getKind()) && headerFilePath.toOSString().equals(r.getPath())).findFirst()).isPresent() && (targetResource = SdkProjectResourcesUtils.getTargetResource((ResourceSdkDescriptor)optional.get(), (SdkDescriptor)sdk, (IProject)this.project.getProject(), null)) != null && (location = targetResource.getLocation()) != null) {
            IPath targetFilePath = Path.fromOSString((String)location.toOSString());
            isMatched = targetFilePath.isPrefixOf(includeRefElementPath);
        }
        return isMatched;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    private ICElement[] getIncRefChildren(IIncludeReference incRef) {
        return this.getRefChildren(incRef, new IRefWrapper<IIncludeReference>(){

            @Override
            public IIncludeReference create(IPath base, ICElement parent) {
                IIncludeReference ref = (IIncludeReference)parent;
                RefKey key = RefKey.create(base, ref);
                return SdkExplorerContentProvider.this.extRefMap.computeIfAbsent(key, s -> new ExtendedIncludeRef(base, ref));
            }

            @Override
            public boolean acceptRef(ICElement ref) {
                return ref instanceof ExtendedIncludeRef && SdkExplorerContentProvider.this.contains(ref, ResourceSdkCore.headerFilesMatcher);
            }

            @Override
            public boolean accept(ICElement element) {
                return element instanceof ITranslationUnit && ((ITranslationUnit)element).isHeaderUnit();
            }
        });
    }

    private <R extends IParent & ICElement> ICElement[] getRefChildren(R baseRef, IRefWrapper<R> wrapper) {
        ArrayList<ICElement> refChildren = new ArrayList<ICElement>();
        try {
            IPath path = ((ICElement)baseRef).getPath();
            HashMap<String, IExtendedIncludeReference> segments = new HashMap<String, IExtendedIncludeReference>();
            ICElement[] iCElementArray = baseRef.getChildren();
            int n = iCElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICElement element = iCElementArray[n2];
                if (wrapper.acceptRef(element)) {
                    IIncludeReference ref = ((IExtendedIncludeReference)element).get();
                    this.processIncludeReference(ref, path, refChildren, segments, Collections.emptyList(), (aPath, aRef) -> (IExtendedIncludeReference)wrapper.create(aPath, (ICElement)aRef));
                } else if (wrapper.accept(element)) {
                    refChildren.add(element);
                }
                ++n2;
            }
        }
        catch (CModelException e) {
            SdkUiNavigatorActivator.getInstance().logError("C Model Exception", e);
        }
        return this.sortToArray(refChildren);
    }

    private <T extends ICElement> boolean contains(T ref, final PathMatcher matcher) {
        final boolean[] found = new boolean[1];
        java.nio.file.Path root = Paths.get(ref.getPath().toOSString(), new String[0]);
        try {
            Files.walkFileTree(root, (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

                @Override
                public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                    if (matcher.matches(file)) {
                        found[0] = true;
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            SdkUiNavigatorActivator.getInstance().logError("IO Exception", e);
        }
        return found[0];
    }

    private ICElement[] sortToArray(List<ICElement> list) {
        if (!list.isEmpty()) {
            Collections.sort(list, (o1, o2) -> {
                boolean isDir1 = o1.getPath().toFile().isDirectory();
                boolean isDir2 = o2.getPath().toFile().isDirectory();
                String path1 = o1.getPath().toString();
                String path2 = o2.getPath().toString();
                if (isDir1 && isDir2 || !isDir1 && !isDir2) {
                    return path1.compareTo(path2);
                }
                return isDir1 ? -1 : 1;
            });
        }
        return list.toArray(new ICElement[list.size()]);
    }

    private void processIncludeReference(IIncludeReference ref, IPath sdkPath, List<ICElement> children, Map<String, IExtendedIncludeReference> segments, List<IPath> headers, IExtendedInculdeReferenceCreator creator) throws CModelException {
        IPath parent;
        IExtendedIncludeReference extRef;
        IPath includeReferencePath = ref.getPath();
        if (includeReferencePath.equals((Object)sdkPath)) {
            children.addAll(Arrays.stream(this.getIncRefChildren(ref)).filter(incRefChild -> headers.contains(incRefChild.getPath())).collect(Collectors.toSet()));
            return;
        }
        if (!sdkPath.isPrefixOf(includeReferencePath)) {
            return;
        }
        String first = includeReferencePath.makeRelativeTo(sdkPath).segment(0);
        if (!segments.containsKey(first)) {
            extRef = creator.create(sdkPath, ref);
            segments.put(first, extRef);
            children.add((ICElement)extRef);
        }
        if (includeReferencePath.equals((Object)(parent = (extRef = segments.get(first)).getPath()))) {
            extRef.addAll(ref.getChildren());
        } else {
            IExtendedIncludeReference child = creator.create(parent, ref);
            extRef.add((ICElement)child);
        }
    }

    static interface IExtendedInculdeReferenceCreator {
        public IExtendedIncludeReference create(IPath var1, IIncludeReference var2);
    }

    static interface IRefWrapper<R extends IParent & ICElement> {
        public R create(IPath var1, ICElement var2);

        public boolean acceptRef(ICElement var1);

        public boolean accept(ICElement var1);
    }

    static class RefKey {
        final IPath base;
        final IIncludeReference ref;

        public static RefKey create(IPath base, IIncludeReference ref) {
            return new RefKey(base, ref);
        }

        RefKey(IPath base, IIncludeReference ref) {
            this.base = base;
            this.ref = ref;
        }

        public int hashCode() {
            return 31 * this.base.hashCode() + 13 * this.ref.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RefKey)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            RefKey other = (RefKey)obj;
            return this.base.equals((Object)other.base) && this.ref.equals(other.ref);
        }
    }
}

