/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model;

import com.nxp.swtools.common.utils.logging.LogManager;
import java.io.File;
import java.net.URL;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Version;

public class XSDUtils {
    private static final Logger LOGGER = LogManager.getLogger(XSDUtils.class);
    private static final Version HIGHEST_SCHEMA_VERSION = new Version("13.0");

    public static void verifySchemaVersion(URL schema, File source) {
        Version schemaVersion;
        String fileName = schema.getFile();
        Matcher pattern = Pattern.compile(".*-(.*).xsd").matcher(fileName);
        if (!pattern.matches()) {
            return;
        }
        String version = pattern.group(1);
        try {
            assert (version != null);
            schemaVersion = Version.valueOf((String)version);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.severe(String.format("[DATA] XML file %1s references an improperly formatted schema version %2s", source.getAbsolutePath(), version));
            return;
        }
        int result = schemaVersion.compareTo(HIGHEST_SCHEMA_VERSION);
        if (result > 0) {
            LOGGER.severe(String.format("[DATA] XML file %1s references schema version %2s, which is higher than the supported %3s", source.getAbsolutePath(), schemaVersion, HIGHEST_SCHEMA_VERSION));
        }
    }
}

