/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.config;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.concurrent.CounterLatch;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.core.service.scriptapi.db.IRegBitFieldAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegParentPeripheralAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegisterAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.resourcetables.model.config.AssignConfig;
import com.nxp.swtools.resourcetables.model.config.ChildContext;
import com.nxp.swtools.resourcetables.model.config.ChildProviderHelper;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.config.RegisterConfig;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.resourcetables.model.config.SetConfig;
import com.nxp.swtools.resourcetables.model.mcu.ICommonMcu;
import com.nxp.swtools.utils.registers.BitFieldInfo;
import com.nxp.swtools.utils.registers.BitFieldProvider;
import com.nxp.swtools.utils.registers.RegisterData;
import com.nxp.swtools.utils.registers.RegisterInfo;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RegistersModelSingleton {
    public static final String PERIPHERAL_REGISTER_SEPARATOR = "::";
    private final Map<IFunctionalGroup, List<CollectionsUtils.Pair<RegisterConfig, AssignConfig>>> registerAssingsBoundToRegister = new HashMap<IFunctionalGroup, List<CollectionsUtils.Pair<RegisterConfig, AssignConfig>>>();
    @Nullable
    private ICommonMcu mcu = null;
    static final Logger LOGGER = LogManager.getLogger(RegistersModelSingleton.class);
    private Map<IFunctionalGroup, Map<String, Map<String, BitFieldValue>>> registerValues = new HashMap<IFunctionalGroup, Map<String, Map<String, BitFieldValue>>>();
    private CounterLatch assignCreationLatch = new CounterLatch(0);
    public static final BigInteger ERROR_REGISTER_DATABASE_NOT_FOUND = BigInteger.valueOf(-1L);
    public static final BigInteger ERROR_PERIPHERAL_NOT_FOUND = BigInteger.valueOf(-2L);
    public static final BigInteger ERROR_REGISTER_NOT_FOUND = BigInteger.valueOf(-3L);
    public static final BigInteger ERROR_BITFIELD_NOT_FOUND = BigInteger.valueOf(-4L);
    public static final BigInteger ERROR_REGISTER_BASE_ADDRESS_NOT_FOUND = BigInteger.valueOf(-5L);
    public static final BigInteger ERROR_PERIPHERAL_BASE_ADDRESS_NOT_FOUND = BigInteger.valueOf(-6L);
    public static final BigInteger ERROR_ALIAS_WITH_TYPE_NOT_FOUND = BigInteger.valueOf(-7L);
    @Nullable
    private IComponentInstanceConfig selectedInstance = null;
    private boolean regenerationNeeded;
    private static Function<IChild, String> GET_LOGGABLE_ID_FUNCTION = x -> {
        IComponentInstanceConfig instance = x.getChildContext().getComponentInstanceConfig();
        if (instance != null) {
            return String.valueOf(instance.getId()) + "." + x.getId();
        }
        return x.getId();
    };

    private RegistersModelSingleton() {
    }

    public static RegistersModelSingleton getInstance() {
        try {
            return (RegistersModelSingleton)SWTFactoryProxy.INSTANCE.getSingletonInstance(RegistersModelSingleton.class);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Cannot obtain instance of a controller", e);
        }
    }

    public void initialize(ICommonMcu newMcu) {
        this.mcu = newMcu;
    }

    public ICommonMcu getMcuNonNull() throws NullPointerException {
        ICommonMcu mcuLoc = this.mcu;
        if (mcuLoc == null) {
            LOGGER.log(Level.SEVERE, "[TOOL] RegisterModelSingleton was not yet beed initialized. Mcu is not set");
        }
        return Objects.requireNonNull(mcuLoc);
    }

    public Set<String> getConfiguredRegisterNames(IFunctionalGroup group) {
        return this.getRegisters(group).keySet();
    }

    public Map<String, Map<String, BitFieldValue>> getRegisters(IFunctionalGroup group) {
        Map registersOfFunctionalGroup = this.registerValues.computeIfAbsent(group, x -> new HashMap());
        assert (registersOfFunctionalGroup != null);
        return registersOfFunctionalGroup;
    }

    public Map<String, BitFieldValue> getBitFields(IFunctionalGroup group, String registerName) {
        Map bitfields = this.registerValues.computeIfAbsent(group, x -> new HashMap());
        assert (bitfields != null);
        Map computeIfAbsent = bitfields.computeIfAbsent(registerName, x -> new HashMap());
        assert (computeIfAbsent != null);
        return computeIfAbsent;
    }

    public BigInteger getValueOfBitField(IFunctionalGroup group, String registerIdentification, String bitfieldIdentification) {
        String[] parts = registerIdentification.split(PERIPHERAL_REGISTER_SEPARATOR);
        if (parts.length != 2) {
            LOGGER.log(Level.SEVERE, "[TOOL] Register {0} does not specify both peripheral and register separated by ::", registerIdentification);
            return ERROR_REGISTER_NOT_FOUND;
        }
        IRegistersDatabaseAPI registersDb = group.getMcu().getRegistersDb();
        if (registersDb == null) {
            return ERROR_REGISTER_DATABASE_NOT_FOUND;
        }
        IRegParentPeripheralAPI peripheral = RegistersModelSingleton.getPeripheralInternal(registersDb, parts[0]);
        if (peripheral == null) {
            return ERROR_PERIPHERAL_NOT_FOUND;
        }
        IRegisterAPI register = RegistersModelSingleton.getRegisterInternal(peripheral, parts[1]);
        if (register == null) {
            return ERROR_REGISTER_NOT_FOUND;
        }
        String newRegisterIdentification = RegistersModelSingleton.computeFullNameOfRegister(peripheral.getName(), register.getName());
        BitFieldValue userValueOfBitfield = this.getBitFields(group, newRegisterIdentification).get(bitfieldIdentification);
        if (userValueOfBitfield == null) {
            return RegistersModelSingleton.getResetValueOfBitfieldInternal(this.getMcuNonNull(), parts[0], parts[1], bitfieldIdentification);
        }
        return userValueOfBitfield.getValue();
    }

    public String getDescriptionOfBitField(String peripheralIdentification, String registerIdentification, String bitfieldIdentification) {
        IRegistersDatabaseAPI registersDb = this.getMcuNonNull().getRegistersDb();
        if (registersDb == null) {
            return String.valueOf(ERROR_REGISTER_DATABASE_NOT_FOUND);
        }
        IRegParentPeripheralAPI peripheral = RegistersModelSingleton.getPeripheralInternal(registersDb, peripheralIdentification);
        if (peripheral == null) {
            return String.valueOf(ERROR_PERIPHERAL_NOT_FOUND);
        }
        IRegisterAPI register = RegistersModelSingleton.getRegisterInternal(peripheral, registerIdentification);
        if (register == null) {
            return String.valueOf(ERROR_REGISTER_NOT_FOUND);
        }
        IRegBitFieldAPI bitfield = RegistersModelSingleton.getBitfieldInternal(register, bitfieldIdentification);
        if (bitfield == null) {
            return String.valueOf(ERROR_BITFIELD_NOT_FOUND);
        }
        return bitfield.getDescription();
    }

    public BigInteger getValueOfRegister(IFunctionalGroup group, String peripheralIdentification, String registerIdentification) {
        IRegistersDatabaseAPI registersDb = this.getMcuNonNull().getRegistersDb();
        if (registersDb == null) {
            return ERROR_REGISTER_DATABASE_NOT_FOUND;
        }
        IRegParentPeripheralAPI peripheral = RegistersModelSingleton.getPeripheralInternal(registersDb, peripheralIdentification);
        if (peripheral == null) {
            return ERROR_PERIPHERAL_NOT_FOUND;
        }
        IRegisterAPI register = RegistersModelSingleton.getRegisterInternal(peripheral, registerIdentification);
        if (register == null) {
            return ERROR_REGISTER_NOT_FOUND;
        }
        String registerFullName = RegistersModelSingleton.computeFullNameOfRegister(peripheral.getName(), register.getName());
        Map<String, BitFieldValue> bitFields = this.getBitFields(group, registerFullName);
        RegisterData registerData = RegisterData.valueOf((String)peripheralIdentification, (String)registerIdentification, (IRegistersDatabaseAPI)registersDb);
        if (registerData == null) {
            return ERROR_REGISTER_NOT_FOUND;
        }
        ArrayList<BitFieldInfo> infos = new ArrayList<BitFieldInfo>();
        for (Map.Entry<String, BitFieldValue> entry : bitFields.entrySet()) {
            BitFieldInfo info;
            IRegBitFieldAPI bitfield = BitFieldProvider.findBitField((String)peripheralIdentification, (String)registerIdentification, (String)entry.getKey(), (IRegistersDatabaseAPI)registersDb);
            if (bitfield == null || (info = BitFieldInfo.create((String)peripheralIdentification, (String)registerIdentification, (String)entry.getKey(), (BigInteger)entry.getValue().getValue(), (boolean)false, (IRegistersDatabaseAPI)registersDb)) == null) continue;
            infos.add(info);
        }
        RegisterInfo registerInfo = new RegisterInfo(registerData, infos);
        return registerInfo.getValue();
    }

    public String getDescriptionOfRegister(String peripheralIdentification, String registerIdentification) {
        IRegistersDatabaseAPI registersDb = this.getMcuNonNull().getRegistersDb();
        if (registersDb == null) {
            return String.valueOf(ERROR_REGISTER_DATABASE_NOT_FOUND);
        }
        IRegParentPeripheralAPI peripheral = RegistersModelSingleton.getPeripheralInternal(registersDb, peripheralIdentification);
        if (peripheral == null) {
            return String.valueOf(ERROR_PERIPHERAL_NOT_FOUND);
        }
        IRegisterAPI register = RegistersModelSingleton.getRegisterInternal(peripheral, registerIdentification);
        if (register == null) {
            return String.valueOf(ERROR_REGISTER_NOT_FOUND);
        }
        return register.getDescription();
    }

    public void setValueOfBitfield(IFunctionalGroup group, RegisterConfig register, IChild node, @Nullable BigInteger value, AssignConfig assign, boolean notifyOthers) {
        if (!assign.isEnabled()) {
            return;
        }
        if (group.getError() != null) {
            this.regenerationNeeded = true;
            return;
        }
        String instancePeripheral = "";
        IComponentInstanceConfig instance = node.getChildContext().getComponentInstanceConfig();
        if (instance != null) {
            instancePeripheral = UtilsText.safeString((String)instance.getPeripheral());
        }
        IContext nodeExpressionContext = node.getExpressionContext();
        String registerPeripheral = null;
        String registerName = "";
        String bitfieldName = "";
        BigInteger unknownBitsMask = BigInteger.ZERO;
        try {
            registerPeripheral = register.getPeripheral(nodeExpressionContext);
            registerName = register.getName(nodeExpressionContext);
            bitfieldName = register.getBitfield(nodeExpressionContext);
        }
        catch (RegisterNotFoundException e) {
            e.log(node.getId());
            return;
        }
        if (value == null) {
            try {
                value = register.getValue(nodeExpressionContext);
            }
            catch (RegisterNotFoundException e) {
                e.log(node.getId());
                return;
            }
        }
        if (value == null) {
            if (instance != null) {
                LOGGER.log(Level.SEVERE, "[DATA] [{0}] Value of register assign returned NULL", instance.getComponent().getId());
            }
            return;
        }
        try {
            unknownBitsMask = register.getUnknownBitsMask(nodeExpressionContext);
        }
        catch (RegisterNotFoundException e) {
            e.log(node.getId());
            return;
        }
        String peripheral = registerPeripheral != null ? registerPeripheral : instancePeripheral;
        String resolvedPeripheral = RegistersModelSingleton.resolvePeripheral(peripheral, node);
        if (resolvedPeripheral == null) {
            LOGGER.log(Level.SEVERE, "[TOOL] Peripheral {0} was not resolved to mcu specific name", peripheral);
            return;
        }
        String resolvedRegister = RegistersModelSingleton.resolveRegister(peripheral, registerName, node);
        if (resolvedRegister == null) {
            LOGGER.log(Level.SEVERE, "[TOOL] Register {0} was not resolved to mcu specific name", registerName);
            return;
        }
        String resolvedBitfield = RegistersModelSingleton.resolveBitField(peripheral, registerName, bitfieldName, node);
        if (resolvedBitfield == null) {
            LOGGER.log(Level.SEVERE, "[TOOL] BitField {0} was not resolved to mcu specific name", bitfieldName);
            return;
        }
        if (RegistersModelSingleton.checkNamesExistence(resolvedPeripheral, resolvedRegister, resolvedBitfield, node)) {
            String fullRegisterName = RegistersModelSingleton.computeFullNameOfRegister(resolvedPeripheral, resolvedRegister);
            int bitFieldWidth = nodeExpressionContext.getBitFiledWidth(fullRegisterName, bitfieldName);
            BigInteger newValueMask = register.getMask(nodeExpressionContext);
            BigInteger bitFieldMask = BigInteger.ONE.shiftLeft(bitFieldWidth).subtract(BigInteger.ONE);
            if (newValueMask == null) {
                newValueMask = bitFieldMask;
            }
            BigInteger maskedValue = value.and(newValueMask);
            BigInteger bitfieldValue = this.getValueOfBitField(group, fullRegisterName, bitfieldName);
            BigInteger bitFieldMaskWithoutTheChangingBits = bitFieldMask.xor(newValueMask);
            BigInteger maskedCurrentValue = bitfieldValue.and(bitFieldMaskWithoutTheChangingBits);
            BigInteger newBitfieldValue = maskedCurrentValue.xor(maskedValue);
            this.getBitFields(group, fullRegisterName).put(resolvedBitfield, new BitFieldValue(newBitfieldValue, unknownBitsMask));
            if (this.regenerationNeeded) {
                this.refreshRegistersFromAssigns(group);
            }
            if (notifyOthers) {
                this.notifyAboutValueChange(group, resolvedPeripheral, resolvedRegister, resolvedBitfield, assign, maskedValue, newValueMask);
            }
        }
    }

    public static boolean checkNamesExistence(String peripheralIdentification, String registerIdentification, String bitfieldIdentification, IChild node) {
        IRegParentPeripheralAPI peripheral;
        ChildContext nodeChildContext = node.getChildContext();
        IRegistersDatabaseAPI registersDb = nodeChildContext.getRoot().getMcu().getRegistersDb();
        if (registersDb == null) {
            LOGGER.log(Level.SEVERE, "[TOOL] Register database is null");
            return false;
        }
        boolean logMessages = true;
        IComponentInstanceConfig instance = nodeChildContext.getComponentInstanceConfig();
        if (instance != null) {
            boolean bl = logMessages = instance.getError() == null;
        }
        if (logMessages) {
            if (UtilsText.isEmpty((String)peripheralIdentification)) {
                LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[DATA] Asking for peripheral with empty name empty. Requested by setting {0}", GET_LOGGABLE_ID_FUNCTION.apply(node)));
            }
            if (UtilsText.isEmpty((String)registerIdentification)) {
                LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[DATA] Asking for register with empty name empty. Requested by setting {0}", GET_LOGGABLE_ID_FUNCTION.apply(node)));
            }
            if (UtilsText.isEmpty((String)bitfieldIdentification)) {
                LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[DATA] Asking for bitfield with empty name empty (which is reserved bitfield). Requested by setting {0}", GET_LOGGABLE_ID_FUNCTION.apply(node)));
            }
        }
        if ((peripheral = RegistersModelSingleton.getPeripheralInternal(registersDb, peripheralIdentification)) == null) {
            if (logMessages) {
                LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[DATA] Peripheral {0} does not exist. Requested by setting {1}", peripheralIdentification, GET_LOGGABLE_ID_FUNCTION.apply(node)));
            }
            return false;
        }
        IRegisterAPI register = RegistersModelSingleton.getRegisterInternal(peripheral, registerIdentification);
        if (register == null) {
            if (logMessages) {
                LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[DATA] Register {0} does not exist. Requested by setting {1}", registerIdentification, GET_LOGGABLE_ID_FUNCTION.apply(node)));
            }
            return false;
        }
        IRegBitFieldAPI bitfield = RegistersModelSingleton.getBitfieldInternal(register, bitfieldIdentification);
        if (bitfield == null) {
            if (logMessages) {
                LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[DATA] BitField {0} does not exist. Requested by setting {1}", bitfieldIdentification, GET_LOGGABLE_ID_FUNCTION.apply(node)));
            }
            return false;
        }
        return true;
    }

    public static boolean verifyAssignValidity(AssignConfig assign) {
        boolean result = true;
        IChild node = assign.getParent();
        @NonNull String instancePeripheral = "";
        IComponentInstanceConfig instance = node.getChildContext().getComponentInstanceConfig();
        if (instance != null) {
            instancePeripheral = UtilsText.safeString((String)instance.getPeripheral());
        }
        IContext nodeExpressionContext = node.getExpressionContext();
        for (RegisterConfig register : assign.getRegisters()) {
            try {
                String registerName = register.getName(nodeExpressionContext);
                String bitfieldName = register.getBitfield(nodeExpressionContext);
                String registerPeripheral = register.getPeripheral(nodeExpressionContext);
                String peripheral = registerPeripheral != null ? registerPeripheral : instancePeripheral;
                result &= RegistersModelSingleton.checkNamesExistence(peripheral, registerName, bitfieldName, node);
            }
            catch (RegisterNotFoundException e) {
                e.log(node.getId());
            }
        }
        return result;
    }

    public void registerAssign(IFunctionalGroup group, RegisterConfig register, AssignConfig assign) {
        List<CollectionsUtils.Pair<RegisterConfig, AssignConfig>> registerAssingsInFunctionalGroup = this.getRegisteredAssingsInFunctionalGroup(group);
        registerAssingsInFunctionalGroup.add((CollectionsUtils.Pair<RegisterConfig, AssignConfig>)new CollectionsUtils.Pair((Object)register, (Object)assign));
    }

    public void unregisterAssign(IFunctionalGroup group, RegisterConfig register, AssignConfig assign) {
        List<CollectionsUtils.Pair<RegisterConfig, AssignConfig>> registerAssingsInFunctionalGroup = this.getRegisteredAssingsInFunctionalGroup(group);
        Optional<CollectionsUtils.Pair> optional = registerAssingsInFunctionalGroup.stream().filter(entry -> ((RegisterConfig)entry.getFirst()).equals(register)).filter(entry -> ((AssignConfig)entry.getSecond()).equals(assign)).findAny();
        if (optional.isPresent()) {
            registerAssingsInFunctionalGroup.remove(optional.get());
        }
    }

    public void unregisterAllAssigns(IFunctionalGroup group) {
        this.registerAssingsBoundToRegister.remove(group);
    }

    public void unregisterAllAssigns(IFunctionalGroup group, IComponentInstanceConfig instance) {
        for (AssignConfig assign : instance.getAllAssigns()) {
            for (RegisterConfig register : assign.getRegisters()) {
                this.unregisterAssign(group, register, assign);
            }
        }
    }

    public void unregisterAllAssigns(IFunctionalGroup group, Collection<? extends ISettingConfig> configs) {
        for (ISettingConfig iSettingConfig : configs) {
            this.unregisterAllAssigns(group, iSettingConfig);
        }
    }

    public void unregisterAllAssigns(IFunctionalGroup group, ISettingConfig config) {
        if (config instanceof IChildProvidable) {
            this.unregisterAllAssigns(group, (IChildProvidable)((Object)config));
        } else {
            ArrayList<AssignConfig> assignConfigs = new ArrayList<AssignConfig>(config.getAssignConfigs());
            for (AssignConfig assign : assignConfigs) {
                for (RegisterConfig register : assign.getRegisters()) {
                    this.unregisterAssign(group, register, assign);
                }
            }
        }
    }

    public void unregisterAllAssigns(IFunctionalGroup group, IChildProvidable providable) {
        ArrayList<AssignConfig> assignConfigs = new ArrayList<AssignConfig>();
        List<ISettingConfig> allSettings = ChildProviderHelper.getAllSettings(providable);
        for (ISettingConfig setting : allSettings) {
            assignConfigs.addAll(setting.getAssignConfigs());
            if (!(setting instanceof SetConfig)) continue;
            for (SetConfig.SetPresence presence : ((SetConfig)setting).getChildren()) {
                assignConfigs.addAll(presence.getAssignConfigs());
            }
        }
        for (AssignConfig assign : assignConfigs) {
            for (RegisterConfig register : assign.getRegisters()) {
                this.unregisterAssign(group, register, assign);
            }
        }
    }

    public void registerAllAssigns(IFunctionalGroup group, IComponentInstanceConfig instance) {
        for (AssignConfig assign : instance.getAllAssigns()) {
            for (RegisterConfig register : assign.getRegisters()) {
                this.registerAssign(group, register, assign);
            }
        }
    }

    public void registerAllAssigns(IFunctionalGroup group, Collection<? extends ISettingConfig> configs) {
        for (ISettingConfig iSettingConfig : configs) {
            this.registerAllAssigns(group, iSettingConfig);
        }
    }

    public void registerAllAssigns(IFunctionalGroup group, ISettingConfig config) {
        if (config instanceof IChildProvidable) {
            this.registerAllAssigns(group, (IChildProvidable)((Object)config));
        } else {
            ArrayList<AssignConfig> assignConfigs = new ArrayList<AssignConfig>(config.getAssignConfigs());
            for (AssignConfig assign : assignConfigs) {
                for (RegisterConfig register : assign.getRegisters()) {
                    this.registerAssign(group, register, assign);
                }
            }
        }
    }

    public void registerAllAssigns(IFunctionalGroup group, IChildProvidable providable) {
        ArrayList<AssignConfig> assignConfigs = new ArrayList<AssignConfig>();
        List<ISettingConfig> allSettings = ChildProviderHelper.getAllSettings(providable);
        for (ISettingConfig setting : allSettings) {
            assignConfigs.addAll(setting.getAssignConfigs());
            if (!(setting instanceof SetConfig)) continue;
            for (SetConfig.SetPresence presence : ((SetConfig)setting).getChildren()) {
                assignConfigs.addAll(presence.getAssignConfigs());
            }
        }
        for (AssignConfig assign : assignConfigs) {
            for (RegisterConfig register : assign.getRegisters()) {
                this.registerAssign(group, register, assign);
            }
        }
    }

    public void clearRegisterValues(IFunctionalGroup group) {
        this.registerValues.remove(group);
    }

    public void clear() {
        this.registerAssingsBoundToRegister.clear();
        this.registerValues.clear();
        this.selectedInstance = null;
    }

    public List<CollectionsUtils.Pair<RegisterConfig, AssignConfig>> getRegisteredAssingsInFunctionalGroup(IFunctionalGroup group) {
        List registersInGroup = this.registerAssingsBoundToRegister.computeIfAbsent(group, x -> new ArrayList());
        assert (registersInGroup != null);
        return registersInGroup;
    }

    public void refreshRegistersFromAssigns(IFunctionalGroup group) {
        if (group.getError() != null) {
            this.regenerationNeeded = true;
            return;
        }
        this.regenerationNeeded = false;
        this.getRegisters(group).clear();
        List<CollectionsUtils.Pair<RegisterConfig, AssignConfig>> assignsForRegister = this.getRegisteredAssingsInFunctionalGroup(group);
        for (CollectionsUtils.Pair<RegisterConfig, AssignConfig> entry : assignsForRegister) {
            RegisterConfig register = (RegisterConfig)entry.getFirst();
            AssignConfig assign = (AssignConfig)entry.getSecond();
            IChild node = assign.getParent();
            if (!node.isAvailable() || !node.isEnabled() || !assign.isEnabled()) continue;
            this.setValueOfBitfield(group, register, node, null, assign, false);
        }
    }

    public synchronized CounterLatch getAssignCreationLatch() {
        return this.assignCreationLatch;
    }

    private static List<RegisterConfig> getRegisterConfigs(AssignConfig assign, String registerName) {
        ArrayList<RegisterConfig> registers = new ArrayList<RegisterConfig>();
        IContext expressionContext = assign.getParent().getExpressionContext();
        for (RegisterConfig register : assign.getRegisters()) {
            try {
                if (!registerName.endsWith(register.getName(expressionContext))) continue;
                registers.add(register);
            }
            catch (RegisterNotFoundException e) {
                e.log(assign.getParent().getId());
            }
        }
        return registers;
    }

    public boolean notifyAboutValueChange(IFunctionalGroup group, String peripheral, String registerName, String bitfieldName, @Nullable AssignConfig originator, BigInteger value, BigInteger mask) {
        IChild parent;
        ArrayList<AssignConfig> listOfAssigns = new ArrayList<AssignConfig>();
        List<CollectionsUtils.Pair<RegisterConfig, AssignConfig>> registeredAssingsInFunctionalGroup = this.getRegisteredAssingsInFunctionalGroup(group);
        for (CollectionsUtils.Pair<RegisterConfig, AssignConfig> pair : registeredAssingsInFunctionalGroup) {
            AssignConfig assignConfig = (AssignConfig)pair.getSecond();
            parent = assignConfig.getParent();
            IContext parentContext = parent.getExpressionContext();
            RegisterConfig registerConfig = (RegisterConfig)pair.getFirst();
            if (!parent.isAvailable() || !parent.isEnabled() || !assignConfig.isEnabled()) continue;
            try {
                String resolvedBitFieldName;
                String usedPeripheral;
                String peripheralNameAlias = registerConfig.getPeripheral(parent.getExpressionContext());
                String registerNameAlias = registerConfig.getName(parentContext);
                String bitfieldNameAlias = registerConfig.getBitfield(parentContext);
                if (peripheralNameAlias == null) {
                    IComponentInstanceConfig instance = parent.getChildContext().getComponentInstanceConfig();
                    if (instance == null || !peripheral.equals(instance.getPeripheral())) continue;
                    usedPeripheral = UtilsText.safeString((String)instance.getPeripheral());
                } else {
                    String resolvedPeripheralName = RegistersModelSingleton.resolvePeripheral(peripheralNameAlias, group);
                    if (!peripheral.equals(resolvedPeripheralName)) continue;
                    usedPeripheral = UtilsText.safeString((String)resolvedPeripheralName);
                }
                String resolvedRegisterName = RegistersModelSingleton.resolveRegister(usedPeripheral, registerNameAlias, group);
                if (!registerName.equals(resolvedRegisterName) || !bitfieldName.equals(resolvedBitFieldName = RegistersModelSingleton.resolveBitField(usedPeripheral, registerNameAlias, bitfieldNameAlias, group)) || assignConfig.equals(originator)) continue;
                listOfAssigns.add(assignConfig);
            }
            catch (RegisterNotFoundException e) {
                e.log(parent.getId());
            }
        }
        boolean change = false;
        for (AssignConfig assignConfig : listOfAssigns) {
            parent = assignConfig.getParent();
            List<RegisterConfig> registerConfigs = RegistersModelSingleton.getRegisterConfigs(assignConfig, registerName);
            for (RegisterConfig register : registerConfigs) {
                try {
                    BigInteger maskMatch;
                    BigInteger otherRegisterMask;
                    if (!register.getBitfield(parent.getExpressionContext()).equals(bitfieldName) || (otherRegisterMask = register.getMask(parent.getExpressionContext())) != null && (maskMatch = mask.and(otherRegisterMask)).compareTo(BigInteger.ZERO) == 0) continue;
                    change |= this.performReverseValueChange(group, RegistersModelSingleton.computeFullNameOfRegister(peripheral, registerName), bitfieldName, parent, register, value);
                }
                catch (RegisterNotFoundException e) {
                    LOGGER.log(Level.SEVERE, MessageFormat.format("{0} of assigned register cannot be computed for setting {1}", new Object[]{e.getType(), parent.getId()}));
                }
            }
        }
        return change;
    }

    private boolean performReverseValueChange(IFunctionalGroup group, String registerName, String bitfieldName, IChild setting, RegisterConfig binding, @Nullable BigInteger value) {
        BigInteger bitfieldValue;
        block8: {
            bitfieldValue = value;
            if (bitfieldValue == null) {
                bitfieldValue = this.getValueOfBitField(group, registerName, bitfieldName);
            }
            if (binding.isReverseValueEnabled(setting.getExpressionContext())) break block8;
            return false;
        }
        try {
            String settingValue = binding.getReverseValue(setting.getExpressionContext(), bitfieldValue);
            if (settingValue != null) {
                if (setting instanceof ScalarConfig) {
                    ((ScalarConfig)setting).setValue(settingValue);
                } else if (setting instanceof SetConfig.SetPresence) {
                    ((SetConfig.SetPresence)setting).setValue(Boolean.parseBoolean(settingValue));
                }
                ChildProviderHelper.unsetParentQuickSelections(setting);
                return true;
            }
        }
        catch (RegisterNotFoundException e) {
            e.log(setting.getId());
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.registerValues.toString() + "]";
    }

    public static String computeFullNameOfRegister(String peripheral, String registerName) {
        return String.valueOf(peripheral) + PERIPHERAL_REGISTER_SEPARATOR + registerName;
    }

    public static String computeFullNameOfRegister(@Nullable String instancePeripheral, @Nullable String registerPeripheral, String registerName) {
        return String.valueOf(registerPeripheral != null ? registerPeripheral : instancePeripheral) + PERIPHERAL_REGISTER_SEPARATOR + registerName;
    }

    public static String computeFullNameOfBitfield(String peripheralWithRegister, String bitfield) {
        return String.valueOf(peripheralWithRegister) + "[" + bitfield + "]";
    }

    public static String computeFullNameOfBitfield(String peripheral, String register, String bitfield) {
        return String.valueOf(RegistersModelSingleton.computeFullNameOfRegister(peripheral, register)) + "[" + bitfield + "]";
    }

    public static BigInteger getResetValueOfBitfieldInternal(ICommonMcu mcu, String peripheralName, String registerName, String bitfieldName) {
        IRegistersDatabaseAPI registersDb = mcu.getRegistersDb();
        return RegistersModelSingleton.getResetValueOfBitfieldInternal(registersDb, peripheralName, registerName, bitfieldName);
    }

    public static BigInteger getResetValueOfBitfieldInternal(@Nullable IRegistersDatabaseAPI registersDb, String peripheralName, String registerName, String bitfieldName) {
        if (registersDb == null) {
            return ERROR_REGISTER_DATABASE_NOT_FOUND;
        }
        IRegParentPeripheralAPI peripheral = RegistersModelSingleton.getPeripheralInternal(registersDb, peripheralName);
        if (peripheral == null) {
            return ERROR_PERIPHERAL_NOT_FOUND;
        }
        IRegisterAPI register = RegistersModelSingleton.getRegisterInternal(peripheral, registerName);
        if (register == null) {
            return ERROR_REGISTER_NOT_FOUND;
        }
        IRegBitFieldAPI bitfield = RegistersModelSingleton.getBitfieldInternal(register, bitfieldName);
        if (bitfield == null) {
            return ERROR_BITFIELD_NOT_FOUND;
        }
        BigInteger resetValue = bitfield.getResetValueAsBigInteger();
        BigInteger resetMask = bitfield.getResetMaskAsBigInteger();
        return resetValue.and(resetMask);
    }

    public static BigInteger getResetValueOfRegisterInternal(ICommonMcu mcu, String peripheralName, String registerName) {
        IRegistersDatabaseAPI registersDb = mcu.getRegistersDb();
        return RegistersModelSingleton.getResetValueOfRegisterInternal(registersDb, peripheralName, registerName);
    }

    public static BigInteger getResetValueOfRegisterInternal(@Nullable IRegistersDatabaseAPI registersDb, String peripheralName, String registerName) {
        IRegBitFieldAPI[] bitFields;
        if (registersDb == null) {
            return ERROR_REGISTER_DATABASE_NOT_FOUND;
        }
        IRegParentPeripheralAPI peripheral = RegistersModelSingleton.getPeripheralInternal(registersDb, peripheralName);
        if (peripheral == null) {
            return ERROR_PERIPHERAL_NOT_FOUND;
        }
        IRegisterAPI register = RegistersModelSingleton.getRegisterInternal(peripheral, registerName);
        if (register == null) {
            return ERROR_REGISTER_NOT_FOUND;
        }
        BigInteger registerResetValue = BigInteger.ZERO;
        IRegBitFieldAPI[] iRegBitFieldAPIArray = bitFields = register.getBitFields();
        int n = bitFields.length;
        int n2 = 0;
        while (n2 < n) {
            IRegBitFieldAPI bitfield = iRegBitFieldAPIArray[n2];
            BigInteger bitfieldResetValue = bitfield.getResetValueAsBigInteger().and(bitfield.getResetMaskAsBigInteger()).shiftLeft(bitfield.getOffset());
            registerResetValue = registerResetValue.add(bitfieldResetValue);
            ++n2;
        }
        return registerResetValue;
    }

    public static @Nullable IRegParentPeripheralAPI getPeripheralInternal(IRegistersDatabaseAPI registersDb, String peripheralName) {
        return BitFieldProvider.findPeripheral((String)peripheralName, (IRegistersDatabaseAPI)registersDb);
    }

    public static @Nullable IRegisterAPI getRegisterInternal(IRegParentPeripheralAPI peripheral, String registerName) {
        return BitFieldProvider.findRegister((IRegParentPeripheralAPI)peripheral, (String)registerName);
    }

    public static @Nullable IRegBitFieldAPI getBitfieldInternal(IRegisterAPI register, String bitfieldName) {
        return BitFieldProvider.findBitField((IRegisterAPI)register, (String)bitfieldName);
    }

    public void setSelectedComponent(IComponentInstanceConfig selectedInstance) {
        this.selectedInstance = selectedInstance;
    }

    public @Nullable IComponentInstanceConfig getSelectedInstance() {
        return this.selectedInstance;
    }

    public boolean isRegenerationNeeded() {
        return this.regenerationNeeded;
    }

    public static @Nullable String resolvePeripheral(String peripheralIdentification, IChild node) {
        IRegistersDatabaseAPI registersDb = RegistersModelSingleton.getRegisterDatabase(node);
        if (registersDb == null) {
            LOGGER.log(Level.SEVERE, "[TOOL] Register database is null");
            return null;
        }
        IRegParentPeripheralAPI peripheralFromDb = RegistersModelSingleton.getPeripheralInternal(registersDb, peripheralIdentification);
        if (peripheralFromDb == null) {
            RegistersModelSingleton.logNonExistingPeripheral(peripheralIdentification);
            return null;
        }
        return peripheralFromDb.getName();
    }

    public static @Nullable String resolveRegister(String peripheralIdentification, String registerIdentification, IChild node) {
        IRegistersDatabaseAPI registersDb = RegistersModelSingleton.getRegisterDatabase(node);
        if (registersDb == null) {
            LOGGER.log(Level.SEVERE, "[TOOL] Register database is null");
            return null;
        }
        IRegParentPeripheralAPI peripheralFromDb = RegistersModelSingleton.getPeripheralInternal(registersDb, peripheralIdentification);
        if (peripheralFromDb == null) {
            RegistersModelSingleton.logNonExistingPeripheral(peripheralIdentification);
            return null;
        }
        IRegisterAPI registerFromDb = RegistersModelSingleton.getRegisterInternal(peripheralFromDb, registerIdentification);
        if (registerFromDb == null) {
            RegistersModelSingleton.logNonExistingRegister(registerIdentification);
            return null;
        }
        return registerFromDb.getName();
    }

    public static @Nullable String resolveBitField(String peripheralIdentification, String registerIdentification, String bitfieldIdentification, IChild node) {
        IRegistersDatabaseAPI registersDb = RegistersModelSingleton.getRegisterDatabase(node);
        if (registersDb == null) {
            LOGGER.log(Level.SEVERE, "[TOOL] Register database is null");
            return null;
        }
        IRegParentPeripheralAPI peripheralFromDb = RegistersModelSingleton.getPeripheralInternal(registersDb, peripheralIdentification);
        if (peripheralFromDb == null) {
            RegistersModelSingleton.logNonExistingPeripheral(peripheralIdentification);
            return null;
        }
        IRegisterAPI registerFromDb = RegistersModelSingleton.getRegisterInternal(peripheralFromDb, registerIdentification);
        if (registerFromDb == null) {
            RegistersModelSingleton.logNonExistingRegister(registerIdentification);
            return null;
        }
        IRegBitFieldAPI bitfieldFromDb = RegistersModelSingleton.getBitfieldInternal(registerFromDb, bitfieldIdentification);
        if (bitfieldFromDb == null) {
            RegistersModelSingleton.logNonExistingBitField(bitfieldIdentification);
            return null;
        }
        return bitfieldFromDb.getName();
    }

    private static @Nullable IRegistersDatabaseAPI getRegisterDatabase(IChild node) {
        return node.getChildContext().getRoot().getMcu().getRegistersDb();
    }

    private static void logNonExistingPeripheral(String peripheralIdentification) {
        LOGGER.log(Level.SEVERE, "[TOOL] Peripheral {0} was not found in the register database", peripheralIdentification);
    }

    private static void logNonExistingRegister(String registerIdentification) {
        LOGGER.log(Level.SEVERE, "[TOOL] Register {0} was not found in the register database", registerIdentification);
    }

    private static void logNonExistingBitField(String bitfieldIdentification) {
        LOGGER.log(Level.SEVERE, "[TOOL] Bitfield {0} was not found in the register database", bitfieldIdentification);
    }

    public void setRegenerationNeeded() {
        this.regenerationNeeded = true;
    }

    public static class BitFieldValue {
        private BigInteger value = BigInteger.ZERO;
        private BigInteger unknownBitsMask = BigInteger.ZERO;

        public BitFieldValue(BigInteger value, BigInteger unknownBitsMask) {
            this.setValue(value);
            this.setUnknownBitsMask(unknownBitsMask);
        }

        public BigInteger getValue() {
            return this.value;
        }

        public void setValue(BigInteger value) {
            this.value = value;
        }

        public BigInteger getUnknownBitsMask() {
            return this.unknownBitsMask;
        }

        public void setUnknownBitsMask(BigInteger unknownBitsMask) {
            this.unknownBitsMask = unknownBitsMask;
        }
    }

    public static class RegisterNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final RegisterNotFoundType type;
        @Nullable
        private Exception exception = null;

        public RegisterNotFoundException(RegisterNotFoundType type) {
            this.type = type;
        }

        public RegisterNotFoundException(RegisterNotFoundType type, Exception innerException) {
            this.type = type;
            this.exception = innerException;
        }

        public RegisterNotFoundType getType() {
            return this.type;
        }

        public @Nullable Exception getException() {
            return this.exception;
        }

        public void log(String id) {
            Supplier<@Nullable String> supplier = () -> MessageFormat.format("{0} of assigned register cannot be computed for setting {1}", new Object[]{this.getType(), id});
            Exception exceptionLoc = this.getException();
            if (exceptionLoc == null) {
                LOGGER.log(Level.SEVERE, supplier);
            } else {
                LOGGER.log(Level.SEVERE, exceptionLoc, supplier);
            }
        }

        public static enum RegisterNotFoundType {
            PERIPHERAL,
            NAME,
            BITFIELD,
            VALUE,
            UNKNOWN_BITS,
            REVERSE_VALUE;

        }
    }
}

