/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.config;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.number.BigRationalRange;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.resourcetables.model.Messages;
import com.nxp.swtools.resourcetables.model.config.ASettingConfig;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.resourcetables.model.data.setting.AMinMaxSetting;
import com.nxp.swtools.resourcetables.model.data.setting.FloatSetting;
import com.nxp.swtools.resourcetables.model.data.setting.IntegerSetting;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScalarUtils {
    private static final int MAXIMAL_WHOLE_DIGITS_UNTIL_ENGINEERING_STRING = 10;
    private static final Logger LOGGER = LogManager.getLogger(ScalarUtils.class);
    private static BigInteger UNSIGNED_MIN = BigInteger.ZERO;
    private static BigInteger INT8_T_MIN = BigInteger.valueOf(-128L);
    private static BigInteger INT8_T_MAX = BigInteger.valueOf(127L);
    private static BigInteger UINT8_T_MAX = BigInteger.valueOf(255L);
    private static BigInteger INT16_T_MIN = BigInteger.valueOf(-32768L);
    private static BigInteger INT16_T_MAX = BigInteger.valueOf(32767L);
    private static BigInteger UINT16_T_MAX = BigInteger.valueOf(65535L);
    private static BigInteger INT32_T_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
    private static BigInteger INT32_T_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private static BigInteger UINT32_T_MAX = BigInteger.valueOf(0xFFFFFFFFL);
    private static BigInteger INT64_T_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private static BigInteger INT64_T_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    private static BigInteger UINT64_T_MAX = INT64_T_MAX.add(INT64_T_MIN.abs());
    private static BigRational SINGLE_PRECISION_LIMIT = BigRational.parse((String)String.valueOf(Float.MAX_VALUE));
    private static BigRational DOUBLE_PRECISION_LIMIT = BigRational.parse((String)String.valueOf(Double.MAX_VALUE));
    private static BigRational QUADRUPLE_PRECISION_LIMIT = BigRational.parse((String)"1.1897314953572317650857593266280070162e4932");
    public static final String BINARY_PREFIX = "0b";
    public static final String HEXADECIMAL_PREFIX = "0x";
    public static final String OCTAL_PREFIX = "0";

    public static boolean isInRange(ASettingConfig config, String number) {
        BigRational parsedNumber;
        try {
            parsedNumber = ScalarUtils.parseNumber(config, number);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return true;
        }
        return ScalarUtils.isInRange(config, parsedNumber);
    }

    public static boolean isInRange(ASettingConfig config, int number) {
        BigRational parsedNumber = new BigRational(number);
        return ScalarUtils.isInRange(config, parsedNumber);
    }

    public static boolean isInRange(ASettingConfig config, BigRational number) {
        BigRationalRange range = ScalarUtils.getRange(config);
        if (range != null) {
            return range.contains((Comparable)number);
        }
        return true;
    }

    public static boolean isBelowRange(ASettingConfig config, String number) {
        BigRational parsedNumber;
        try {
            parsedNumber = ScalarUtils.parseNumber(config, number);
        }
        catch (NumberFormatException numberFormatException) {
            return true;
        }
        return ScalarUtils.isBelowRange(config, parsedNumber);
    }

    public static boolean isBelowRange(ASettingConfig config, int number) {
        BigRational parsedNumber = new BigRational(number);
        return ScalarUtils.isBelowRange(config, parsedNumber);
    }

    public static boolean isBelowRange(ASettingConfig config, BigRational number) {
        BigRationalRange range = ScalarUtils.getRange(config);
        if (range != null) {
            return range.isAbove((Comparable)number);
        }
        return false;
    }

    public static boolean isAboveRange(ASettingConfig config, String number) {
        BigRational parsedNumber;
        try {
            parsedNumber = ScalarUtils.parseNumber(config, number);
        }
        catch (NumberFormatException numberFormatException) {
            return true;
        }
        return ScalarUtils.isAboveRange(config, parsedNumber);
    }

    public static boolean isAboveRange(ASettingConfig config, int number) {
        BigRational parsedNumber = new BigRational(number);
        return ScalarUtils.isAboveRange(config, parsedNumber);
    }

    public static boolean isAboveRange(ASettingConfig config, BigRational number) {
        BigRationalRange range = ScalarUtils.getRange(config);
        if (range != null) {
            return range.isBelow((Comparable)number);
        }
        return false;
    }

    public static @Nullable BigRationalRange getRange(ASettingConfig scalarConfig) {
        BigRationalRange minMaxRange = ScalarUtils.getConstraintsRange(scalarConfig);
        BigRationalRange typeRange = ScalarUtils.getTypeRange(scalarConfig);
        return BigRationalRange.intersection((BigRationalRange)minMaxRange, (BigRationalRange)typeRange);
    }

    public static @Nullable BigRationalRange getConstraintsRange(ASettingConfig config) {
        if (config.getModelData() instanceof AMinMaxSetting) {
            AMinMaxSetting minMaxSetting = (AMinMaxSetting)config.getModelData();
            BigRational minValue = minMaxSetting.getMinValue(config.getExpressionContext());
            BigRational maxValue = minMaxSetting.getMaxValue(config.getExpressionContext());
            if (SWToolsProperties.isVerificationOn() && minValue != null && maxValue != null && maxValue.compareTo(minValue) < 0) {
                LOGGER.log(Level.WARNING, "[DATA] Maximal value of setting with id: {0} is lower than minimal!", config.getId());
            }
            return new BigRationalRange(minValue, maxValue);
        }
        return null;
    }

    public static boolean hasRangeConstraintDefined(ASettingConfig config) {
        String minValueString = null;
        String maxValueString = null;
        if (config.getModelData() instanceof AMinMaxSetting) {
            AMinMaxSetting minMaxSetting = (AMinMaxSetting)config.getModelData();
            minValueString = minMaxSetting.getMinValueString();
            maxValueString = minMaxSetting.getMaxValueString();
        }
        return minValueString != null || maxValueString != null;
    }

    private static @Nullable BigRationalRange getTypeRange(ASettingConfig config) {
        if (config instanceof ScalarConfig) {
            ScalarConfig scalarConfig = (ScalarConfig)config;
            if (scalarConfig.getType() == ScalarConfig.Type.INTEGER) {
                IntegerSetting.IntegerType intType = ((IntegerSetting)config.getModelData()).getType();
                return ScalarUtils.getIntegerRange(intType);
            }
            if (scalarConfig.getType() == ScalarConfig.Type.FLOAT) {
                FloatSetting.Type type = ((FloatSetting)config.getModelData()).getType();
                return ScalarUtils.getFloatRange(type);
            }
        }
        return null;
    }

    private static BigRational parseNumber(ASettingConfig config, String number) {
        ScalarConfig scalarConfig;
        if (config instanceof ScalarConfig && (scalarConfig = (ScalarConfig)config).getType() == ScalarConfig.Type.INTEGER) {
            IntegerSetting.IntegerType type = ((IntegerSetting)scalarConfig.getModelData()).getType();
            return new BigRational(ScalarUtils.parseInteger(number, type));
        }
        return BigRational.parse((String)number);
    }

    public static BigRationalRange getIntegerRange(IntegerSetting.IntegerType intType) {
        BigInteger min = BigInteger.valueOf(Long.MIN_VALUE);
        BigInteger max = BigInteger.valueOf(Long.MAX_VALUE);
        switch (intType) {
            case uint8_t: {
                min = UNSIGNED_MIN;
                max = UINT8_T_MAX;
                break;
            }
            case int8_t: {
                min = INT8_T_MIN;
                max = INT8_T_MAX;
                break;
            }
            case uint16_t: {
                min = UNSIGNED_MIN;
                max = UINT16_T_MAX;
                break;
            }
            case int16_t: {
                min = INT16_T_MIN;
                max = INT16_T_MAX;
                break;
            }
            case uint32_t: {
                min = UNSIGNED_MIN;
                max = UINT32_T_MAX;
                break;
            }
            case int32_t: {
                min = INT32_T_MIN;
                max = INT32_T_MAX;
                break;
            }
            case uint64_t: {
                min = UNSIGNED_MIN;
                max = UINT64_T_MAX;
                break;
            }
            case int64_t: {
                min = INT64_T_MIN;
                max = INT64_T_MAX;
                break;
            }
        }
        return new BigRationalRange(min, max);
    }

    public static BigRationalRange getFloatRange(FloatSetting.Type type) {
        BigRational min = BigRational.valueOf((long)Long.MIN_VALUE);
        BigRational max = BigRational.valueOf((long)Long.MAX_VALUE);
        switch (type) {
            case single_precision: {
                min = SINGLE_PRECISION_LIMIT.negate();
                max = SINGLE_PRECISION_LIMIT;
                break;
            }
            case double_precision: {
                min = DOUBLE_PRECISION_LIMIT.negate();
                max = DOUBLE_PRECISION_LIMIT;
                break;
            }
            case quadruple_precision: {
                min = QUADRUPLE_PRECISION_LIMIT.negate();
                max = QUADRUPLE_PRECISION_LIMIT;
                break;
            }
        }
        return new BigRationalRange(min, max);
    }

    public static int detectIntegerBase(String number) {
        if (number.regionMatches(true, 0, HEXADECIMAL_PREFIX, 0, HEXADECIMAL_PREFIX.length())) {
            return 16;
        }
        if (number.regionMatches(true, 0, BINARY_PREFIX, 0, BINARY_PREFIX.length())) {
            return 2;
        }
        if (number.length() > OCTAL_PREFIX.length() && number.regionMatches(true, 0, OCTAL_PREFIX, 0, OCTAL_PREFIX.length())) {
            return 8;
        }
        return 10;
    }

    public static BigInteger parseInteger(String number) {
        switch (ScalarUtils.detectIntegerBase(number)) {
            case 2: {
                return new BigInteger(number.substring(BINARY_PREFIX.length()), 2);
            }
            case 8: {
                return new BigInteger(number.substring(OCTAL_PREFIX.length()), 8);
            }
            case 16: {
                return new BigInteger(number.substring(HEXADECIMAL_PREFIX.length()), 16);
            }
        }
        return new BigInteger(number);
    }

    public static BigInteger parseInteger(String number, IntegerSetting.IntegerType intType) {
        boolean isSigned = false;
        int bits = 0;
        switch (intType) {
            case int8_t: {
                isSigned = true;
            }
            case uint8_t: {
                bits = 8;
                break;
            }
            case int16_t: {
                isSigned = true;
            }
            case uint16_t: {
                bits = 16;
                break;
            }
            case int32_t: {
                isSigned = true;
            }
            case uint32_t: {
                bits = 32;
                break;
            }
            case int64_t: {
                isSigned = true;
            }
            case uint64_t: {
                bits = 64;
            }
        }
        String processedNumber = number;
        int integerBase = ScalarUtils.detectIntegerBase(number);
        if (integerBase == 2) {
            processedNumber = number.substring(BINARY_PREFIX.length());
        } else if (integerBase == 8) {
            processedNumber = number.substring(OCTAL_PREFIX.length());
        } else if (integerBase == 16) {
            processedNumber = number.substring(HEXADECIMAL_PREFIX.length());
        }
        if (processedNumber.startsWith("-") && integerBase != 10) {
            throw new NumberFormatException("Non-decimal number contains minus!");
        }
        BigInteger result = new BigInteger(processedNumber, integerBase);
        if (integerBase != 10) {
            boolean isNegative;
            BigInteger msbOnly = BigInteger.ONE.shiftLeft(bits - 1);
            boolean bl = isNegative = result.and(msbOnly).compareTo(msbOnly) == 0;
            if (isSigned && isNegative) {
                result = result.subtract(BigInteger.ONE.shiftLeft(bits));
            }
        }
        return result;
    }

    public static String getRangeError(ScalarConfig scalarConfig) {
        BigRationalRange range = ScalarUtils.getRange(scalarConfig);
        if (range != null) {
            BigRational min = (BigRational)range.getMin();
            BigRational max = (BigRational)range.getMax();
            if (min == null) {
                if (max == null) {
                    return "";
                }
                return MessageFormat.format(UtilsText.safeString((String)Messages.get().ScalarUtils_OutOfRange_MustBeLower), ScalarUtils.getStringRepresentation(max));
            }
            if (max == null) {
                return MessageFormat.format(UtilsText.safeString((String)Messages.get().ScalarUtils_OutOfRange_MustBeHigher), ScalarUtils.getStringRepresentation(min));
            }
            return MessageFormat.format(UtilsText.safeString((String)Messages.get().ScalarUtils_OutOfRange), ScalarUtils.getStringRepresentation(min), ScalarUtils.getStringRepresentation(max));
        }
        return "";
    }

    private static String getStringRepresentation(BigRational rational) {
        if (rational.isInteger()) {
            int[] digits = rational.getDigitsCount();
            if (digits[0] > 10) {
                return rational.toBigDecimal().toEngineeringString();
            }
            return rational.toBigInteger().toString();
        }
        return rational.toBigDecimal().toEngineeringString();
    }
}

