/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.resourcetables.model.data.Register;
import com.nxp.swtools.resourcetables.model.data.Setting;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="assign", strict=false)
public class Assign {
    @Attribute(name="when", required=false)
    @Nullable
    private @Attribute(name="when", required=false) @Nullable String whenCondition;
    @ElementList(type=Register.class, required=false, inline=true)
    private List<Register> registers;
    @ElementList(type=Setting.class, required=false, inline=true)
    private List<Setting> settings;
    @Nullable
    private Expression whenConditionExpr;

    public Assign(List<Register> registers, @Nullable String whenCondition, List<Setting> settings) {
        this.whenCondition = whenCondition;
        this.registers = registers;
        this.settings = settings;
        this.whenConditionExpr = !UtilsText.isEmpty((String)whenCondition) ? Expression.tryCreate((String)UtilsText.safeString((String)whenCondition)) : null;
    }

    public Assign() {
        this(new ArrayList<Register>(), null, new ArrayList<Setting>());
    }

    public int hashCode() {
        int result = super.hashCode();
        int registersHash = Objects.hashCode(this.registers);
        int settingsHash = Objects.hashCode(this.settings);
        result = 31 * result + UtilsText.safeString((String)this.whenCondition).hashCode() + registersHash + settingsHash;
        return result;
    }

    public String getWhenCondition() {
        return UtilsText.safeString((String)this.whenCondition);
    }

    public List<Register> getRegisters() {
        return this.registers;
    }

    public List<Setting> getSettings() {
        return this.settings;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj) && this.getClass() != obj.getClass()) {
            return false;
        }
        Assign assign = (Assign)obj;
        boolean registersCompare = Objects.equals(this.registers, assign.getRegisters());
        boolean settingsCompare = Objects.equals(this.settings, assign.getSettings());
        return registersCompare && settingsCompare && this.getWhenCondition().equalsIgnoreCase(assign.getWhenCondition());
    }

    public @Nullable Expression getWhenConditionExpr() {
        return this.whenConditionExpr == null && !UtilsText.isEmpty((String)this.whenCondition) ? (this.whenConditionExpr = Expression.tryCreate((String)UtilsText.safeString((String)this.whenCondition))) : this.whenConditionExpr;
    }

    public void setRegisters(List<Register> registers) {
        this.registers = registers;
    }

    public void setSettings(List<Setting> settings) {
        this.settings = settings;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + "Registers: " + this.registers.toString() + ", " + "\n" + "Settings: " + this.settings.toString() + "]";
    }
}

