/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.expert.processordb.ComponentInfo;
import com.nxp.swtools.expert.processordb.IConfigComponentInfo;
import com.nxp.swtools.resourcetables.model.data.IConfigurationComponent;
import com.nxp.swtools.resourcetables.model.data.SWComponent;
import com.nxp.swtools.resourcetables.model.data.documentation.Contents;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class ConfigurationComponentTypeId {
    private static final String DOCUMENTATION_MENU_GENERATOR = "menuGenerator.js";
    private static final String DOCUMENTATION_CONTENTS_XML = "contents.xml";
    public static final String DOCUMENTATION_SUBFOLDER_NAME = "doc";
    private static final String DOCUMENTATION_INDEX_FILE_NAME = "index.md";
    private final ComponentInfo info;
    private IConfigurationComponent configurationComponent;
    private final boolean docExists;

    public ConfigurationComponentTypeId(ComponentInfo componentInfo, IConfigurationComponent component) {
        this.configurationComponent = component;
        this.info = componentInfo;
        this.docExists = ConfigurationComponentTypeId.getDocIndexFile((IConfigComponentInfo)componentInfo).exists();
    }

    public IConfigurationComponent getConfigurationComponent() {
        return this.configurationComponent;
    }

    public List<SWComponent> getComponentReferences() {
        return this.getConfigurationComponent().getComponents();
    }

    public String getType() {
        return this.getConfigurationComponent().getId();
    }

    public String getTypeId() {
        return this.info.getName();
    }

    public String getSdkVersion() {
        return this.info.getSdkVersion();
    }

    public boolean isDocumentationPresent() {
        return this.docExists;
    }

    public @Nullable String getDocumentationLocation() {
        if (this.docExists) {
            return ConfigurationComponentTypeId.getDocIndexFile((IConfigComponentInfo)this.info).getAbsolutePath();
        }
        return null;
    }

    public @Nullable Contents getDocumentationMenuContent() {
        File menuContentFile = ConfigurationComponentTypeId.getDocumentationMenuContentFile((IConfigComponentInfo)this.info);
        if (this.docExists && menuContentFile.exists()) {
            return Contents.loadContent(menuContentFile);
        }
        return null;
    }

    public @Nullable File getDocumentationMenuGeneratorScript() {
        File generatorFile = ConfigurationComponentTypeId.getDocumentationMenuGeneratorScript((IConfigComponentInfo)this.info);
        if (!generatorFile.exists()) {
            return null;
        }
        return generatorFile;
    }

    public Path getFileLocation() {
        Path path = this.info.getComponentDir().toPath();
        assert (path != null);
        return path;
    }

    public Path resolvePath(Path other) {
        return Paths.get(this.getFileLocation().toString(), DOCUMENTATION_SUBFOLDER_NAME).resolve(other);
    }

    public void setConfigurationComponent(IConfigurationComponent configurationComponent) {
        this.configurationComponent = configurationComponent;
    }

    private static File getDocIndexFile(IConfigComponentInfo componentInfo) {
        return new File(new File(componentInfo.getComponentDir(), DOCUMENTATION_SUBFOLDER_NAME), DOCUMENTATION_INDEX_FILE_NAME);
    }

    private static File getDocumentationMenuContentFile(IConfigComponentInfo componentInfo) {
        return new File(new File(componentInfo.getComponentDir(), DOCUMENTATION_SUBFOLDER_NAME), DOCUMENTATION_CONTENTS_XML);
    }

    private static File getDocumentationMenuGeneratorScript(IConfigComponentInfo componentInfo) {
        return new File(new File(componentInfo.getComponentDir(), DOCUMENTATION_SUBFOLDER_NAME), DOCUMENTATION_MENU_GENERATOR);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.getTypeId().hashCode();
        result = 31 * result + this.getSdkVersion().hashCode();
        result = 31 * result + this.getFileLocation().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationComponentTypeId other = (ConfigurationComponentTypeId)obj;
        if (!this.getTypeId().equals(other.getTypeId())) {
            return false;
        }
        if (!this.getSdkVersion().equals(other.getSdkVersion())) {
            return false;
        }
        return this.getFileLocation().equals(other.getFileLocation());
    }

    public String toString() {
        return "ConfigurationComponentTypeId [Type='" + this.getType() + "' TypeId='" + this.getTypeId() + "']";
    }
}

