/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="master_peripheral", strict=false)
public class MasterPeripheral {
    @Attribute(name="exclusive", required=false)
    private Boolean exclusive;
    @ElementList(entry="peripheral_type", inline=true, required=false)
    private List<String> peripherals;

    public MasterPeripheral(boolean exclusive) {
        this.exclusive = exclusive;
        this.peripherals = new ArrayList<String>();
    }

    public MasterPeripheral(boolean exclusive, List<String> peripherals) {
        this.exclusive = exclusive;
        this.peripherals = new ArrayList<String>(peripherals);
    }

    @Deprecated
    protected MasterPeripheral() {
        this(true);
    }

    public boolean addPeripheral(String peripheral) {
        return this.peripherals.add(peripheral);
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public List<String> getPeripherals() {
        return CollectionsUtils.unmodifiableList(this.peripherals);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + "exclusive" + "=" + this.exclusive + ", " + "peripherals(fst " + 3 + ")=" + CollectionsUtils.firstN(this.peripherals, (int)3) + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.exclusive.hashCode();
        result = 31 * result + this.peripherals.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MasterPeripheral other = (MasterPeripheral)obj;
        if (!this.exclusive.equals(other.exclusive)) {
            return false;
        }
        return this.peripherals.equals(other.peripherals);
    }
}

