/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.FormatOptions;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.resourcetables.model.data.IQuickSelection;
import com.nxp.swtools.resourcetables.model.data.IQuickSetting;
import com.nxp.swtools.resourcetables.model.data.QuickSetting;
import com.nxp.swtools.resourcetables.model.data.setting.UiName;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;

@Root(name="quick_selection", strict=false)
@Order(attributes={"id"})
public class QuickSelection
extends UiName
implements IQuickSelection {
    protected static final Logger LOGGER = LogManager.getLogger(QuickSelection.class);
    @Attribute(name="id")
    private String id;
    @Element(name="description", required=false)
    @Nullable
    private @Element(name="description", required=false) @Nullable String description;
    @ElementList(inline=true, type=QuickSetting.class)
    private List<IQuickSetting> settings = new ArrayList<IQuickSetting>();
    @Nullable
    private Expression availableCond;

    @Attribute(name="available", required=false)
    public @Attribute(name="available", required=false) @Nullable String getConditionString() {
        return this.availableCond != null ? this.availableCond.formatOutput(FormatOptions.DEFAULT) : null;
    }

    @Override
    public @Nullable String getAvailableExprString() {
        return this.getConditionString();
    }

    @Attribute(name="available", required=false)
    private void setConditionString(String newCond) {
        if (!newCond.isEmpty()) {
            try {
                this.availableCond = Expression.create((String)newCond);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Available condition of quick selection \"" + this.getId() + "\" caused exception: " + e.getLocalizedMessage());
            }
        }
    }

    public QuickSelection(String id, @Nullable String uiName, @Nullable String uiNameExpr, @Nullable String description, @Nullable String availableCond) {
        super(uiName, uiNameExpr);
        if (uiName == null && uiNameExpr == null) {
            this.setUINameString(id);
        }
        this.id = id;
        String string = this.description = UtilsText.isEmpty((String)description) ? null : description;
        if (availableCond != null && !availableCond.isEmpty()) {
            this.availableCond = Expression.tryCreate((String)availableCond);
        }
    }

    @Deprecated
    protected QuickSelection() {
        this("", null, null, null, null);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public @Nullable IQuickSetting getSetting(String sId) {
        for (IQuickSetting sett : this.settings) {
            if (!sId.equals(sett.getId())) continue;
            return sett;
        }
        return null;
    }

    @Override
    public List<IQuickSetting> getSettings() {
        return CollectionsUtils.unmodifiableList(this.settings);
    }

    public boolean addSetting(QuickSetting setting) {
        return this.settings.add(setting);
    }

    @Override
    public @Nullable Expression getCondition() {
        return this.availableCond;
    }

    @Override
    public boolean isAvailable(IContext context) {
        return this.availableCond != null ? this.availableCond.resolve(context).getBoolean() : true;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + "id" + "=" + this.getId() + ", " + super.toString() + ", " + "description" + "=" + this.getDescription() + ", " + "available" + "=" + UtilsText.safeString((String)this.getConditionString()) + ", content(fst " + 3 + ")=" + CollectionsUtils.firstN(this.settings, (int)3) + "]";
    }

    @Override
    public String getDescription() {
        return UtilsText.safeString((String)this.description);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + Objects.hashCode(this.availableCond);
        result = 31 * result + this.settings.hashCode();
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        QuickSelection other = (QuickSelection)obj;
        if (!this.id.equals(other.id)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        if (!this.settings.equals(other.settings)) {
            return false;
        }
        return Objects.equals(this.availableCond, other.availableCond);
    }

    @Override
    public void addSetting(IQuickSetting quickSetting) {
        this.settings.add(quickSetting);
    }

    public static void saveToWriter(QuickSelection quickSelection, Writer writer) {
        Persister persister = new Persister();
        try {
            persister.write((Object)quickSelection, writer);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "[TOOL] Problem occurred while saving quick selection to file: " + e.getLocalizedMessage());
        }
    }
}

