/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data.setting;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.EmptyContext;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.FormatOptions;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.resourcetables.model.data.Assign;
import com.nxp.swtools.resourcetables.model.data.Description;
import com.nxp.swtools.resourcetables.model.data.IActiveContextRefResolver;
import com.nxp.swtools.resourcetables.model.data.IConfigurationComponent;
import com.nxp.swtools.resourcetables.model.data.Migration;
import com.nxp.swtools.resourcetables.model.data.Option;
import com.nxp.swtools.resourcetables.model.data.OptionsExpr;
import com.nxp.swtools.resourcetables.model.data.OptionsMap;
import com.nxp.swtools.resourcetables.model.data.SettingUtils;
import com.nxp.swtools.resourcetables.model.data.setting.IBaseModel;
import com.nxp.swtools.resourcetables.model.data.setting.IID;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.model.data.setting.ReferenceSetting;
import com.nxp.swtools.resourcetables.model.data.setting.UiName;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.core.Commit;

@Order(elements={"options_expr", "description"}, attributes={"id", "label", "label_expr", "available", "enable", "options"})
public abstract class ABaseModel
extends UiName
implements IBaseModel {
    private static final Logger LOGGER = LogManager.getLogger(ABaseModel.class);
    @Attribute(name="id")
    private String id;
    @Element(name="description", required=false)
    @Nullable
    private @Element(name="description", required=false) @Nullable Description description;
    @Nullable
    private Expression availableCond;
    @Nullable
    private Expression enableCond;
    private OptionsMap optionsMap;
    @Attribute(name="options", required=false)
    @Nullable
    private @Attribute(name="options", required=false) @Nullable String options;
    @Element(type=OptionsExpr.class, name="options_expr", required=false)
    @Nullable
    private @Element(type=OptionsExpr.class, name="options_expr", required=false) @Nullable OptionsExpr optionsExpr;
    @ElementList(inline=true, required=false)
    private List<Migration> migrations = new ArrayList<Migration>();
    @ElementList(type=Assign.class, required=false, inline=true)
    private List<Assign> assigns;
    protected LinkedHashMap<String, ISetting> relatedSettings = new LinkedHashMap();
    protected static final String LOCATION_SPLITTER = "::";

    public ABaseModel(String id, @Nullable String uiName, @Nullable String uiNameExpr, @Nullable Description description, @Nullable String availableCond, @Nullable String enableCond, @Nullable String options, @Nullable OptionsExpr optionsExpr) {
        super(uiName, uiNameExpr);
        this.id = id;
        this.assigns = new ArrayList<Assign>();
        this.options = UtilsText.isEmpty((String)options) ? null : options;
        this.optionsExpr = optionsExpr;
        this.optionsMap = SettingUtils.createOptionsMap(options, optionsExpr, this);
        this.description = description;
        if (availableCond != null) {
            this.setAvailableExprString(availableCond);
        }
        if (enableCond != null) {
            this.setEnableExprString(enableCond);
        }
    }

    public List<Assign> getAssigns() {
        return this.assigns;
    }

    public void setAssigns(List<Assign> assigns) {
        this.assigns = new ArrayList<Assign>(assigns);
    }

    protected static @Nullable String andConditions(@Nullable String c1, @Nullable String c2) {
        if (c1 == null && c2 == null) {
            return null;
        }
        if (c1 != null && c2 == null) {
            return c1;
        }
        if (c1 == null && c2 != null) {
            return c2;
        }
        return String.format("(%s) && (%s)", c1, c2);
    }

    protected @Nullable OptionsExpr mergeOptionExpr(@Nullable OptionsExpr o1, @Nullable OptionsExpr o2) {
        if (o1 == null && o2 == null) {
            return null;
        }
        OptionsExpr curOptionsExpr = new OptionsExpr();
        if (o2 != null) {
            curOptionsExpr.addAllOptions(o2.getOptions());
        }
        if (o1 != null) {
            curOptionsExpr.addAllOptions(o1.getOptions());
        }
        return curOptionsExpr;
    }

    protected @Nullable String mergeOptions(@Nullable String o1, @Nullable String o2) {
        if (o1 == null && o2 == null) {
            return null;
        }
        if (o1 != null && o2 == null) {
            return o1;
        }
        if (o1 == null && o2 != null) {
            return o2;
        }
        return String.valueOf(o1) + ";" + o2;
    }

    @Deprecated
    protected OptionsMap createOptionsMap(@Nullable String optionsPrototype, @Nullable OptionsExpr optionsExprPrototype, @Nullable String optionsReference, @Nullable OptionsExpr optionsExprReference, IID iid) {
        OptionsMap optionsMapLoc = new OptionsMap();
        if (optionsPrototype != null) {
            SettingUtils.addOptionsToOptionsMap(optionsPrototype, iid, optionsMapLoc);
        }
        if (optionsExprPrototype != null) {
            for (Option option : optionsExprPrototype.getOptions()) {
                optionsMapLoc.addOption(option.getId(), option);
            }
        }
        if (optionsReference != null) {
            SettingUtils.addOptionsToOptionsMap(optionsReference, iid, optionsMapLoc);
        }
        if (optionsExprReference != null) {
            for (Option option : optionsExprReference.getOptions()) {
                optionsMapLoc.addOption(option.getId(), option);
            }
        }
        return optionsMapLoc;
    }

    protected OptionsMap createOptionsMap(@Nullable OptionsMap optionsPrototype, @Nullable OptionsMap optionsReference) {
        OptionsMap optionsMapLoc = new OptionsMap();
        if (optionsPrototype != null) {
            for (Map.Entry<String, Option> opt : optionsPrototype.getOptions().entrySet()) {
                optionsMapLoc.addOption(opt.getKey(), opt.getValue());
            }
        }
        if (optionsReference != null) {
            for (Map.Entry<String, Option> opt : optionsReference.getOptions().entrySet()) {
                optionsMapLoc.addOption(opt.getKey(), opt.getValue());
            }
        }
        return optionsMapLoc;
    }

    @Override
    @Attribute(name="available", required=false)
    public @Attribute(name="available", required=false) @Nullable String getAvailableExprString() {
        return Expression.formatOutput((Expression)this.availableCond, (FormatOptions)FormatOptions.DEFAULT);
    }

    @Attribute(name="available", required=false)
    protected void setAvailableExprString(String newCond) {
        if (!newCond.isEmpty()) {
            try {
                this.availableCond = Expression.create((String)newCond);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Available expression of setting \"" + this.getId() + "\" caused exception: " + e.getLocalizedMessage());
            }
        }
    }

    @Override
    @Attribute(name="enable", required=false)
    public @Attribute(name="enable", required=false) @Nullable String getEnableExprString() {
        return Expression.formatOutput((Expression)this.enableCond, (FormatOptions)FormatOptions.DEFAULT);
    }

    @Attribute(name="enable", required=false)
    protected void setEnableExprString(String newCond) {
        if (!newCond.isEmpty()) {
            try {
                this.enableCond = Expression.create((String)newCond);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Enable expression of setting \"" + this.getId() + "\" caused exception: " + e.getLocalizedMessage());
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<Migration> getMigrations() {
        return CollectionsUtils.unmodifiableList(this.migrations);
    }

    @Override
    public void setMigrations(Collection<Migration> migrations) {
        this.migrations = new ArrayList<Migration>(migrations);
    }

    @Override
    public @Nullable Expression getCondition() {
        return this.availableCond;
    }

    @Override
    public String getUIName(IContext context) {
        String result = super.getUIName(context);
        if (result.isEmpty()) {
            return this.id;
        }
        return result;
    }

    @Override
    public boolean isAvailable(IContext context) {
        return this.availableCond != null ? this.availableCond.resolve(context).getBoolean() : true;
    }

    @Override
    public boolean isEnabled(IContext context) {
        return this.enableCond != null ? this.enableCond.resolve(context).getBoolean() : true;
    }

    protected @Nullable Description getDescription(@Nullable Description newDescription) {
        if (newDescription != null) {
            return newDescription;
        }
        return this.description;
    }

    @Override
    public @Nullable Description getDescription() {
        return this.description;
    }

    @Override
    public boolean hasDescription() {
        return this.description != null;
    }

    @Override
    public @Nullable String getResolvedDescription(IContext context) {
        if (this.description != null) {
            return this.description.getDescription(context);
        }
        return null;
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    @Override
    public Collection<String> getPresentOptions() {
        return this.optionsMap.getPresentOptions();
    }

    @Override
    public @Nullable Object getOptionValue(String key, IContext context) {
        return this.optionsMap.getOptionValue(key, context);
    }

    @Override
    public boolean isOptionSet(String option) {
        return this.optionsMap.isOptionSet(option);
    }

    @Override
    public boolean isOptionAvailable(String option, IContext context) {
        return this.optionsMap.isAvailable(option, context);
    }

    @Commit
    public void commit() {
        Object relatedSettValue;
        Expression relatedSettExpr;
        if (this.options != null || this.optionsExpr != null) {
            this.optionsMap = SettingUtils.createOptionsMap(this.options, this.optionsExpr, this);
        }
        if ((relatedSettExpr = this.optionsMap.getOptionExpr("RELATED_SETTINGS_AUTO")) != null && (relatedSettValue = relatedSettExpr.resolve((IContext)EmptyContext.getInstsance()).getValue()) instanceof String) {
            String values = (String)relatedSettValue;
            String[] stringArray = values.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String setting = stringArray[n2];
                ReferenceSetting resolvedSetting = this.computeReferenceInstance(setting);
                if (resolvedSetting != null) {
                    this.relatedSettings.put(resolvedSetting.getId(), resolvedSetting);
                }
                ++n2;
            }
        }
        this.verify();
    }

    private void verify() {
        if (!SWToolsProperties.isVerificationOn()) {
            return;
        }
        String uiNameExprString = this.getUINameExprString();
        if (uiNameExprString != null && uiNameExprString.startsWith(" ")) {
            LOGGER.log(Level.SEVERE, "[DATA] Label of setting: \"{0}\" contains space at the beginning. This is not permitted and will break GUI.", this.getId());
            this.setUINameString(uiNameExprString.trim());
        }
    }

    public @Nullable String getOptions() {
        return this.options;
    }

    public @Nullable OptionsExpr getOptionsExpression() {
        return this.optionsExpr;
    }

    public OptionsMap getOptionsMap() {
        return this.optionsMap;
    }

    public void setOptionsMap(OptionsMap optionsMap) {
        this.optionsMap = optionsMap;
    }

    public void setOptions(@Nullable String options, @Nullable OptionsExpr optionsExpr) {
        this.options = options;
        this.optionsExpr = optionsExpr;
        this.optionsMap = SettingUtils.createOptionsMap(this.options, this.optionsExpr, this);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.enableCond);
        result = 31 * result + Objects.hashCode(this.availableCond);
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + this.id.hashCode();
        result = 31 * result + Objects.hashCode(this.options);
        result = 31 * result + Objects.hashCode(this.optionsExpr);
        result = 31 * result + Objects.hashCode(this.assigns);
        result = 31 * result + Objects.hashCode(this.relatedSettings);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        ABaseModel other = (ABaseModel)obj;
        if (!Objects.equals(this.availableCond, other.availableCond)) {
            return false;
        }
        if (!Objects.equals(this.enableCond, other.enableCond)) {
            return false;
        }
        if (!this.id.equals(other.id)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        if (!Objects.equals(this.optionsMap, other.optionsMap)) {
            return false;
        }
        if (!Objects.equals(this.relatedSettings, other.relatedSettings)) {
            return false;
        }
        return Objects.equals(this.assigns, other.assigns);
    }

    @Override
    public String toString() {
        return "id=" + this.getId() + ", " + super.toString() + ", " + "available" + "=" + UtilsText.safeString((String)this.getAvailableExprString()) + ", " + "enable" + "=" + UtilsText.safeString((String)this.getEnableExprString()) + ", " + "options" + "=" + UtilsText.safeString((String)this.getOptions()) + ", " + "options_expr" + "=" + (this.optionsExpr != null ? this.optionsExpr : "") + ", " + "description" + "=" + (this.description != null ? this.description : "") + ", " + "migration" + "=" + this.migrations + ", " + "assign" + "=" + UtilsText.safeString((String)this.assigns.toString());
    }

    @Override
    public void resolveRelatedSettings(IActiveContextRefResolver sdkRefResolver, @Nullable IConfigurationComponent comp, String configSetID, Map<String, ISetting> allRelSettings) {
        sdkRefResolver.resolve(this, this.relatedSettings, comp, configSetID);
        allRelSettings.putAll(this.relatedSettings);
    }

    @Override
    public LinkedHashMap<String, ISetting> getRelatedSettings() {
        return this.relatedSettings;
    }

    @Override
    public @Nullable ISetting getRelatedSetting(String settingId) {
        return this.relatedSettings.get(settingId);
    }

    protected @Nullable ReferenceSetting computeReferenceInstance(String settingTypeId) {
        if (!settingTypeId.matches("([A-Za-z_][0-9A-Za-z_]*::){0,2}[A-Za-z_][0-9A-Za-z_]*(\\.[0-9A-Za-z_]*)*")) {
            LOGGER.severe(MessageFormat.format("[DATA] The received setting ID, {0}, doesn't match the pattern: \"([A-Za-z_][0-9A-Za-z_]*::){0,2}[A-Za-z_][0-9A-Za-z_]*\" and the setting can not be resolved.", settingTypeId));
            return null;
        }
        String[] settingPath = settingTypeId.split(LOCATION_SPLITTER);
        String compId = null;
        String configSet = null;
        String settingId = null;
        switch (settingPath.length) {
            case 3: {
                compId = settingPath[0];
                configSet = settingPath[1];
                settingId = settingPath[2];
                break;
            }
            case 2: {
                configSet = settingPath[0];
                settingId = settingPath[1];
                break;
            }
            default: {
                settingId = settingPath[0];
            }
        }
        return new ReferenceSetting(settingId, null, null, null, settingId, configSet, compId, null, null, null, null, null);
    }
}

