/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data.setting;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.resourcetables.model.data.Description;
import com.nxp.swtools.resourcetables.model.data.IActiveContextRefResolver;
import com.nxp.swtools.resourcetables.model.data.IConfigurationComponent;
import com.nxp.swtools.resourcetables.model.data.IQuickSelection;
import com.nxp.swtools.resourcetables.model.data.IQuickSelectionGroup;
import com.nxp.swtools.resourcetables.model.data.OptionsExpr;
import com.nxp.swtools.resourcetables.model.data.QuickSelectionsGroup;
import com.nxp.swtools.resourcetables.model.data.setting.ACollectionSetting;
import com.nxp.swtools.resourcetables.model.data.setting.ASetting;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.model.data.setting.IUIName;
import com.nxp.swtools.resourcetables.model.data.setting.ReferenceSetting;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;

@Root(name="struct", strict=false)
@Order(attributes={"id", "label", "label_expr", "available", "public", "enable", "options", "from", "from_source"})
public class StructSetting
extends ACollectionSetting
implements IQuickSelectionGroup {
    @Attribute(name="from", required=false)
    private String cStructure = "";
    @Attribute(name="from_source", required=false)
    @Nullable
    private @Attribute(name="from_source", required=false) @Nullable String source = "";
    @Element(name="quick_selections", required=false)
    @Nullable
    private @Element(name="quick_selections", required=false) @Nullable QuickSelectionsGroup qsGroup;
    @Attribute(name="base_type", required=false)
    @Nullable
    private @Attribute(name="base_type", required=false) @Nullable String baseTypeId;

    public StructSetting(String id, @Nullable String uiName, @Nullable String uiNameExpr, @Nullable Description description, String fromStructure, @Nullable String fromSource, @Nullable String condition, @Nullable String enableCond, @Nullable String publicCond, @Nullable String options, @Nullable OptionsExpr optionsExpression) {
        super(id, uiName, uiNameExpr, description, condition, enableCond, publicCond, options, optionsExpression);
        this.source = UtilsText.isEmpty((String)fromSource) ? null : fromSource;
        this.cStructure = fromStructure;
    }

    @Deprecated
    protected StructSetting() {
        this("", null, null, null, "", null, null, null, null, null, null);
    }

    public String getCStructure() {
        return this.cStructure;
    }

    public @Nullable String getSource() {
        return this.source;
    }

    @Override
    public boolean hasQuickSelections() {
        return this.qsGroup != null;
    }

    @Override
    public List<IQuickSelection> getQuickSelections() {
        return this.qsGroup != null ? this.qsGroup.getQuickSelections() : CollectionsUtils.emptyList();
    }

    public @Nullable IQuickSelection getQuickSelection(String qsId) {
        if (this.qsGroup != null) {
            return (IQuickSelection)CollectionsUtils.nullableOptionalGet(this.qsGroup.getQuickSelections().stream().filter(x -> x.getId().equals(qsId)).findFirst());
        }
        return null;
    }

    @Override
    public List<IQuickSelection> getDefaultQS() {
        return this.qsGroup != null ? this.qsGroup.getDefaultQS() : new ArrayList();
    }

    @Override
    public void setDefaultQS(IQuickSelection qs) {
        if (this.qsGroup != null) {
            this.qsGroup.setDefaultQS(qs);
        }
    }

    @Override
    public void setDefaultQuickSelectionById(@Nullable String qsId) {
        if (this.qsGroup != null) {
            this.qsGroup.setDefaultQuickSelectionById(qsId);
        }
    }

    @Override
    public @Nullable String getDefaultQuickSelectionId() {
        QuickSelectionsGroup qsGroupLoc = this.qsGroup;
        if (qsGroupLoc == null) {
            return null;
        }
        return qsGroupLoc.getDefaultQuickSelectionId();
    }

    @Override
    public boolean addQuickSelection(IQuickSelection quickSelection) {
        QuickSelectionsGroup qsGroupLoc = this.qsGroup;
        if (qsGroupLoc == null) {
            qsGroupLoc = new QuickSelectionsGroup();
        }
        this.qsGroup = qsGroupLoc;
        return qsGroupLoc.addQuickSelection(quickSelection);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + super.toString() + ", " + "from" + "=" + this.getCStructure() + ", " + "from_source" + "=" + UtilsText.safeString((String)this.getSource()) + ", " + "quick_selections" + "=" + (this.qsGroup != null ? this.qsGroup : "") + "]";
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.cStructure.hashCode();
        result = 31 * result + Objects.hashCode(this.source);
        result = 31 * result + Objects.hashCode(this.qsGroup);
        result = 31 * result + Objects.hashCode(this.baseTypeId);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        StructSetting other = (StructSetting)obj;
        if (!this.cStructure.equals(other.cStructure)) {
            return false;
        }
        if (!Objects.equals(this.source, other.source)) {
            return false;
        }
        if (!Objects.equals(this.qsGroup, other.qsGroup)) {
            return false;
        }
        return Objects.equals(this.baseTypeId, other.baseTypeId);
    }

    @Override
    public StructSetting fromReference(ReferenceSetting ref) {
        StructSetting s = new StructSetting(ref.getId(), (String)IUIName.getUiNames(ref, this).getFirst(), (String)IUIName.getUiNames(ref, this).getSecond(), this.getDescription(ref.getDescription()), this.cStructure, this.source, StructSetting.andConditions(ref.getAvailableExprString(), this.getAvailableExprString()), StructSetting.andConditions(ref.getEnableExprString(), this.getEnableExprString()), StructSetting.andConditions(ref.getPublicCondition(), this.getPublicCondition()), null, null);
        s.setOptionsMap(this.createOptionsMap(this.getOptionsMap(), ref.getOptionsMap()));
        s.setSettings(this.settings);
        s.setValidation(this.mergeValidations(ref.getValidation(), this.getValidation()));
        s.setMigrations(ref.getMigrations());
        s.relatedSettings = this.relatedSettings;
        s.setBaseTypeId(this.getBaseTypeId());
        s.qsGroup = this.qsGroup;
        s.verify();
        return s;
    }

    @Override
    public void resolve(IActiveContextRefResolver sdkRefResolver, @Nullable IConfigurationComponent comp, String setID) {
        ASetting baseTypeSetting;
        sdkRefResolver.resolve(this, this.settings, comp, setID);
        if (this.baseTypeId != null && (baseTypeSetting = this.resolveBaseType(sdkRefResolver, comp, setID, this.baseTypeId)) instanceof StructSetting) {
            StructSetting structBaseType = (StructSetting)baseTypeSetting;
            LinkedHashMap<String, ISetting> finalSettings = new LinkedHashMap<String, ISetting>();
            finalSettings.putAll(structBaseType.getSettings());
            finalSettings.putAll(this.getSettings());
            this.setSettings(finalSettings);
        }
    }

    @Override
    @Commit
    public void commit() {
        super.commit();
    }

    @Override
    public @NonNull String getTypeName() {
        return "struct";
    }

    public void setBaseTypeId(@Nullable String baseTypeId) {
        this.baseTypeId = baseTypeId;
    }

    public @Nullable String getBaseTypeId() {
        return this.baseTypeId;
    }
}

