/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.settings.checker;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.runtime.ExecutableExtensionProvider;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.ISharedConfigurationListener;
import com.nxp.swtools.provider.configuration.SharedConfigurationAdapter;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.resourcetables.settings.checker.ISettingsChecker;
import java.util.Collection;
import java.util.Collections;

public class SettingsCheckerSingleton {
    protected Collection<@NonNull ISettingsChecker> settingCheckers = Collections.emptyList();

    private SettingsCheckerSingleton() {
        this.collectSettingCheckers();
        SharedConfigurationFactory.getSharedConfigurationSingleton().addListener((ISharedConfigurationListener)new SharedConfigurationAdapter(){

            public void configurationReloaded(@NonNull ISharedConfiguration sharedConfig, @NonNull ConfigChangeReason reason) {
                SettingsCheckerSingleton.this.loadAdditionalData();
            }
        });
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void collectSettingCheckers() {
        @NonNull ExecutableExtensionProvider provider = new ExecutableExtensionProvider("com.nxp.swtools.settings.checker", "setting_checker", "class", null, null, null);
        this.settingCheckers = provider.getExtensions();
        this.loadAdditionalData();
    }

    public static SettingsCheckerSingleton getInstance() {
        try {
            return (SettingsCheckerSingleton)SWTFactoryProxy.INSTANCE.getSingletonInstance(SettingsCheckerSingleton.class);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("[TOOL] Cannot create singleton instance of setting checker", e);
        }
    }

    public Collection<@NonNull ISettingsChecker> getCheckers() {
        return this.settingCheckers;
    }

    protected void loadAdditionalData() {
        for (ISettingsChecker checker : this.settingCheckers) {
            checker.loadAdditionalData();
        }
    }
}

