/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.modular.internal.core;

import com.nxp.s32ds.ext.rcp.registry.BaseRegistry;
import com.nxp.s32ds.rcp.modular.ModularFactory;
import com.nxp.s32ds.rcp.modular.ModularInstallerService;
import com.nxp.s32ds.rcp.modular.ModularOperationStatus;
import com.nxp.s32ds.rcp.modular.ModularPack;
import com.nxp.s32ds.rcp.modular.internal.core.ModularInstallerActivator;
import com.nxp.s32ds.rcp.modular.internal.core.ModularMessages;
import com.nxp.s32ds.rcp.modular.internal.core.ModularMetaModelReader;
import com.nxp.s32ds.rcp.modular.internal.core.UpdateChecker;
import com.nxp.s32ds.rcp.modular.internal.core.operations.InstallModularOperation;
import com.nxp.s32ds.rcp.modular.internal.core.operations.UninstallModularOperation;
import com.nxp.s32ds.rcp.modular.internal.core.operations.UpdateModularOperation;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.planner.IPlanner;

public class ModularInstallerServiceImplementation
extends BaseRegistry
implements ModularInstallerService {
    private InstallModularOperation installModularOperation;
    private UpdateModularOperation updateModularOperation;
    private UninstallModularOperation uninstallModularOperation;
    private ModularMetaModelReader metaModelReader;
    private ProvisioningSession provisioningSession;
    private IPlanner planner;
    private IProfileRegistry profileRegistry;
    private UpdateChecker updateChecker;

    public ModularInstallerServiceImplementation() {
        IProvisioningAgent provisioningAgent = ModularInstallerActivator.getInstance().getProvisionAgent();
        if (provisioningAgent != null) {
            this.planner = (IPlanner)provisioningAgent.getService(IPlanner.SERVICE_NAME);
            this.profileRegistry = (IProfileRegistry)provisioningAgent.getService(IProfileRegistry.SERVICE_NAME);
            if (this.planner == null || this.profileRegistry == null) {
                ModularInstallerActivator.getInstance().logError(ModularMessages.ModularInstallerServiceImplementation_ErrorServerInitialization);
            }
            this.provisioningSession = new ProvisioningSession(provisioningAgent);
            this.metaModelReader = new ModularMetaModelReader(this.provisioningSession);
            this.installModularOperation = new InstallModularOperation(this.provisioningSession, this.metaModelReader);
            this.updateModularOperation = new UpdateModularOperation(this.provisioningSession, this.metaModelReader);
            this.uninstallModularOperation = new UninstallModularOperation(this.provisioningSession, this.metaModelReader);
            this.updateChecker = new UpdateChecker(provisioningAgent, this.profileRegistry, this.planner);
        }
    }

    public Set<ModularPack> getPacksFromRepository(Collection<URI> uris, IProgressMonitor progressMonitor) throws OperationCanceledException {
        return this.metaModelReader.getLastedPackfromUri(uris, ModularInstallerActivator.getInstance().getProvisionAgent(), progressMonitor);
    }

    public IStatus install(ModularOperationStatus modularOperationStatus, IProgressMonitor progressMonitor) {
        String symbolicName = ModularInstallerActivator.getContext().getBundle().getSymbolicName();
        ProfileChangeOperation operation = modularOperationStatus.getExecutableOperation();
        if (operation != null && operation instanceof InstallOperation) {
            InstallOperation changeOperation = (InstallOperation)operation;
            return this.installModularOperation.executeOperation((ProfileChangeOperation)changeOperation, progressMonitor);
        }
        return new Status(4, symbolicName, ModularMessages.ModularInstallerServiceImplementation_EmptyOrNullInstallOperation);
    }

    public IStatus update(ModularOperationStatus modularOperationStatus, IProgressMonitor progressMonitor) {
        String symbolicName = ModularInstallerActivator.getContext().getBundle().getSymbolicName();
        ProfileChangeOperation operation = modularOperationStatus.getExecutableOperation();
        if (operation != null && operation instanceof UpdateOperation) {
            UpdateOperation changeOperation = (UpdateOperation)operation;
            return this.updateModularOperation.executeOperation((ProfileChangeOperation)changeOperation, progressMonitor);
        }
        return new Status(4, symbolicName, ModularMessages.ModularInstallerServiceImplementation_EmptyOrNullInstallOperation);
    }

    public Collection<URI> getAllAvailableRepository() {
        return this.metaModelReader.getEnabledRepositories();
    }

    public Collection<ModularPack> getInstalledUnit(IProgressMonitor progressMonitor) {
        return this.metaModelReader.getInstalledUnit(progressMonitor);
    }

    public ModularOperationStatus computeInstallOperation(Set<ModularPack> modularObjects, IProgressMonitor progressMonitor) {
        ModularOperationStatus resolutionStatus = this.installModularOperation.computeOperation(modularObjects, progressMonitor);
        if (resolutionStatus.getStatus().getSeverity() == 4) {
            ModularInstallerActivator.getInstance().log((IStatus)resolutionStatus.getStatus());
        }
        return resolutionStatus;
    }

    public ModularOperationStatus getResolutionStatusForUpdate(Set<ModularPack> modularObjects, IProgressMonitor progressMonitor) {
        ModularOperationStatus resolutionStatus = this.updateModularOperation.computeOperation(modularObjects, progressMonitor);
        if (resolutionStatus.getStatus().getSeverity() == 4) {
            ModularInstallerActivator.getInstance().log((IStatus)resolutionStatus.getStatus());
        }
        return resolutionStatus;
    }

    public IProfileRegistry getProfileRegistry() {
        IProfileRegistry profileRegistry = (IProfileRegistry)this.provisioningSession.getProvisioningAgent().getService(IProfileRegistry.SERVICE_NAME);
        return profileRegistry;
    }

    public Collection<ModularPack> checkForUpdate(Collection<URI> uris, IProgressMonitor progressMonitor) throws OperationCanceledException {
        return this.updateChecker.checkForUpdate(uris, progressMonitor);
    }

    public ModularOperationStatus getResolutionStatusForUninstall(Set<ModularPack> modularObjects, IProgressMonitor progressMonitor) {
        ModularOperationStatus resolutionStatus = this.uninstallModularOperation.computeOperation(modularObjects, progressMonitor);
        if (resolutionStatus.getStatus().getSeverity() == 4) {
            ModularInstallerActivator.getInstance().log((IStatus)resolutionStatus.getStatus());
        }
        return resolutionStatus;
    }

    public ModularFactory getModularFactory() {
        return ModularFactory.FACTORY;
    }
}

