/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.modular.internal.core;

import com.nxp.s32ds.rcp.modular.HWDevice;
import com.nxp.s32ds.rcp.modular.HWFamily;
import com.nxp.s32ds.rcp.modular.ModularFactory;
import com.nxp.s32ds.rcp.modular.ModularFeature;
import com.nxp.s32ds.rcp.modular.ModularObject;
import com.nxp.s32ds.rcp.modular.ModularPack;
import com.nxp.s32ds.rcp.modular.internal.CompatibilitiesModularUtils;
import com.nxp.s32ds.rcp.modular.internal.ModularFeatureImplementation;
import com.nxp.s32ds.rcp.modular.internal.ModularPackImplementation;
import com.nxp.s32ds.rcp.modular.internal.core.LoadRepositoryOperation;
import com.nxp.s32ds.rcp.modular.internal.core.ModularInstallerActivator;
import com.nxp.s32ds.rcp.modular.internal.core.ModularInstallerMarker;
import com.nxp.s32ds.rcp.modular.internal.core.ModularMessages;
import com.nxp.s32ds.rcp.modular.internal.core.ModularMetaModelReader;
import com.nxp.s32ds.rcp.modular.internal.core.exception.ModularException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;

public class ModularUtils {
    private static final String HTTPS_SCHEME = "https";
    private static final String PRODUCT_FEATURE = "product.feature";
    public static final String DF_LT = "df_LT.";
    public static final String MODULAR_META_MODEL_READER_FEATURE_DESCRIPTION = "df_LT.description";
    public static final String MODULAR_META_MODEL_READER_FEATURE_NAME = "df_LT.featureName";
    public static final String MODULAR_META_MODEL_READER_PACK_DESCRIPTION = "com.nxp.s32ds.pack.description";
    public static final String MODULAR_META_MODEL_READER_PACK_ICON = "com.nxp.s32ds.pack.icon";
    public static final String MODULAR_META_MODEL_READER_PACK_VERSION = "com.nxp.s32ds.pack.version";
    public static final String MODULAR_META_MODEL_READER_PACK_UNISTALLABLE = "com.nxp.s32ds.pack.uninstallable";
    public static final String MODULAR_META_MODEL_READER_PACK_NAME = "com.nxp.s32ds.pack.name";
    public static final String MODULAR_META_MODEL_READER_PACK_ID = "com.nxp.s32ds.pack.id";
    public static final String MODULAR_META_MODEL_READER_PACK_ERROR_DETAILS = "com.nxp.s32ds.pack.error.details";
    public static final String MODULAR_META_MODEL_READER_PACK_CLL_LICENSE = "com.nxp.s32ds.pack.licenseinfo";
    public static final String MODULAR_META_MODEL_READER_PACK_OS = "com.nxp.s32ds.pack.os";
    public static final String MODULAR_META_MODEL_READER_PACK_ARCHITECTURE = "com.nxp.s32ds.pack.architecture";
    public static final String MODULAR_META_MODEL_READER_PACK_HARDWARE = "com.nxp.s32ds.pack.hardware";
    public static final String MODULAR_META_MODEL_READER_PACK_CATEGORY = "com.nxp.s32ds.pack.category";
    public static final String INSTALLER_FEATURE_GROUP_SUFFIX = "feature.feature.group";
    public static final String INSTALLER_FEATUR_ROOT_SUFFIX = "feature_root";
    public static final String MODULAR_META_MODEL_READER_PACKSUPPORT_PRODUCTS = "com.nxp.s32ds.pack.support.products";
    public static final String OS_WIN = "win32";
    public static final String OS_LINUX = "linux";
    public static final String OS_ARCHITECTURE_x86 = "x86";
    public static final String OS_ARCHITECTURE_x86_64 = "x86_64";
    private static final String GROUP_PARAMETRS_PATTERN = "(.*)(\\[.*\\])";
    private static final String GROUP_SPLITTER = ";";
    private static final String ELEMENT_SPLITTER = ",";

    private ModularUtils() {
    }

    public static IMetadataRepository loadMetadataRepository(URI uri, IMetadataRepositoryManager metaRepositorymanager, IArtifactRepositoryManager artifactRepositoryManager, IProgressMonitor progressMonitor) {
        IEclipsePreferences node = ConfigurationScope.INSTANCE.getNode("com.nxp.s32ds.rcp.modular.core");
        boolean overlapHttp = node.getBoolean("overlapHttp", false);
        IMetadataRepository repo = null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)100).checkCanceled();
        if (overlapHttp) {
            try {
                uri = new URI(HTTPS_SCHEME, uri.getHost(), uri.getPath(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                ModularInstallerActivator.getInstance().logError(e.getMessage());
            }
        }
        if ((repo = ModularUtils.readRepo(uri, metaRepositorymanager, artifactRepositoryManager, (IProgressMonitor)subMonitor.split(50))) == null && !overlapHttp) {
            ModularInstallerActivator.getInstance().logWarning(ModularMessages.bind((String)ModularMessages.ModularUtils_OverlapMessage, (Object)uri.toString()));
            try {
                URI httpsUri = new URI(HTTPS_SCHEME, uri.getHost(), uri.getPath(), uri.getFragment());
                repo = ModularUtils.readRepo(httpsUri, metaRepositorymanager, artifactRepositoryManager, (IProgressMonitor)subMonitor.split(50));
                if (repo != null) {
                    node.putBoolean("overlapHttp", true);
                    try {
                        node.flush();
                    }
                    catch (BackingStoreException backingStoreException) {
                        ModularInstallerActivator.getInstance().logError(backingStoreException.getMessage());
                    }
                }
            }
            catch (URISyntaxException uriSyntaxException) {
                ModularInstallerActivator.getInstance().logError(uriSyntaxException.getMessage());
            }
        }
        return repo;
    }

    private static IMetadataRepository readRepo(URI uri, IMetadataRepositoryManager metaRepositorymanager, IArtifactRepositoryManager artifactRepositoryManager, IProgressMonitor progressMonitor) {
        IEclipsePreferences node = ConfigurationScope.INSTANCE.getNode("com.nxp.s32ds.rcp.modular.core");
        boolean useTimeOut = node.getBoolean("useTimeout", false);
        int timeout = node.getInt("timeoutValue", 0);
        String jobBindingName = uri.getHost() != null ? uri.getHost() : uri.getRawSchemeSpecificPart();
        LoadRepositoryOperation loadRepositoryJob = new LoadRepositoryOperation(NLS.bind((String)ModularMessages.ModularUtils_LoadRepositoryJobName, (Object)jobBindingName), uri, metaRepositorymanager, artifactRepositoryManager, useTimeOut, timeout);
        loadRepositoryJob.run(progressMonitor);
        return loadRepositoryJob.getMetadataRepository();
    }

    public static IInstallableUnit getFeatureGroupInstalledUnitByRootInstalledUnit(IQueryable<IInstallableUnit> queryable, IInstallableUnit unit, IProgressMonitor progressMonitor) {
        IInstallableUnit firstFoundUnit = null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor).checkCanceled();
        if (unit != null && unit.getId().endsWith(INSTALLER_FEATUR_ROOT_SUFFIX)) {
            String id = String.valueOf(unit.getId().substring(0, unit.getId().indexOf(INSTALLER_FEATUR_ROOT_SUFFIX))) + INSTALLER_FEATURE_GROUP_SUFFIX;
            Version version = unit.getVersion();
            for (IInstallableUnit iInstallableUnit : queryable.query(QueryUtil.ALL_UNITS, (IProgressMonitor)subMonitor)) {
                if (!id.equals(iInstallableUnit.getId())) continue;
                if (version != null && version.equals(iInstallableUnit.getVersion())) {
                    return iInstallableUnit;
                }
                if (firstFoundUnit != null) continue;
                firstFoundUnit = iInstallableUnit;
            }
        }
        return firstFoundUnit;
    }

    public static Set<IInstallableUnit> getRequirementsUnit(IQueryable<IInstallableUnit> picker, IInstallableUnit installableUnit, IProgressMonitor progressMonitor) {
        HashSet requirements = new HashSet();
        requirements.addAll(installableUnit.getRequirements());
        requirements.addAll(installableUnit.getMetaRequirements());
        HashSet<IInstallableUnit> installableUnits = new HashSet<IInstallableUnit>();
        for (IRequirement req : requirements) {
            IQuery query = QueryUtil.createMatchQuery((IExpression)req.getMatches(), (Object[])new Object[0]);
            IQueryResult matches = picker.query(query, progressMonitor);
            for (IInstallableUnit unit : matches) {
                installableUnits.add(unit);
            }
        }
        return installableUnits;
    }

    public static Collection<IInstallableUnit> getInstallUnitByURI(Set<ModularPack> modularObjects, IProgressMonitor progressMonitor, ModularMetaModelReader metaModelReader, IProvisioningAgent agent) {
        return modularObjects.stream().map(p -> p.getInstallableUnit()).collect(Collectors.toList());
    }

    private static Optional<IInstallableUnit> getSubUnit(IProgressMonitor progressMonitor, IQueryResult<IInstallableUnit> query, IInstallableUnit q) {
        if (query != null) {
            return Optional.ofNullable(ModularUtils.getFeatureGroupInstalledUnitByRootInstalledUnit(query, q, progressMonitor));
        }
        return Optional.empty();
    }

    private static void readSubUnit(IInstallableUnit groupUnit, IProgressMonitor progressMonitor, URI uri, IQueryResult<IInstallableUnit> query, ModularPack modularPack) {
        ModularFactory.FACTORY.setIInstallableUnitToPack(modularPack, groupUnit);
        ModularFactory.FACTORY.setP2FeatureIdToPack(modularPack, groupUnit.getId());
        ModularFactory.FACTORY.setP2FeatureVersionToPack(modularPack, groupUnit.getVersion().toString());
        Set<IInstallableUnit> requirementsUnit = ModularUtils.getRequirementsUnit(query, groupUnit, progressMonitor);
        ModularFactory.FACTORY.addRequarementIInstallableUnitsToModularPack(modularPack, requirementsUnit);
        int nameParametIndex = 0;
        Set requirementNameSet = Stream.concat(groupUnit.getRequirements().stream(), groupUnit.getMetaRequirements().stream()).map(req -> req.getMatches()).filter(match -> match.getParameters().length > 0).map(match -> match.getParameters()[nameParametIndex].toString()).collect(Collectors.toSet());
        ModularFactory.FACTORY.addAllthirdPartyIds(modularPack, requirementNameSet);
        for (IInstallableUnit iInstallableUnit : requirementsUnit) {
            String cllLicense;
            ModularFeature feature = ModularFactory.FACTORY.createFeature(iInstallableUnit.getId(), iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_FEATURE_NAME), iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_FEATURE_DESCRIPTION), iInstallableUnit.getVersion().toString(), uri);
            if (feature instanceof ModularFeatureImplementation && feature.getDescription() != null && !feature.getDescription().isEmpty()) {
                for (ILicense iLicense : iInstallableUnit.getLicenses()) {
                    ModularFeatureImplementation featureImplementation = (ModularFeatureImplementation)feature;
                    featureImplementation.addLicense(iLicense);
                }
                ModularFactory.FACTORY.addModularFeatureToPack(feature, modularPack);
            }
            if ((cllLicense = iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACK_CLL_LICENSE)) == null || cllLicense.isEmpty() || !(modularPack instanceof ModularPackImplementation)) continue;
            ModularPackImplementation modPackImpl = (ModularPackImplementation)modularPack;
            modPackImpl.addModularLicense(cllLicense, modularPack.getName());
        }
    }

    public static Collection<ModularPack> getInstalledUnit(IProfileRegistry profileRegistry, IProgressMonitor progressMonitor) {
        if (profileRegistry == null) {
            return Collections.emptySet();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)2).checkCanceled();
        HashSet<ModularPack> modularObjects = new HashSet<ModularPack>();
        IProfile profile = profileRegistry.getProfile("_SELF_");
        if (profile == null) {
            return Collections.emptySet();
        }
        IQueryResult queryResult = profile.query(QueryUtil.ALL_UNITS, (IProgressMonitor)subMonitor);
        subMonitor.worked(1);
        for (IInstallableUnit iInstallableUnit : queryResult) {
            if (iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACK_ID) == null) continue;
            try {
                ModularUtils.createModularPackByIInstableUnit(iInstallableUnit, (IQueryResult<IInstallableUnit>)queryResult, (IProgressMonitor)subMonitor.split(1), null).ifPresent(pack -> {
                    boolean bl = modularObjects.add((ModularPack)pack);
                });
            }
            catch (ModularException e) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                ModularInstallerMarker.createMarker((IResource)root, e.getMessage());
                ModularInstallerActivator.getInstance().logError(e.getMessage());
            }
        }
        subMonitor.worked(1);
        return modularObjects;
    }

    public static Optional<ModularPack> createModularPackByIInstableUnit(IInstallableUnit iInstallableUnit, IQueryResult<IInstallableUnit> query, IProgressMonitor monitor, URI uri) throws ModularException, OperationCanceledException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2).checkCanceled();
        if (iInstallableUnit != null) {
            if (!ModularUtils.isAcceptableOS(iInstallableUnit) || !ModularUtils.isAcceptableAtrchitecture(iInstallableUnit)) {
                return Optional.empty();
            }
            ModularPack modularPack = ModularFactory.FACTORY.createPack(iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACK_ID), iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACK_NAME), iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACK_DESCRIPTION), iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACK_VERSION), uri);
            if (modularPack instanceof ModularPackImplementation) {
                String supportProducts;
                String hardware;
                String isUninstall;
                String errorMessage;
                ModularPackImplementation packImplementation = (ModularPackImplementation)modularPack;
                String iconB64 = iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACK_ICON);
                if (iconB64 != null && !iconB64.isEmpty()) {
                    ModularFactory.FACTORY.setIconToModularPack((ModularPack)packImplementation, iconB64);
                }
                if ((errorMessage = iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACK_ERROR_DETAILS)) != null && !errorMessage.isEmpty()) {
                    ModularFactory.FACTORY.setErrorMessageToModularPack((ModularPack)packImplementation, errorMessage);
                }
                for (ILicense iLicense : iInstallableUnit.getLicenses()) {
                    packImplementation.addLicense(iLicense);
                }
                String cllLicense = iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACK_CLL_LICENSE);
                if (cllLicense != null && !cllLicense.isEmpty()) {
                    packImplementation.addModularLicense(cllLicense, modularPack.getName());
                }
                if ((isUninstall = iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACK_UNISTALLABLE)) != null && !isUninstall.isEmpty()) {
                    packImplementation.setUninstall(Boolean.parseBoolean(isUninstall));
                }
                if ((hardware = iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACK_HARDWARE)) != null && !hardware.isEmpty()) {
                    ModularUtils.setHardwareToModularPack(hardware, modularPack);
                }
                if ((supportProducts = iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACKSUPPORT_PRODUCTS)) != null && !supportProducts.isEmpty()) {
                    ModularUtils.setSupportProductsToModularPack(supportProducts, modularPack);
                }
                ModularUtils.setCategoryToModularPack(iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACK_CATEGORY), modularPack);
                IInstallableUnit groupUnit = ModularUtils.getSubUnit((IProgressMonitor)subMonitor, query, iInstallableUnit).orElseThrow(() -> new ModularException(ModularMessages.bind((String)ModularMessages.ModularUtils_IncorrectPackageStructure, (Object)modularPack.getName())));
                ModularUtils.readSubUnit(groupUnit, (IProgressMonitor)subMonitor, uri, query, modularPack);
                packImplementation.setIcon(iconB64);
            }
            return Optional.of(modularPack);
        }
        return Optional.empty();
    }

    private static void setCategoryToModularPack(String property, ModularPack modularPack) {
        if (property != null && !property.isEmpty()) {
            Arrays.asList(property.trim().split(ELEMENT_SPLITTER)).stream().filter(category -> !category.isEmpty()).forEach(category -> ModularFactory.FACTORY.addCategoryToPack(modularPack, category));
        } else {
            Set compatibleCategories = CompatibilitiesModularUtils.getCompatibleCategories((ModularPack)modularPack);
            if (!compatibleCategories.isEmpty()) {
                compatibleCategories.forEach(category -> ModularFactory.FACTORY.addCategoryToPack(modularPack, category));
            }
        }
    }

    private static void setHardwareToModularPack(String hardware, ModularPack modularPack) {
        String[] split = hardware.split(GROUP_SPLITTER);
        Pattern pattern = Pattern.compile(GROUP_PARAMETRS_PATTERN);
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            try {
                Matcher matcher = pattern.matcher(string);
                if (matcher.groupCount() != 2) {
                    return;
                }
                if (matcher.find()) {
                    String familyName = matcher.group(1);
                    String devicesString = matcher.group(2);
                    String[] devices = devicesString.substring(1, devicesString.length() - 1).split(ELEMENT_SPLITTER);
                    HWFamily family = new HWFamily(familyName.trim());
                    String[] stringArray2 = devices;
                    int n3 = devices.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String deviceName = stringArray2[n4];
                        HWDevice hWdevice = new HWDevice(deviceName.trim(), family);
                        family.addHWdevice(hWdevice);
                        ++n4;
                    }
                    ModularFactory.FACTORY.addHwFamilyToPack(modularPack, family);
                }
            }
            catch (IllegalStateException | IndexOutOfBoundsException e) {
                ModularInstallerActivator.getInstance().logError("Can't read hardware model for pack " + modularPack, e);
                return;
            }
            ++n2;
        }
    }

    private static void setSupportProductsToModularPack(String supportProducts, ModularPack modularPack) {
        String[] split = supportProducts.split(GROUP_SPLITTER);
        Pattern pattern = Pattern.compile(GROUP_PARAMETRS_PATTERN);
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            try {
                Matcher matcher = pattern.matcher(string);
                if (matcher.groupCount() != 2) {
                    return;
                }
                if (matcher.find()) {
                    String productName = matcher.group(1);
                    String productVersionsFromString = matcher.group(2);
                    String[] versionsArray = productVersionsFromString.substring(1, productVersionsFromString.length() - 1).split(ELEMENT_SPLITTER);
                    HashSet<String> productVersions = new HashSet<String>();
                    String[] stringArray2 = versionsArray;
                    int n3 = versionsArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String versionName = stringArray2[n4];
                        productVersions.add(versionName);
                        ++n4;
                    }
                    ModularFactory.FACTORY.addSupportProduct(modularPack, productName, productVersions);
                }
            }
            catch (IllegalStateException | IndexOutOfBoundsException e) {
                ModularInstallerActivator.getInstance().logError("Can't read support Products for pack " + modularPack, e);
                return;
            }
            ++n2;
        }
    }

    public static boolean isAcceptableOS(IInstallableUnit iInstallableUnit) {
        String os = iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACK_OS);
        if (os != null) {
            String paltformOs = Platform.getOS();
            if (paltformOs.equals(OS_WIN) && !os.equals(OS_WIN)) {
                return false;
            }
            if (paltformOs.equals(OS_LINUX) && !os.equals(OS_LINUX)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isAcceptableAtrchitecture(IInstallableUnit iInstallableUnit) {
        String architecture = iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACK_ARCHITECTURE);
        if (architecture != null) {
            String paltformOs = Platform.getOSArch();
            if (paltformOs.equals(OS_ARCHITECTURE_x86) && !architecture.equals(OS_ARCHITECTURE_x86)) {
                return false;
            }
            if (paltformOs.equals(OS_ARCHITECTURE_x86_64) && !architecture.equals(OS_ARCHITECTURE_x86_64)) {
                return false;
            }
        }
        return true;
    }

    public static void getInstallUnit(Set<ModularPack> modularObjects, Collection<IInstallableUnit> updateUnits, IQueryable<IInstallableUnit> query, IProgressMonitor progressMonitor) {
        if (query != null) {
            for (ModularObject modularObject : modularObjects) {
                IQueryResult repository = query.query(QueryUtil.createIUPropertyQuery((String)MODULAR_META_MODEL_READER_PACK_ID, (String)modularObject.getId()), progressMonitor);
                IInstallableUnit unit = (IInstallableUnit)repository.iterator().next();
                IInstallableUnit installableUnit = ModularUtils.getFeatureGroupInstalledUnitByRootInstalledUnit(query, unit, progressMonitor);
                if (installableUnit != null) {
                    updateUnits.add(installableUnit);
                    continue;
                }
                if (unit.getId() == null || !unit.getId().contains(PRODUCT_FEATURE)) continue;
                updateUnits.add(unit);
            }
        }
    }

    public static boolean shouldRemediate(IStatus status) {
        if (status == null) {
            return true;
        }
        return status.getSeverity() == 4;
    }

    public static Collection<IInstallableUnit> checkForUpdates(String profileId, IQuery<IInstallableUnit> query, IProfileRegistry iProfileRegistry, IProvisioningAgent agent, URI[] repos, IPlanner planner, IProgressMonitor progressMonitor) {
        IProfile profile = iProfileRegistry.getProfile(profileId);
        ArrayList<IInstallableUnit> iusWithUpdates = new ArrayList<IInstallableUnit>();
        if (profile == null) {
            return Collections.emptyList();
        }
        ProvisioningContext context = new ProvisioningContext(agent);
        context.setMetadataRepositories(repos);
        if (query == null) {
            query = QueryUtil.createIUAnyQuery();
        }
        for (IInstallableUnit iu : profile.query(query, null)) {
            IQueryResult replacements = planner.updatesFor(iu, context, progressMonitor);
            if (replacements.isEmpty()) continue;
            IInstallableUnit newUnit = iu;
            for (IInstallableUnit unit : replacements) {
                if (unit.getVersion().compareTo((Object)newUnit.getVersion()) <= 0) continue;
                newUnit = unit;
            }
            iusWithUpdates.add(newUnit);
        }
        return iusWithUpdates;
    }

    public static IQuery<IInstallableUnit> getInstalledUnitQuery(IProgressMonitor monitor, IProfileRegistry iProfileRegistry, String profileId) {
        IProfile profile = iProfileRegistry.getProfile(profileId);
        IQuery iQueryResult = QueryUtil.createIUAnyQuery();
        ArrayList<IInstallableUnit> units = new ArrayList<IInstallableUnit>();
        IQueryResult query = profile.query(QueryUtil.ALL_UNITS, null);
        for (IInstallableUnit iInstallableUnit : query) {
            if (iInstallableUnit.getProperty(MODULAR_META_MODEL_READER_PACK_ID) == null) continue;
            units.add(iInstallableUnit);
        }
        ArrayList<IInstallableUnit> swapUnit = new ArrayList<IInstallableUnit>();
        for (IInstallableUnit unit : units) {
            IInstallableUnit installableUnit = ModularUtils.getFeatureGroupInstalledUnitByRootInstalledUnit((IQueryable<IInstallableUnit>)query, unit, monitor);
            if (installableUnit == null) continue;
            swapUnit.add(installableUnit);
        }
        ArrayList<IQuery> iQueries = new ArrayList<IQuery>();
        for (IInstallableUnit iu : swapUnit) {
            iQueries.add(QueryUtil.createIUQuery((String)iu.getId()));
        }
        iQueryResult = QueryUtil.createCompoundQuery(iQueries, (boolean)false);
        return iQueryResult;
    }

    public static IInstallableUnit getFeatureRootInstalledUnitByGroupInstalledUnit(IQueryable<IInstallableUnit> queryable, IInstallableUnit unit, IProgressMonitor progressMonitor) {
        IInstallableUnit firstFoundUnit = null;
        if (unit != null && unit.getId().endsWith(INSTALLER_FEATURE_GROUP_SUFFIX)) {
            String id = String.valueOf(unit.getId().substring(0, unit.getId().indexOf(INSTALLER_FEATURE_GROUP_SUFFIX))) + INSTALLER_FEATUR_ROOT_SUFFIX;
            Version version = unit.getVersion();
            for (IInstallableUnit iInstallableUnit : queryable.query(QueryUtil.ALL_UNITS, progressMonitor)) {
                if (!id.equals(iInstallableUnit.getId())) continue;
                if (version != null && version.equals(iInstallableUnit.getVersion())) {
                    return iInstallableUnit;
                }
                if (firstFoundUnit != null) continue;
                firstFoundUnit = iInstallableUnit;
            }
        }
        return firstFoundUnit;
    }

    public static Collection<ModularPack> getUpdateModularPack(Collection<IInstallableUnit> updates, Collection<URI> knownRepositories, IProfileRegistry profileRegistry, IProvisioningAgent agent, IProgressMonitor monitor) throws OperationCanceledException {
        ArrayList<ModularPack> collection = new ArrayList<ModularPack>();
        SubMonitor convert = SubMonitor.convert((IProgressMonitor)monitor, (int)(updates.size() * 3));
        for (IInstallableUnit iInstallableUnit : updates) {
            for (URI uri : knownRepositories) {
                IArtifactRepositoryManager artifactRepositoryManager;
                IMetadataRepositoryManager metaRepositorymanager;
                IMetadataRepository repository = ModularUtils.loadMetadataRepository(uri, metaRepositorymanager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME), artifactRepositoryManager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME), (IProgressMonitor)convert.split(1));
                if (repository == null) continue;
                IQueryResult result = repository.query(QueryUtil.createIUQuery((String)iInstallableUnit.getId(), (Version)iInstallableUnit.getVersion()), (IProgressMonitor)convert.split(1));
                SubMonitor split = SubMonitor.convert((IProgressMonitor)convert.split(1), (int)3);
                for (IInstallableUnit unit : result) {
                    if (!unit.getId().equals(iInstallableUnit.getId()) || !unit.getVersion().equals(iInstallableUnit.getVersion())) continue;
                    IQueryResult iQueryResult = repository.query(QueryUtil.ALL_UNITS, (IProgressMonitor)split.split(1));
                    IInstallableUnit featureRootInstalledUnitByGroupInstalledUnit = ModularUtils.getFeatureRootInstalledUnitByGroupInstalledUnit((IQueryable<IInstallableUnit>)repository, unit, (IProgressMonitor)split.split(1));
                    try {
                        ModularUtils.createModularPackByIInstableUnit(featureRootInstalledUnitByGroupInstalledUnit, (IQueryResult<IInstallableUnit>)iQueryResult, (IProgressMonitor)split.split(1), uri).ifPresent(pack -> {
                            boolean bl = collection.add((ModularPack)pack);
                        });
                    }
                    catch (ModularException e) {
                        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                        ModularInstallerMarker.createMarker((IResource)root, e.getMessage());
                        ModularInstallerActivator.getInstance().logError(e.getMessage());
                    }
                }
            }
        }
        return collection;
    }

    public static void addLastPack(Set<ModularPack> modularObjects, ModularPack inputPack) {
        modularObjects.removeIf(pack -> ModularUtils.isOlderVersion(pack, inputPack));
        if (!modularObjects.contains(inputPack)) {
            modularObjects.add(inputPack);
        }
    }

    private static boolean isOlderVersion(ModularPack packFromCollection, ModularPack inputPack) {
        if (packFromCollection.equals(inputPack)) {
            if (ModularUtils.isP2versionGreater(packFromCollection, inputPack)) {
                return true;
            }
            if (inputPack.getVersion().compareToIgnoreCase(packFromCollection.getVersion()) > 0) {
                return true;
            }
        }
        return false;
    }

    private static boolean isP2versionGreater(ModularPack packFromCollection, ModularPack inputPack) {
        Optional<String> inputPackVersion = Optional.ofNullable(inputPack.getVersion());
        Optional<String> packFromCollections = Optional.ofNullable(packFromCollection.getVersion());
        Optional<String> inputP2featureVersion = Optional.ofNullable(inputPack.getP2featureVersion());
        Optional<String> fromCollectionsp2featureVersion = Optional.ofNullable(packFromCollection.getP2featureVersion());
        return inputPackVersion.orElse("").compareToIgnoreCase(packFromCollections.orElse("")) == 0 && inputP2featureVersion.orElse("").compareToIgnoreCase(fromCollectionsp2featureVersion.orElse("")) > 0;
    }

    public static void removeRepository(URI uri, IProvisioningAgent agent) {
        IMetadataRepositoryManager metaRepositorymanager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        IArtifactRepositoryManager artifactRepositoryManager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        metaRepositorymanager.removeRepository(uri);
        artifactRepositoryManager.removeRepository(uri);
    }
}

