/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.modular.internal.core.operations;

import com.nxp.s32ds.rcp.modular.ModularOperationStatus;
import com.nxp.s32ds.rcp.modular.ModularPack;
import com.nxp.s32ds.rcp.modular.internal.core.ModularInstallerActivator;
import com.nxp.s32ds.rcp.modular.internal.core.ModularMetaModelReader;
import com.nxp.s32ds.rcp.modular.internal.core.ModularOperationStatusImpl;
import com.nxp.s32ds.rcp.modular.internal.core.ModularUtils;
import com.nxp.s32ds.rcp.modular.internal.core.operations.ModularOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;

public class UpdateModularOperation
extends ModularOperation {
    public UpdateModularOperation(ProvisioningSession provisioningSession, ModularMetaModelReader metaModelReader) {
        super(provisioningSession, metaModelReader);
    }

    @Override
    ProfileChangeOperation getProfileChangeOperation(Collection<IInstallableUnit> elements, String profileId, ProvisioningSession session) {
        UpdateOperation op = new UpdateOperation(session, elements);
        op.setProfileId(profileId);
        op.setProvisioningContext(this.getProvisioningContext());
        return op;
    }

    @Override
    public ModularOperationStatus computeOperation(Set<ModularPack> modularObjects, IProgressMonitor progressMonitor) {
        ArrayList<IInstallableUnit> updateUnits = new ArrayList<IInstallableUnit>();
        IProfileRegistry profileRegistry = (IProfileRegistry)this.getProvisioningSession().getProvisioningAgent().getService(IProfileRegistry.SERVICE_NAME);
        IProfile profile = profileRegistry.getProfile(this.getProfileId());
        IQueryResult queryResult = profile.query(QueryUtil.ALL_UNITS, progressMonitor);
        ModularUtils.getInstallUnit(modularObjects, updateUnits, (IQueryable<IInstallableUnit>)queryResult, progressMonitor);
        this.validateIusToUpdate(updateUnits, profile);
        try {
            return this.computeModularOperation(updateUnits, modularObjects, progressMonitor);
        }
        catch (ProvisionException e) {
            ModularInstallerActivator.getInstance().logError("Can't compute update operation", e);
            MultiStatus status = new MultiStatus(ModularInstallerActivator.getContext().getBundle().getSymbolicName(), 4, e.getMessage(), (Throwable)e);
            return new ModularOperationStatusImpl((IStatus)status, null, null, modularObjects, this.getProvisioningSession());
        }
    }

    private void validateIusToUpdate(Collection<IInstallableUnit> iusWithUpdates, IProfile profile) {
        ArrayList<IInstallableUnit> list = new ArrayList<IInstallableUnit>(iusWithUpdates.size());
        for (IInstallableUnit iuWithUpdate : iusWithUpdates) {
            if (!this.validToUpdate(profile, iuWithUpdate)) continue;
            list.add(iuWithUpdate);
        }
        iusWithUpdates = list;
    }

    private boolean validToUpdate(IProfile profile, IInstallableUnit iu) {
        int lock = 0;
        boolean isRoot = false;
        try {
            String value = profile.getInstallableUnitProperty(iu, "org.eclipse.equinox.p2.type.lock");
            if (value != null) {
                lock = Integer.parseInt(value);
            }
            isRoot = (value = profile.getInstallableUnitProperty(iu, "org.eclipse.equinox.p2.type.root")) == null ? false : Boolean.parseBoolean(value);
        }
        catch (NumberFormatException e) {
            ModularInstallerActivator.getInstance().logError("Can't get profile instalation units state", e);
        }
        return isRoot && (lock & 2) == 0;
    }
}

