/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.internal.variables;

import com.nxp.s32ds.ext.rcp.internal.variables.EclipseVariableListener;
import com.nxp.s32ds.ext.rcp.variables.RcpVariable;
import com.nxp.s32ds.ext.rcp.variables.RcpVariableListener;
import com.nxp.s32ds.ext.rcp.variables.VariableListeners;
import com.nxp.s32ds.ext.rcp.variables.VariableResolver;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariableListener;
import org.eclipse.core.variables.VariablesPlugin;

public class EclipseVariableResolver
implements VariableResolver {
    public static final EclipseVariableResolver INSTANCE = new EclipseVariableResolver();
    private final EclipseVariableListener eclipseVariableListener = new EclipseVariableListener();
    private final IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();

    public EclipseVariableResolver() {
        this.variableManager.addValueVariableListener((IValueVariableListener)this.eclipseVariableListener);
    }

    @Override
    public String resolve(String variableName) throws CoreException {
        return this.performSubstitution("${" + variableName + "}");
    }

    @Override
    public String performSubstitution(String substitutableStr) throws CoreException {
        return this.variableManager.performStringSubstitution(substitutableStr);
    }

    @Override
    public void addListener(RcpVariable variable, RcpVariableListener listener) {
        this.eclipseVariableListener.addListener(variable, listener);
    }

    @Override
    public void removeListener(RcpVariable variable, RcpVariableListener listener) {
        this.eclipseVariableListener.removeListener(variable, listener);
    }

    @Override
    public void setVariablesListeners(VariableListeners listeners) {
        this.eclipseVariableListener.setVariablesListeners(listeners);
    }
}

