/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.migration.internal.ui.wizard;

import com.nxp.s32ds.cle.ide.migration.internal.ui.Messages;
import com.nxp.s32ds.cle.ide.migration.internal.ui.MigrationUiActivator;
import com.nxp.s32ds.cle.ide.migration.internal.ui.wizard.BackupComposite;
import com.nxp.s32ds.cle.ide.migration.internal.ui.wizard.MigrationWizardPageBase;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public abstract class MigrateWizardBase
extends Wizard
implements IWorkbenchWizard {
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    private final String windowTitle;

    public MigrateWizardBase(String windowTitle) {
        this.windowTitle = windowTitle;
        this.setDialogSettings(MigrationUiActivator.getInstance().getDialogSettingsSection(((Object)((Object)this)).getClass()));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(this.windowTitle);
        this.setNeedsProgressMonitor(true);
    }

    public void addPage(IWizardPage page) {
        if (!(page instanceof MigrationWizardPageBase)) {
            throw new IllegalArgumentException("Page must be instance of MigrationWizardPageBase");
        }
        super.addPage(page);
    }

    public List<MigrationWizardPageBase> getMigrationPages() {
        return Arrays.asList(this.getPages()).stream().map(p -> (MigrationWizardPageBase)((Object)p)).collect(Collectors.toList());
    }

    public boolean performFinish() {
        this.workbench.saveAllEditors(true);
        if (this.finish()) {
            for (MigrationWizardPageBase page : this.getMigrationPages()) {
                page.saveWidgetState();
            }
            return true;
        }
        return false;
    }

    private boolean finish() {
        IRunnableWithProgress backupOperation;
        BackupComposite backupComposite = this.getBackupComposite();
        if (backupComposite.createBackup()) {
            if (!backupComposite.continueIfExist()) {
                return false;
            }
            backupOperation = backupComposite.getBackupOperation();
        } else {
            backupOperation = null;
        }
        IRunnableWithProgress migrationOperation = this.getMigrationOperation();
        try {
            this.getContainer().run(true, true, m -> {
                if (backupOperation != null) {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)m, (int)2);
                    backupOperation.run((IProgressMonitor)subMonitor.split(1));
                    migrationOperation.run((IProgressMonitor)subMonitor.split(1));
                } else {
                    migrationOperation.run(m);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            MigrationUiActivator.getInstance().logError("The error occurred while performing the migration.", e);
            Throwable targetException = e.getTargetException();
            if (targetException instanceof CoreException) {
                IStatus orignStatus = ((CoreException)targetException).getStatus();
                IStatus status = orignStatus.getSeverity() != 4 ? MigrationUiActivator.getInstance().createError(orignStatus.getMessage(), orignStatus.getException()) : orignStatus;
                ErrorDialog.openError((Shell)this.getContainer().getShell(), null, null, (IStatus)status);
            } else {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), null, (String)targetException.getMessage(), (IStatus)MigrationUiActivator.getInstance().createError(Messages.MigrateWizardBase_internal_error, targetException));
            }
            return false;
        }
        return true;
    }

    protected abstract IRunnableWithProgress getMigrationOperation();

    protected abstract BackupComposite getBackupComposite();
}

