/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.migration.ui;

import com.nxp.s32ds.cle.ide.migration.internal.ui.Messages;
import com.nxp.s32ds.cle.ide.migration.internal.ui.MigrationUiActivator;
import com.nxp.s32ds.cle.ide.migration.internal.ui.wizard.MigrationDescriptorsUtil;
import com.nxp.s32ds.cle.runtime.migration.sequence.MigrationSequenceDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class MigrationsUI {
    public static boolean migrate(IProject project, MigrationSequenceDescriptor descriptor) {
        try {
            IRunnableWithProgress operation = MigrationDescriptorsUtil.getMigrationOperation(Collections.singletonList(project), descriptor);
            PlatformUI.getWorkbench().getProgressService().run(true, true, operation);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            MigrationUiActivator.getInstance().logError("The error occurred while performing the migration.", targetException);
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (targetException instanceof CoreException) {
                IStatus status = ((CoreException)targetException).getStatus();
                if (status.getSeverity() != 4) {
                    status = MigrationUiActivator.getInstance().createError(status.getMessage(), status.getException());
                }
                ErrorDialog.openError((Shell)shell, null, null, (IStatus)status);
            } else {
                ErrorDialog.openError((Shell)shell, null, (String)targetException.getMessage(), (IStatus)MigrationUiActivator.getInstance().createError(Messages.MigrateWizardBase_internal_error, targetException));
            }
            return false;
        }
        return true;
    }
}

