/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.resources;

import java.util.List;
import java.util.Map;
import org.eclipse.core.externaltools.internal.model.BuilderCoreUtils;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;

public class BuildCommands {
    public static final String COMMAND_ENABLED_ARGUMENT = "CommandEnabled";

    public static void toggleBuilder(List<IProject> projects, String builderId, TOGGLE_MODE mode, IProgressMonitor monitor) throws CoreException {
        String[] version = new String[]{""};
        for (IProject project : projects) {
            IProjectDescription desc = project.getDescription();
            ICommand[] commands = desc.getBuildSpec();
            boolean found = false;
            int i = 0;
            while (i < commands.length) {
                if (commands[i].getBuilderName().equals(builderId)) {
                    if (BuildCommands.commandDisabled(commands[i]) && mode != TOGGLE_MODE.OFF) {
                        Map args = commands[i].getArguments();
                        args.remove(COMMAND_ENABLED_ARGUMENT);
                        commands[i].setArguments(args);
                        desc.setBuildSpec(commands);
                        project.setDescription(desc, monitor);
                    } else if (mode != TOGGLE_MODE.ON) {
                        project.setDescription(BuildCommands.removeBuilder(desc, i), monitor);
                    }
                    found = true;
                    break;
                }
                ILaunchConfiguration config = BuilderCoreUtils.configFromBuildCommandArgs((IProject)project, (Map)commands[i].getArguments(), (String[])version);
                if (config != null && BuildCommands.findDisabledBuilder(builderId, config)) {
                    if (mode != TOGGLE_MODE.OFF) {
                        desc = BuildCommands.removeBuilder(desc, i);
                        desc = BuildCommands.addBuildder(desc, builderId);
                        project.setDescription(desc, monitor);
                        config.delete();
                    }
                    found = true;
                    break;
                }
                ++i;
            }
            if (found || mode == TOGGLE_MODE.OFF) continue;
            project.setDescription(BuildCommands.addBuildder(desc, builderId), monitor);
        }
    }

    private static boolean commandDisabled(ICommand iCommand) {
        Map args = iCommand.getArguments();
        if (args == null) {
            return false;
        }
        String argument = (String)args.get(COMMAND_ENABLED_ARGUMENT);
        if (argument == null) {
            return false;
        }
        return argument.trim().equalsIgnoreCase("false");
    }

    private static boolean findDisabledBuilder(String builderId, ILaunchConfiguration config) throws CoreException {
        boolean enabled = (Boolean)config.getAttributes().get("org.eclipse.ui.externaltools.ATTR_BUILDER_ENABLED");
        String builderFromConfig = (String)config.getAttributes().get("org.eclipse.ui.externaltools.ATTR_DISABLED_BUILDER");
        return !enabled && builderFromConfig.equals(builderId);
    }

    private static IProjectDescription addBuildder(IProjectDescription desc, String builderId) {
        ICommand[] commands = desc.getBuildSpec();
        ICommand command = desc.newCommand();
        command.setBuilderName(builderId);
        ICommand[] nc = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, nc, 1, commands.length);
        nc[0] = command;
        desc.setBuildSpec(nc);
        return desc;
    }

    private static IProjectDescription removeBuilder(IProjectDescription desc, int removeIndex) {
        ICommand[] commands = desc.getBuildSpec();
        ICommand[] nc = new ICommand[commands.length - 1];
        if (removeIndex != 0) {
            System.arraycopy(commands, 0, nc, 0, removeIndex);
        }
        if (removeIndex != commands.length - 1) {
            System.arraycopy(commands, removeIndex + 1, nc, removeIndex, commands.length - removeIndex - 1);
        }
        desc.setBuildSpec(nc);
        return desc;
    }

    public static enum TOGGLE_MODE {
        ON,
        OFF,
        SWITCH;

    }
}

