/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.resources.path;

import com.nxp.s32ds.ext.ide.internal.resources.ResourcesMessages;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ProjectDirectoryFileSystemValidator
implements IValidator<String> {
    public static final String ID = "project.directory.validator";

    public IStatus validate(String path) {
        if (path == null) {
            return new Status(4, "com.nxp.s32ds.ext.ide.resources", ResourcesMessages.ProjectPathValidator_invalid_path);
        }
        Path fullPath = Paths.get(path, new String[0]);
        if (Files.exists(fullPath, new LinkOption[0])) {
            String message = NLS.bind((String)ResourcesMessages.ProjectNameValidator_e_directory_already_exists, (Object)fullPath.toString());
            return new Status(4, "com.nxp.s32ds.ext.ide.resources", message);
        }
        if (!this.canCreate(fullPath)) {
            String message = NLS.bind((String)ResourcesMessages.ProjectNameValidator_e_cant_write, (Object)fullPath.toString());
            return new Status(4, "com.nxp.s32ds.ext.ide.resources", message);
        }
        return Status.OK_STATUS;
    }

    private boolean canCreate(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            return Files.isWritable(path);
        }
        if (path.toAbsolutePath().getParent() != null) {
            return this.canCreate(path.toAbsolutePath().getParent());
        }
        return false;
    }
}

