/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.checkers.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class CdtLaunchConfigurationAbstractChecker {
    private static final String FILE_SEARCH = "launch";

    public IStatus checkLaunchConfigurationFiles(IResource resource) {
        if (resource instanceof IProject) {
            IProject project = (IProject)resource;
            ICProjectDescription desc = CCorePlugin.getDefault().getProjectDescription(project, true);
            if (desc != null) {
                try {
                    List<IFile> listLaunchFiles = CdtLaunchConfigurationAbstractChecker.getLaunchConfigurationFiles((IContainer)resource);
                    return this.check(listLaunchFiles, project);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
            }
        }
        return Status.OK_STATUS;
    }

    private static List<IFile> getLaunchConfigurationFiles(IContainer container) throws CoreException {
        IResource[] members;
        ArrayList<IFile> files = new ArrayList<IFile>();
        IResource[] iResourceArray = members = container.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            String fileExtension;
            IResource member = iResourceArray[n2];
            if (member instanceof IContainer) {
                files.addAll(CdtLaunchConfigurationAbstractChecker.getLaunchConfigurationFiles((IContainer)member));
            } else if (member instanceof IFile && (fileExtension = (file = (IFile)member).getFileExtension()) != null && fileExtension.contains(FILE_SEARCH)) {
                files.add(file);
            }
            ++n2;
        }
        return files;
    }

    protected abstract IStatus check(List<IFile> var1, IProject var2);
}

