/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.imports;

import com.freescale.s32ds.cross.core.model.HWModel;
import com.freescale.s32ds.cross.core.model.Hardware;
import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.CoreData;
import com.freescale.s32ds.cross.core.model.data.CoreKindData;
import com.freescale.s32ds.cross.core.model.data.FamilyData;
import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import com.freescale.s32ds.cross.wizard.imports.IImportConverter;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class ImportConvertorHolder {
    public final String label;
    public final Image image;
    public final Object clazz;
    public final boolean isReady;
    public final String descr;
    private static final Map<String, CoreData> ALLCORES = new HashMap<String, CoreData>();
    public final Map<String, CoreData> cores;

    static {
        Collection contexts = Hardware.instance().getModels();
        for (HWModel context : contexts) {
            for (FamilyData family : context.getFamilies()) {
                for (ConfigurationData cfd : context.searchDatas("core", "family", (Object)family.getId())) {
                    if (!(cfd instanceof CoreData)) {
                        S32DSWizardPlugin.logWarning("Strange Core Data type: " + cfd);
                        continue;
                    }
                    CoreData c = (CoreData)cfd;
                    ImportConvertorHolder.put(c.getCoreNatureId(), c);
                    ImportConvertorHolder.put(c.getId(), c);
                    ImportConvertorHolder.put(c.getName(), c);
                    ImportConvertorHolder.put(c.getCoreKindId(), c);
                    CoreKindData coreKind = c.getCoreKind();
                    ImportConvertorHolder.put(coreKind != null ? coreKind.getName() : null, c);
                    ImportConvertorHolder.put(c.getCoreType().getId(), c);
                    ImportConvertorHolder.put(c.getCoreType().getName(), c);
                }
            }
        }
    }

    private static void put(String s, CoreData c) {
        if (s != null && !s.trim().isEmpty() && !ALLCORES.containsKey(s = s.toLowerCase())) {
            ALLCORES.put(s, c);
        }
    }

    public ImportConvertorHolder(IConfigurationElement ce) {
        boolean state = false;
        String lb = null;
        String de = null;
        Object ic = null;
        Image img = null;
        LinkedHashMap<String, CoreData> tmpCore = new LinkedHashMap<String, CoreData>();
        if ("converter".equals(ce.getName())) {
            try {
                IConfigurationElement[] els;
                img = this.createImage(ce);
                lb = ce.getAttribute("label");
                String x = ce.getAttribute("class");
                if (lb != null && x != null && lb.trim().length() > 0) {
                    ic = ce.createExecutableExtension("class");
                    state = true;
                }
                de = (els = ce.getChildren("description")) != null && els.length > 0 ? els[0].getValue() : "";
                IConfigurationElement[] iConfigurationElementArray = ce.getChildren("aliasCore");
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement el = iConfigurationElementArray[n2];
                    String alias = el.getAttribute("alias");
                    String id = el.getAttribute("id");
                    if (id != null && !id.trim().isEmpty()) {
                        CoreData c;
                        if (alias == null || alias.isEmpty()) {
                            alias = id;
                        }
                        if ((c = ALLCORES.get((id = id.toLowerCase()).toLowerCase())) != null) {
                            if (!tmpCore.containsKey(id)) {
                                tmpCore.put(id, c);
                            }
                            if (!tmpCore.containsKey(alias = alias.toLowerCase())) {
                                tmpCore.put(alias, c);
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                S32DSWizardPlugin.log(e);
            }
        }
        this.cores = Collections.unmodifiableMap(tmpCore);
        this.label = lb;
        this.image = img;
        this.clazz = ic;
        this.descr = de;
        this.isReady = state;
    }

    private Image createImage(IConfigurationElement ce) {
        String s = ce.getAttribute("image");
        if (s != null) {
            try {
                URL url = FileLocator.find((URL)new URL("platform:/plugin/" + ce.getNamespaceIdentifier() + "/" + s));
                if (url != null) {
                    ImageData id = ImageDescriptor.createFromURL((URL)url).createImage().getImageData();
                    return ImageDescriptor.createFromImageData((ImageData)id.scaledTo(16, 16)).createImage();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public boolean isToolchainSupported(String id) {
        return ((IImportConverter)this.clazz).supportsToolChain(id);
    }
}

