/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.page2;

import com.freescale.s32ds.cross.core.model.Parameter;
import com.freescale.s32ds.cross.core.model.ValueType;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.DataSet;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import com.freescale.s32ds.cross.wizard.page2.MemorySpinnerAdapter;
import com.freescale.s32ds.cross.wizard.page2.Page2AbstractManager;
import com.freescale.s32ds.cross.wizard.page2.WizardElfDialogCellEditor;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilteringParameters;
import com.nxp.s32ds.cle.cdt.sdk.ui.property.WizardSdksDialogCellEditor;
import com.nxp.s32ds.cle.cdt.wizard.core.WizardProjectContextSdkFilter;
import com.nxp.s32ds.cle.cdt.wizard.core.WizardProjectContextUtil;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class Page2Utils {
    private static final int KILO = 1024;
    private static final int INCREMENT = 32;
    private static final int PAGE_INCR = 128;
    private static final String OX = "0x";
    private static final String EMPTY_STRING = "";

    public static String getCommonLabelValue(Parameter parameter, CProjectContext projectContext) {
        Object value = projectContext.getValue(parameter.getTag());
        if (parameter.getValueType() == ValueType.LONG) {
            return Page2Utils.getLongDisplayValue(value);
        }
        if (parameter.getValueType() == ValueType.BOOLEAN) {
            return EMPTY_STRING;
        }
        return value != null ? value.toString() : "null";
    }

    public static String getLongDisplayValue(Object value) {
        String str = value instanceof Long ? Long.toHexString((Long)value) : value.toString();
        return Page2Utils.formatLongTextValue(str);
    }

    public static String formatLongTextValue(String v) {
        if (!v.isEmpty() && !v.startsWith(OX)) {
            v = OX + v;
        }
        return v;
    }

    public static Button createChecbox(CProjectContext projectContext, String text, boolean checked, SelectionListener selectionListener, Composite parent) {
        Button b = new Button(parent, 32);
        b.setText(text);
        b.setSelection(checked);
        b.addSelectionListener(selectionListener);
        return b;
    }

    public static Label createLabel(String text, Composite parent) {
        return Page2Utils.createLabel(text, text, parent);
    }

    public static Label createLabel(String text, String tooltip, Composite parent) {
        Label label = new Label(parent, 64);
        label.setToolTipText(tooltip);
        label.setText(text);
        return label;
    }

    public static Text createText(String text, Composite parent) {
        Text txt = new Text(parent, 0);
        txt.setText(text);
        txt.setEditable(false);
        return txt;
    }

    public static Control createSDKDialog(CProjectContext projectContext, WizardSdksDialogCellEditor.WizardSdksDialogEditorListener listener, Composite parent) {
        ProcessorData processorData;
        List sdksList = Collections.emptyList();
        String sdkTag = EMPTY_STRING;
        if (projectContext != null && (processorData = projectContext.getProcessor()) != null) {
            sdksList = projectContext.getSdkList();
            sdkTag = processorData.getSdkTag();
        }
        return WizardSdksDialogCellEditor.getControl((Composite)parent, sdksList, (String)sdkTag, (SdkFilteringParameters)Page2Utils.createSDKFilterInfo(projectContext), (WizardSdksDialogCellEditor.WizardSdksDialogEditorListener)listener);
    }

    public static Control createELFDialog(CProjectContext projectContext, WizardElfDialogCellEditor.WizardElfDialogEditorListener listener, Composite parent) {
        String elf = EMPTY_STRING;
        if (projectContext != null) {
            elf = projectContext.getElf();
        }
        return WizardElfDialogCellEditor.getControl(parent, elf, listener);
    }

    public static SdkFilteringParameters createSDKFilterInfo(CProjectContext projectContext) {
        return new WizardProjectContextSdkFilter(projectContext);
    }

    public static Control createComboIfDataPresent(CProjectContext projectContext, Parameter parameter, SelectionListener listener, Composite parent) {
        DataSet dataSet = projectContext.getDataSet(parameter.getTag());
        if (dataSet == null || dataSet.getValues().isEmpty()) {
            dataSet = WizardProjectContextUtil.getDebugerDataSetByContextParameter(projectContext, parameter);
        }
        if (dataSet == null) {
            return Page2Utils.createLabel(EMPTY_STRING, parameter.getDescription(), parent);
        }
        Combo combo = new Combo(parent, 12);
        Page2Utils.setComboData(combo, dataSet);
        Point p = combo.computeSize(131072, 131072);
        combo.setSize(p);
        combo.addSelectionListener(listener);
        combo.notifyListeners(13, null);
        return combo;
    }

    public static Spinner createSpinner(CProjectContext projectContext, Parameter parameter, Page2AbstractManager page2Manager, Composite parent) {
        Spinner spinner = new Spinner(parent, 8);
        spinner.setMinimum(0);
        spinner.setMaximum(Integer.MAX_VALUE);
        spinner.setIncrement(32);
        spinner.setPageIncrement(128);
        Page2Utils.setSpinnerData(spinner, projectContext.getLongValue(parameter.getTag()));
        MemorySpinnerAdapter spinnerAdapter = new MemorySpinnerAdapter(page2Manager, spinner, projectContext, parameter.getTag());
        spinner.addSelectionListener((SelectionListener)spinnerAdapter);
        spinner.addKeyListener((KeyListener)spinnerAdapter);
        return spinner;
    }

    public static void setComboData(CCombo combo, DataSet dataSet) {
        if (dataSet == null || combo == null || combo.isDisposed()) {
            return;
        }
        combo.removeAll();
        List configurationDescriptors = dataSet.getElements();
        if (configurationDescriptors.isEmpty()) {
            if ("debugger".equals(dataSet.getElementTag())) {
                combo.setToolTipText("Not applicable dubugger for current toolchain");
            }
            combo.setItems(new String[]{"N/A"});
            combo.setTouchEnabled(false);
            combo.setEnabled(false);
        }
        for (ConfigurationData data : configurationDescriptors) {
            combo.add(data.getName());
        }
        if (combo.getItemCount() > 0) {
            combo.select(0);
        }
    }

    public static void setComboData(Combo combo, DataSet dataSet) {
        if (dataSet == null || combo == null || combo.isDisposed()) {
            return;
        }
        combo.removeAll();
        List configurationDescriptors = dataSet.getElements();
        if (configurationDescriptors.isEmpty()) {
            if ("debugger".equals(dataSet.getElementTag())) {
                combo.setToolTipText("Not applicable dubugger for current toolchain");
            }
            combo.setItems(new String[]{"N/A"});
            combo.setTouchEnabled(false);
            combo.setEnabled(false);
        }
        for (ConfigurationData data : configurationDescriptors) {
            combo.add(data.getName());
        }
        if (combo.getItemCount() > 0) {
            combo.select(0);
        }
    }

    public static void setComboData(CCombo combo, DataSet dataSet, Object value) {
        Page2Utils.setComboData(combo, dataSet);
        if (dataSet == null || combo == null || combo.isDisposed()) {
            return;
        }
        List configurationDescriptors = dataSet.getElements();
        int index = 0;
        if (value instanceof String) {
            String stringDataValue = (String)value;
            for (ConfigurationData data : configurationDescriptors) {
                if (!data.getId().equals(stringDataValue)) continue;
                index = configurationDescriptors.indexOf(data);
                break;
            }
            if (index > -1) {
                combo.select(index);
            }
        } else {
            S32DSWizardPlugin.logWarning("The value format does not match with String type.");
        }
    }

    public static void setComboData(Combo combo, DataSet dataSet, Object value) {
        Page2Utils.setComboData(combo, dataSet);
        if (dataSet == null || combo == null || combo.isDisposed()) {
            return;
        }
        List configurationDescriptors = dataSet.getElements();
        int index = 0;
        if (value instanceof String) {
            String stringDataValue = (String)value;
            for (ConfigurationData data : configurationDescriptors) {
                if (!data.getId().equals(stringDataValue)) continue;
                index = configurationDescriptors.indexOf(data);
                break;
            }
            if (index > -1) {
                combo.select(index);
            }
        } else {
            S32DSWizardPlugin.logWarning("The value format does not match with String type.");
        }
    }

    public static void setSpinnerData(Spinner spinner, long lv) {
        int v = (int)lv / 1024;
        spinner.setSelection(v);
    }
}

