/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.template;

import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ConditionalProcessGroup;
import org.eclipse.cdt.core.templateengine.process.ProcessHelper;
import org.w3c.dom.Element;

public class Condition
extends ConditionalProcessGroup {
    private static final String[] OPS = new String[]{"**", "||", "==", "!="};
    private static final byte OP_AND = 0;
    private static final byte OP_OR = 1;
    private static final byte OP_EQ = 2;
    private static final byte OP_NE = 3;
    private static final byte OP_TRUE = -1;
    private static final byte OP_FALSE = -2;
    private static int condition_count = 0;
    private final String condition;
    private Set<String> macros;
    private final TemplateCore temp;
    private final ArrayList<String> tokens;

    public Condition(TemplateCore template, Element[] processElements) {
        super(template, processElements);
        this.condition = null;
        this.temp = template;
        this.tokens = null;
    }

    public Condition(TemplateCore template, Element conditionElement) {
        super(template, conditionElement, ++condition_count);
        this.temp = template;
        this.condition = conditionElement.getAttribute("condition");
        this.tokens = this.split(this.condition);
        if (this.tokens == null || (this.tokens.size() + 1) % 4 != 0) {
            throw new IllegalArgumentException("Bad IF condition: " + this.condition);
        }
        int i = 0;
        while (i < this.tokens.size()) {
            if (i % 2 == 1) {
                String c = this.tokens.get(i);
                if (i % 4 == 3) {
                    if (!OPS[0].equalsIgnoreCase(c) && !OPS[1].equalsIgnoreCase(c)) {
                        throw new IllegalArgumentException("Bad AND/OR condition: " + this.condition + " : " + c);
                    }
                } else if (!OPS[2].equalsIgnoreCase(c) && !OPS[3].equalsIgnoreCase(c)) {
                    throw new IllegalArgumentException("Bad EQUALS condition: " + this.condition + " : " + c);
                }
            }
            ++i;
        }
    }

    protected ArrayList<String> split(String s) {
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        ArrayList<String> cs = new ArrayList<String>();
        int pos = 0;
        while (pos < s.length()) {
            int n = Integer.MAX_VALUE;
            int i = 0;
            while (i < OPS.length) {
                int m = s.indexOf(OPS[i], pos);
                if (m >= 0 && m < n) {
                    n = m;
                }
                ++i;
            }
            if (n == Integer.MAX_VALUE) {
                cs.add(s.substring(pos));
                break;
            }
            cs.add(s.substring(pos, n).trim());
            pos = n + 2;
            cs.add(s.substring(n, pos).trim());
        }
        if (this.macros == null) {
            this.macros = new HashSet<String>();
        }
        for (String x : cs) {
            this.macros.addAll(ProcessHelper.getReplaceKeys((String)x));
        }
        return cs;
    }

    public boolean isConditionValueTrue() {
        if (this.condition == null || this.macros == null) {
            return true;
        }
        Map valueStore = this.temp.getValueStore();
        for (String value : this.macros) {
            if (valueStore.get(value) != null) continue;
            return false;
        }
        byte[] values = new byte[(this.tokens.size() - 1) / 2];
        int cnt = 0;
        int i = 0;
        while (i < this.tokens.size()) {
            String v1 = ProcessHelper.getValueAfterExpandingMacros((String)this.tokens.get(i), this.macros, (Map)valueStore);
            String v2 = ProcessHelper.getValueAfterExpandingMacros((String)this.tokens.get(i + 2), this.macros, (Map)valueStore);
            if (this.tokens.get(i + 1).equals(OPS[2])) {
                values[cnt++] = v1.equals(v2) ? -1 : -2;
            } else if (this.tokens.get(i + 1).equals(OPS[3])) {
                values[cnt++] = v1.equals(v2) ? -2 : -1;
            } else {
                S32DSWizardPlugin.logWarning("Bad condition sign (expected == or !=) : " + this.tokens.get(i + 1));
                return false;
            }
            if (this.tokens.size() > i + 3) {
                values[cnt++] = this.tokens.get(i + 3).equals(OPS[1]) ? (byte)1 : 0;
            }
            i += 4;
        }
        values = Condition.scan(values, 0);
        return (values = Condition.scan(values, 1))[0] == -1;
    }

    private static byte[] scan(byte[] values, int mode) {
        boolean found = true;
        block0: while (values != null && values.length > 2 && found) {
            byte[] out = new byte[values.length - 2];
            int cnt = 0;
            found = false;
            int i = 0;
            while (i < values.length - 2) {
                if (values[i + 1] == mode) {
                    if (mode == 0) {
                        out[cnt++] = values[i] == -1 && values[i + 2] == -1 ? -1 : -2;
                    } else {
                        out[cnt++] = values[i] == -1 || values[i + 2] == -1 ? -1 : -2;
                    }
                    i += 3;
                    while (cnt < out.length) {
                        out[cnt++] = values[i++];
                    }
                    values = out;
                    found = true;
                    continue block0;
                }
                out[cnt++] = values[i];
                if (out.length > cnt) {
                    out[cnt++] = values[i + 1];
                }
                i += 2;
            }
        }
        return values;
    }

    public String toString() {
        return "[CONDITION : " + this.condition + "]";
    }
}

