/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.template;

import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;

public class SetConfigurationName
extends ProcessRunner {
    private static final String PROJECT_NAME = "projectName";
    private static final String CONFIG_NAME = "name";
    private static final String CONFIG_ID = "id";

    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        if (args == null || args.length < 2) {
            S32DSWizardPlugin.logWarning("Data for SetConfigurationName should contain more input parameters !");
            return;
        }
        String id = null;
        String nm = null;
        String pr = null;
        ProcessArgument[] processArgumentArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessArgument pa = processArgumentArray[n2];
            pa.resolve();
            String name = pa.getName();
            if (pa.getParameterType() == 1) {
                if (CONFIG_ID.equals(name)) {
                    id = pa.getSimpleValue();
                } else if (CONFIG_NAME.equals(name)) {
                    nm = pa.getSimpleValue();
                } else if (PROJECT_NAME.equals(name)) {
                    pr = pa.getSimpleValue();
                }
            }
            ++n2;
        }
        if (id == null || nm == null || pr == null) {
            S32DSWizardPlugin.logWarning("SetConfigurationName process has incorrect arguments");
            return;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(pr);
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info == null) {
            throw new ProcessFailureException("This project is not Managed CDT project");
        }
        IConfiguration tmp_conf = null;
        IConfiguration[] iConfigurationArray = info.getManagedProject().getConfigurations();
        int n3 = iConfigurationArray.length;
        int n4 = 0;
        while (n4 < n3) {
            IConfiguration c = iConfigurationArray[n4];
            if (c.getName().equalsIgnoreCase(id)) {
                tmp_conf = c;
                break;
            }
            ++n4;
        }
        if (tmp_conf == null) {
            S32DSWizardPlugin.logWarning("This project has no configuration: " + id);
            return;
        }
        IConfiguration conf = tmp_conf;
        conf.setName(nm);
    }
}

