/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.volkano.internal.ui;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum VolkanoTypes {
    ADKP_VALUE("ADKP", "ADKP", 16, false),
    ADKP_WRAPPED_FILE("Wrapped ADKP from file", "ADKP", 256, true),
    KUID_VALUE("Wrapped KUID", "kUID", 256, false),
    KUID_FILE("Wrapped KUID from file", "kUID", 256, true),
    SOC_UID("UID", 8, false),
    COMMON_FILE_INFO("File content", 256, true);

    private String name;
    private String serverSideName;
    private int byteLength;
    private boolean isFile;
    private boolean isRegisterType;

    private VolkanoTypes(String fieldName, String serverSideName, int length, boolean isFile) {
        this(fieldName, length, isFile);
        this.serverSideName = serverSideName;
        this.isRegisterType = true;
    }

    private VolkanoTypes(String fieldName, int length, boolean isFile) {
        this.name = fieldName;
        this.byteLength = length;
        this.isFile = isFile;
    }

    public String getName() {
        return this.name;
    }

    public String getServerSideName() {
        return this.serverSideName;
    }

    public int getByteLength() {
        return this.byteLength;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public boolean isRegisterType() {
        return this.isRegisterType;
    }

    public static List<String> getRegistrationTypes() {
        return Stream.of(VolkanoTypes.values()).filter(VolkanoTypes::isRegisterType).map(VolkanoTypes::getName).collect(Collectors.toList());
    }

    public static VolkanoTypes findRegisterTypeByName(String name) {
        return Stream.of(VolkanoTypes.values()).filter(type -> type.isRegisterType && type.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }
}

