/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.modular.installer.core.utils;

import com.nxp.s32ds.rcp.modular.ModularInstallerService;
import com.nxp.s32ds.rcp.modular.ModularOperationStatus;
import com.nxp.s32ds.rcp.modular.ModularPack;
import com.nxp.s32ds.rcp.modular.installer.core.MIPackAgregator;
import com.nxp.s32ds.rcp.modular.installer.core.Messages;
import com.nxp.s32ds.rcp.modular.installer.core.internal.MIPackAgregatorRegistry;
import com.nxp.s32ds.rcp.modular.internal.core.ModularInstallerActivator;
import com.nxp.s32ds.rcp.modular.internal.core.exception.ModularException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.UninstallOperation;
import org.eclipse.equinox.p2.operations.UpdateOperation;

public final class ModularInstallerUtils {
    public static final String PLUGIN_ID = "com.nxp.s32ds.rcp.modular.installer.core";
    public static final String FEATURE_SUFFIX = ".feature.group";

    private ModularInstallerUtils() {
    }

    public static boolean configureUnistallButton(Collection<ModularPack> installCollect, Collection<ModularPack> selectedModularObjects) {
        if (installCollect == null || selectedModularObjects == null) {
            return false;
        }
        int countInstalledObject = 0;
        for (ModularPack modularPack : installCollect) {
            if (!selectedModularObjects.contains(modularPack)) continue;
            if (!modularPack.isUninstallable()) {
                return false;
            }
            ++countInstalledObject;
        }
        return countInstalledObject != 0 && countInstalledObject == selectedModularObjects.size();
    }

    public static IStatus installJob(ModularOperationStatus resolutionStatus, final MultiStatus installationStatus, String toShow, IProgressMonitor monitor) {
        try {
            try {
                if (resolutionStatus.getStatus() != null) {
                    monitor.beginTask(toShow, -1);
                    ProfileChangeOperation operation = resolutionStatus.getExecutableOperation();
                    ProvisioningJob provisioningJob = operation.getProvisioningJob(null);
                    if (provisioningJob != null) {
                        provisioningJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                            public void done(IJobChangeEvent event) {
                                installationStatus.add(event.getResult());
                            }
                        });
                        installationStatus.add(provisioningJob.runModal(monitor));
                        provisioningJob.join();
                    }
                }
            }
            catch (InterruptedException e) {
                IStatus iStatus = ModularInstallerActivator.getInstance().createError(Messages.ModularInstallerUtils_InstallInterrupted, (Throwable)e);
                monitor.done();
                return iStatus;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public static IStatus unistallJob(Set<ModularPack> unit, ModularInstallerService service, final MultiStatus status, IProgressMonitor monitor) {
        block6: {
            ModularOperationStatus resolutionStatusForUninstall = service.getResolutionStatusForUninstall(unit, monitor);
            if (resolutionStatusForUninstall.getStatus().isOK()) {
                ProfileChangeOperation operation = resolutionStatusForUninstall.getExecutableOperation();
                try {
                    try {
                        ProvisioningJob provisioningJob = operation.getProvisioningJob(null);
                        resolutionStatusForUninstall.getProvisioningSession().rememberJob((Job)provisioningJob);
                        provisioningJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                            public void done(IJobChangeEvent event) {
                                status.add(event.getResult());
                            }
                        });
                        provisioningJob.schedule();
                        provisioningJob.join();
                        break block6;
                    }
                    catch (InterruptedException e) {
                        IStatus iStatus = ModularInstallerActivator.getInstance().createError(Messages.ModularInstallerUtils_UninstallInterrupted, (Throwable)e);
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
            }
            ModularInstallerUtils.extractNestedStatus(status, resolutionStatusForUninstall);
            return status;
        }
        return Status.OK_STATUS;
    }

    private static void extractNestedStatus(MultiStatus status, ModularOperationStatus resolutionStatusForUninstall) {
        IStatus[] iStatusArray = resolutionStatusForUninstall.getStatus().getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus iStatus = iStatusArray[n2];
            status.merge(iStatus);
            ++n2;
        }
        status.merge((IStatus)resolutionStatusForUninstall.getStatus());
    }

    public static String getDialogTitleByModularOperationStatus(ModularOperationStatus resolutionStatus) {
        String dialogStr = Messages.Proccess_step_proceeding;
        if (resolutionStatus.getStatus() != null) {
            ProfileChangeOperation operation = resolutionStatus.getExecutableOperation();
            if (operation instanceof InstallOperation) {
                dialogStr = Messages.Proccess_step_installing;
            } else if (operation instanceof UninstallOperation) {
                dialogStr = Messages.Proccess_step_uninstalling;
            } else if (operation instanceof UpdateOperation) {
                dialogStr = Messages.Proccess_step_updating;
            }
        }
        return dialogStr;
    }

    public static final Collection<String> getNotAvailablePacksName(Set<ModularPack> units, Collection<MIPackAgregator> availableFromRepositoryModularPack) {
        ArrayList<String> notAvailable = new ArrayList<String>();
        Collection availableNames = availableFromRepositoryModularPack.stream().map(pack -> pack.getAvailablePackFromRepository().getName()).collect(Collectors.toList());
        Collection toReinstallNames = units.stream().map(pack -> pack.getName()).collect(Collectors.toList());
        for (String string : toReinstallNames) {
            if (availableNames.contains(string)) continue;
            notAvailable.add(string);
        }
        return notAvailable;
    }

    public static Set<ModularPack> getUninstalledPacks(Collection<MIPackAgregator> modelObject, Collection<ModularPack> selectedModularObjects) {
        HashSet<ModularPack> units = new HashSet<ModularPack>();
        if (selectedModularObjects == null) {
            return units;
        }
        List collect = modelObject.stream().map(mObject -> mObject.getInstalledPack()).collect(Collectors.toList());
        for (ModularPack modularPack : collect) {
            if (!selectedModularObjects.contains(modularPack) || !modularPack.isUninstallable()) continue;
            units.add(modularPack);
        }
        return units;
    }

    public static boolean configureReistallButton(Collection<ModularPack> installCollect, Collection<ModularPack> selectedModularObjects) {
        if (selectedModularObjects == null || selectedModularObjects.size() > 1) {
            return false;
        }
        return ModularInstallerUtils.configureUnistallButton(installCollect, selectedModularObjects);
    }

    public static void resolveDependencies(MIPackAgregatorRegistry registry, MIPackAgregator processingItem, Set<MIPackAgregator> resolvedSet, Stack<MIPackAgregator> processingStack) throws ModularException {
        processingStack.push(processingItem);
        HashSet<String> thirdPartyIds = new HashSet<String>(processingItem.getPack().getThirdPartyIds());
        if (!thirdPartyIds.isEmpty()) {
            thirdPartyIds.removeIf(id -> ModularInstallerUtils.addAlreadyInstalledPackToContaner(id, registry, resolvedSet).isPresent());
            for (String thirdPartyId : thirdPartyIds) {
                MIPackAgregator agregator;
                Optional<MIPackAgregator> findFirst = ModularInstallerUtils.avaliableFromNet(thirdPartyId, registry);
                if (!findFirst.isPresent() || resolvedSet.contains(agregator = findFirst.get())) continue;
                if (!processingStack.contains(agregator)) {
                    ModularInstallerUtils.resolveDependencies(registry, findFirst.get(), resolvedSet, processingStack);
                    continue;
                }
                throw new ModularException(String.valueOf(processingStack.stream().map(pack -> pack.getPack().toString()).reduce(Messages.ModularInstallerUtils_CycleDependencies, (previus, curent) -> String.valueOf(previus) + curent + "->")) + agregator.getPack().toString());
            }
        }
        resolvedSet.add(processingStack.pop());
    }

    private static Optional<MIPackAgregator> avaliableFromNet(String thirdPartyId, MIPackAgregatorRegistry registry) {
        return registry.getPackAgregatorList().stream().filter(pack -> pack.getAvailablePack() != null || pack.hasUpdatePack()).filter(p -> p.getPack().getP2featureId() != null).filter(pack -> thirdPartyId.equals(pack.getPack().getP2featureId()) || thirdPartyId.equals(pack.getPack().getP2featureId().replace(FEATURE_SUFFIX, ""))).findFirst();
    }

    private static Optional<MIPackAgregator> addAlreadyInstalledPackToContaner(String id, MIPackAgregatorRegistry registry, Set<MIPackAgregator> resolvedSet) {
        Optional<MIPackAgregator> findFirst = registry.getPackAgregatorList().stream().filter(pack -> pack.getInstalledPack() != null && pack.getInstalledPack().getId().equals(id) || pack.getUpdatePack() != null && pack.getUpdatePack().getId().equals(id)).findFirst();
        findFirst.ifPresent(resolvedSet::add);
        return findFirst;
    }
}

