/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.integration.diags;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.integration.diags.CustomLineChart;
import com.nxp.swtools.mem.validation.integration.diags.Messages;
import com.nxp.swtools.mem.validation.integration.diags.VDiagsOverlayFigure;
import com.nxp.swtools.mem.validation.model.VModel;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.model.presenter.IDisplayFigure;
import com.nxp.swtools.mem.validation.model.presenter.VDiagsPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VScenarioPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.embed.swt.FXCanvas;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.util.Callback;
import javafx.util.Duration;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DiagsOverlapView {
    protected static final Logger LOGGER = LogManager.getLogger(DiagsOverlapView.class);
    @Nullable
    private ScrolledComposite graphScrolledPanel;
    @Nullable
    private FXCanvas graphCanvas;
    @Nullable
    private VStagePresentation selectedStage;
    @Nullable
    private CustomLineChart lineAreaChart;
    @Nullable
    private HBox hBoxCheckBoxes;
    @Nullable
    private TableView<EyeResult> eyeResult;
    @Nullable
    private VBox vBox;
    @Nullable
    private ScrollPane scrollPane;
    private boolean chartGenerated = false;

    public @Nullable FXCanvas createChart(CTabFolder scenTabFolder, @Nullable CTabItem diagsOverlapTab) {
        int numGraphs = this.readNumGraphs();
        ScrolledComposite graphScrolledPanelLoc = this.graphScrolledPanel = new ScrolledComposite((Composite)scenTabFolder, 0);
        graphScrolledPanelLoc.setExpandHorizontal(true);
        graphScrolledPanelLoc.setExpandVertical(true);
        FXCanvas graphCanvasLoc = this.graphCanvas = new FXCanvas((Composite)this.graphScrolledPanel, 0);
        graphCanvasLoc.setData((Object)Messages.DiagsTabName);
        if (numGraphs == 0) {
            this.createStatusLabel(graphCanvasLoc);
            this.lineAreaChart = null;
            this.hBoxCheckBoxes = null;
            this.eyeResult = null;
            this.vBox = null;
            this.scrollPane = null;
        } else if (this.selectedStage != null) {
            URL chartsSkin;
            String detailsTableOption;
            NumberAxis xAxis = new NumberAxis();
            NumberAxis yAxis = new NumberAxis();
            xAxis.setLabel(Messages.StrobeDelayLabel);
            yAxis.setLabel(Messages.VrefLabel);
            xAxis.setAutoRanging(false);
            yAxis.setAutoRanging(false);
            xAxis.setTickUnit(2.0);
            yAxis.setTickUnit(0.05);
            CustomLineChart lineAreaChartLoc = this.lineAreaChart = new CustomLineChart((Axis<Number>)xAxis, (Axis<Number>)yAxis);
            lineAreaChartLoc.setCreateSymbols(false);
            lineAreaChartLoc.setAnimated(false);
            lineAreaChartLoc.setCursor(Cursor.CROSSHAIR);
            lineAreaChartLoc.setLegendSide(Side.RIGHT);
            lineAreaChartLoc.setAxisSortingPolicy(LineChart.SortingPolicy.NONE);
            lineAreaChartLoc.setMinHeight(600.0);
            lineAreaChartLoc.setMinWidth(900.0);
            lineAreaChartLoc.setVerticalZeroLineVisible(false);
            VBox.setVgrow((Node)this.lineAreaChart, (Priority)Priority.ALWAYS);
            int graph = 0;
            while (graph < numGraphs) {
                XYChart.Series series = new XYChart.Series();
                lineAreaChartLoc.getData().add((Object)series);
                ++graph;
            }
            HBox hBoxCheckBoxesLoc = this.hBoxCheckBoxes = new HBox();
            hBoxCheckBoxesLoc.setAlignment(Pos.CENTER);
            HBox.setHgrow((Node)this.hBoxCheckBoxes, (Priority)Priority.ALWAYS);
            hBoxCheckBoxesLoc.setPadding(new Insets(0.0, 0.0, 0.0, 220.0));
            HBox xAxisUnitHbox = new HBox(2.0);
            xAxisUnitHbox.setAlignment(Pos.CENTER_LEFT);
            xAxisUnitHbox.setPadding(new Insets(0.0, 5.0, 0.0, 30.0));
            Label xAxisLabel = new Label();
            xAxisLabel.setText(Messages.OxAxisUnitLabel);
            xAxisLabel.setFont(new Font(14.0));
            xAxisLabel.setAlignment(Pos.CENTER_LEFT);
            ComboBox xAxisUnit = new ComboBox();
            xAxisUnit.getItems().addAll((Object[])new String[]{"UI", "ps"});
            xAxisUnit.setValue((Object)"UI");
            xAxisUnit.getSelectionModel().selectedItemProperty().addListener((options, oldValue, newValue) -> {
                lineAreaChartLoc.applyOxUnit((String)newValue);
                lineAreaChartLoc.setOxBounds((String)newValue);
                if (this.eyeResult != null) {
                    TableView<EyeResult> eyeResultLoc = this.eyeResult;
                    for (EyeResult eyeRes : eyeResultLoc.getItems()) {
                        eyeRes.updateDelayProperties((String)newValue);
                        eyeRes.setTableCellValues(eyeRes.getBitLane());
                    }
                    this.updateColumnsName((String)newValue);
                    eyeResultLoc.refresh();
                }
            });
            xAxisUnitHbox.getChildren().addAll((Object[])new Node[]{xAxisLabel, xAxisUnit});
            HBox lineChartControlHbox = new HBox();
            lineChartControlHbox.setPadding(new Insets(0.0, 0.0, 30.0, 0.0));
            lineChartControlHbox.getChildren().addAll((Object[])new Node[]{this.hBoxCheckBoxes, xAxisUnitHbox});
            VBox vBoxLoc = this.vBox = new VBox();
            vBoxLoc.getChildren().addAll((Object[])new Node[]{this.lineAreaChart, lineChartControlHbox});
            VPresentationModel vData = ValidationContext.getInstance().getData();
            VModel vModel = vData.getModel();
            if (vModel != null && (detailsTableOption = vModel.getCustomOption("overlay_details_table")) != null && Boolean.parseBoolean(detailsTableOption)) {
                HBox hBoxTable = new HBox();
                hBoxTable.setPadding(new Insets(0.0, 0.0, 5.0, 62.0));
                this.eyeResult = this.createTableView();
                hBoxTable.getChildren().add(this.eyeResult);
                vBoxLoc.getChildren().add((Object)hBoxTable);
            }
            ScrollPane scrollPaneLoc = this.scrollPane = new ScrollPane();
            scrollPaneLoc.setFitToWidth(true);
            scrollPaneLoc.setContent((Node)vBoxLoc);
            Scene scene = new Scene((Parent)scrollPaneLoc, (Paint)Color.rgb((int)graphScrolledPanelLoc.getBackground().getRed(), (int)graphScrolledPanelLoc.getBackground().getGreen(), (int)graphScrolledPanelLoc.getBackground().getBlue()));
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader != null && (chartsSkin = classLoader.getResource("resources/overlapped-charts-skin.css")) != null) {
                scene.getStylesheets().add((Object)chartsSkin.getPath());
            }
            graphCanvasLoc.setScene(scene);
        }
        graphScrolledPanelLoc.setContent((Control)this.graphCanvas);
        CTabItem diagsOverlapTabLoc = diagsOverlapTab;
        if (diagsOverlapTabLoc != null && !diagsOverlapTabLoc.isDisposed()) {
            diagsOverlapTabLoc.setControl((Control)this.graphScrolledPanel);
        }
        return this.graphCanvas;
    }

    private void createStatusLabel(FXCanvas gCanvas) {
        VParamVariation cell;
        VTable table;
        VStagePresentation stage = this.selectedStage;
        Label label = new Label();
        label.setAlignment(Pos.TOP_LEFT);
        label.setFont(new Font(15.0));
        if (stage != null && (table = stage.getSelectedScenarioTable()) != null && (cell = table.getParamVariation(new Point(0, 0))) != null) {
            VRunResult runResult = cell.getResult(0);
            if (runResult != null && runResult.getType() == VRunResult.ResultType.FAILED) {
                label.setText(runResult.getErrorMessage());
            } else if (table.getState() == VTable.TableState.RUNNING) {
                label.setText(Messages.CollectingDataLabel);
            } else {
                label.setText(Messages.NoDataCollectedLabel);
            }
        }
        Scene scene = new Scene((Parent)label);
        gCanvas.setScene(scene);
    }

    private int readNumGraphs() {
        VDiagsPresentation diagsScenario;
        IDisplayFigure figure;
        VScenarioPresentation scenario;
        if (this.selectedStage != null && (scenario = this.selectedStage.getSelectedScenario()) instanceof VDiagsPresentation && (figure = (diagsScenario = (VDiagsPresentation)scenario).getChart()) instanceof VDiagsOverlayFigure) {
            return ((VDiagsOverlayFigure)figure).getNoEyeTables();
        }
        return 0;
    }

    public @Nullable FXCanvas setInput(VStagePresentation selectedStage, CTabFolder scenTabFolder, CTabItem overlappedChartsTab) {
        VDiagsPresentation diagsScenario;
        IDisplayFigure figure;
        this.selectedStage = selectedStage;
        this.graphCanvas = this.createChart(scenTabFolder, overlappedChartsTab);
        VScenarioPresentation scenario = selectedStage.getSelectedScenario();
        if (scenario instanceof VDiagsPresentation && (figure = (diagsScenario = (VDiagsPresentation)scenario).getChart()) instanceof VDiagsOverlayFigure) {
            ((VDiagsOverlayFigure)figure).updateDiagsInfo(this.lineAreaChart, this.hBoxCheckBoxes, this.eyeResult);
            if (this.graphCanvas != null) {
                this.graphCanvas.redraw();
            }
        }
        return this.graphCanvas;
    }

    public TableView<EyeResult> createTableView() {
        TableColumn byteColumn = new TableColumn(Messages.ByteLaneColumn);
        byteColumn.setCellValueFactory((Callback)new PropertyValueFactory(Messages.ByteLaneObject));
        TableColumn bitColumn = new TableColumn(Messages.BitLaneColumn);
        bitColumn.setCellValueFactory((Callback)new PropertyValueFactory(Messages.BitLaneObject));
        TableColumn goldenVrefColumn = new TableColumn();
        this.setColumnLabel(goldenVrefColumn, Messages.CenterVrefColumn, Messages.CenterVrefTooltip);
        goldenVrefColumn.setCellValueFactory((Callback)new PropertyValueFactory(Messages.GoldenVrefObject));
        TableColumn goldenDelayColumn = new TableColumn();
        this.setColumnLabel(goldenDelayColumn, String.format(Messages.CenterDelayColumn, "UI"), Messages.CenterDelayTooltip);
        goldenDelayColumn.setCellValueFactory((Callback)new PropertyValueFactory(Messages.GoldenDelayObject));
        TableColumn minVrefMarginColumn = new TableColumn();
        this.setColumnLabel(minVrefMarginColumn, Messages.MarginPointVrefColumn, Messages.VrefMarginPointTooltip);
        minVrefMarginColumn.setCellValueFactory((Callback)new PropertyValueFactory(Messages.ClosestVrefMarginObject));
        TableColumn minDelayMarginColumn = new TableColumn();
        this.setColumnLabel(minDelayMarginColumn, String.format(Messages.MarginPointDelayColumn, "UI"), Messages.DelayMarginPointTooltip);
        minDelayMarginColumn.setCellValueFactory((Callback)new PropertyValueFactory(Messages.ClosestDelayMarginObject));
        TableColumn deltaVrefColumn = new TableColumn();
        this.setColumnLabel(deltaVrefColumn, Messages.DeltaVrefColumn, Messages.DeltaVrefTooltip);
        deltaVrefColumn.setCellValueFactory((Callback)new PropertyValueFactory(Messages.DeltaVrefObject));
        TableColumn deltaDelayColumn = new TableColumn();
        this.setColumnLabel(deltaDelayColumn, String.format(Messages.DeltaDelayColumn, "UI"), Messages.DeltaDelayTooltip);
        deltaDelayColumn.setCellValueFactory((Callback)new PropertyValueFactory(Messages.DeltaDelayObject));
        TableView table = new TableView();
        table.setEditable(true);
        table.setTableMenuButtonVisible(true);
        table.getColumns().addAll((Object[])new TableColumn[]{byteColumn, bitColumn, goldenVrefColumn, goldenDelayColumn, deltaVrefColumn, minVrefMarginColumn, deltaDelayColumn, minDelayMarginColumn});
        table.setPrefHeight(200.0);
        table.setPrefWidth(900.0);
        byteColumn.prefWidthProperty().bind((ObservableValue)table.widthProperty().multiply(0.08));
        bitColumn.prefWidthProperty().bind((ObservableValue)table.widthProperty().multiply(0.08));
        goldenVrefColumn.prefWidthProperty().bind((ObservableValue)table.widthProperty().multiply(0.12));
        goldenDelayColumn.prefWidthProperty().bind((ObservableValue)table.widthProperty().multiply(0.12));
        minVrefMarginColumn.prefWidthProperty().bind((ObservableValue)table.widthProperty().multiply(0.17));
        minDelayMarginColumn.prefWidthProperty().bind((ObservableValue)table.widthProperty().multiply(0.17));
        deltaVrefColumn.prefWidthProperty().bind((ObservableValue)table.widthProperty().multiply(0.12));
        deltaDelayColumn.prefWidthProperty().bind((ObservableValue)table.widthProperty().multiply(0.12));
        return table;
    }

    public <T> void setColumnLabel(TableColumn<EyeResult, T> column, String columnName, String tooltipMessage) {
        Label columnLabel = new Label(columnName);
        Tooltip tooltip = new Tooltip(tooltipMessage);
        tooltip.getStyleClass().add((Object)"custom-tooltip");
        tooltip.setShowDelay(Duration.millis((double)10.0));
        columnLabel.setTooltip(tooltip);
        column.setGraphic((Node)columnLabel);
    }

    public void updateColumnsName(String unit) {
        if (this.eyeResult != null) {
            TableView<EyeResult> eyeResultLoc = this.eyeResult;
            try {
                TableColumn deltaDelayColumn;
                TableColumn minDelayMarginColumn;
                TableColumn goldenDelayColumn = (TableColumn)eyeResultLoc.getColumns().get(3);
                if (goldenDelayColumn != null) {
                    this.setLabelNameOfColumn(goldenDelayColumn, String.format(Messages.CenterDelayColumn, unit));
                }
                if ((minDelayMarginColumn = (TableColumn)eyeResultLoc.getColumns().get(7)) != null) {
                    this.setLabelNameOfColumn(minDelayMarginColumn, String.format(Messages.MarginPointDelayColumn, unit));
                }
                if ((deltaDelayColumn = (TableColumn)eyeResultLoc.getColumns().get(6)) != null) {
                    this.setLabelNameOfColumn(deltaDelayColumn, String.format(Messages.DeltaDelayColumn, unit));
                }
            }
            catch (IndexOutOfBoundsException error) {
                LOGGER.warning(error.getMessage());
            }
        }
    }

    public void setLabelNameOfColumn(TableColumn<EyeResult, ?> column, String columnName) {
        if (column.getGraphic() instanceof Label) {
            Label columnLabel = (Label)column.getGraphic();
            columnLabel.setText(columnName);
        }
    }

    public @Nullable CustomLineChart getLineChart() {
        return this.lineAreaChart;
    }

    public @Nullable TableView<EyeResult> getTable() {
        return this.eyeResult;
    }

    public @Nullable ScrolledComposite getScrolledPanel() {
        return this.graphScrolledPanel;
    }

    public boolean getChartGenerationState() {
        return this.chartGenerated;
    }

    public void setChartGenState(boolean generated) {
        this.chartGenerated = generated;
    }

    public void disposeParentComposite() {
        if (this.graphScrolledPanel != null) {
            this.graphScrolledPanel.dispose();
        }
    }

    public static class EyeResult {
        private final SimpleStringProperty byteLane;
        private final SimpleStringProperty bitLane;
        private final SimpleStringProperty goldenVref;
        private final SimpleStringProperty goldenDelay;
        private final SimpleStringProperty closestVrefMargin;
        private final SimpleStringProperty closestDelayMargin;
        private final SimpleStringProperty deltaVref;
        private final SimpleStringProperty deltaDelay;
        private Map<String, List<String>> bitMap = new HashMap<String, List<String>>();
        private Map<String, Map<String, List<String>>> delayPropertyMap = new HashMap<String, Map<String, List<String>>>();
        public static final int TAP_DELAY_INDEX_MAP = 0;
        public static final int MARGIN_DELAY_POINT_INDEX_MAP = 1;
        public static final int MARGIN_DELAY_INDEX_MAP = 2;
        public static final int CENTER_DELAY_COL_INDEX = 3;
        public static final int CLOSEST_DELAY_COL_INDEX = 7;
        public static final int DELTA_DELAY_COL_INDEX = 6;
        public static final int BIT0 = 0;
        public static final int BIT7 = 8;

        EyeResult(String byteLaneParam, String bitLaneParam, String goldenVrefParam, String goldenDelayParam, String closestVrefMarginParam, String closestDelayMarginParam, String deltaVref, String deltaDelay) {
            this.byteLane = new SimpleStringProperty(byteLaneParam);
            this.bitLane = new SimpleStringProperty(bitLaneParam);
            this.goldenVref = new SimpleStringProperty(goldenVrefParam);
            this.goldenDelay = new SimpleStringProperty(goldenDelayParam);
            this.closestVrefMargin = new SimpleStringProperty(closestVrefMarginParam);
            this.closestDelayMargin = new SimpleStringProperty(closestDelayMarginParam);
            this.deltaVref = new SimpleStringProperty(deltaVref);
            this.deltaDelay = new SimpleStringProperty(deltaDelay);
        }

        public String getByteLane() {
            return Objects.requireNonNull(this.byteLane.get());
        }

        public String getBitLane() {
            return Objects.requireNonNull(this.bitLane.get());
        }

        public void setBitLane(String bitLaneParam) {
            this.bitLane.set(bitLaneParam);
        }

        public String getGoldenVref() {
            return Objects.requireNonNull(this.goldenVref.get());
        }

        public String getGoldenDelay() {
            return Objects.requireNonNull(this.goldenDelay.get());
        }

        public void setGoldenVref(String goldenVrefParam) {
            this.goldenVref.set(goldenVrefParam);
        }

        public void setGoldenDelay(String goldenDelayParam) {
            this.goldenDelay.set(goldenDelayParam);
        }

        public String getClosestVrefMargin() {
            return Objects.requireNonNull(this.closestVrefMargin.get());
        }

        public String getClosestDelayMargin() {
            return Objects.requireNonNull(this.closestDelayMargin.get());
        }

        public void setClosestVrefMargin(String closestVrefMarginParam) {
            this.closestVrefMargin.set(closestVrefMarginParam);
        }

        public void setClosestDelayMargin(String closestDelayMarginParam) {
            this.closestDelayMargin.set(closestDelayMarginParam);
        }

        public String getDeltaVref() {
            return Objects.requireNonNull(this.deltaVref.get());
        }

        public void setDeltaVref(String deltaVref) {
            this.deltaVref.set(deltaVref);
        }

        public String getDeltaDelay() {
            return Objects.requireNonNull(this.deltaDelay.get());
        }

        public void setDeltaDelay(String deltaDelay) {
            this.deltaDelay.set(deltaDelay);
        }

        public void addBitKey(String bitNumber, List<String> parameters) {
            this.bitMap.put(bitNumber, parameters);
        }

        public void setTableCellValues(String bitLaneParam) {
            String centerVref = "";
            String centerDelay = "";
            String closestVref = "";
            String closestDelay = "";
            String vrefMarginDistance = "";
            String delayMarginDistance = "";
            List<String> paramList = this.bitMap.get(bitLaneParam);
            if (paramList != null) {
                try {
                    centerVref = paramList.get(PropertyIndex.CENTER_VREF.ordinal());
                    centerDelay = paramList.get(PropertyIndex.CENTER_DELAY.ordinal());
                    closestVref = paramList.get(PropertyIndex.CLOSEST_VREF.ordinal());
                    closestDelay = paramList.get(PropertyIndex.CLOSEST_DELAY.ordinal());
                    vrefMarginDistance = paramList.get(PropertyIndex.DELTA_VREF.ordinal());
                    delayMarginDistance = paramList.get(PropertyIndex.DELTA_DELAY.ordinal());
                }
                catch (IndexOutOfBoundsException error) {
                    LOGGER.warning(error.getMessage());
                }
            }
            this.setGoldenVref(centerVref);
            this.setGoldenDelay(centerDelay);
            this.setClosestVrefMargin(closestVref);
            this.setClosestDelayMargin(closestDelay);
            this.setDeltaVref(vrefMarginDistance);
            this.setDeltaDelay(delayMarginDistance);
        }

        public void updateDelayProperties(String unit) {
            for (Map.Entry<String, Map<String, List<String>>> entry : this.delayPropertyMap.entrySet()) {
                Map<String, List<String>> delayMap = entry.getValue();
                List<String> delayList = delayMap.get(unit);
                if (delayList == null) continue;
                String tapDelay = delayList.get(0);
                String marginDelayPoint = delayList.get(1);
                String marginDelay = delayList.get(2);
                List<String> propertyList = this.bitMap.get(entry.getKey());
                if (propertyList == null) continue;
                propertyList.set(PropertyIndex.CENTER_DELAY.ordinal(), tapDelay);
                propertyList.set(PropertyIndex.CLOSEST_DELAY.ordinal(), marginDelayPoint);
                propertyList.set(PropertyIndex.DELTA_DELAY.ordinal(), marginDelay);
            }
        }

        public void addBitProperties(int bit, String goldenVrefParam, int tapDelay, String closestOyMargin, String closestOxMargin, String vrefMarginDistance, String delayMarginDistance, Map<String, List<String>> unitMap) {
            String bitEntry = String.valueOf(bit);
            ArrayList<String> params = new ArrayList<String>();
            params.add(goldenVrefParam);
            params.add(String.valueOf(tapDelay));
            params.add(closestOyMargin);
            params.add(closestOxMargin);
            params.add(vrefMarginDistance);
            params.add(delayMarginDistance);
            this.addBitKey(bitEntry, params);
            this.addDelayPropertiesValues(bitEntry, unitMap);
        }

        public void addDelayPropertiesValues(String bit, Map<String, List<String>> delayMap) {
            this.delayPropertyMap.put(bit, delayMap);
        }

        public Map<String, List<String>> getBitMap() {
            return this.bitMap;
        }

        public static enum PropertyIndex {
            CENTER_VREF,
            CENTER_DELAY,
            CLOSEST_VREF,
            CLOSEST_DELAY,
            DELTA_VREF,
            DELTA_DELAY;

        }
    }

    private static class OverlapChartsConstants {
        private static final int LINE_CHART_WIDTH = 900;
        private static final int LINE_CHART_HEIGHT = 600;
        private static final int TABLE_WIDTH = 900;
        private static final int TABLE_HEIGHT = 200;
        private static final double BYTE_BIT_COL_MULTIPLY = 0.08;
        private static final double VREF_DELAY_CENTER_AND_MARGIN_MULTIPLY = 0.12;
        private static final double VREF_DELAY_POINTS_MULTIPLY = 0.17;

        private OverlapChartsConstants() {
        }
    }
}

