/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.migration.actions;

import com.nxp.s32ds.cle.runtime.migration.action.MigrationAction;
import com.nxp.s32ds.cle.runtime.migration.annotation.MigrationEntityAnnotation;
import com.nxp.s32ds.cle.runtime.migration.annotation.MigrationPropertyAnnotation;
import com.nxp.s32ds.ext.ide.resources.WorkspaceResources;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

@MigrationEntityAnnotation(name="Update SDK for Configuration Tool.", description="Replaces old SDK ID to new one in .mex files.")
public class UpdateSdkForConfigToolAction
implements MigrationAction {
    @MigrationPropertyAnnotation(name="sourceSdkId", description="The ID list of source SDK.")
    private List<String> sourceSdkIds;
    @MigrationPropertyAnnotation(description="The ID of target SDK.")
    private String targetSdkId;

    public void perform(IProject project, IProgressMonitor monitor) throws CoreException {
        IResource[] members = project.members();
        ArrayDeque<IResource> stack = new ArrayDeque<IResource>();
        stack.addAll(Arrays.asList(members));
        while (!stack.isEmpty()) {
            IResource resource = (IResource)stack.pop();
            if (resource instanceof IFile) {
                if (!"mex".equals(resource.getFileExtension()) && !".project".equals(resource.getName()) && !Arrays.asList(resource.getFullPath().segments()).stream().filter(s -> s.equals("board")).findAny().isPresent()) continue;
                for (String sourceSdkId : this.sourceSdkIds) {
                    UpdateSdkForConfigToolAction.updateFile((IFile)resource, sourceSdkId, this.targetSdkId, monitor);
                }
                continue;
            }
            if (!(resource instanceof IFolder) || !"board".equals(resource.getName())) continue;
            IResource[] folderMembers = ((IFolder)resource).members();
            stack.addAll(Arrays.asList(folderMembers));
        }
    }

    private static void updateFile(IFile file, String sourceSdkId, String targetSdkId, IProgressMonitor monitor) throws CoreException {
        String changed;
        String fileContents = WorkspaceResources.getFileContents((IFile)file);
        if (!fileContents.equals(changed = fileContents.replace(sourceSdkId, targetSdkId))) {
            WorkspaceResources.setFileContents((IFile)file, (String)changed, (IProgressMonitor)monitor);
        }
    }
}

