/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.EmptyContext;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.lang.Triplet;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.version.VersionUtils;
import com.nxp.swtools.expert.processordb.sdkcomponents.SdkComponentsTable;
import com.nxp.swtools.expert.processordb.sdkcomponents.SupportedSdkComponent;
import com.nxp.swtools.provider.toolchainproject.ISdkComponentInProject;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.resourcetables.model.data.IConfigSet;
import com.nxp.swtools.resourcetables.model.data.IConfigurationComponent;
import com.nxp.swtools.resourcetables.model.data.Migrations;
import com.nxp.swtools.resourcetables.model.data.SWComponent;
import com.nxp.swtools.resourcetables.model.data.SettingUtils;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.model.data.setting.ReferenceSetting;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.osgi.framework.Version;

public class Components {
    public static final BigInteger MULTIPLY_FACTOR_VERSION_MAJOR_MINOR_DIFFERS = BigInteger.valueOf(1000L);
    public static final BigInteger MULTIPLY_FACTOR_VERSION_HIGHER_THAN_REQUIRED = BigInteger.valueOf(1000000000L);
    protected Collection<ConfigurationComponentTypeId> confCompTypeIds;
    private static IContext emptyContext = EmptyContext.getInstsance();
    public static final BigInteger SCORE_PERFECT_MATCH = BigInteger.valueOf(1000000L);
    public static final BigInteger SCORE_NOT_REQUIRED_NOT_MATCHING = BigInteger.valueOf(1000000L);
    public static final String COMPONENT_TYPE_USED_FOR_MARKING_AS_USED = "custom_init";

    public Components(Collection<ConfigurationComponentTypeId> confCompTypeIds) {
        this.confCompTypeIds = confCompTypeIds;
    }

    public Components(Components original, Collection<ConfigurationComponentTypeId> collection) {
        this.confCompTypeIds = collection;
        this.confCompTypeIds.clear();
        this.confCompTypeIds.addAll(original.confCompTypeIds);
    }

    public boolean addConfigurationComponent(IComponentConfig componentConfig) {
        return this.confCompTypeIds.add(componentConfig.getConfigCompTypeId());
    }

    public static @Nullable BigInteger computeMatchScore(SWComponent swComp, SupportedSdkComponent sdkComp) {
        SWComponent.Match match = swComp.getMatch();
        String sdkRevision = sdkComp.getRevision();
        BigInteger score = Components.computeMatchScore(new ComputeScoreWrapper(swComp.getVersion(), swComp.getRevisionsList()), new ComputeScoreWrapper(sdkComp.getVersion(), sdkRevision == null ? Collections.emptyList() : Arrays.asList(sdkRevision)), match != null ? match.getName() : "", swComp.getUntilVersion());
        if (score == null && !swComp.getRequired()) {
            return BigInteger.ZERO;
        }
        return score;
    }

    public static @Nullable BigInteger computeMatchScore(SWComponent current, SWComponent required) {
        SWComponent.Match match = current.getMatch();
        BigInteger score = Components.computeMatchScore(new ComputeScoreWrapper(current.getVersion(), current.getRevisionsList()), new ComputeScoreWrapper(required.getVersion(), required.getRevisionsList()), match != null ? match.getName() : "", current.getUntilVersion());
        if (score == null && !current.getRequired()) {
            return BigInteger.ZERO;
        }
        return score;
    }

    public static @Nullable BigInteger computeMatchScore(@Nullable Version swCompVersion, Version sdkCompVersion, String matchName, @Nullable Version upperLimitVersion) {
        if (swCompVersion == null) {
            return null;
        }
        return Components.computeMatchScore(new ComputeScoreWrapper(swCompVersion, Collections.emptyList()), new ComputeScoreWrapper(sdkCompVersion, Collections.emptyList()), matchName, upperLimitVersion);
    }

    public static @Nullable BigInteger computeMatchScore(ComputeScoreWrapper swCompVersionWrapper, ComputeScoreWrapper sdkCompVersionWrapper, String matchName, @Nullable Version upperLimitVersion) {
        Version swCompVersion = swCompVersionWrapper.getVersion();
        if (swCompVersion == null) {
            return null;
        }
        Version sdkVersion = sdkCompVersionWrapper.getVersion();
        if (sdkVersion == null) {
            return null;
        }
        List<String> swCompRevisions = swCompVersionWrapper.getRevisions();
        List<String> sdkCompRevisions = sdkCompVersionWrapper.getRevisions();
        if (!swCompRevisions.isEmpty() && CollectionsUtils.intersection(sdkCompRevisions, swCompRevisions).isEmpty()) {
            return null;
        }
        BigInteger score = null;
        SWComponent.Match match = SWComponent.Match.getMatchByName((String)matchName);
        if (match != null) {
            switch (match) {
                case PERFECT: {
                    score = Components.computeMatchScorePerfect(swCompVersion, sdkVersion);
                    break;
                }
                case COMPATIBLE: {
                    score = Components.computeMatchScoreCompatible(swCompVersion, sdkVersion, upperLimitVersion);
                    break;
                }
                case GREATER_OR_EQUAL: {
                    score = Components.computeMatchScoreGreaterOrEqual(swCompVersion, sdkVersion, upperLimitVersion);
                    break;
                }
                default: {
                    score = Components.computeMatchScoreEquivalent(swCompVersion, sdkVersion, upperLimitVersion);
                    break;
                }
            }
        } else {
            score = Components.computeMatchScoreEquivalent(swCompVersion, sdkVersion, upperLimitVersion);
        }
        return score;
    }

    public static @Nullable BigInteger computeMatchScorePerfect(Version versionRequired, Version versionActual) {
        if (VersionUtils.perfect((Version)versionActual, (Version)versionRequired)) {
            return SCORE_PERFECT_MATCH;
        }
        return null;
    }

    public static @Nullable BigInteger computeMatchScoreEquivalent(Version versionRequired, Version versionActual, @Nullable Version upperVersionLimit) {
        if (upperVersionLimit != null && !VersionUtils.isInRange((Version)versionActual, (Version)versionRequired, (Version)upperVersionLimit)) {
            return null;
        }
        BigInteger negatedDifference = Components.computeNegatedDifferenceBetweenVersions(versionRequired, versionActual);
        if (VersionUtils.equivalent((Version)versionActual, (Version)versionRequired)) {
            return negatedDifference;
        }
        if (VersionUtils.equivalent((Version)versionRequired, (Version)versionActual)) {
            return negatedDifference.multiply(MULTIPLY_FACTOR_VERSION_HIGHER_THAN_REQUIRED);
        }
        return null;
    }

    public static @Nullable BigInteger computeMatchScoreCompatible(Version versionRequired, Version versionActual, @Nullable Version upperVersionLimit) {
        if (upperVersionLimit != null && !VersionUtils.isInRange((Version)versionActual, (Version)versionRequired, (Version)upperVersionLimit)) {
            return null;
        }
        BigInteger negatedDifference = Components.computeNegatedDifferenceBetweenVersions(versionRequired, versionActual);
        if (VersionUtils.compatible((Version)versionActual, (Version)versionRequired)) {
            return negatedDifference;
        }
        return null;
    }

    private static BigInteger computeNegatedDifferenceBetweenVersions(Version first, Version second) {
        return Components.getValueOfVersion(second).subtract(Components.getValueOfVersion(first)).abs().negate();
    }

    private static BigInteger getValueOfVersion(Version version) {
        return BigInteger.ZERO.add(BigInteger.valueOf(version.getMicro()).add(BigInteger.valueOf(version.getMinor()).multiply(MULTIPLY_FACTOR_VERSION_MAJOR_MINOR_DIFFERS)).add(BigInteger.valueOf(version.getMajor()).multiply(MULTIPLY_FACTOR_VERSION_MAJOR_MINOR_DIFFERS).multiply(MULTIPLY_FACTOR_VERSION_MAJOR_MINOR_DIFFERS)));
    }

    public static @Nullable BigInteger computeMatchScoreGreaterOrEqual(Version versionRequired, Version versionActual, @Nullable Version upperVersionLimit) {
        if (upperVersionLimit != null && !VersionUtils.isInRange((Version)versionActual, (Version)versionRequired, (Version)upperVersionLimit)) {
            return null;
        }
        BigInteger negatedDifference = Components.computeNegatedDifferenceBetweenVersions(versionRequired, versionActual);
        if (VersionUtils.greaterOrEqual((Version)versionActual, (Version)versionRequired)) {
            return negatedDifference;
        }
        return null;
    }

    public static @Nullable BigInteger computeMatchScore(ConfigurationComponentTypeId comp, SdkComponentsTable supportedComps) {
        BigInteger result = BigInteger.ZERO;
        for (SWComponent swComp : comp.getConfigurationComponent().getComponents()) {
            SupportedSdkComponent bestMatchingSdkComp = Components.findBestMatchingSdkComponent(swComp, supportedComps);
            if (bestMatchingSdkComp == null) {
                if (!swComp.getRequired()) continue;
                return null;
            }
            BigInteger bestMatchScore = Components.computeMatchScore(swComp, bestMatchingSdkComp);
            if (bestMatchScore == null) {
                return null;
            }
            result = result.add(bestMatchScore);
        }
        return result;
    }

    public static @Nullable SupportedSdkComponent findBestMatchingSdkComponent(SWComponent swComponent, SdkComponentsTable supportedComps) {
        SupportedSdkComponent result = (SupportedSdkComponent)CollectionsUtils.nullableOptionalGet(supportedComps.findById(swComponent.getName()).filter(sdkComp -> Components.computeMatchScore(swComponent, sdkComp) != null).max(Comparator.comparing(sdkComp -> Components.computeMatchScore(swComponent, sdkComp))));
        return result;
    }

    public @Nullable Triplet<ISetting, IConfigSet, IConfigurationComponent> findSetting(IConfigurationComponent confComp, String confSetID, String settingID, boolean autoResolve) {
        return Components.findSetting(this.getConfigComps(), confComp, confSetID, settingID, autoResolve);
    }

    public static @Nullable Triplet<ISetting, IConfigSet, IConfigurationComponent> findSetting(Collection<IConfigurationComponent> components, IConfigurationComponent confComp, String confSetID, String settingID, boolean autoResolve) {
        IConfigurationComponent comp;
        HashSet<ReferenceSetting> references = new HashSet<ReferenceSetting>();
        ISetting result = null;
        ReferenceSetting prevReference = null;
        IConfigurationComponent prevComp = comp = confComp;
        IConfigSet confSet = null;
        do {
            String refConfSetID;
            if (comp != null) {
                confSet = comp.findConfigSet(confSetID);
            }
            if (confSet != null) {
                result = confSet.find(settingID.split("\\."));
            }
            if (prevReference != null && result != null) {
                result = result.fromReference(prevReference);
                if (comp != prevComp && !result.isPublic(emptyContext)) {
                    return null;
                }
            }
            if (!(result instanceof ReferenceSetting)) continue;
            assert (comp != null);
            ReferenceSetting reference = (ReferenceSetting)result;
            if (!references.add(reference)) {
                String id = SettingUtils.buildId((String[])new String[]{comp.getId(), confSetID, settingID});
                throw new IllegalStateException("Cycle detected while finding " + id + ", composed of " + references);
            }
            String refCompID = reference.getComponentRefID();
            if (refCompID != null && !refCompID.equals(comp.getId())) {
                prevComp = comp;
                comp = (IConfigurationComponent)CollectionsUtils.nullableOptionalGet(components.stream().filter(x -> x.getId().equals(refCompID)).findFirst());
            }
            confSetID = (refConfSetID = reference.getConfigSetRefID()) == null ? confSetID : refConfSetID;
            settingID = reference.getReferenceID();
            prevReference = reference;
        } while (autoResolve && result instanceof ReferenceSetting);
        if (result == null || confSet == null || comp == null) {
            return null;
        }
        return new Triplet((Object)result, (Object)confSet, (Object)comp);
    }

    public Collection<IConfigurationComponent> getConfigComps() {
        return CollectionsUtils.unmodifiableCollection((Collection)((Collection)this.confCompTypeIds.stream().map(x -> x.getConfigurationComponent()).collect(CollectorsUtils.toList())));
    }

    public @Nullable ConfigurationComponentTypeId getConfigCompTypeId(String typeId) {
        return (ConfigurationComponentTypeId)CollectionsUtils.nullableOptionalGet(this.confCompTypeIds.stream().filter(x -> x.getTypeId().equals(typeId)).findAny());
    }

    public @Nullable ConfigurationComponentTypeId getConfigCompTypeIdByType(String type) {
        return (ConfigurationComponentTypeId)CollectionsUtils.nullableOptionalGet(this.confCompTypeIds.stream().filter(x -> x.getType().equals(type)).findAny());
    }

    public Collection<ConfigurationComponentTypeId> getConfigCompTypeIds() {
        return CollectionsUtils.unmodifiableCollection(this.confCompTypeIds);
    }

    public static @Nullable ConfigurationComponentTypeId getLatestVersionConfigCompType(List<ConfigurationComponentTypeId> configComps) {
        if (configComps.isEmpty()) {
            return null;
        }
        ConfigurationComponentTypeId latestComp = configComps.get(0);
        Version highestVersion = Components.getHighestComponentVersion(latestComp);
        boolean hadRevisions = !latestComp.getComponentReferences().isEmpty() && !((SWComponent)latestComp.getComponentReferences().get(0)).getRevisionsList().isEmpty();
        for (ConfigurationComponentTypeId comp : configComps) {
            List newRevisions;
            Version otherVersion = Components.getHighestComponentVersion(comp);
            List list = newRevisions = comp.getComponentReferences().isEmpty() ? Collections.emptyList() : ((SWComponent)comp.getComponentReferences().get(0)).getRevisionsList();
            if (otherVersion == null || highestVersion != null && otherVersion.compareTo(highestVersion) <= 0 && (otherVersion.compareTo(highestVersion) != 0 || hadRevisions || newRevisions.isEmpty())) continue;
            latestComp = comp;
            highestVersion = otherVersion;
            boolean bl = hadRevisions = !newRevisions.isEmpty();
        }
        if (highestVersion == null && configComps.size() > 1) {
            return null;
        }
        return latestComp;
    }

    public static boolean replacementMatchesAllSWComponents(List<SWComponent> currentSWComponents, List<SWComponent> replacementSWComponents) {
        for (SWComponent replacementSWComponent : replacementSWComponents) {
            SWComponent currentSWComp = (SWComponent)CollectionsUtils.nullableOptionalGet(currentSWComponents.stream().filter(swComp -> swComp.getName().equals(replacementSWComponent.getName())).findAny());
            if (currentSWComp == null) {
                return false;
            }
            BigInteger score = Components.computeMatchScore(replacementSWComponent, currentSWComp);
            if (score != null) continue;
            return false;
        }
        return true;
    }

    public static boolean canReplace(ConfigurationComponentTypeId currentComponent, ConfigurationComponentTypeId potentialReplacementComponent) {
        boolean sameType = potentialReplacementComponent.getType().equals(currentComponent.getType());
        boolean isNotDeprecated = !potentialReplacementComponent.getConfigurationComponent().isHidden();
        boolean isTargetOfMigration = false;
        Migrations migrations = potentialReplacementComponent.getConfigurationComponent().getMigrations();
        if (migrations != null) {
            List mig = (List)migrations.getMigrationComponents().stream().filter(m -> m.getComponentType().equals(currentComponent.getType())).filter(m -> Components.replacementMatchesAllSWComponents(currentComponent.getComponentReferences(), m.getSwCompRefs())).collect(CollectorsUtils.toList());
            boolean bl = isTargetOfMigration = !mig.isEmpty();
        }
        return isNotDeprecated && (sameType || isTargetOfMigration);
    }

    private static @Nullable Version getHighestComponentVersion(ConfigurationComponentTypeId componentTypeId) {
        List swComps = componentTypeId.getConfigurationComponent().getComponents();
        if (swComps.isEmpty()) {
            return null;
        }
        Version highestVersion = ((SWComponent)swComps.get(0)).getVersion();
        for (SWComponent swComp : swComps) {
            Version otherVersion = swComp.getVersion();
            if (otherVersion == null || highestVersion != null && otherVersion.compareTo(highestVersion) <= 0) continue;
            highestVersion = otherVersion;
        }
        return highestVersion;
    }

    public void dispose() {
        this.confCompTypeIds.clear();
    }

    public static class ComputeScoreWrapper {
        @Nullable
        private Version version;
        private List<String> revisions;

        public ComputeScoreWrapper(@Nullable Version version, List<String> revisions) {
            this.version = version;
            this.revisions = revisions;
        }

        public @Nullable Version getVersion() {
            return this.version;
        }

        public List<String> getRevisions() {
            return this.revisions;
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof ComputeScoreWrapper)) {
                return false;
            }
            ComputeScoreWrapper other = (ComputeScoreWrapper)obj;
            return Objects.equals(this.version, other.version) && Objects.equals(this.revisions, other.revisions);
        }

        public int hashCode() {
            return Objects.hash(this.version, this.revisions);
        }

        public static ComputeScoreWrapper fromProjectComponent(ISdkComponentInProject projectComponent) {
            String revision = projectComponent.getRevision();
            List<String> revisionsList = Collections.emptyList();
            if (revision != null && !revision.isEmpty()) {
                revisionsList = Arrays.asList(revision);
            }
            return new ComputeScoreWrapper(projectComponent.getVersion(), revisionsList);
        }

        public static ComputeScoreWrapper fromSWComponent(SWComponent swComponent) {
            return new ComputeScoreWrapper(swComponent.getVersion(), swComponent.getRevisionsList());
        }
    }
}

