/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.periphs.model.data.Code;
import com.nxp.swtools.periphs.model.data.FragmentDefs;
import com.nxp.swtools.resourcetables.model.data.Description;
import com.nxp.swtools.resourcetables.model.data.IActiveContextRefResolver;
import com.nxp.swtools.resourcetables.model.data.IConfigSet;
import com.nxp.swtools.resourcetables.model.data.IConfigurationComponent;
import com.nxp.swtools.resourcetables.model.data.IQuickSelection;
import com.nxp.swtools.resourcetables.model.data.OptionsExpr;
import com.nxp.swtools.resourcetables.model.data.QuickSelectionsGroup;
import com.nxp.swtools.resourcetables.model.data.SettingUtils;
import com.nxp.swtools.resourcetables.model.data.Validation;
import com.nxp.swtools.resourcetables.model.data.setting.ABaseModel;
import com.nxp.swtools.resourcetables.model.data.setting.ACollectionSetting;
import com.nxp.swtools.resourcetables.model.data.setting.ArraySetting;
import com.nxp.swtools.resourcetables.model.data.setting.BoolSetting;
import com.nxp.swtools.resourcetables.model.data.setting.ButtonSetting;
import com.nxp.swtools.resourcetables.model.data.setting.DynamicEnumSetting;
import com.nxp.swtools.resourcetables.model.data.setting.EnumSetting;
import com.nxp.swtools.resourcetables.model.data.setting.FileSetting;
import com.nxp.swtools.resourcetables.model.data.setting.FixmeSetting;
import com.nxp.swtools.resourcetables.model.data.setting.FloatSetting;
import com.nxp.swtools.resourcetables.model.data.setting.IID;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.model.data.setting.InfoSetting;
import com.nxp.swtools.resourcetables.model.data.setting.IntegerSetting;
import com.nxp.swtools.resourcetables.model.data.setting.ReferenceSetting;
import com.nxp.swtools.resourcetables.model.data.setting.SetSetting;
import com.nxp.swtools.resourcetables.model.data.setting.StringSetting;
import com.nxp.swtools.resourcetables.model.data.setting.StructSetting;
import com.nxp.swtools.resourcetables.model.data.setting.VariableSetting;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementListUnion;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Path;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;

@Root(name="config_set", strict=false)
@Order(elements={"description", "generated_types", "user_types", "settings", "fragment_defs", "code", "validation", "quick_selections"}, attributes={"id", "label", "label_expr", "from_source", "options"})
public class ConfigSet
extends ABaseModel
implements IConfigSet {
    private static final Logger LOGGER = LogManager.getLogger(ConfigSet.class);
    private LinkedHashMap<String, ISetting> generatedTypes;
    private LinkedHashMap<String, ISetting> userTypes;
    private LinkedHashMap<String, ISetting> settings;
    @Attribute(name="from_source", required=false)
    private String source;
    @Element(type=FragmentDefs.class, name="fragment_defs", required=false)
    private FragmentDefs fragmentDefs;
    @Element(type=Code.class, name="code", required=false)
    private Code code;
    @Element(type=Validation.class, name="validation", required=false)
    private Validation validation;
    @Element(name="quick_selections", required=false)
    private QuickSelectionsGroup qsGroup;
    private Map<String, ISetting> allRelatedSettings = new LinkedHashMap<String, ISetting>();

    @Path(value="generated_types")
    @ElementListUnion(value={@ElementList(type=FixmeSetting.class, required=false, inline=true), @ElementList(type=EnumSetting.class, required=false, inline=true), @ElementList(type=ReferenceSetting.class, required=false, inline=true), @ElementList(type=StructSetting.class, required=false, inline=true), @ElementList(type=BoolSetting.class, required=false, inline=true), @ElementList(type=FloatSetting.class, required=false, inline=true), @ElementList(type=StringSetting.class, required=false, inline=true), @ElementList(type=IntegerSetting.class, required=false, inline=true)})
    private @Path(value="generated_types") @ElementListUnion(value={@ElementList(type=FixmeSetting.class, required=false, inline=true), @ElementList(type=EnumSetting.class, required=false, inline=true), @ElementList(type=ReferenceSetting.class, required=false, inline=true), @ElementList(type=StructSetting.class, required=false, inline=true), @ElementList(type=BoolSetting.class, required=false, inline=true), @ElementList(type=FloatSetting.class, required=false, inline=true), @ElementList(type=StringSetting.class, required=false, inline=true), @ElementList(type=IntegerSetting.class, required=false, inline=true)}) @ElementList(type=FixmeSetting.class, required=false, inline=true) @ElementList(type=EnumSetting.class, required=false, inline=true) @ElementList(type=ReferenceSetting.class, required=false, inline=true) @ElementList(type=StructSetting.class, required=false, inline=true) @ElementList(type=BoolSetting.class, required=false, inline=true) @ElementList(type=FloatSetting.class, required=false, inline=true) @ElementList(type=StringSetting.class, required=false, inline=true) @ElementList(type=IntegerSetting.class, required=false, inline=true) List<ISetting> getGeneratedTypesList() {
        return CollectionsUtils.listFromMapValues(this.generatedTypes);
    }

    @Path(value="generated_types")
    @ElementListUnion(value={@ElementList(type=FixmeSetting.class, required=false, inline=true), @ElementList(type=EnumSetting.class, required=false, inline=true), @ElementList(type=ReferenceSetting.class, required=false, inline=true), @ElementList(type=StructSetting.class, required=false, inline=true), @ElementList(type=BoolSetting.class, required=false, inline=true), @ElementList(type=FloatSetting.class, required=false, inline=true), @ElementList(type=StringSetting.class, required=false, inline=true), @ElementList(type=IntegerSetting.class, required=false, inline=true)})
    private void setGeneratedTypesList(List<ISetting> generatedTypesList) {
        this.addGeneratedTypes(generatedTypesList);
    }

    @Path(value="user_types")
    @ElementListUnion(value={@ElementList(type=ArraySetting.class, required=false, inline=true), @ElementList(type=SetSetting.class, required=false, inline=true), @ElementList(type=DynamicEnumSetting.class, required=false, inline=true), @ElementList(type=InfoSetting.class, required=false, inline=true), @ElementList(type=VariableSetting.class, required=false, inline=true), @ElementList(type=FileSetting.class, required=false, inline=true), @ElementList(type=ButtonSetting.class, required=false, inline=true), @ElementList(type=EnumSetting.class, required=false, inline=true), @ElementList(type=ReferenceSetting.class, required=false, inline=true), @ElementList(type=StructSetting.class, required=false, inline=true), @ElementList(type=BoolSetting.class, required=false, inline=true), @ElementList(type=FloatSetting.class, required=false, inline=true), @ElementList(type=StringSetting.class, required=false, inline=true), @ElementList(type=IntegerSetting.class, required=false, inline=true)})
    public @Path(value="user_types") @ElementListUnion(value={@ElementList(type=ArraySetting.class, required=false, inline=true), @ElementList(type=SetSetting.class, required=false, inline=true), @ElementList(type=DynamicEnumSetting.class, required=false, inline=true), @ElementList(type=InfoSetting.class, required=false, inline=true), @ElementList(type=VariableSetting.class, required=false, inline=true), @ElementList(type=FileSetting.class, required=false, inline=true), @ElementList(type=ButtonSetting.class, required=false, inline=true), @ElementList(type=EnumSetting.class, required=false, inline=true), @ElementList(type=ReferenceSetting.class, required=false, inline=true), @ElementList(type=StructSetting.class, required=false, inline=true), @ElementList(type=BoolSetting.class, required=false, inline=true), @ElementList(type=FloatSetting.class, required=false, inline=true), @ElementList(type=StringSetting.class, required=false, inline=true), @ElementList(type=IntegerSetting.class, required=false, inline=true)}) @ElementList(type=ArraySetting.class, required=false, inline=true) @ElementList(type=SetSetting.class, required=false, inline=true) @ElementList(type=DynamicEnumSetting.class, required=false, inline=true) @ElementList(type=InfoSetting.class, required=false, inline=true) @ElementList(type=VariableSetting.class, required=false, inline=true) @ElementList(type=FileSetting.class, required=false, inline=true) @ElementList(type=ButtonSetting.class, required=false, inline=true) @ElementList(type=EnumSetting.class, required=false, inline=true) @ElementList(type=ReferenceSetting.class, required=false, inline=true) @ElementList(type=StructSetting.class, required=false, inline=true) @ElementList(type=BoolSetting.class, required=false, inline=true) @ElementList(type=FloatSetting.class, required=false, inline=true) @ElementList(type=StringSetting.class, required=false, inline=true) @ElementList(type=IntegerSetting.class, required=false, inline=true) List<ISetting> getUserTypesList() {
        return CollectionsUtils.listFromMapValues(this.userTypes);
    }

    @Path(value="user_types")
    @ElementListUnion(value={@ElementList(type=ArraySetting.class, required=false, inline=true), @ElementList(type=SetSetting.class, required=false, inline=true), @ElementList(type=DynamicEnumSetting.class, required=false, inline=true), @ElementList(type=InfoSetting.class, required=false, inline=true), @ElementList(type=VariableSetting.class, required=false, inline=true), @ElementList(type=FileSetting.class, required=false, inline=true), @ElementList(type=ButtonSetting.class, required=false, inline=true), @ElementList(type=EnumSetting.class, required=false, inline=true), @ElementList(type=ReferenceSetting.class, required=false, inline=true), @ElementList(type=StructSetting.class, required=false, inline=true), @ElementList(type=BoolSetting.class, required=false, inline=true), @ElementList(type=FloatSetting.class, required=false, inline=true), @ElementList(type=StringSetting.class, required=false, inline=true), @ElementList(type=IntegerSetting.class, required=false, inline=true)})
    private void setUserTypesList(List<ISetting> userTypesList) {
        this.addUserTypes(userTypesList);
    }

    @Path(value="settings")
    @ElementListUnion(value={@ElementList(type=ArraySetting.class, required=false, inline=true), @ElementList(type=SetSetting.class, required=false, inline=true), @ElementList(type=DynamicEnumSetting.class, required=false, inline=true), @ElementList(type=InfoSetting.class, required=false, inline=true), @ElementList(type=VariableSetting.class, required=false, inline=true), @ElementList(type=FileSetting.class, required=false, inline=true), @ElementList(type=ButtonSetting.class, required=false, inline=true), @ElementList(type=EnumSetting.class, required=false, inline=true), @ElementList(type=ReferenceSetting.class, required=false, inline=true), @ElementList(type=StructSetting.class, required=false, inline=true), @ElementList(type=BoolSetting.class, required=false, inline=true), @ElementList(type=FloatSetting.class, required=false, inline=true), @ElementList(type=StringSetting.class, required=false, inline=true), @ElementList(type=IntegerSetting.class, required=false, inline=true)})
    public @Path(value="settings") @ElementListUnion(value={@ElementList(type=ArraySetting.class, required=false, inline=true), @ElementList(type=SetSetting.class, required=false, inline=true), @ElementList(type=DynamicEnumSetting.class, required=false, inline=true), @ElementList(type=InfoSetting.class, required=false, inline=true), @ElementList(type=VariableSetting.class, required=false, inline=true), @ElementList(type=FileSetting.class, required=false, inline=true), @ElementList(type=ButtonSetting.class, required=false, inline=true), @ElementList(type=EnumSetting.class, required=false, inline=true), @ElementList(type=ReferenceSetting.class, required=false, inline=true), @ElementList(type=StructSetting.class, required=false, inline=true), @ElementList(type=BoolSetting.class, required=false, inline=true), @ElementList(type=FloatSetting.class, required=false, inline=true), @ElementList(type=StringSetting.class, required=false, inline=true), @ElementList(type=IntegerSetting.class, required=false, inline=true)}) @ElementList(type=ArraySetting.class, required=false, inline=true) @ElementList(type=SetSetting.class, required=false, inline=true) @ElementList(type=DynamicEnumSetting.class, required=false, inline=true) @ElementList(type=InfoSetting.class, required=false, inline=true) @ElementList(type=VariableSetting.class, required=false, inline=true) @ElementList(type=FileSetting.class, required=false, inline=true) @ElementList(type=ButtonSetting.class, required=false, inline=true) @ElementList(type=EnumSetting.class, required=false, inline=true) @ElementList(type=ReferenceSetting.class, required=false, inline=true) @ElementList(type=StructSetting.class, required=false, inline=true) @ElementList(type=BoolSetting.class, required=false, inline=true) @ElementList(type=FloatSetting.class, required=false, inline=true) @ElementList(type=StringSetting.class, required=false, inline=true) @ElementList(type=IntegerSetting.class, required=false, inline=true) List<ISetting> getSettingsList() {
        return CollectionsUtils.listFromMapValues(this.settings);
    }

    @Path(value="settings")
    @ElementListUnion(value={@ElementList(type=ArraySetting.class, required=false, inline=true), @ElementList(type=SetSetting.class, required=false, inline=true), @ElementList(type=DynamicEnumSetting.class, required=false, inline=true), @ElementList(type=InfoSetting.class, required=false, inline=true), @ElementList(type=VariableSetting.class, required=false, inline=true), @ElementList(type=FileSetting.class, required=false, inline=true), @ElementList(type=ButtonSetting.class, required=false, inline=true), @ElementList(type=EnumSetting.class, required=false, inline=true), @ElementList(type=ReferenceSetting.class, required=false, inline=true), @ElementList(type=StructSetting.class, required=false, inline=true), @ElementList(type=BoolSetting.class, required=false, inline=true), @ElementList(type=FloatSetting.class, required=false, inline=true), @ElementList(type=StringSetting.class, required=false, inline=true), @ElementList(type=IntegerSetting.class, required=false, inline=true)})
    private void setSettingsList(List<ISetting> settingsList) {
        this.addSettings(settingsList);
    }

    @Deprecated
    protected ConfigSet() {
        this("", null, null, "", null);
    }

    public ConfigSet(String id, @Nullable String uiName, @Nullable String uiNameExpr, String source, @Nullable Description description) {
        this(id, uiName, uiNameExpr, source, description, null, null, null, null);
    }

    public ConfigSet(String id, @Nullable String uiName, @Nullable String uiNameExpr, String source, @Nullable Description description, @Nullable String available, @Nullable String enable, @Nullable String options, @Nullable OptionsExpr optionExpr) {
        super(id, uiName, uiNameExpr, description, available, enable, options, optionExpr);
        if (uiName == null && uiNameExpr == null) {
            this.setUINameString(id);
        }
        this.source = source;
        this.userTypes = new LinkedHashMap();
        this.settings = new LinkedHashMap();
        this.generatedTypes = new LinkedHashMap();
        this.qsGroup = new QuickSelectionsGroup();
        this.code = new Code();
        this.fragmentDefs = new FragmentDefs();
        this.validation = new Validation();
    }

    public void addGeneratedType(ISetting newType) {
        if (this.generatedTypes.put(newType.getId(), newType) != null && SWToolsProperties.isVerificationOn()) {
            LOGGER.severe(MessageFormat.format("[DATA] Duplicate element ID {0} detected inside {1} - only last element is used.", new Object[]{newType.getId(), this}));
        }
    }

    public void addGeneratedTypes(LinkedHashMap<String, ISetting> newGeneratedTypes) {
        newGeneratedTypes.values().stream().forEachOrdered(generatedType -> this.addGeneratedType((ISetting)generatedType));
    }

    public void addGeneratedTypes(List<ISetting> newGeneratedTypes) {
        newGeneratedTypes.stream().forEachOrdered(generatedType -> this.addGeneratedType((ISetting)generatedType));
    }

    public void addUserType(ISetting newType) {
        if (this.userTypes.put(newType.getId(), newType) != null && SWToolsProperties.isVerificationOn()) {
            LOGGER.severe(MessageFormat.format("[DATA] Duplicate element ID {0} detected inside {1} - only last element is used.", new Object[]{newType.getId(), this}));
        }
    }

    public void addUserTypes(LinkedHashMap<String, ISetting> newUserTypes) {
        newUserTypes.values().stream().forEachOrdered(userType -> this.addUserType((ISetting)userType));
    }

    public void addUserTypes(List<ISetting> newUserTypes) {
        newUserTypes.stream().forEachOrdered(userType -> this.addUserType((ISetting)userType));
    }

    public void addSetting(ISetting setting) {
        if (this.settings.put(setting.getId(), setting) != null && SWToolsProperties.isVerificationOn()) {
            LOGGER.severe(MessageFormat.format("[DATA] Duplicate element ID {0} detected inside {1} - only last element is used.", new Object[]{setting.getId(), this}));
        }
    }

    public void addSettings(LinkedHashMap<String, ISetting> newSettings) {
        newSettings.values().stream().forEachOrdered(setting -> this.addSetting((ISetting)setting));
    }

    public void addSettings(List<ISetting> newSettings) {
        newSettings.stream().forEachOrdered(setting -> this.addSetting((ISetting)setting));
    }

    public void setCode(Code newCode) {
        this.code = newCode;
    }

    public void setFragmentDefs(FragmentDefs newFragmentDefs) {
        this.fragmentDefs = newFragmentDefs;
    }

    public void setValidation(Validation validation) {
        this.validation = validation;
    }

    public List<IQuickSelection> getQuickSelections() {
        return this.qsGroup.getQuickSelections();
    }

    public boolean hasQuickSelections() {
        return true;
    }

    public @Nullable IQuickSelection getQuickSelection(String qsId) {
        return (IQuickSelection)CollectionsUtils.nullableOptionalGet(this.qsGroup.getQuickSelections().stream().filter(x -> x.getId().equals(qsId)).findFirst());
    }

    public List<IQuickSelection> getDefaultQS() {
        return this.qsGroup.getDefaultQS();
    }

    public @Nullable String getDefaultQuickSelectionId() {
        return this.qsGroup.getDefaultQuickSelectionId();
    }

    public Map<String, ISetting> getSettings() {
        return this.settings;
    }

    public Map<String, ISetting> getUserTypes() {
        return this.userTypes;
    }

    public Map<String, ISetting> getGeneratedTypes() {
        return this.generatedTypes;
    }

    public String getSource() {
        return this.source;
    }

    public Code getCode() {
        return this.code;
    }

    public FragmentDefs getFragmentDefs() {
        return this.fragmentDefs;
    }

    public Validation getValidation() {
        return this.validation;
    }

    public @Nullable ISetting find(String ... settingId) {
        ISetting refSetting = null;
        String[] stringArray = settingId;
        int n = settingId.length;
        int n2 = 0;
        while (n2 < n) {
            String splitIdPart = stringArray[n2];
            if (refSetting instanceof ArraySetting) {
                refSetting = ((ArraySetting)refSetting).getReferenceType();
            } else if (refSetting instanceof ACollectionSetting) {
                refSetting = ((ACollectionSetting)refSetting).getSetting(splitIdPart);
            } else {
                ISetting iSetting = refSetting = refSetting == null ? this.find(splitIdPart) : null;
            }
            if (refSetting == null) break;
            ++n2;
        }
        return refSetting;
    }

    private @Nullable ISetting find(String settingId) {
        String[] settingIds;
        int arraySize;
        ISetting setting = null;
        setting = this.settings.get(settingId);
        if (setting == null) {
            setting = this.userTypes.get(settingId);
        }
        if (setting == null) {
            setting = this.generatedTypes.get(settingId);
        }
        if (setting == null && settingId.startsWith("related_settings_auto") && (arraySize = (settingIds = settingId.split("\\.")).length) != 1) {
            String id = settingIds[--arraySize];
            while (arraySize != 1 && setting == null) {
                setting = this.getAllRelatedSettings().get(id);
                id = SettingUtils.buildId((String[])new String[]{settingIds[--arraySize], id});
            }
        }
        return setting;
    }

    public void removeGenTypes() {
        this.generatedTypes.clear();
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "[" + super.toString() + ", " + "from_source" + "=" + this.getSource() + ", " + "settings" + "(fst " + 3 + ")=" + CollectionsUtils.firstN(this.getSettingsList(), (int)3) + ", " + "quick_selections" + "=" + this.qsGroup + ", " + "code" + "=" + this.getCode() + ", " + "fragment_defs" + "=" + this.getFragmentDefs() + ", " + "validation" + "=" + this.getValidation() + "]";
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.generatedTypes.hashCode();
        result = 31 * result + this.qsGroup.hashCode();
        result = 31 * result + this.settings.hashCode();
        result = 31 * result + this.source.hashCode();
        result = 31 * result + this.userTypes.hashCode();
        result = 31 * result + this.code.hashCode();
        result = 31 * result + this.fragmentDefs.hashCode();
        result = 31 * result + this.validation.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        ConfigSet other = (ConfigSet)((Object)obj);
        if (!this.source.equals(other.source)) {
            return false;
        }
        if (!this.generatedTypes.equals(other.generatedTypes)) {
            return false;
        }
        if (!this.qsGroup.equals((Object)other.qsGroup)) {
            return false;
        }
        if (!this.settings.equals(other.settings)) {
            return false;
        }
        if (!this.userTypes.equals(other.userTypes)) {
            return false;
        }
        if (!this.code.equals(other.code)) {
            return false;
        }
        if (!this.fragmentDefs.equals(other.fragmentDefs)) {
            return false;
        }
        return this.validation.equals((Object)other.validation);
    }

    public void resolve(IActiveContextRefResolver sdkRefResolver, @Nullable IConfigurationComponent comp, String setID) {
        sdkRefResolver.resolve((IID)this, this.settings, comp, setID);
    }

    public void resolveRelatedSettings(IActiveContextRefResolver sdkRefResolver, @Nullable IConfigurationComponent comp, String configSetID, Map<String, ISetting> allRelSettings) {
        super.resolveRelatedSettings(sdkRefResolver, comp, configSetID, allRelSettings);
        this.settings.values().forEach(setting -> setting.resolveRelatedSettings(sdkRefResolver, comp, configSetID, allRelSettings));
    }

    @Commit
    public void commit() {
        super.commit();
        this.verify();
    }

    public void verify() {
        if (SWToolsProperties.isVerificationOn() && this.isOptionSet("UI_BORDER_HIDDEN") && this.isOptionSet("UI_LABEL_HIDDEN") && !this.getValidation().getConstraints().isEmpty()) {
            LOGGER.severe("[DATA] Setting with id: " + this.getId() + " has defined options: " + "UI_BORDER_HIDDEN" + " and " + "UI_LABEL_HIDDEN" + ", therefore it cannot contain any validations");
        }
    }

    public boolean addQuickSelection(IQuickSelection selection) {
        return this.qsGroup.addQuickSelection(selection);
    }

    public void setDefaultQS(IQuickSelection selection) {
        this.qsGroup.setDefaultQS(selection);
    }

    public void setDefaultQuickSelectionById(@Nullable String qsId) {
        this.qsGroup.setDefaultQuickSelectionById(qsId);
    }

    public QuickSelectionsGroup getQsGroup() {
        return this.qsGroup;
    }

    public IConfigSet createCopy(String id, @Nullable String uiName, @Nullable String uiNameExpr, String sourceLoc, @Nullable String availableExprString, @Nullable String enableExprString) {
        ConfigSet newConfigSet = new ConfigSet(id, uiName != null ? uiName : this.getUINameString(), uiNameExpr != null ? uiNameExpr : this.getUINameExprString(), !sourceLoc.isEmpty() ? sourceLoc : this.getSource(), this.getDescription(), availableExprString != null ? availableExprString : this.getAvailableExprString(), enableExprString != null ? enableExprString : this.getEnableExprString(), this.getOptions(), this.getOptionsExpression());
        newConfigSet.generatedTypes = new LinkedHashMap<String, ISetting>(this.generatedTypes);
        newConfigSet.userTypes = new LinkedHashMap<String, ISetting>(this.userTypes);
        newConfigSet.settings = new LinkedHashMap<String, ISetting>(this.settings);
        newConfigSet.qsGroup = new QuickSelectionsGroup(this.qsGroup);
        newConfigSet.code = new Code(this.code);
        newConfigSet.fragmentDefs = new FragmentDefs(this.fragmentDefs);
        newConfigSet.validation = new Validation(this.validation);
        return newConfigSet;
    }

    public void mergeWith(IConfigSet anotherConfigSet) {
        Description descriptionLoc = anotherConfigSet.getDescription();
        if (descriptionLoc != null) {
            this.setDescription(descriptionLoc);
        }
        this.getOptionsMap().mergeWith(anotherConfigSet.getOptionsMap());
        this.generatedTypes.putAll(anotherConfigSet.getGeneratedTypes());
        this.userTypes.putAll(anotherConfigSet.getUserTypes());
        this.settings.putAll(anotherConfigSet.getSettings());
        anotherConfigSet.getQsGroup().getQuickSelections().forEach(x -> {
            boolean bl = this.qsGroup.addQuickSelection(x);
        });
        this.qsGroup.setDefaultQuickSelectionById(anotherConfigSet.getQsGroup().getDefaultQuickSelectionId());
        this.validation.mergeWith(anotherConfigSet.getValidation());
    }

    public Map<String, ISetting> getAllRelatedSettings() {
        return this.allRelatedSettings;
    }

    public void setAllRelatedSettings(Map<String, ISetting> allRelSettings) {
        this.allRelatedSettings = new LinkedHashMap<String, ISetting>(allRelSettings);
    }
}

