/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.common.uct.svd.utils;

import com.nxp.swtools.common.uct.svd.utils.AccessMode;
import com.nxp.swtools.common.uct.svd.utils.BitFieldInfo;
import com.nxp.swtools.common.uct.svd.utils.ClusterInfo;
import com.nxp.swtools.common.uct.svd.utils.EnumeratedValuesInfo;
import com.nxp.swtools.common.uct.svd.utils.PeripheralInfo;
import com.nxp.swtools.common.uct.svd.utils.RegisterInfo;
import com.nxp.swtools.common.uct.utils.Messages;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ContentProvider {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ContentProvider.class);
    @NonNull
    private static final String INDEX_PATTERN = "[%s]";
    @NonNull
    private static final String DEVICE_TAG = "device";
    @NonNull
    private static final String NAME_TAG = "name";
    @NonNull
    private static final String DESCRIPTION_TAG = "description";
    @NonNull
    private static final String ACCESS_TAG = "access";
    @NonNull
    private static final String SIZE_TAG = "size";
    @NonNull
    private static final String DERIVED_FROM_ATTRIBUTE = "derivedFrom";
    @NonNull
    private static final String PERIPHERAL_TAG = "peripheral";
    @NonNull
    private static final String PERIPHERAL_BASE_ADDRESS_TAG = "baseAddress";
    @NonNull
    private static final String PERIPHERAL_ADDRESS_BLOCK_TAG = "addressBlock";
    @NonNull
    private static final String PERIPHERAL_OFFSET_TAG = "offset";
    @NonNull
    private static final String REGISTER_TAG = "register";
    @NonNull
    private static final String CLUSTER_TAG = "cluster";
    @NonNull
    private static final String ADDRESS_OFFSET_TAG = "addressOffset";
    @NonNull
    private static final String DIM_TAG = "dim";
    @NonNull
    private static final String DIM_INCREMENT_TAG = "dimIncrement";
    @NonNull
    private static final String DIM_INDEX_TAG = "dimIndex";
    @NonNull
    private static final String REGISTER_RESET_VALUE_TAG = "resetValue";
    @NonNull
    private static final String BITFIELD_TAG = "field";
    @NonNull
    private static final String BITFIELD_OFFSET_TAG = "bitOffset";
    @NonNull
    private static final String BITFIELD_WIDTH_TAG = "bitWidth";
    @NonNull
    private static final String ENUMERATED_FIELD_TAG = "enumeratedValue";
    @NonNull
    private static final String ENUMERATED_FIELD_VALUE_TAG = "value";
    @NonNull
    private static final String ACCESS_READ_WRITE_STRING = "read-write";
    @NonNull
    private static final String ACCESS_READ_ONLY_STRING = "read-only";
    @NonNull
    private static final String ACCESS_WRITE_ONLY_STRING = "write-only";
    @NonNull
    private static final String TARGET_MODULE_TAG = "targetModule";
    @NonNull
    private static final String TRIPLE_VOTING_TAG = "tripleVoting";
    @NonNull
    private static final String SPREAD_TRIPLE_VOTING_TAG = "spreadTripleVoting";
    @NonNull
    private static final String SECOND_WRITE_TAG = "secondWrite";
    @NonNull
    private static final String WRITE_ONCE_ONLY_TAG = "writeOnceOnly";
    @NonNull
    private static final String WRITE_ZERO_ONLY_TAG = "writeZeroOnly";
    @NonNull
    private static final String WRITE_ONE_ONLY_TAG = "writeOneOnly";
    @NonNull
    private static final String CHIP_SELECT_TAG = "chipSelect";
    @NonNull
    private static final String ADDRESS_TAG = "address";
    @NonNull
    private static final String PARITY_TAG = "parity";
    private boolean bPeripheral = false;
    private boolean bPeriphName = false;
    private boolean bPeriphBaseAddress = false;
    private boolean bPeriphAddressBlock = false;
    private boolean bPeriphOffset = false;
    private boolean bPeriphSize = false;
    private boolean bRegister = false;
    private boolean bCluster = false;
    private boolean bRegDim = false;
    private boolean bRegDimIncrement = false;
    private boolean bRegDimIndex = false;
    private boolean bRegName = false;
    private boolean bClusterName = false;
    private boolean bRegDescription = false;
    private boolean bRegSize = false;
    private boolean bRegOffset = false;
    private boolean bRegAccess = false;
    private boolean bRegResetValue = false;
    private boolean bField = false;
    private boolean bFieldDescription = false;
    private boolean bFieldName = false;
    private boolean bFieldOffset = false;
    private boolean bFieldWidth = false;
    private boolean bFieldAccess = false;
    private boolean bEnumeratedField = false;
    private boolean bEnumeratedFieldName = false;
    private boolean bEnumeratedFieldDescription = false;
    private boolean bEnumeratedFieldValue = false;
    private boolean bPeripheralDerivedFrom = false;
    private boolean bRegTargetModule = false;
    private boolean bRegTripleVoting = false;
    private boolean bRegSpreadTripleVoting = false;
    private boolean bRegSecondWrite = false;
    private boolean bRegWriteOnceOnly = false;
    private boolean bRegWriteZeroOnly = false;
    private boolean bRegWriteOneOnly = false;
    private boolean bRegChipSelect = false;
    private boolean bRegAddress = false;
    private boolean bRegParity = false;
    private static ContentProvider instance;
    @NonNull
    private @NonNull Map<@NonNull String, @NonNull PeripheralInfo> peripherals;
    @NonNull
    private @NonNull Map<@NonNull String, @NonNull RegisterInfo> registers;
    @Nullable
    private ClusterInfo tempCluster;
    @Nullable
    private PeripheralInfo tempPeripheral;
    @Nullable
    private RegisterInfo tempRegister;
    @Nullable
    private BitFieldInfo tempBitField;
    @Nullable
    private EnumeratedValuesInfo tempEnumeratedValue;
    @Nullable
    private String dim;
    @Nullable
    private String dimIncrement;
    @Nullable
    private String dimIndex;
    @Nullable
    private String peripheralDerivedFrom;
    @NonNull
    private @NonNull List<@NonNull ClusterInfo> clusters;
    @NonNull
    private BooleanProperty contentValid = new SimpleBooleanProperty();
    @NonNull
    private String mcuName = "";
    @NonNull
    private String sdkVersion = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @NonNull ContentProvider getInstance() {
        Class<ContentProvider> clazz = ContentProvider.class;
        synchronized (ContentProvider.class) {
            if (instance == null) {
                instance = new ContentProvider();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            assert (instance != null);
            return instance;
        }
    }

    private ContentProvider() {
        this.peripherals = new HashMap<String, PeripheralInfo>();
        this.registers = new HashMap<String, RegisterInfo>();
        this.clusters = new ArrayList<ClusterInfo>();
    }

    public void parseDocument(@NonNull String file, @NonNull String mcuName, @NonNull String sdkVersion) {
        if (mcuName.equals(this.mcuName) && this.sdkVersion.equals(sdkVersion)) {
            return;
        }
        this.mcuName = mcuName;
        this.sdkVersion = sdkVersion;
        this.contentValid.set(false);
        this.peripherals.clear();
        this.clusters.clear();
        this.registers.clear();
        File registersFile = new File(file);
        if (!file.isEmpty() && registersFile.exists()) {
            Display display = Display.getCurrent();
            if (SWToolsProperties.isHeadlessOn() || display == null) {
                this.loadRegistersFromFileHeadlessMode(registersFile);
            } else {
                this.loadRegistersFromFile(registersFile);
            }
        } else {
            LOGGER.log(Level.WARNING, "Error while parsing file. File not found");
        }
    }

    private void loadRegistersFromFile(@NonNull File registersFile) {
        Shell shell = new Shell(Display.getCurrent());
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(shell);
        pmd.setCancelable(false);
        pmd.create();
        try {
            pmd.run(true, false, monitor -> {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (InputStream registersInSTr = UtilsDecryption.getFileInputStream((File)registersFile);){
                        try {
                            XMLInputFactory factory = XMLInputFactory.newInstance();
                            XMLStreamReader reader = factory.createXMLStreamReader(registersInSTr);
                            monitor.beginTask(Messages.Msg_LoadingRegistersDb, -1);
                            while (reader.hasNext()) {
                                int event = reader.next();
                                switch (event) {
                                    case 1: {
                                        this.startElement(reader.getName().toString(), reader.getAttributeValue(null, DERIVED_FROM_ATTRIBUTE));
                                        break;
                                    }
                                    case 4: {
                                        String text = reader.getText().trim();
                                        if (text.isEmpty()) break;
                                        this.characters(text);
                                        break;
                                    }
                                    case 2: {
                                        this.endElement(reader.getName().toString());
                                    }
                                }
                            }
                            reader.close();
                        }
                        catch (XMLStreamException se) {
                            LOGGER.log(Level.WARNING, "Error while parsing file ", se);
                        }
                        catch (Exception ie) {
                            LOGGER.log(Level.WARNING, "Error while parsing file ", ie);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error while parsing file ", e);
                }
                monitor.done();
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            LOGGER.log(Level.WARNING, "Error while parsing file ", e);
        }
    }

    private void loadRegistersFromFileHeadlessMode(@NonNull File registersFile) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream registersInSTr = UtilsDecryption.getFileInputStream((File)registersFile);){
                try {
                    XMLInputFactory factory = XMLInputFactory.newInstance();
                    XMLStreamReader reader = factory.createXMLStreamReader(registersInSTr);
                    while (reader.hasNext()) {
                        int event = reader.next();
                        switch (event) {
                            case 1: {
                                this.startElement(reader.getName().toString(), reader.getAttributeValue(null, DERIVED_FROM_ATTRIBUTE));
                                break;
                            }
                            case 4: {
                                String text = reader.getText().trim();
                                if (text.isEmpty()) break;
                                this.characters(text);
                                break;
                            }
                            case 2: {
                                this.endElement(reader.getName().toString());
                            }
                        }
                    }
                    reader.close();
                }
                catch (XMLStreamException se) {
                    LOGGER.log(Level.WARNING, "Error while parsing file ", se);
                }
                catch (Exception ie) {
                    LOGGER.log(Level.WARNING, "Error while parsing file ", ie);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error while parsing file ", e);
        }
    }

    public void startElement(String qName, String attribute) {
        if (ENUMERATED_FIELD_TAG.equalsIgnoreCase(qName)) {
            this.tempEnumeratedValue = new EnumeratedValuesInfo();
            this.bEnumeratedField = true;
        } else if (BITFIELD_TAG.equalsIgnoreCase(qName)) {
            this.tempBitField = new BitFieldInfo();
            this.bField = true;
        } else if (REGISTER_TAG.equalsIgnoreCase(qName)) {
            this.tempRegister = new RegisterInfo();
            this.bRegister = true;
        } else if (CLUSTER_TAG.equalsIgnoreCase(qName)) {
            this.bCluster = true;
            if (this.tempCluster != null) {
                ClusterInfo childCluster = new ClusterInfo();
                assert (this.tempCluster != null);
                this.tempCluster.setChildCluster(childCluster);
                childCluster.setParentCluster(this.tempCluster);
                childCluster.setChildCluster(null);
                this.tempCluster = childCluster;
            } else {
                this.tempCluster = new ClusterInfo();
                this.tempCluster.setParentCluster(null);
                assert (this.tempCluster != null);
                this.clusters.add(this.tempCluster);
            }
        } else if (PERIPHERAL_TAG.equalsIgnoreCase(qName)) {
            if (attribute != null) {
                this.bPeripheralDerivedFrom = true;
                this.peripheralDerivedFrom = attribute;
            }
            this.tempPeripheral = new PeripheralInfo();
            this.bPeripheral = true;
        } else if (NAME_TAG.equalsIgnoreCase(qName)) {
            if (this.bEnumeratedField) {
                this.bEnumeratedFieldName = true;
            } else if (this.bField) {
                this.bFieldName = true;
            } else if (this.bRegister) {
                this.bRegName = true;
            } else if (this.bCluster) {
                this.bClusterName = true;
            } else if (this.bPeripheral) {
                this.bPeriphName = true;
            }
        } else if (DESCRIPTION_TAG.equalsIgnoreCase(qName)) {
            if (this.bEnumeratedField) {
                this.bEnumeratedFieldDescription = true;
            } else if (this.bField) {
                this.bFieldDescription = true;
            } else if (this.bRegister) {
                this.bRegDescription = true;
            }
        } else if (ACCESS_TAG.equalsIgnoreCase(qName)) {
            if (this.bField) {
                this.bFieldAccess = true;
            } else if (this.bRegister) {
                this.bRegAccess = true;
            }
        } else if (SIZE_TAG.equalsIgnoreCase(qName)) {
            if (this.bPeriphAddressBlock) {
                this.bPeriphSize = true;
            } else if (this.bRegister) {
                this.bRegSize = true;
            }
        } else if (REGISTER_RESET_VALUE_TAG.equals(qName)) {
            if (this.bRegister) {
                this.bRegResetValue = true;
            }
        } else if (ENUMERATED_FIELD_VALUE_TAG.equalsIgnoreCase(qName)) {
            this.bEnumeratedFieldValue = true;
        } else if (BITFIELD_OFFSET_TAG.equalsIgnoreCase(qName)) {
            if (this.bField) {
                this.bFieldOffset = true;
            }
        } else if (BITFIELD_WIDTH_TAG.equalsIgnoreCase(qName)) {
            if (this.bField) {
                this.bFieldWidth = true;
            }
        } else if (ADDRESS_OFFSET_TAG.equalsIgnoreCase(qName)) {
            if (this.bRegister || this.bCluster) {
                this.bRegOffset = true;
            }
        } else if (PERIPHERAL_BASE_ADDRESS_TAG.equalsIgnoreCase(qName)) {
            if (this.bPeripheral) {
                this.bPeriphBaseAddress = true;
            }
        } else if (PERIPHERAL_ADDRESS_BLOCK_TAG.equalsIgnoreCase(qName)) {
            if (this.bPeripheral) {
                this.bPeriphAddressBlock = true;
            }
        } else if (PERIPHERAL_OFFSET_TAG.equalsIgnoreCase(qName)) {
            if (this.bPeriphAddressBlock) {
                this.bPeriphOffset = true;
            }
        } else if (DEVICE_TAG.equalsIgnoreCase(qName)) {
            this.contentValid.set(false);
        } else if (DIM_TAG.equalsIgnoreCase(qName)) {
            if (this.bRegister || this.bCluster) {
                this.bRegDim = true;
            }
        } else if (DIM_INCREMENT_TAG.equalsIgnoreCase(qName)) {
            if (this.bRegister || this.bCluster) {
                this.bRegDimIncrement = true;
            }
        } else if (DIM_INDEX_TAG.equalsIgnoreCase(qName)) {
            if (this.bRegister || this.bCluster) {
                this.bRegDimIndex = true;
            }
        } else if (TARGET_MODULE_TAG.equalsIgnoreCase(qName)) {
            if (this.bRegister) {
                this.bRegTargetModule = true;
            }
        } else if (TRIPLE_VOTING_TAG.equalsIgnoreCase(qName)) {
            if (this.bRegister) {
                this.bRegTripleVoting = true;
            }
        } else if (SPREAD_TRIPLE_VOTING_TAG.equalsIgnoreCase(qName)) {
            if (this.bRegister) {
                this.bRegSpreadTripleVoting = true;
            }
        } else if (SECOND_WRITE_TAG.equalsIgnoreCase(qName)) {
            if (this.bRegister) {
                this.bRegSecondWrite = true;
            }
        } else if (WRITE_ONCE_ONLY_TAG.equalsIgnoreCase(qName)) {
            if (this.bRegister) {
                this.bRegWriteOnceOnly = true;
            }
        } else if (WRITE_ZERO_ONLY_TAG.equalsIgnoreCase(qName)) {
            if (this.bRegister) {
                this.bRegWriteZeroOnly = true;
            }
        } else if (WRITE_ONE_ONLY_TAG.equalsIgnoreCase(qName)) {
            if (this.bRegister) {
                this.bRegWriteOneOnly = true;
            }
        } else if (CHIP_SELECT_TAG.equalsIgnoreCase(qName)) {
            if (this.bRegister) {
                this.bRegChipSelect = true;
            }
        } else if (ADDRESS_TAG.equalsIgnoreCase(qName)) {
            if (this.bRegister) {
                this.bRegAddress = true;
            }
        } else if (PARITY_TAG.equalsIgnoreCase(qName) && this.bRegister) {
            this.bRegParity = true;
        }
    }

    public void endElement(String qName) {
        PeripheralInfo peripheral;
        if (DIM_TAG.equalsIgnoreCase(qName)) {
            this.bRegDim = false;
        } else if (DIM_INCREMENT_TAG.equalsIgnoreCase(qName)) {
            this.bRegDimIncrement = false;
        } else if (DIM_INDEX_TAG.equalsIgnoreCase(qName)) {
            this.bRegDimIndex = false;
        } else if (ENUMERATED_FIELD_TAG.equalsIgnoreCase(qName)) {
            if (this.tempBitField != null && this.tempEnumeratedValue != null) {
                EnumeratedValuesInfo enumeratedValue = this.tempEnumeratedValue;
                assert (this.tempBitField != null);
                this.tempBitField.getEnumeratedValues().put(enumeratedValue.getName(), enumeratedValue);
            }
            this.bEnumeratedField = false;
            this.bEnumeratedFieldName = false;
            this.bEnumeratedFieldDescription = false;
            this.bEnumeratedFieldValue = false;
        } else if (BITFIELD_TAG.equalsIgnoreCase(qName)) {
            if (this.tempRegister != null && this.tempBitField != null) {
                BitFieldInfo bitField = this.tempBitField;
                assert (this.tempRegister != null);
                this.tempRegister.getBitfields().put(bitField.getName(), bitField);
            }
            this.bField = false;
            this.bFieldAccess = false;
            this.bFieldDescription = false;
            this.bFieldName = false;
            this.bFieldOffset = false;
            this.bFieldWidth = false;
            this.bEnumeratedField = false;
        } else if (REGISTER_TAG.equalsIgnoreCase(qName)) {
            if (this.tempPeripheral != null && this.tempRegister != null) {
                peripheral = this.tempPeripheral;
                RegisterInfo register = this.tempRegister;
                assert (register != null);
                if (this.dim != null && this.dimIncrement != null) {
                    long registerOffset = Long.decode(register.getOffset());
                    assert (this.dimIncrement != null);
                    long increment = Long.decode(this.dimIncrement);
                    long offset = registerOffset;
                    long resetValue = Long.decode(register.getResetValue());
                    if (this.dimIndex != null) {
                        @NonNull String @NonNull [] indexes = this.dimIndex.split(",");
                        int index = 0;
                        while (index < indexes.length) {
                            String regIndex = indexes[index];
                            this.createRegisterInfo(register, regIndex, offset, resetValue, peripheral, this.bCluster);
                            offset += increment;
                            ++index;
                        }
                    } else {
                        int index = 0;
                        while (index < Integer.decode(Objects.requireNonNull(this.dim))) {
                            this.createRegisterInfo(register, UtilsText.safeString((String)Integer.toString(index)), offset, resetValue, peripheral, this.bCluster);
                            offset += increment;
                            ++index;
                        }
                    }
                    this.dim = null;
                    this.dimIncrement = null;
                    this.dimIndex = null;
                } else if (this.bCluster && !this.clusters.isEmpty()) {
                    this.clusters.get(this.clusters.size() - 1).addRegister(register);
                } else {
                    peripheral.getRegisters().put(register.getName(), register);
                }
            } else if (this.tempRegister != null) {
                this.registers.put(this.tempRegister.getName(), Objects.requireNonNull(this.tempRegister));
            }
            this.tempRegister = null;
            this.bRegister = false;
            this.bRegAccess = false;
            this.bRegDescription = false;
            this.bRegSize = false;
            this.bRegName = false;
            this.bRegOffset = false;
            this.bRegResetValue = false;
        } else if (CLUSTER_TAG.equalsIgnoreCase(qName)) {
            if (this.tempCluster != null && this.tempCluster.getParentCluster() != null) {
                assert (this.tempCluster != null);
                this.tempCluster = this.tempCluster.getParentCluster();
                this.bCluster = true;
            } else {
                this.bCluster = false;
                this.tempCluster = null;
            }
        }
        if (PERIPHERAL_TAG.equalsIgnoreCase(qName)) {
            if (this.tempPeripheral != null) {
                peripheral = this.tempPeripheral;
                if (this.bPeripheralDerivedFrom) {
                    long peripheralAddress = peripheral.getFullAddress();
                    long peripheralAddressLimit = peripheral.getFullAddressLimit();
                    PeripheralInfo derivedPeripheral = this.peripherals.get(this.peripheralDerivedFrom);
                    if (derivedPeripheral != null) {
                        for (RegisterInfo registerInfo : derivedPeripheral.getRegisters().values()) {
                            RegisterInfo tempReg = new RegisterInfo();
                            tempReg.setAccess(registerInfo.getAccess());
                            tempReg.setName(registerInfo.getName());
                            tempReg.setOffset(registerInfo.getOffset());
                            tempReg.setSize(registerInfo.getSize());
                            tempReg.setDescription(registerInfo.getDescription());
                            tempReg.setResetValue(registerInfo.getResetValue());
                            tempReg.getBitfields().putAll(registerInfo.getBitfields());
                            ContentProvider.setRegisterAddress(peripheral, tempReg);
                            long address = NumberFormatValidator.getLongValueFromString((String)tempReg.getAddress());
                            if (peripheralAddress > address || address >= peripheralAddressLimit) continue;
                            peripheral.getRegisters().put(tempReg.getName(), tempReg);
                        }
                    }
                }
                this.resolveClusters();
                this.peripherals.put(peripheral.getName(), peripheral);
            }
            this.tempPeripheral = null;
            this.bPeripheral = false;
            this.bPeriphAddressBlock = false;
            this.bPeriphBaseAddress = false;
            this.bPeriphName = false;
            this.bPeriphOffset = false;
            this.bPeriphSize = false;
            this.bPeripheralDerivedFrom = false;
        } else if (PERIPHERAL_ADDRESS_BLOCK_TAG.equalsIgnoreCase(qName)) {
            this.bPeriphAddressBlock = false;
            this.bPeripheral = false;
        } else if (DEVICE_TAG.equalsIgnoreCase(qName)) {
            this.contentValid.set(true);
        }
    }

    public void characters(String value) {
        if (this.bEnumeratedFieldName) {
            if (this.tempEnumeratedValue != null) {
                this.tempEnumeratedValue.setName(value);
            }
            this.bEnumeratedFieldName = false;
        }
        if (this.bEnumeratedFieldDescription) {
            if (this.tempEnumeratedValue != null) {
                this.tempEnumeratedValue.setDescription(value);
            }
            this.bEnumeratedFieldDescription = false;
        } else if (this.bEnumeratedFieldValue) {
            if (this.tempEnumeratedValue != null) {
                this.tempEnumeratedValue.setValue(value);
            }
            this.bEnumeratedFieldValue = false;
        } else if (this.bFieldAccess) {
            if (this.tempBitField != null) {
                if (value.equals(ACCESS_READ_WRITE_STRING) || value.equals(ACCESS_WRITE_ONLY_STRING)) {
                    assert (this.tempBitField != null);
                    this.tempBitField.setAccess(AccessMode.MODE_RW);
                } else if (value.equals(ACCESS_READ_ONLY_STRING)) {
                    assert (this.tempBitField != null);
                    this.tempBitField.setAccess(AccessMode.MODE_RO);
                }
            }
            this.bFieldAccess = false;
        } else if (this.bFieldDescription) {
            if (!this.bEnumeratedField) {
                if (this.tempBitField != null) {
                    this.tempBitField.setDescription(value);
                }
                this.bFieldDescription = false;
            }
        } else if (this.bFieldName) {
            if (!this.bEnumeratedField) {
                if (this.tempBitField != null) {
                    this.tempBitField.setName(value);
                }
                this.bFieldName = false;
            }
        } else if (this.bFieldOffset) {
            if (this.tempBitField != null) {
                this.tempBitField.setOffset(value);
            }
            this.bFieldOffset = false;
        } else if (this.bFieldWidth) {
            if (this.tempBitField != null) {
                this.tempBitField.setWidth(value);
            }
            this.bFieldWidth = false;
        } else if (this.bRegAccess) {
            if (this.tempRegister != null) {
                if (value.equals(ACCESS_READ_WRITE_STRING) || value.equals(ACCESS_WRITE_ONLY_STRING)) {
                    assert (this.tempRegister != null);
                    this.tempRegister.setAccess(AccessMode.MODE_RW);
                } else if (value.equals(ACCESS_READ_ONLY_STRING)) {
                    assert (this.tempRegister != null);
                    this.tempRegister.setAccess(AccessMode.MODE_RO);
                }
            }
            this.bRegAccess = false;
        } else if (this.bRegDescription) {
            if (this.tempRegister != null) {
                this.tempRegister.setDescription(value);
            }
            this.bRegDescription = false;
        } else if (this.bRegSize) {
            if (this.tempRegister != null) {
                this.tempRegister.setSize(value);
            }
            this.bRegSize = false;
        } else if (this.bRegName) {
            if (this.tempRegister != null) {
                this.tempRegister.setName(value);
            }
            this.bRegName = false;
        } else if (this.bClusterName) {
            if (this.tempCluster != null) {
                this.tempCluster.setName(value);
            }
            this.bClusterName = false;
        } else if (this.bRegOffset) {
            if (this.bCluster && this.tempCluster != null && !this.bRegister) {
                this.tempCluster.setAddressOffset(value);
            }
            if (this.tempRegister != null) {
                this.tempRegister.setOffset(value);
            }
            this.bRegOffset = false;
            if (this.tempPeripheral != null && this.tempRegister != null) {
                ContentProvider.setRegisterAddress(this.tempPeripheral, this.tempRegister);
            }
        } else if (this.bRegResetValue) {
            if (this.tempRegister != null) {
                this.tempRegister.setResetValue(value);
            }
            this.bRegResetValue = false;
        } else if (this.bPeriphName) {
            if (this.tempPeripheral != null) {
                this.tempPeripheral.setName(value);
            }
            this.bPeriphName = false;
        } else if (this.bPeriphBaseAddress) {
            if (this.tempPeripheral != null) {
                this.tempPeripheral.setBaseAddress(value);
            }
            this.bPeriphBaseAddress = false;
        } else if (this.bPeriphOffset) {
            if (this.tempPeripheral != null) {
                this.tempPeripheral.setOffset(value);
            }
            this.bPeriphOffset = false;
        } else if (this.bPeriphSize) {
            if (this.tempPeripheral != null) {
                this.tempPeripheral.setBlockSize(value);
            }
            this.bPeriphSize = false;
        } else if (this.bRegister || this.bCluster) {
            if (this.bRegDim) {
                if (this.bCluster && this.tempCluster != null && !this.bRegister) {
                    this.tempCluster.setDim(value);
                } else {
                    this.dim = value;
                }
            } else if (this.bRegDimIncrement) {
                if (this.bCluster && this.tempCluster != null && !this.bRegister) {
                    this.tempCluster.setDimIncrement(value);
                } else {
                    this.dimIncrement = value;
                }
            } else if (this.bRegDimIndex) {
                if (this.bCluster && this.tempCluster != null && !this.bRegister) {
                    this.tempCluster.setDimIndex(value);
                } else {
                    this.dimIndex = value;
                }
            } else if (this.bRegTargetModule) {
                if (this.tempRegister != null) {
                    this.tempRegister.setTargetModule(value);
                }
                this.bRegTargetModule = false;
            } else if (this.bRegTripleVoting) {
                if (this.tempRegister != null) {
                    this.tempRegister.setTripleVoting(Boolean.parseBoolean(value));
                }
                this.bRegTripleVoting = false;
            } else if (this.bRegSpreadTripleVoting) {
                if (this.tempRegister != null) {
                    this.tempRegister.setSpreadTripleVoting(Boolean.parseBoolean(value));
                }
                this.bRegSpreadTripleVoting = false;
            } else if (this.bRegSecondWrite) {
                if (this.tempRegister != null) {
                    this.tempRegister.setSecondWrite(Boolean.parseBoolean(value));
                }
                this.bRegSecondWrite = false;
            } else if (this.bRegWriteOnceOnly) {
                if (this.tempRegister != null) {
                    this.tempRegister.setWriteOnceOnly(Boolean.parseBoolean(value));
                }
                this.bRegWriteOnceOnly = false;
            } else if (this.bRegWriteZeroOnly) {
                if (this.tempRegister != null) {
                    this.tempRegister.setWriteZeroOnly(Boolean.parseBoolean(value));
                }
                this.bRegWriteZeroOnly = false;
            } else if (this.bRegWriteOneOnly) {
                if (this.tempRegister != null) {
                    this.tempRegister.setWriteOneOnly(Boolean.parseBoolean(value));
                }
                this.bRegWriteOneOnly = false;
            } else if (this.bRegChipSelect) {
                if (this.tempRegister != null) {
                    this.tempRegister.setChipSelect(Integer.parseInt(value));
                }
                this.bRegChipSelect = false;
            } else if (this.bRegAddress) {
                if (this.tempRegister != null) {
                    this.tempRegister.setAddress(value);
                }
                this.bRegAddress = false;
            } else if (this.bRegParity) {
                if (this.tempRegister != null) {
                    this.tempRegister.setParity(Boolean.parseBoolean(value));
                }
                this.bRegParity = false;
            }
        }
    }

    public synchronized @NonNull Map<@NonNull String, @NonNull PeripheralInfo> getPeripheralsList() {
        return this.peripherals;
    }

    public synchronized @NonNull Map<@NonNull String, @NonNull RegisterInfo> getRegistersList() {
        return this.registers;
    }

    public @NonNull BooleanProperty getContentValidProperty() {
        return this.contentValid;
    }

    private void createRegisterInfo(@NonNull RegisterInfo register, @NonNull String index, long offset, long resetValue, @NonNull PeripheralInfo peripheral, boolean inCluster) {
        String regName = ContentProvider.resolveRegisterName(register.getName(), index);
        RegisterInfo newReg = new RegisterInfo();
        newReg.setName(regName);
        newReg.setAccess(register.getAccess());
        newReg.setDescription(register.getDescription());
        newReg.setOffset(UtilsText.safeString((String)Long.toString(offset)));
        newReg.setSize(register.getSize());
        newReg.setResetValue(UtilsText.safeString((String)Long.toString(resetValue)));
        newReg.getBitfields().putAll(register.getBitfields());
        ContentProvider.setRegisterAddress(peripheral, newReg);
        if (inCluster && !this.clusters.isEmpty()) {
            this.clusters.get(this.clusters.size() - 1).addRegister(newReg);
        } else {
            peripheral.getRegisters().put(newReg.getName(), newReg);
        }
    }

    private static @NonNull RegisterInfo createRegisterInfoFromCluster(@NonNull RegisterInfo register, @NonNull String index, long offset, long resetValue, @NonNull PeripheralInfo peripheral, @NonNull ClusterInfo cluster) {
        String regName = ContentProvider.resolveRegisterNameByCluster(register.getName(), index, cluster);
        RegisterInfo newReg = new RegisterInfo();
        newReg.setName(regName);
        newReg.setAccess(register.getAccess());
        newReg.setDescription(register.getDescription());
        newReg.setOffset(UtilsText.safeString((String)Long.toString(offset)));
        newReg.setSize(register.getSize());
        newReg.setResetValue(UtilsText.safeString((String)Long.toString(resetValue)));
        newReg.getBitfields().putAll(register.getBitfields());
        ContentProvider.setRegisterAddress(peripheral, newReg);
        return newReg;
    }

    private static @NonNull String resolveRegisterName(@NonNull String regName, @NonNull String index) {
        if (regName.contains(INDEX_PATTERN)) {
            return regName.replace(INDEX_PATTERN, index);
        }
        if (regName.contains("%s")) {
            return regName.replace("%s", index);
        }
        return regName.concat(index);
    }

    private static @NonNull String resolveRegisterNameByCluster(@NonNull String regName, @NonNull String index, @NonNull ClusterInfo cluster) {
        String clusterName = cluster.getName();
        if (clusterName.endsWith(INDEX_PATTERN)) {
            if ((clusterName = clusterName.replace(INDEX_PATTERN, "")).matches(".*[A-Z]{1}[a-z]{1}")) {
                clusterName = clusterName.substring(0, clusterName.length() - 1);
            }
            if (cluster.getParentCluster() != null) {
                ClusterInfo parentCluster = cluster.getParentCluster();
                while (parentCluster != null) {
                    String parentName = parentCluster.getName();
                    if (parentName.endsWith(INDEX_PATTERN)) {
                        parentName = parentName.replace(INDEX_PATTERN, "");
                        clusterName = clusterName.replace(parentName, "");
                    }
                    parentCluster = parentCluster.getParentCluster();
                }
            }
        }
        if (!clusterName.isEmpty()) {
            String newRegName = regName.replace(clusterName, String.valueOf(clusterName) + index);
            if (newRegName.equals(regName)) {
                return regName.concat(index);
            }
            return newRegName;
        }
        return regName.concat(index);
    }

    private static void setRegisterAddress(@NonNull PeripheralInfo peripheral, @NonNull RegisterInfo register) {
        long peripheralAddress = peripheral.getFullAddress();
        String registerOffsetString = register.getOffset();
        long registerOffset = NumberFormatValidator.getLongValueFromString((String)registerOffsetString);
        if (peripheralAddress >= 0L && registerOffset >= 0L) {
            register.setAddress("0x" + Long.toHexString(peripheralAddress + registerOffset));
        }
    }

    private void resolveClusters() {
        PeripheralInfo peripheral;
        if (!this.clusters.isEmpty() && (peripheral = this.tempPeripheral) != null) {
            for (ClusterInfo cluster : this.clusters) {
                List<@NonNull RegisterInfo> registers = cluster.getRegisters();
                List<@NonNull RegisterInfo> createdRegisters = ContentProvider.parseRegisters(peripheral, registers, cluster);
                ClusterInfo childCluster = cluster.getChildCluster();
                while (childCluster != null) {
                    List<@NonNull RegisterInfo> newRegs = ContentProvider.parseRegisters(peripheral, createdRegisters, childCluster);
                    createdRegisters.clear();
                    createdRegisters.addAll(newRegs);
                    childCluster = childCluster.getChildCluster();
                }
                createdRegisters.stream().forEach(register -> {
                    RegisterInfo registerInfo = peripheral.getRegisters().put(register.getName(), (RegisterInfo)register);
                });
            }
        }
        this.clusters.clear();
        this.bCluster = false;
        this.tempCluster = null;
    }

    private static @NonNull List<@NonNull RegisterInfo> parseRegisters(@NonNull PeripheralInfo peripheral, @NonNull List<@NonNull RegisterInfo> registers, @NonNull ClusterInfo cluster) {
        ArrayList<@NonNull RegisterInfo> newRegisters = new ArrayList<RegisterInfo>();
        long clusterOffset = Long.decode(cluster.getAddressOffset());
        for (RegisterInfo register : registers) {
            String dimVal = cluster.getDim();
            String dimIndexVal = cluster.getDimIndex();
            String dimIncrVal = cluster.getDimIncrement();
            if (dimVal != null && dimIncrVal != null) {
                long registerOffset = Long.decode(register.getOffset());
                assert (dimIncrVal != null);
                long increment = Long.decode(dimIncrVal);
                long offset = registerOffset + clusterOffset;
                long resetValue = Long.decode(register.getResetValue());
                if (dimIndexVal != null) {
                    @NonNull String @NonNull [] indexes = dimIndexVal.split(",");
                    int index = 0;
                    while (index < indexes.length) {
                        String regIndex = indexes[index];
                        RegisterInfo reg = ContentProvider.createRegisterInfoFromCluster(register, regIndex, offset, resetValue, peripheral, cluster);
                        newRegisters.add(reg);
                        offset += increment;
                        ++index;
                    }
                    continue;
                }
                int index = 0;
                while (index < Integer.decode(Objects.requireNonNull(dimVal))) {
                    RegisterInfo reg = ContentProvider.createRegisterInfoFromCluster(register, UtilsText.safeString((String)Integer.toString(index)), offset, resetValue, peripheral, cluster);
                    newRegisters.add(reg);
                    offset += increment;
                    ++index;
                }
                continue;
            }
            long offset = Long.decode(register.getOffset()) + clusterOffset;
            register.setOffset(UtilsText.safeString((String)Long.toString(offset)));
            ContentProvider.setRegisterAddress(peripheral, register);
            newRegisters.add(register);
        }
        return newRegisters;
    }
}

