/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.common.uct.ui.xml.settings;

import com.nxp.swtools.common.uct.xml.settings.DisableState;
import com.nxp.swtools.common.uct.xml.settings.VisibleState;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.SimpleBooleanProperty;
import org.simpleframework.xml.Attribute;

public abstract class ABaseUIComponentSetting {
    @Attribute(name="id", required=true)
    private String id;
    @Attribute(name="label", required=false)
    private String label;
    @Attribute(name="row", required=false)
    private String row;
    @Attribute(name="column", required=false)
    private String column;
    @Attribute(name="value", required=false)
    private String initValue;
    @Attribute(name="action", required=false)
    private String action;
    @Attribute(name="type", required=false)
    private String type;
    @Attribute(name="constraint_ref", required=false)
    private String constraintRef;
    @Attribute(name="read_only", required=false)
    private boolean readOnly = false;
    @Attribute(name="value_expr", required=false)
    private String valueExpr;
    @Attribute(name="visible", required=false)
    private String initVisibleState;
    private SimpleBooleanProperty visibleProperty = new SimpleBooleanProperty(true);
    private Map<Integer, DisableState> disableStateConditions;
    private SimpleBooleanProperty disableProperty = new SimpleBooleanProperty(false);
    private String currentValue;
    @Nullable
    private VisibleState visibleStateCondition;
    @Nullable
    private DisableState disableStateCondition;

    public ABaseUIComponentSetting() {
        this.id = "";
        this.label = "";
        this.row = "";
        this.column = "";
        this.initValue = "";
        this.action = "";
        this.type = "";
        this.constraintRef = "";
        this.readOnly = false;
        this.valueExpr = "";
        this.visibleStateCondition = null;
        this.disableStateCondition = null;
        this.disableStateConditions = new HashMap<Integer, DisableState>();
        this.currentValue = "";
        this.initVisibleState = "";
    }

    public ABaseUIComponentSetting(String id, ABaseUIComponentSetting setting) {
        this.id = id;
        this.label = setting.label;
        this.row = setting.row;
        this.column = setting.column;
        this.initValue = setting.initValue;
        this.action = setting.action;
        this.type = setting.type;
        this.constraintRef = setting.constraintRef;
        this.readOnly = setting.readOnly;
        this.valueExpr = setting.valueExpr;
        this.visibleStateCondition = setting.visibleStateCondition;
        this.disableStateCondition = setting.disableStateCondition;
        this.disableStateConditions = new HashMap<Integer, DisableState>();
        this.currentValue = "";
        this.initVisibleState = setting.initVisibleState;
    }

    public ABaseUIComponentSetting(String id, String label, ABaseUIComponentSetting setting) {
        this.id = id;
        this.label = label;
        this.row = setting.row;
        this.column = setting.column;
        this.initValue = setting.initValue;
        this.action = setting.action;
        this.type = setting.type;
        this.constraintRef = setting.constraintRef;
        this.readOnly = setting.readOnly;
        this.valueExpr = setting.valueExpr;
        this.visibleStateCondition = setting.visibleStateCondition;
        this.disableStateCondition = setting.disableStateCondition;
        this.disableStateConditions = new HashMap<Integer, DisableState>();
        this.currentValue = "";
        this.initVisibleState = setting.initVisibleState;
    }

    public ABaseUIComponentSetting(String id, String label, String constraintRef, ABaseUIComponentSetting setting) {
        this.id = id;
        this.label = label;
        this.row = setting.row;
        this.column = setting.column;
        this.initValue = setting.initValue;
        this.action = setting.action;
        this.type = setting.type;
        this.constraintRef = constraintRef;
        this.readOnly = setting.readOnly;
        this.valueExpr = setting.valueExpr;
        this.visibleStateCondition = null;
        this.disableStateCondition = null;
        this.disableStateConditions = new HashMap<Integer, DisableState>();
        this.currentValue = "";
        this.initVisibleState = setting.initVisibleState;
    }

    public ABaseUIComponentSetting(String id, String label, String constraintRef, ABaseUIComponentSetting setting, String row, String column) {
        this.id = id;
        this.label = label;
        this.row = row;
        this.column = column;
        this.initValue = setting.initValue;
        this.action = setting.action;
        this.type = setting.type;
        this.constraintRef = constraintRef;
        this.readOnly = setting.readOnly;
        this.valueExpr = setting.valueExpr;
        this.visibleStateCondition = null;
        this.disableStateCondition = null;
        this.disableStateConditions = new HashMap<Integer, DisableState>();
        this.currentValue = "";
        this.initVisibleState = setting.initVisibleState;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getRowStrValue() {
        return this.row;
    }

    public String getColumnStrValue() {
        return this.column;
    }

    public int getRow() {
        return NumberFormatValidator.getIntValueFromString((String)this.row);
    }

    public int getColumn() {
        return NumberFormatValidator.getIntValueFromString((String)this.column);
    }

    public String getInitValue() {
        return this.initValue;
    }

    public String getVisibleAttribute() {
        return this.initVisibleState;
    }

    public boolean getInitVisibleState() {
        return !this.initVisibleState.isEmpty() ? this.initVisibleState.equals("true") : true;
    }

    public String getAction() {
        return this.action;
    }

    public String getTypeComponentId() {
        return this.type;
    }

    public String getConstraintsRef() {
        return this.constraintRef;
    }

    public String[] getConstraintsReferences() {
        return this.constraintRef.split("\\;");
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public String getValueExpression() {
        return this.valueExpr;
    }

    public void setVisibleState(boolean state) {
        this.visibleProperty.set(state);
    }

    public boolean isVisible() {
        return this.visibleProperty.get();
    }

    public Map<Integer, DisableState> getConditionsForDisableState() {
        return this.disableStateConditions;
    }

    public void setDisableState(boolean state) {
        this.disableProperty.set(state);
    }

    public @Nullable VisibleState getVisibleStateCondition() {
        return this.visibleStateCondition;
    }

    public void setVisibleStateCondition(VisibleState visibleStateCondition) {
        this.visibleStateCondition = visibleStateCondition;
    }

    public @Nullable DisableState getDisableStateCondition() {
        return this.disableStateCondition;
    }

    public void setDisableStateCondition(DisableState disableStateCondition) {
        this.disableStateCondition = disableStateCondition;
    }

    public boolean isDisabled() {
        return this.disableProperty.get();
    }

    public void setCurrentValue(String currentValue) {
        this.currentValue = currentValue;
    }

    public String getCurrentValue() {
        return this.currentValue;
    }

    public abstract long getValueToWrite();
}

