/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.common.uct.utils;

import com.nxp.swtools.common.uct.mcu.IMcu;
import com.nxp.swtools.common.uct.svd.utils.AccessMode;
import com.nxp.swtools.common.uct.svd.utils.BitFieldInfo;
import com.nxp.swtools.common.uct.svd.utils.PeripheralInfo;
import com.nxp.swtools.common.uct.svd.utils.RegisterInfo;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.BoolSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.EnumSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.IntegerSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.ItemSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.StructSetting;
import com.nxp.swtools.common.uct.utils.CustomMap;
import com.nxp.swtools.common.uct.utils.UctXmlSettingsUtils;
import com.nxp.swtools.common.uct.xml.settings.DisableState;
import com.nxp.swtools.common.uct.xml.settings.VisibleState;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.frequency.FrequencyUnit;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.time.TimeUnit;
import com.nxp.swtools.core.service.scriptapi.db.IRegBitFieldAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegParentPeripheralAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegisterAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UctUtils {
    private static final Logger LOGGER = LogManager.getLogger(UctUtils.class);
    public static final Pattern PARENTHESIS_GROUP_REGEX = Pattern.compile("\\((.*?)\\)", 8);

    public static long getBitsMaskValue(int offset, int bitsLength) {
        byte[] maskBuffer = new byte[64];
        int i = 0;
        while (i < bitsLength) {
            maskBuffer[63 - offset + i] = 1;
            ++i;
        }
        long maskValue = 0L;
        int i2 = 0;
        while (i2 < 64) {
            maskValue = (maskValue << 1) + (long)maskBuffer[i2];
            ++i2;
        }
        return maskValue;
    }

    public static byte[] getBytesFromBuffer(ByteBuffer bytesBuffer, int offset, int size) {
        byte[] bytes = new byte[size];
        if (bytesBuffer.hasArray()) {
            System.arraycopy(bytesBuffer.array(), offset, bytes, 0, size);
        }
        return bytes;
    }

    public static long getLongValueFromByteArray(byte[] buffer, int offset, int size) {
        long value = 0L;
        int i = 0;
        while (i < size) {
            value = (value << 8) + (long)(buffer[offset + i] & 0xFF);
            ++i;
        }
        return value;
    }

    public static long getLongValueFromString(String valueStr) {
        if (NumberFormatValidator.isValidXmlHexFormat((String)valueStr)) {
            return NumberFormatValidator.getDecimalLongFromXmlHex((String)valueStr);
        }
        return NumberFormatValidator.getLongValueFromString((String)valueStr);
    }

    public static List<String> getAllAndConditions(String condition) {
        String[] tempValuesBuffer;
        ArrayList<String> allConditions = new ArrayList<String>();
        String[] stringArray = tempValuesBuffer = condition.split("\\ And ");
        int n = tempValuesBuffer.length;
        int n2 = 0;
        while (n2 < n) {
            String tempStr = stringArray[n2];
            allConditions.add(tempStr);
            ++n2;
        }
        return allConditions;
    }

    public static long getUIComponentDefaultValue(ABaseUIComponentSetting componentSetting) {
        long defaultValue = 0L;
        if (componentSetting instanceof BoolSetting) {
            BoolSetting boolSetting = (BoolSetting)componentSetting;
            defaultValue = boolSetting.getDefaultValue() ? 1L : 0L;
        } else if (componentSetting instanceof EnumSetting) {
            EnumSetting enumSetting = (EnumSetting)componentSetting;
            ItemSetting defaultSelectedItem = enumSetting.getItemById(enumSetting.getInitValue());
            if (defaultSelectedItem != null) {
                defaultValue = defaultSelectedItem.getValueToWrite();
            }
        } else if (componentSetting instanceof IntegerSetting) {
            defaultValue = ((IntegerSetting)componentSetting).getDefaultValue();
        }
        return defaultValue;
    }

    public static @Nullable ABaseUIComponentSetting getUIComponentSettingById(IMcu selectedMcu, String id) {
        for (ABaseUIComponentSetting componentSetting : selectedMcu.getAllGuiComponentSettings()) {
            if (!id.equals(componentSetting.getId())) continue;
            return componentSetting;
        }
        return null;
    }

    public static boolean getComponentVisibilityState(IMcu selectedMcu, ABaseUIComponentSetting component) {
        VisibleState visibleConditionState = component.getVisibleStateCondition();
        boolean state = true;
        if (visibleConditionState != null) {
            state = false;
            for (String condition : visibleConditionState.getAllOrConditions()) {
                Matcher paranthesisGroupMatcher = PARENTHESIS_GROUP_REGEX.matcher(condition);
                if (paranthesisGroupMatcher.find() && paranthesisGroupMatcher.groupCount() == 1) {
                    String exprString = paranthesisGroupMatcher.group(1);
                    if (exprString == null) continue;
                    List<String> allAndConditions = UctUtils.getAllAndConditions(exprString);
                    state = UctUtils.evaluateAndConditions(selectedMcu, allAndConditions, visibleConditionState.getState());
                    continue;
                }
                state |= UctUtils.evaluateCondition(selectedMcu, condition, visibleConditionState.getState());
            }
        }
        return state;
    }

    private static boolean evaluateAndConditions(IMcu selectedMcu, List<String> conditions, boolean conditionState) {
        boolean result = true;
        for (String condition : conditions) {
            result &= UctUtils.evaluateCondition(selectedMcu, condition, conditionState);
        }
        return result;
    }

    private static boolean evaluateCondition(IMcu selectedMcu, String condition, boolean conditionState) {
        boolean result = false;
        String visibleCondField = UctXmlSettingsUtils.getConditionField(condition);
        String visibleCondValue = UctXmlSettingsUtils.getConditionValue(condition);
        if (visibleCondField != null && visibleCondValue != null) {
            Pattern regex;
            Matcher matcher;
            ABaseUIComponentSetting conditionComponent = UctUtils.getUIComponentSettingById(selectedMcu, visibleCondField);
            if (conditionComponent != null && !conditionComponent.isDisabled()) {
                result = conditionState ? conditionComponent.getCurrentValue().equals(visibleCondValue) : !conditionComponent.getCurrentValue().equals(visibleCondValue);
            } else if (conditionComponent == null && (matcher = (regex = Pattern.compile("(.*)(\\.)(.*)", 8)).matcher(visibleCondField)).matches() && matcher.groupCount() == 3) {
                ABaseUIComponentSetting childCondComponent;
                ABaseUIComponentSetting parentCondComponent;
                String parentId = matcher.group(1);
                String childId = matcher.group(3);
                if (parentId != null && childId != null && (parentCondComponent = UctUtils.getUIComponentSettingById(selectedMcu, parentId)) instanceof StructSetting && parentCondComponent.isVisible() && (childCondComponent = UctUtils.getChildFromStructSetting((StructSetting)parentCondComponent, childId)) != null && !childCondComponent.isDisabled()) {
                    result = conditionState ? childCondComponent.getCurrentValue().equals(visibleCondValue) : !childCondComponent.getCurrentValue().equals(visibleCondValue);
                }
            }
        }
        return result;
    }

    public static @Nullable ABaseUIComponentSetting getChildFromStructSetting(StructSetting structSetting, String childID) {
        ABaseUIComponentSetting childComponent = null;
        for (ABaseUIComponentSetting currentChild : structSetting.getChildrenComponents()) {
            if (!childID.equalsIgnoreCase(currentChild.getId())) continue;
            childComponent = currentChild;
            break;
        }
        if (childComponent == null) {
            for (StructSetting childStruct : structSetting.getStructSettings()) {
                childComponent = UctUtils.getChildFromStructSetting(childStruct, childID);
            }
        }
        return childComponent;
    }

    public static @Nullable StructSetting getParentSettingByComponentId(IMcu selectedMcu, String id) {
        for (ABaseUIComponentSetting componentSetting : selectedMcu.getAllGuiComponentSettings()) {
            ABaseUIComponentSetting parentStructSetting;
            if (!(componentSetting instanceof StructSetting) || !((parentStructSetting = UctUtils.getCustomComponentSettingById((StructSetting)componentSetting, id)) instanceof StructSetting)) continue;
            return (StructSetting)parentStructSetting;
        }
        return null;
    }

    public static @Nullable BoolSetting getBoolSettingById(StructSetting parentStructure, String id) {
        for (BoolSetting boolSetting : parentStructure.getBoolSettings()) {
            if (!boolSetting.getId().equals(id)) continue;
            return boolSetting;
        }
        for (StructSetting childStructSetting : parentStructure.getStructSettings()) {
            BoolSetting boolSetting = UctUtils.getBoolSettingById(childStructSetting, id);
            if (boolSetting == null) continue;
            return boolSetting;
        }
        return null;
    }

    public static @Nullable EnumSetting getEnumSettingById(StructSetting parentStructure, String id) {
        for (EnumSetting enumSetting : parentStructure.getEnumSettings()) {
            if (!enumSetting.getId().equals(id)) continue;
            return enumSetting;
        }
        for (StructSetting childStructSetting : parentStructure.getStructSettings()) {
            EnumSetting enumSetting = UctUtils.getEnumSettingById(childStructSetting, id);
            if (enumSetting == null) continue;
            return enumSetting;
        }
        return null;
    }

    public static @Nullable IntegerSetting getIntegerSettingById(StructSetting parentStructure, String id) {
        for (IntegerSetting integerSetting : parentStructure.getIntegerSettings()) {
            if (!integerSetting.getId().equals(id)) continue;
            return integerSetting;
        }
        for (StructSetting childStructSetting : parentStructure.getStructSettings()) {
            IntegerSetting integerSetting = UctUtils.getIntegerSettingById(childStructSetting, id);
            if (integerSetting == null) continue;
            return integerSetting;
        }
        return null;
    }

    public static @Nullable ABaseUIComponentSetting getCustomComponentSettingById(StructSetting parentStructure, String id) {
        BoolSetting boolSetting = UctUtils.getBoolSettingById(parentStructure, id);
        if (boolSetting != null) {
            return boolSetting;
        }
        EnumSetting enumSetting = UctUtils.getEnumSettingById(parentStructure, id);
        if (enumSetting != null) {
            return enumSetting;
        }
        IntegerSetting integerSetting = UctUtils.getIntegerSettingById(parentStructure, id);
        if (integerSetting != null) {
            return integerSetting;
        }
        return null;
    }

    public static void setChildrenVisibility(ABaseUIComponentSetting component, boolean state) {
        if (component instanceof StructSetting) {
            List<ABaseUIComponentSetting> childrenList = ((StructSetting)component).getChildrenComponents();
            for (ABaseUIComponentSetting child : childrenList) {
                child.setVisibleState(state);
                UctUtils.setChildrenVisibility(child, state);
            }
        }
    }

    private static void updateComponentState(IMcu selectedMcu, ABaseUIComponentSetting component, ABaseUIComponentSetting conditionComponent) {
        boolean newDisableState;
        DisableState disableStateCondition;
        VisibleState visibleStateCondition = component.getVisibleStateCondition();
        if (visibleStateCondition != null && visibleStateCondition.existsOrConditionWithFieldId(conditionComponent.getId())) {
            boolean state = UctUtils.isComponentVisible(selectedMcu, component);
            component.setVisibleState(state);
            UctUtils.setChildrenVisibility(component, state);
        }
        if ((disableStateCondition = component.getDisableStateCondition()) != null && disableStateCondition.existsOrConditionWithFieldId(conditionComponent.getId()) && (newDisableState = UctUtils.isComponentDisable(selectedMcu, component)) != component.isDisabled()) {
            component.setDisableState(newDisableState);
            UctUtils.updateComponentsState(selectedMcu, component);
        }
    }

    public static void updateComponentsState(IMcu selectedMcu, ABaseUIComponentSetting conditionComponent) {
        for (ABaseUIComponentSetting componentSetting : selectedMcu.getAllGuiComponentSettings()) {
            UctUtils.updateComponentState(selectedMcu, componentSetting, conditionComponent);
            if (!(componentSetting instanceof EnumSetting)) continue;
            EnumSetting enumSetting = (EnumSetting)componentSetting;
            for (ItemSetting item : enumSetting.getItems()) {
                UctUtils.updateComponentState(selectedMcu, item, conditionComponent);
            }
        }
    }

    public static @Nullable ABaseUIComponentSetting getComponentSettingById(IMcu selectedMcu, String id) {
        for (ABaseUIComponentSetting componentSetting : selectedMcu.getAllGuiComponentSettings()) {
            if (!id.equalsIgnoreCase(componentSetting.getId())) continue;
            return componentSetting;
        }
        return null;
    }

    public static boolean isComponentVisible(IMcu selectedMcu, ABaseUIComponentSetting component) {
        boolean state = true;
        VisibleState visibleConditionState = component.getVisibleStateCondition();
        if (visibleConditionState != null) {
            state = UctUtils.getComponentVisibilityState(selectedMcu, component);
        }
        return state;
    }

    public static boolean isComponentDisable(IMcu selectedMcu, ABaseUIComponentSetting component) {
        boolean state = false;
        DisableState disableStateCondition = component.getDisableStateCondition();
        if (disableStateCondition != null) {
            List<String> allOrConditions = disableStateCondition.getAllOrConditions();
            for (String condition : allOrConditions) {
                ABaseUIComponentSetting conditionComponent;
                String disableCondField = UctXmlSettingsUtils.getConditionField(condition);
                String disableCondValue = UctXmlSettingsUtils.getConditionValue(condition);
                if (disableCondField == null || disableCondValue == null || (conditionComponent = UctUtils.getUIComponentSettingById(selectedMcu, disableCondField)) == null || conditionComponent.isDisabled()) continue;
                boolean conditionState = disableStateCondition.getState();
                state |= conditionState & conditionComponent.getCurrentValue().equals(disableCondValue);
            }
        }
        return state;
    }

    public static Long getLongFromHexString(String value) {
        if (value.endsWith("h")) {
            value = UtilsText.safeString((String)value.substring(0, value.length() - 1));
        }
        if (!value.startsWith("0x")) {
            value = "0x" + value;
        }
        Long hexValue = Long.decode(value);
        assert (hexValue != null);
        return hexValue;
    }

    public static CustomMap<String, PeripheralInfo> parseRegisterDb(IRegistersDatabaseAPI registerApi, Collection<ProcessorCore> cores) {
        try {
            CustomMap<@NonNull String, PeripheralInfo> peripherals = new CustomMap<String, PeripheralInfo>();
            IRegParentPeripheralAPI[] peripheralsDb = registerApi.getPeripherals();
            ProcessorCore core = cores.iterator().next();
            IRegParentPeripheralAPI[] iRegParentPeripheralAPIArray = peripheralsDb;
            int n = peripheralsDb.length;
            int n2 = 0;
            while (n2 < n) {
                IRegParentPeripheralAPI peripheral = iRegParentPeripheralAPIArray[n2];
                PeripheralInfo peripheralInfo = new PeripheralInfo();
                BigInteger baseAddress = peripheral.getBaseAddress(core.getName(), null);
                if (baseAddress != null) {
                    peripheralInfo.setBaseAddress(baseAddress.toString(16));
                }
                peripheralInfo.setBlockSize(Integer.valueOf(peripheral.getSizeOfAddrSpace()).toString());
                peripheralInfo.setName(peripheral.getName());
                peripheralInfo.setOffset("0");
                HashMap<@NonNull String, RegisterInfo> registers = new HashMap<String, RegisterInfo>();
                IRegisterAPI[] iRegisterAPIArray = peripheral.getRegisters();
                int n3 = iRegisterAPIArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IRegisterAPI register = iRegisterAPIArray[n4];
                    RegisterInfo registerInfo = new RegisterInfo();
                    registerInfo.setAddress(Long.toHexString(UctUtils.getLongFromHexString(peripheralInfo.getBaseAddress()) + (long)register.getOffset()));
                    registerInfo.setSize(Integer.valueOf(register.getWidth()).toString());
                    registerInfo.setName(register.getName());
                    registerInfo.setResetValue(UctUtils.calculateRegisterResetValue(register));
                    boolean registerReadOnly = true;
                    HashMap<@NonNull String, BitFieldInfo> bitFields = new HashMap<String, BitFieldInfo>();
                    IRegBitFieldAPI[] iRegBitFieldAPIArray = register.getBitFields();
                    int n5 = iRegBitFieldAPIArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IRegBitFieldAPI bitField = iRegBitFieldAPIArray[n6];
                        if (!bitField.isReserved()) {
                            BitFieldInfo bitFieldInfo = new BitFieldInfo();
                            if (bitField.isReadOnly()) {
                                bitFieldInfo.setAccess(AccessMode.MODE_RO);
                            } else {
                                bitFieldInfo.setAccess(AccessMode.MODE_RW);
                                registerReadOnly = false;
                            }
                            bitFieldInfo.setDescription(bitField.getDescription());
                            bitFieldInfo.setName(bitField.getName());
                            bitFieldInfo.setOffset(Short.valueOf(bitField.getOffset()).toString());
                            bitFieldInfo.setWidth(Short.valueOf(bitField.getWidth()).toString());
                            bitFields.put(bitField.getName(), bitFieldInfo);
                        }
                        ++n6;
                    }
                    registerInfo.setBitFields(bitFields);
                    registerInfo.setAccess(registerReadOnly ? AccessMode.MODE_RO : AccessMode.MODE_RW);
                    registers.put(register.getName(), registerInfo);
                    ++n4;
                }
                peripheralInfo.setRegisters(registers);
                peripherals.put(peripheral.getName(), peripheralInfo);
                ++n2;
            }
            return peripherals;
        }
        catch (Exception e) {
            LOGGER.severe("Cannot parse the registers database " + e.getMessage());
            return new CustomMap<String, PeripheralInfo>();
        }
    }

    private static String calculateRegisterResetValue(IRegisterAPI register) {
        long resetValue = 0L;
        IRegBitFieldAPI[] iRegBitFieldAPIArray = register.getBitFields();
        int n = iRegBitFieldAPIArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRegBitFieldAPI bitField = iRegBitFieldAPIArray[n2];
            resetValue += bitField.getResetValue().longValue() << bitField.getOffset();
            ++n2;
        }
        return "0x" + Long.toHexString(resetValue);
    }

    public static boolean isValueInRange(long valueToTest, String minValue, String maxValue) {
        boolean currentStatus = true;
        if (!minValue.isEmpty() && !maxValue.isEmpty()) {
            long minValueLong = UctUtils.getLongValueFromString(minValue);
            long maxValueLong = UctUtils.getLongValueFromString(maxValue);
            if (minValueLong > valueToTest || valueToTest > maxValueLong) {
                currentStatus = false;
            }
        } else if (!minValue.isEmpty() && maxValue.isEmpty()) {
            long minValueLong = UctUtils.getLongValueFromString(minValue);
            currentStatus = valueToTest >= minValueLong;
        } else if (minValue.isEmpty() && maxValue.isEmpty()) {
            long maxValueLong = UctUtils.getLongValueFromString(maxValue);
            currentStatus = valueToTest <= maxValueLong;
        }
        return currentStatus;
    }

    public static double getFreqToTimeConversion(double frequency, TimeUnit unit) {
        double result = 0.0;
        if (Double.compare(frequency, 0.0) == 1) {
            switch (unit) {
                case NANO_SECOND: {
                    result = 1.0E9 / frequency;
                    break;
                }
                case MICRO_SECOND: {
                    result = 1000000.0 / frequency;
                    break;
                }
                case MILLI_SECOND: {
                    result = 1000.0 / frequency;
                    break;
                }
            }
        }
        return result;
    }

    public static double getFreqScaleConversion(double frequency, FrequencyUnit unit) {
        double result = 0.0;
        switch (unit) {
            case HERTZ: {
                result = frequency;
                break;
            }
            case KILO_HERTZ: {
                result = frequency / 1000.0;
                break;
            }
            case MEGA_HERTZ: {
                result = frequency / 1000000.0;
                break;
            }
        }
        return result;
    }

    public static String getFreqAutoScaleConversion(double frequency) {
        FrequencyUnit unit = Double.compare(frequency, 1000.0) == -1 ? FrequencyUnit.HERTZ : (Double.compare(frequency, 1000000.0) == -1 ? FrequencyUnit.KILO_HERTZ : FrequencyUnit.MEGA_HERTZ);
        return String.valueOf(Double.toString(UctUtils.getFreqScaleConversion(frequency, unit))) + " " + unit;
    }
}

