/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.common.uct.validation;

import com.nxp.swtools.common.uct.validation.AUctProblem;
import com.nxp.swtools.common.uct.validation.IProblemSource;
import com.nxp.swtools.common.uct.validation.IProblemUIContainer;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.validation.engine.ValidationEngineFactory;
import com.nxp.swtools.validation.utils.AProblemsManager;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public abstract class AUctProblemsManager<@NonNull T extends AUctProblem>
extends AProblemsManager<T> {
    public void clearProblems(IProblemSource source) {
        this.clearProblems(source, null);
    }

    public void clearProblems(IProblemSource source, @Nullable AUctProblem.Type type) {
        ArrayList<AUctProblem> problemsList = new ArrayList<AUctProblem>();
        for (AUctProblem problem : this.getProblemsList()) {
            if (type != null) {
                if (!problem.getType().name().equals(type.name()) || !this.shouldRemove(problem, source)) continue;
                problemsList.add(problem);
                continue;
            }
            if (!this.shouldRemove(problem, source)) continue;
            problemsList.add(problem);
        }
        this.removeProblems(problemsList);
    }

    public void clearProblemsForContainer(IProblemUIContainer container) {
        this.clearProblemsForContainer(container, null);
    }

    public void clearProblemsForContainer(IProblemUIContainer container, @Nullable AUctProblem.Type type) {
        ArrayList<AUctProblem> problemsList = new ArrayList<AUctProblem>();
        for (AUctProblem problem : this.getProblemsList()) {
            if (type != null) {
                if (!problem.getType().name().equals(type.name()) || !this.shouldRemove(problem, container)) continue;
                problemsList.add(problem);
                continue;
            }
            if (!this.shouldRemove(problem, container)) continue;
            problemsList.add(problem);
        }
        this.removeProblems(problemsList);
    }

    public void clearProblems(AUctProblem.Type type) {
        ArrayList<@NonNull AUctProblem> problemsList = new ArrayList<AUctProblem>();
        for (AUctProblem problem : this.getProblemsList()) {
            if (!problem.getType().name().equals(type.name())) continue;
            problemsList.add(problem);
        }
        this.removeProblems(problemsList);
    }

    public List<@NonNull T> getProblemListForSource(IProblemSource source) {
        ArrayList<@NonNull AUctProblem> problemsFound = new ArrayList<AUctProblem>();
        for (AUctProblem problem : this.getProblemsList()) {
            IProblemSource problemSource = problem.getProblemSource();
            if (!source.equals(problemSource)) continue;
            problemsFound.add(problem);
        }
        return problemsFound;
    }

    public List<@NonNull T> getProblemListForContainer(IProblemUIContainer container) {
        ArrayList<@NonNull AUctProblem> problemsFound = new ArrayList<AUctProblem>();
        for (AUctProblem problem : this.getProblemsList()) {
            IProblemUIContainer problemContainer = problem.getSourceContainer();
            if (!container.equals(problemContainer)) continue;
            problemsFound.add(problem);
        }
        return problemsFound;
    }

    public List<@NonNull T> getProblemsListOfLevelError() {
        ArrayList<@NonNull AUctProblem> errorProblems = new ArrayList<AUctProblem>(this.getProblemsList());
        errorProblems.removeIf(p -> p.getProblemLevel() != 2);
        return errorProblems;
    }

    public boolean hasSourceProblemOfType(IProblemSource source, AUctProblem.Type type) {
        for (AUctProblem problem : this.getProblemsList()) {
            if (!problem.getType().equals((Object)type) || !problem.getProblemSource().equals(source)) continue;
            return true;
        }
        return false;
    }

    protected void removeProblems(List<@NonNull T> problemsList) {
        if (!problemsList.isEmpty()) {
            ValidationEngineFactory.addAndRemoveProblems(null, problemsList, null);
            this.getProblemsList().removeAll(problemsList);
        }
    }

    private boolean shouldRemove(T problem, IProblemSource source) {
        return ((AUctProblem)((Object)problem)).getProblemSource().equals(source);
    }

    private boolean shouldRemove(T problem, IProblemUIContainer container) {
        IProblemUIContainer sourceContainer = ((AUctProblem)((Object)problem)).getSourceContainer();
        return sourceContainer != null && sourceContainer.equals(container);
    }

    public void clearAllProblemsForResource(String resourceId) {
        ArrayList<AUctProblem> problemsList = new ArrayList<AUctProblem>();
        for (AUctProblem problem : this.getProblemsList()) {
            if (!problem.getResource().matches(String.format("(?i).*\\b%s\\b.*", Pattern.quote(resourceId)))) continue;
            problemsList.add(problem);
        }
        this.removeProblems(problemsList);
    }
}

