/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.internal.refactoring.text;

import com.nxp.s32ds.ext.ide.internal.refactoring.text.IdeTextDocumentContext;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;

public class IdeTextBufferedDocumentContext
implements IdeTextDocumentContext {
    private static final LocationKind LOCATION_KIND = LocationKind.IFILE;
    private static final ITextFileBufferManager MANAGER = FileBuffers.getTextFileBufferManager();
    private final IPath path;
    private final IProgressMonitor monitor;
    private final ITextFileBuffer buffer;

    public IdeTextBufferedDocumentContext(IFile file, IProgressMonitor monitor) throws CoreException {
        this.path = file.getFullPath();
        this.monitor = monitor;
        MANAGER.connect(this.path, LOCATION_KIND, monitor);
        this.buffer = MANAGER.getTextFileBuffer(this.path, LOCATION_KIND);
    }

    @Override
    public IDocument getDocument() {
        return this.buffer.getDocument();
    }

    @Override
    public void close() throws CoreException {
        if (this.buffer != null) {
            MANAGER.disconnect(this.path, LOCATION_KIND, this.monitor);
        }
    }
}

