/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.refactoring.text;

import com.nxp.s32ds.ext.ide.refactoring.IdeSearchScope;
import com.nxp.s32ds.ext.ide.refactoring.IdeSearchScopes;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.internal.core.text.PatternConstructor;

public class IdeTextSearchScope
extends TextSearchScope {
    private static final boolean IS_CASE_SENSITIVE_FILESYSTEM = !new File("Temp").equals(new File("temp"));
    private final Collection<IResource> roots;
    private final Matcher matcher;
    private final boolean isVisitDerived;
    private final List<String> paths;

    public static IdeTextSearchScope create(IProject project, IdeSearchScope scope, boolean isVisitDerived) {
        List<IResource> resources = IdeSearchScopes.getProjectsByScope(project, scope).stream().map(p -> p).collect(Collectors.toList());
        return new IdeTextSearchScope(resources, isVisitDerived, scope.fileNamePatterns, scope.paths);
    }

    public IdeTextSearchScope(Collection<IResource> roots, boolean isVisitDerived, List<String> fileNamePatterns, List<String> paths) {
        if (roots == null) {
            throw new IllegalArgumentException("Parameter roots is null");
        }
        if (fileNamePatterns == null) {
            throw new IllegalArgumentException("Parameter fileNamePatterns is null");
        }
        if (paths == null) {
            throw new IllegalArgumentException("Parameter paths is null");
        }
        this.roots = roots;
        this.isVisitDerived = isVisitDerived;
        this.paths = paths;
        this.matcher = IdeTextSearchScope.createMatcher(fileNamePatterns);
    }

    public IResource[] getRoots() {
        return this.roots.toArray(new IResource[this.roots.size()]);
    }

    public boolean contains(IResourceProxy proxy) {
        if (!this.isVisitDerived && proxy.isDerived()) {
            return false;
        }
        if (proxy.getType() != 1) {
            return true;
        }
        if (!this.paths.isEmpty()) {
            IResource resource = proxy.requestResource();
            String pathString = resource.getProjectRelativePath().toString();
            boolean present = this.paths.stream().filter(s -> pathString.startsWith((String)s)).findAny().isPresent();
            if (!present) {
                return false;
            }
        }
        return this.matcher.reset(proxy.getName()).matches();
    }

    private static Matcher createMatcher(List<String> fileNamePatterns) {
        Pattern pattern = fileNamePatterns.size() == 0 ? Pattern.compile(".*") : PatternConstructor.createPattern((String[])fileNamePatterns.toArray(new String[fileNamePatterns.size()]), (boolean)IS_CASE_SENSITIVE_FILESYSTEM);
        return pattern.matcher("");
    }
}

