/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.controller.scripting;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.lang.Triplet;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.SwToolsProductConfiguration;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.periphs.controller.scripting.PeripheralsScriptFunctionalGroup;
import com.nxp.swtools.periphs.controller.scripting.PeripheralsScriptRegistersModel;
import com.nxp.swtools.periphs.model.config.PeriphsProfile;
import com.nxp.swtools.periphs.model.data.ActiveComponents;
import com.nxp.swtools.periphs.model.data.Code;
import com.nxp.swtools.periphs.model.data.ConfigSet;
import com.nxp.swtools.periphs.model.data.FragmentDefs;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.periphs.model.yaml.PeripheralsYamlConverter;
import com.nxp.swtools.periphs.model.yaml.PeriphsProfileInfo;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsFuncGroup;
import com.nxp.swtools.resourcetables.model.config.CastableValue;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.resourcetables.model.config.IRoot;
import com.nxp.swtools.resourcetables.model.data.IConfigurationComponent;
import com.nxp.swtools.resourcetables.model.data.Mode;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.model.mcu.ICommonMcu;
import com.nxp.swtools.utils.scripting.ProfileInfo;
import com.nxp.swtools.utils.scripting.ScriptDependencyHelper;
import com.nxp.swtools.utils.scripting.api.IMcuInfo;
import com.nxp.swtools.utils.scripting.api.IScriptDependencyHelper;
import com.nxp.swtools.utils.scripting.api.IScriptProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PeripheralsScriptProfile
implements IScriptProfile {
    protected static final Logger LOGGER = LogManager.getLogger(PeripheralsScriptProfile.class);
    private final ActiveComponents activeComponents;
    private final IRoot profile;
    private final List<PeripheralsScriptFunctionalGroup> peripheralsScriptFunctionalGroups;
    private final IMcu mcu;
    private final ScriptDependencyHelper dependencyHelper;
    private PeripheralsScriptRegistersModel registerModel;

    public PeripheralsScriptProfile(IMcu mcu, PeriphsProfile profile) {
        this.mcu = mcu;
        this.activeComponents = profile.getActiveComponents();
        this.profile = profile;
        this.peripheralsScriptFunctionalGroups = new ArrayList<PeripheralsScriptFunctionalGroup>();
        ArrayList<StoragePeriphsFuncGroup> functionalGroupsStorages = new ArrayList<StoragePeriphsFuncGroup>();
        for (IFunctionalGroup functionalGroup : profile.getFunctionalGroups()) {
            this.peripheralsScriptFunctionalGroups.add(new PeripheralsScriptFunctionalGroup(functionalGroup));
            functionalGroupsStorages.add(functionalGroup.getStorageFuncGroup());
        }
        this.dependencyHelper = new ScriptDependencyHelper(functionalGroupsStorages, false);
        this.registerModel = new PeripheralsScriptRegistersModel((ICommonMcu)mcu);
    }

    public @Nullable String getYaml() {
        if (this.profile.isYamlEnabled()) {
            return new PeripheralsYamlConverter().createYamlProfile((ProfileInfo)new PeriphsProfileInfo(this.profile));
        }
        return null;
    }

    public String getToolVersion() {
        SwToolsProduct periphTool = SwToolsProductConfiguration.getRegisteredProduct((String)"Peripherals");
        assert (periphTool != null);
        return periphTool.getVersion();
    }

    public String getToolName() {
        return "Peripherals";
    }

    public Collection<IConfigurationComponent> getComponents() {
        return this.activeComponents.getConfigComps();
    }

    public @Nullable IConfigurationComponent getComponent(String id) {
        return this.activeComponents.getConfigComp(id);
    }

    public @Nullable ConfigSet getConfigSet(String componentId, String id) {
        IConfigurationComponent configComp = this.activeComponents.getConfigComp(componentId);
        return configComp == null ? null : (ConfigSet)configComp.getConfigSet(id);
    }

    public @Nullable ISetting getSetting(String componentId, String configSetId, String id) {
        IConfigurationComponent component = this.getComponent(componentId);
        if (component != null) {
            Triplet setting = this.activeComponents.findSetting(component, configSetId, id, false);
            return setting == null ? null : (ISetting)setting.getFirst();
        }
        return null;
    }

    public @Nullable Mode getMode(String componentId, String id) {
        IConfigurationComponent configComp = this.activeComponents.getConfigComp(componentId);
        return configComp == null ? null : configComp.getMode(id);
    }

    public @Nullable Code getCode(String componentId, String configSetId) {
        ConfigSet configSet = this.getConfigSet(componentId, configSetId);
        if (configSet != null) {
            return configSet.getCode();
        }
        return null;
    }

    public @Nullable FragmentDefs getFragmentDefs(String componentId, String configSetId) {
        ConfigSet configSet = this.getConfigSet(componentId, configSetId);
        if (configSet != null) {
            return configSet.getFragmentDefs();
        }
        return null;
    }

    public IMcuInfo getMcuInfo() {
        return this.mcu;
    }

    public IScriptDependencyHelper getDependencyHelper() {
        return this.dependencyHelper;
    }

    public PeripheralsScriptFunctionalGroup[] getFunctionalGroups() {
        return this.peripheralsScriptFunctionalGroups.toArray(new PeripheralsScriptFunctionalGroup[this.peripheralsScriptFunctionalGroups.size()]);
    }

    public @Nullable PeripheralsScriptFunctionalGroup getFunctionalGroup(String name) {
        return (PeripheralsScriptFunctionalGroup)CollectionsUtils.nullableOptionalGet(this.peripheralsScriptFunctionalGroups.stream().filter(x -> x.getName().equals(name)).findFirst());
    }

    public Collection<IComponentConfig> getComponentConfigurations() {
        Collection<IComponentConfig> result = this.profile.getConfiguredComponents().values();
        assert (result != null);
        return result;
    }

    public @Nullable IComponentConfig getComponentConfiguration(String id) {
        return this.profile.getComponent(id);
    }

    public void applyDependencies() {
        this.dependencyHelper.applyScriptDependencies();
    }

    public boolean featureDefined(String feature, @Nullable String peripheral) {
        IFunctionalGroup functionalGroup = this.profile.getChildContext().getFunctionalGroup();
        String core = functionalGroup == null ? null : functionalGroup.getCore();
        return this.mcu.hasFeature(feature, core, peripheral);
    }

    public @Nullable IValue getFeature(String feature, @Nullable String peripheral) {
        IFunctionalGroup functionalGroup = this.profile.getChildContext().getFunctionalGroup();
        String core = functionalGroup == null ? null : functionalGroup.getCore();
        String featureValue = this.mcu.getFeature(feature, core, peripheral);
        if (featureValue != null) {
            try {
                return new CastableValue(Expression.create((String)featureValue).resolve(this.profile.getExpressionContext()).getValue());
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "[TOOL] Function getFeature cannot obtain value due to the following exception: {0}", e.getLocalizedMessage());
            }
        }
        return null;
    }

    public @Nullable String getProperty(String propertyName) {
        return SWToolsProperties.getProperty((String)propertyName);
    }

    public boolean isPropertyDefined(String propertyName) {
        return this.getProperty(propertyName) != null;
    }

    public @Nullable IRegistersDatabaseAPI getRegistersDB() {
        return this.mcu.requireRegistersDb();
    }

    public @NonNull PeripheralsScriptRegistersModel getRegisterModelAPI() {
        return this.registerModel;
    }
}

