/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.info.core.imports.processors;

import com.nxp.s32ds.cle.cdt.project.info.core.exports.toolchains.ToolchainMetadata;
import com.nxp.s32ds.cle.cdt.project.info.core.imports.PIReader;
import com.nxp.s32ds.cle.cdt.project.info.core.imports.processors.IOptionProcessor;
import com.nxp.s32ds.cle.cdt.project.info.core.imports.processors.OptionDelta;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.PIActivator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;

public class IARToolchainOptionProcessor
implements IOptionProcessor,
ToolchainMetadata {
    private static final String ENTRY_OVERRIDE_V7 = "iar.arm.toolchain.linker.option.entryOverride.v5.4.0";
    private static final String ENTRY_OVERRIDE_V8 = "iar.arm.toolchain.linker.option.entryOverride.v8.0.0";
    private static final String MAP_FILE_V7 = "iar.arm.toolchain.linker.option.mapFile.v5.4.0";
    private static final String MAP_FILE_V8 = "iar.arm.toolchain.linker.option.mapFile.v8.0.0";
    private static final String QUOTE = "\"";
    private final Map<String, String> attr2Attribute = new HashMap<String, String>();
    private final Map<String, Pattern> patterns = new HashMap<String, Pattern>();
    private final Map<String, Pattern> pathPatterns = new HashMap<String, Pattern>();

    public IARToolchainOptionProcessor() {
        this.patterns.put("iar.arm.toolchain.assembler.option.cpu.v5.4.0", Pattern.compile("--cpu (.*)"));
        this.patterns.put("iar.arm.toolchain.assembler.option.fpu.v5.4.0", Pattern.compile("--fpu (.*)"));
        this.patterns.put("iar.arm.toolchain.assembler.option.caseSensitiveSymbols.v5.4.0", Pattern.compile("-s(\\+|-)"));
        this.patterns.put("iar.arm.toolchain.assembler.option.debugInfo.v5.4.0", Pattern.compile("-r"));
        this.patterns.put("iar.arm.toolchain.compiler.option.endian.v5.4.0", Pattern.compile("--endian (.*)"));
        this.patterns.put("iar.arm.toolchain.compiler.option.defines.v5.4.0", Pattern.compile("(^|\\s)-D([^ ]+)"));
        this.patterns.put("iar.arm.toolchain.compiler.option.language.v6.1.0", Pattern.compile("---AUTO"));
        this.patterns.put("iar.arm.toolchain.compiler.option.cpuMode.v5.4.0", Pattern.compile("--cpu_mode arm|--cpu_mode thumb"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optLevel.v5.4.0", Pattern.compile("-On|-Ol|-Om|-Ohz|-Oh|-Ohs"));
        this.patterns.put("iar.arm.toolchain.compiler.option.languageConformance.v6.1.0", Pattern.compile("-e|--strict"));
        this.patterns.put(MAP_FILE_V7, Pattern.compile("--map \"(.*)\""));
        this.patterns.put("iar.arm.toolchain.compiler.option.optCSE.v5.4.0", Pattern.compile("--no_cse"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optUnroll.v5.4.0", Pattern.compile("--no_unroll"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optInline.v5.4.0", Pattern.compile("--no_inline"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optCodeMotion.v5.4.0", Pattern.compile("--no_code_motion"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optAliasAnalysis.v5.4.0", Pattern.compile("--no_tbaa"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optStaticClustering.v5.4.0", Pattern.compile("--no_clustering"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optScheduling.v5.4.0", Pattern.compile("--no_scheduling"));
        this.patterns.put("iar.arm.toolchain.linker.option.programEntry.v5.4.0", Pattern.compile("--entry (.*)"));
        this.patterns.put("iar.arm.toolchain.compiler.option.suppress.v5.4.0", Pattern.compile("--diag_suppress (.*)"));
        this.patterns.put("iar.arm.toolchain.linker.option.wrapDiagnostics", Pattern.compile("--no_wrap_diagnostics"));
        this.pathPatterns.put("iar.arm.toolchain.compiler.option.incPaths.v5.4.0", Pattern.compile("-I ?\"([^\"]+)\"|-I ?([^ ]+)"));
        this.pathPatterns.put("iar.arm.toolchain.compiler.option.dlibConfig.v5.4.0", Pattern.compile("--dlib_config (.*)"));
        this.pathPatterns.put("iar.arm.toolchain.linker.option.icfFile.v5.4.0", Pattern.compile("--config \"(.*)\""));
        this.attr2Attribute.put(ENTRY_OVERRIDE_V7, "iar.arm.toolchain.linker.option.programEntry.v5.4.0");
        this.attr2Attribute.put(MAP_FILE_V7, MAP_FILE_V7);
        this.patterns.put("iar.arm.toolchain.assembler.option.cpu.v8.0.0", Pattern.compile("--cpu (.*)"));
        this.patterns.put("iar.arm.toolchain.assembler.option.fpu.v8.0.0", Pattern.compile("--fpu (.*)"));
        this.patterns.put("iar.arm.toolchain.assembler.option.caseSensitiveSymbols.v8.0.0", Pattern.compile("-s(\\+|-)"));
        this.patterns.put("iar.arm.toolchain.assembler.option.debugInfo.v8.0.0", Pattern.compile("-r"));
        this.patterns.put("iar.arm.toolchain.compiler.option.endian.v8.0.0", Pattern.compile("--endian (.*)"));
        this.patterns.put("iar.arm.toolchain.compiler.option.defines.v8.0.0", Pattern.compile("(^|\\s)-D([^ ]+)"));
        this.patterns.put("iar.arm.toolchain.compiler.option.language.v8.0.0", Pattern.compile("---AUTO|--c++"));
        this.patterns.put("iar.arm.toolchain.compiler.option.cpuMode.v8.0.0", Pattern.compile("--cpu_mode arm|--cpu_mode thumb"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optLevel.v8.0.0", Pattern.compile("-On|-Ol|-Om|-Ohz|-Oh|-Ohs"));
        this.patterns.put("iar.arm.toolchain.compiler.option.languageConformance.v8.0.0", Pattern.compile("-e|--strict"));
        this.patterns.put(MAP_FILE_V8, Pattern.compile("--map \"(.*)\""));
        this.patterns.put("iar.arm.toolchain.compiler.option.optCSE.v8.0.0", Pattern.compile("--no_cse"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optUnroll.v8.0.0", Pattern.compile("--no_unroll"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optInline.v8.0.0", Pattern.compile("--no_inline"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optCodeMotion.v8.0.0", Pattern.compile("--no_code_motion"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optAliasAnalysis.v8.0.0", Pattern.compile("--no_tbaa"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optStaticClustering.v8.0.0", Pattern.compile("--no_clustering"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optScheduling.v8.0.0", Pattern.compile("--no_scheduling"));
        this.patterns.put("iar.arm.toolchain.linker.option.programEntry.v8.0.0", Pattern.compile("--entry (.*)"));
        this.patterns.put("iar.arm.toolchain.compiler.option.suppress.v8.0.0", Pattern.compile("--diag_suppress (.*)"));
        this.patterns.put("iar.arm.toolchain.linker.option.wrapDiagnostics.v8.0.0", Pattern.compile("--no_wrap_diagnostics"));
        this.pathPatterns.put("iar.arm.toolchain.compiler.option.incPaths.v8.0.0", Pattern.compile("-I ?\"([^\"]+)\"|-I ?([^ ]+)"));
        this.pathPatterns.put("iar.arm.toolchain.compiler.option.dlibConfig.v8.0.0", Pattern.compile("--dlib_config (.*)"));
        this.pathPatterns.put("iar.arm.toolchain.linker.option.icfFile.v8.0.0", Pattern.compile("--config \"(.*)\""));
        this.attr2Attribute.put(ENTRY_OVERRIDE_V8, "iar.arm.toolchain.linker.option.programEntry.v8.0.0");
        this.attr2Attribute.put(MAP_FILE_V8, MAP_FILE_V8);
    }

    @Override
    public List<OptionDelta> prepareChanges(IConfiguration cfg, PIReader piReader) {
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        Arrays.stream(cfg.getToolChain().getTools()).forEach(tool -> Arrays.stream(tool.getOptions()).map(option -> this.processToolOption(cfg, (ITool)tool, (IOption)option, piReader)).filter(delta -> delta != null).forEach(delta -> {
            boolean bl = result.add((OptionDelta)delta);
        }));
        try {
            IARToolchainOptionProcessor.createTCOptions(cfg, result);
        }
        catch (BuildException e) {
            PIActivator.getDefault().logError(e.getMessage());
        }
        return result;
    }

    private static void setTcCpu(IConfiguration cfg, List<OptionDelta> result, String tcOptId, String ccOptId, String asmOptId) throws BuildException {
        Object val;
        Object object = val = IARToolchainOptionProcessor.getValue(result, ccOptId) == null ? IARToolchainOptionProcessor.getValue(result, asmOptId) : IARToolchainOptionProcessor.getValue(result, ccOptId);
        if (val != null) {
            IOption option = cfg.getToolChain().getOptionBySuperClassId(tcOptId);
            String value = option.getEnumeratedId((String)val);
            result.add(new OptionDelta(cfg, (IHoldsOptions)cfg.getToolChain(), option, value));
        }
    }

    private static void setTc7Fpu(IConfiguration cfg, List<OptionDelta> result, String tcOptId, String ccOptId, String asmOptId) throws BuildException {
        Object val;
        Object object = val = IARToolchainOptionProcessor.getValue(result, ccOptId) == null ? IARToolchainOptionProcessor.getValue(result, asmOptId) : IARToolchainOptionProcessor.getValue(result, ccOptId);
        if (val != null) {
            IOption option = cfg.getToolChain().getOptionBySuperClassId(tcOptId);
            String[] stringArray = option.getApplicableValues();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                String eId = option.getEnumeratedId(name);
                String cmd = option.getEnumCommand(eId);
                if (cmd.equals(val)) {
                    result.add(new OptionDelta(cfg, (IHoldsOptions)cfg.getToolChain(), option, eId));
                }
                ++n2;
            }
        }
    }

    private static void setTc8Fpu(IConfiguration cfg, List<OptionDelta> result, String tcOptId, String ccOptId, String asmOptId) {
        Object val;
        Object object = val = IARToolchainOptionProcessor.getValue(result, ccOptId) == null ? IARToolchainOptionProcessor.getValue(result, asmOptId) : IARToolchainOptionProcessor.getValue(result, ccOptId);
        if (val != null) {
            IOption option = cfg.getToolChain().getOptionBySuperClassId(tcOptId);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("None", "iar.arm.toolchain.option.OGFpuProcessor::descriptor.TaChipInfo::PossibleFPUs::kNoFpu.v8.0.0");
            map.put("VFPv1", "iar.arm.toolchain.option.OGFpuProcessor::descriptor.TaChipInfo::PossibleFPUs::kVFPv1.v8.0.0");
            map.put("VFPv2", "iar.arm.toolchain.option.OGFpuProcessor::descriptor.TaChipInfo::PossibleFPUs::kVFPv2.v8.0.0");
            map.put("VFPv3", "iar.arm.toolchain.option.OGFpuProcessor::descriptor.TaChipInfo::PossibleFPUs::kVFPv3.v8.0.0");
            map.put("VFPv4_sp", "iar.arm.toolchain.option.OGFpuProcessor::descriptor.TaChipInfo::PossibleFPUs::kVFPv4sp.v8.0.0");
            map.put("VFPv4", "iar.arm.toolchain.option.OGFpuProcessor::descriptor.TaChipInfo::PossibleFPUs::kVFPv4.v8.0.0");
            map.put("VFPv5_sp", "iar.arm.toolchain.option.OGFpuProcessor::descriptor.TaChipInfo::PossibleFPUs::kVFPv5sp.v8.0.0");
            map.put("VFPv5_dp", "iar.arm.toolchain.option.OGFpuProcessor::descriptor.TaChipInfo::PossibleFPUs::kVFPv5d16.v8.0.0");
            map.put("VFP9-S", "iar.arm.toolchain.option.OGFpuProcessor::descriptor.TaChipInfo::PossibleFPUs::kVFP9S.v8.0.0");
            String value = (String)map.get(val);
            result.add(new OptionDelta(cfg, (IHoldsOptions)cfg.getToolChain(), option, value));
        }
    }

    private static void createTCOptions(IConfiguration cfg, List<OptionDelta> result) throws BuildException {
        Object useNeonOptionDefaultValue;
        IARToolchainOptionProcessor.setTcCpu(cfg, result, "iar.arm.toolchain.option.cpuCore.v5.4.0", "iar.arm.toolchain.compiler.option.cpu.v5.4.0", "iar.arm.toolchain.assembler.option.cpu.v5.4.0");
        IARToolchainOptionProcessor.setTcCpu(cfg, result, "iar.arm.toolchain.option.OGProcessor::descriptor.v8.0.0", "iar.arm.toolchain.compiler.option.cpu.v8.0.0", "iar.arm.toolchain.assembler.option.cpu.v8.0.0");
        IARToolchainOptionProcessor.setTc7Fpu(cfg, result, "iar.arm.toolchain.option.fpu.v5.4.0", "iar.arm.toolchain.compiler.option.fpu.v5.4.0", "iar.arm.toolchain.assembler.option.fpu.v5.4.0");
        IARToolchainOptionProcessor.setTc8Fpu(cfg, result, "iar.arm.toolchain.option.OGFpuProcessor::descriptor.v8.0.0", "iar.arm.toolchain.compiler.option.fpu.v8.0.0", "iar.arm.toolchain.assembler.option.fpu.v8.0.0");
        IOption useNeonOption = cfg.getToolChain().getOptionBySuperClassId("iar.arm.toolchain.option.OGFpuProcessor::useNEON.v8.0.0");
        if (useNeonOption != null && (useNeonOptionDefaultValue = useNeonOption.getDefaultValue()) != null) {
            result.add(new OptionDelta(cfg, (IHoldsOptions)cfg.getToolChain(), useNeonOption, (Boolean)useNeonOptionDefaultValue == false));
            result.add(new OptionDelta(cfg, (IHoldsOptions)cfg.getToolChain(), useNeonOption, (Boolean)useNeonOptionDefaultValue));
        }
    }

    private static Object getValue(List<OptionDelta> result, String optionId) {
        for (OptionDelta d : result) {
            if (!d.getOption().getId().startsWith(optionId)) continue;
            return d.getValue();
        }
        return null;
    }

    private OptionDelta processToolOption(IConfiguration cfg, ITool tool, IOption option, PIReader piReader) {
        String result;
        String optionId = option.getId();
        if (ENTRY_OVERRIDE_V7.equals(optionId) || ENTRY_OVERRIDE_V8.equals(optionId) || MAP_FILE_V7.equals(optionId) || MAP_FILE_V8.equals(optionId)) {
            boolean value = false;
            for (String optionLine : this.getOpts(tool, piReader)) {
                Matcher matcher = this.patterns.get(this.attr2Attribute.get(optionId)).matcher(optionLine);
                if (!matcher.find()) continue;
                value = true;
                break;
            }
            return new OptionDelta(cfg, (IHoldsOptions)tool, option, value);
        }
        ArrayList<String> values = new ArrayList<String>();
        if (this.patterns.containsKey(optionId)) {
            for (String optionLine : this.getOpts(tool, piReader)) {
                Matcher matcher = this.patterns.get(optionId).matcher(optionLine);
                if (!matcher.find()) continue;
                try {
                    if (option.getValueType() == 2) {
                        String value = matcher.group(1);
                        return new OptionDelta(cfg, (IHoldsOptions)tool, option, value);
                    }
                    if (option.getValueType() == 0) {
                        boolean value = !optionLine.equals(option.getCommandFalse());
                        return new OptionDelta(cfg, (IHoldsOptions)tool, option, value);
                    }
                    if (option.getValueType() == 1) {
                        String[] stringArray = option.getApplicableValues();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String name = stringArray[n2];
                            String eId = option.getEnumeratedId(name);
                            String cmd = option.getEnumCommand(eId);
                            if (optionLine.equals(cmd)) {
                                return new OptionDelta(cfg, (IHoldsOptions)tool, option, eId);
                            }
                            ++n2;
                        }
                    }
                    if (option.getValueType() == 3 && (result = matcher.group(1)) != null) {
                        ArrayList<String> valuesStr = new ArrayList<String>();
                        valuesStr.add(result);
                        while (matcher.find()) {
                            valuesStr.add(matcher.group(1));
                        }
                        return new OptionDelta(cfg, (IHoldsOptions)tool, option, valuesStr.toArray(new String[valuesStr.size()]));
                    }
                    if (option.getValueType() != 5 || (result = matcher.group(2)) == null) continue;
                    values.add(result);
                    while (matcher.find()) {
                        values.add(matcher.group(2));
                    }
                }
                catch (BuildException e) {
                    PIActivator.getDefault().logError(e.getMessage());
                }
            }
        }
        if (this.pathPatterns.containsKey(optionId)) {
            for (String optionLine : this.getOpts(tool, piReader)) {
                Matcher pathMatcher = this.pathPatterns.get(option.getId()).matcher(optionLine);
                if (!pathMatcher.find()) continue;
                try {
                    if (option.getValueType() == 4) {
                        do {
                            if ((result = pathMatcher.group(1)) == null) continue;
                            values.add(QUOTE + this.replaceOldProjectLocationToNewInString(result, cfg, piReader) + QUOTE);
                        } while (pathMatcher.find());
                    }
                    if (option.getValueType() != 2) continue;
                    return new OptionDelta(cfg, (IHoldsOptions)tool, option, this.replaceOldProjectLocationToNewInString(pathMatcher.group(1), cfg, piReader));
                }
                catch (BuildException e) {
                    PIActivator.getDefault().logError(e.getMessage());
                }
            }
        }
        return !values.isEmpty() ? new OptionDelta(cfg, (IHoldsOptions)tool, option, values.toArray(new String[values.size()])) : null;
    }

    private List<String> getOpts(ITool tool, PIReader piReader) {
        if (this.isCCompiler(tool)) {
            return piReader.getOptionsCC();
        }
        if (this.isAssembler(tool)) {
            return piReader.getOptionsASM();
        }
        if (this.isLinker(tool)) {
            return piReader.getOptionsLinker();
        }
        PIActivator.getDefault().logWarning("Unknown tool: " + tool + " (" + tool.getId() + ")");
        return Collections.emptyList();
    }

    @Override
    public boolean isAssembler(ITool tool) {
        String toolId = tool.getId();
        return toolId.startsWith("iar.arm.toolchain.assembler.v5.4.0") || toolId.startsWith("iar.arm.toolchain.assembler.v8.0.0");
    }

    @Override
    public boolean isCCompiler(ITool tool) {
        String toolId = tool.getId();
        return toolId.startsWith("iar.arm.toolchain.compiler.v5.4.1") || toolId.startsWith("iar.arm.toolchain.compiler.v8.0.0");
    }

    @Override
    public boolean isLinker(ITool tool) {
        String toolId = tool.getId();
        return toolId.startsWith("iar.arm.toolchain.linker.v5.4.0") || toolId.startsWith("iar.arm.toolchain.linker.v8.0.0");
    }

    @Override
    public boolean isFits(IToolChain toolchain) {
        return toolchain.getId().startsWith("iar.arm.toolchain.v6.1.0") || toolchain.getId().startsWith("iar.arm.toolchain.v8.0.0");
    }
}

