/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.hardware.debugger.core;

import com.nxp.s32ds.cle.runtime.hardware.debugger.DeviceDebuggerDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.debugger.DeviceDebuggerRegistry;
import com.nxp.s32ds.cle.runtime.hardware.internal.debugger.core.HardwareDebuggerCoreActivator;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.FamilyDescriptors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class DeviceDebuggerDescriptors {
    public static DeviceDebuggerRegistry getDeviceDebuggerRegistry() {
        DeviceDebuggerRegistry deviceRegistry = HardwareDebuggerCoreActivator.getInstance().getDeviceDebuggerRegistry();
        return deviceRegistry;
    }

    public static List<DeviceDebuggerDescriptor> getDeviceDebuggerDescriptors(String deviceId) {
        DeviceDebuggerRegistry deviceRegistry = HardwareDebuggerCoreActivator.getInstance().getDeviceDebuggerRegistry();
        return deviceRegistry.getDeviceDebuggerDescriptors().stream().filter(p -> p.getDeviceId().equals(deviceId)).collect(Collectors.toList());
    }

    public static List<DeviceDebuggerDescriptor> getDeviceDebuggerDescriptors() {
        DeviceDebuggerRegistry deviceRegistry = HardwareDebuggerCoreActivator.getInstance().getDeviceDebuggerRegistry();
        return deviceRegistry.getDeviceDebuggerDescriptors();
    }

    public static List<DeviceDebuggerDescriptor> getDeviceDebuggerDescriptors(String deviceId, String toolchainId) {
        if (toolchainId == null || deviceId == null) {
            return Collections.emptyList();
        }
        DeviceDebuggerRegistry deviceRegistry = HardwareDebuggerCoreActivator.getInstance().getDeviceDebuggerRegistry();
        return deviceRegistry.getDeviceDebuggerDescriptors().stream().filter(p -> deviceId.equals(p.getDeviceId())).filter(p -> toolchainId.equals(p.getToolchainId())).filter(p -> p.getDeviceRevision().isEmpty()).distinct().collect(Collectors.toList());
    }

    public static List<DeviceDebuggerDescriptor> getDeviceDebuggerDescriptors(String deviceId, String deviceRevision, String toolchainId) {
        DeviceDebuggerRegistry deviceRegistry = HardwareDebuggerCoreActivator.getInstance().getDeviceDebuggerRegistry();
        return deviceRegistry.getDeviceDebuggerDescriptors().stream().filter(p -> deviceId.equals(p.getDeviceId())).filter(p -> deviceRevision.equals(p.getDeviceRevision())).filter(p -> toolchainId.equals(p.getToolchainId())).distinct().collect(Collectors.toList());
    }

    public static List<DeviceDebuggerDescriptor> getDeviceDebuggerDescriptorByFamily(String familyId, String toolchainId) {
        List deviceDescriptors = FamilyDescriptors.getDeviceDescriptors((String)familyId);
        ArrayList<DeviceDebuggerDescriptor> deviceDebuggers = new ArrayList<DeviceDebuggerDescriptor>();
        for (DeviceDescriptor descriptor : deviceDescriptors) {
            deviceDebuggers.addAll(DeviceDebuggerDescriptors.getDeviceDebuggerDescriptors(descriptor.getId(), toolchainId));
        }
        ArrayList<DeviceDebuggerDescriptor> targetDeviceDebuggers = new ArrayList<DeviceDebuggerDescriptor>();
        for (DeviceDebuggerDescriptor source : deviceDebuggers) {
            boolean isExistInTarget = false;
            for (DeviceDebuggerDescriptor target : targetDeviceDebuggers) {
                if (!source.getDebuggerId().equals(target.getDebuggerId())) continue;
                isExistInTarget = true;
                break;
            }
            if (isExistInTarget) continue;
            targetDeviceDebuggers.add(source);
        }
        return targetDeviceDebuggers;
    }

    public static List<DeviceDebuggerDescriptor> getDeviceDebuggerDescriptorById(String debuggerId) {
        DeviceDebuggerRegistry deviceRegistry = HardwareDebuggerCoreActivator.getInstance().getDeviceDebuggerRegistry();
        return deviceRegistry.getDeviceDebuggerDescriptorsByDebuggerId(debuggerId);
    }

    public static String getInitializationScriptPath(String deviceId, String debuggerId) {
        DeviceDebuggerRegistry deviceDebuggerRegistry = HardwareDebuggerCoreActivator.getInstance().getDeviceDebuggerRegistry();
        List deviceDebuggerDescriptors = deviceDebuggerRegistry.getDeviceDebuggerDescriptors(deviceId);
        if (deviceDebuggerDescriptors.isEmpty()) {
            return "";
        }
        DeviceDebuggerDescriptor found = null;
        for (DeviceDebuggerDescriptor deviceDebuggerDescriptor : deviceDebuggerDescriptors) {
            if (!deviceDebuggerDescriptor.getDebuggerId().equals(debuggerId)) continue;
            found = deviceDebuggerDescriptor;
            break;
        }
        if (found == null) {
            return "";
        }
        String initializationScriptPath = found.getInitializationScriptPath(deviceId, debuggerId);
        if (initializationScriptPath == null) {
            return "";
        }
        return initializationScriptPath;
    }
}

