/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.checkers;

import com.freescale.s32ds.cross.core.ProjectContextSettings;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachStatuses;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.filtering.SdkFilteringUtils;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.FamilyDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.hardware.HardwareSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.lang.LangSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.platform.PlatformSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.toolchain.ToolChainSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.lang.LangSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.lang.LangSdkKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class SdkProjectCompatibilityChecker {
    private SdkProjectCompatibilityChecker() {
    }

    public static IStatus checkToolChainsCompatibility(Collection<String> sdkToolChainIds, IToolChain configToolChain) {
        return !SdkProjectCompatibilityChecker.hasToolChains(sdkToolChainIds) || SdkProjectCompatibilityChecker.matchToolchains(sdkToolChainIds, configToolChain) ? Status.OK_STATUS : SdkAttachStatuses.ERROR_SDK_TOOLCHAIN;
    }

    public static IStatus checkToolChainsCompatibility(SdkDescriptor sdk, IToolChain configToolChain) {
        List<String> sdkToolChainIds = ToolChainSdkDescriptors.getToolChainSdkDescriptorsBySdkId((String)sdk.getId()).stream().map(toolChainSdk -> toolChainSdk.getToolChainId().trim()).filter(toolChainId -> !toolChainId.isEmpty()).collect(Collectors.toList());
        return SdkProjectCompatibilityChecker.checkToolChainsCompatibility(sdkToolChainIds, configToolChain);
    }

    public static IStatus checkToolChainsCompatibility(String sdkToolchainId, String configToolchainId) {
        return !configToolchainId.matches(sdkToolchainId) ? SdkAttachStatuses.ERROR_SDK_TOOLCHAIN : Status.OK_STATUS;
    }

    public static IStatus checkToolChainsCompatibility(List<String> sdkToolChainsIds, List<IToolChain> projectToolChains) {
        List projectIdenticalToolChainIds = projectToolChains.stream().map(ToolChain.class::cast).flatMap(projectToolChain -> projectToolChain.getIdenticalList().stream()).map(IBuildObject::getBaseId).collect(Collectors.toList());
        if (sdkToolChainsIds.stream().anyMatch(projectIdenticalToolChainIds::contains)) {
            return Status.OK_STATUS;
        }
        return SdkAttachStatuses.ERROR_SDK_TOOLCHAIN;
    }

    private static boolean hasToolChains(Collection<String> toolChainsIds) {
        return toolChainsIds != null && toolChainsIds.stream().anyMatch(tcId -> Objects.nonNull(tcId) && !tcId.trim().isEmpty());
    }

    private static boolean matchToolchains(Collection<String> toolChainsIds, IToolChain toolChain) {
        IToolChain realToolChain = ManagedBuildManager.getRealToolChain((IToolChain)toolChain);
        String realToolChainId = realToolChain != null ? realToolChain.getBaseId() : "~";
        return toolChainsIds.stream().anyMatch(SdkProjectCompatibilityChecker.isMatchedWithToolChainId(toolChain.getId(), toolChain.getBaseId(), realToolChainId));
    }

    private static Predicate<? super String> isMatchedWithToolChainId(String cfgToolchainId, String cfgToolchainBaseId, String rtcId) {
        return sdkToolchainId -> sdkToolchainId == null || sdkToolchainId.trim().isEmpty() || cfgToolchainId.equals(sdkToolchainId) || cfgToolchainBaseId.equals(sdkToolchainId) || rtcId.equals(sdkToolchainId);
    }

    private static boolean isSdkAcceptsProjectSettingHardwareIds(String sdkId, IProject project) {
        IEclipsePreferences prefs = new ProjectScope(project).getNode("com.freescale.s32ds.cross.wizard");
        String processorId = prefs.get("processor", "");
        String coreId = prefs.get("coreType", "");
        if (!processorId.isEmpty() && !coreId.isEmpty()) {
            Map hwds = HardwareSdkDescriptors.getHardwareSdkDescriptorsIds((String)sdkId);
            Set devicesIds = (Set)hwds.get("com.nxp.s32ds.cle.runtime.hardware.registry.device.id");
            Set coresIds = (Set)hwds.get("com.nxp.s32ds.cle.runtime.hardware.registry.core.id");
            if (devicesIds.isEmpty() && coresIds.isEmpty()) {
                return true;
            }
            if (coreId.toLowerCase().startsWith(processorId.toLowerCase())) {
                coreId = coreId.substring(processorId.length() + 1);
            }
            String preparedCoreId = SdkFilteringUtils.unifyCoreKind(coreId);
            if (!coresIds.stream().noneMatch(sdkCoreId -> SdkFilteringUtils.unifyProcessor(sdkCoreId).equalsIgnoreCase(preparedCoreId))) {
                return false;
            }
            String preparedProcessorId = SdkFilteringUtils.unifyProcessor(processorId);
            if (!devicesIds.stream().noneMatch(sdkDeviceId -> SdkFilteringUtils.unifyProcessor(sdkDeviceId).equalsIgnoreCase(preparedProcessorId))) {
                return false;
            }
        }
        return true;
    }

    public static IStatus checkCore(String sdkId, IProject project) {
        return SdkProjectCompatibilityChecker.checkCoreInternal(project, sdkId) ? Status.OK_STATUS : SdkAttachStatuses.ERROR_SDK_PROCESSOR_CORE;
    }

    private static boolean checkCoreInternal(IProject project, String sdkId) {
        ProjectContextSettings context = new ProjectContextSettings(project);
        String projectDeviceCoreId = context.getDeviceCore2Context();
        String projectDeviceId = context.getDevice2Context();
        String projectCoreId = context.getCore2Context();
        String projectFamilyId = context.getFamily2Context();
        if (context.isLibrary() && projectDeviceId.isEmpty() && projectDeviceCoreId.isEmpty() && !projectFamilyId.isEmpty() && !projectCoreId.isEmpty()) {
            ArrayList deviceCores = new ArrayList();
            List devicesByFamily = FamilyDescriptors.getDeviceDescriptors((String)projectFamilyId);
            for (DeviceDescriptor device : devicesByFamily) {
                deviceCores.addAll(DeviceDescriptors.getDeviceCoreDescriptors((String)device.getId(), (String)projectCoreId));
            }
            for (DeviceCoreDescriptor deviceCore : deviceCores) {
                if (!SdkFilteringUtils.isSdkAcceptsProjectComponentHardwareIds(sdkId, deviceCore.getDeviceId(), deviceCore.getId(), deviceCore.getCoreId(), "")) continue;
                return true;
            }
        }
        if (!(projectDeviceId.isEmpty() && projectDeviceCoreId.isEmpty() && projectCoreId.isEmpty())) {
            String projectDeviceRevisionId = context.getDeviceRevision2Context();
            DeviceCoreDescriptor deviceCore = DeviceDescriptors.getDeviceCoreDescriptor((String)projectDeviceCoreId);
            if (deviceCore != null) {
                return SdkFilteringUtils.isSdkAcceptsProjectComponentHardwareIds(sdkId, deviceCore.getDeviceId(), deviceCore.getId(), deviceCore.getCoreId(), projectDeviceRevisionId);
            }
            return SdkFilteringUtils.isSdkAcceptsProjectComponentHardwareIds(sdkId, projectDeviceId, projectDeviceCoreId, projectCoreId, projectDeviceRevisionId);
        }
        return SdkProjectCompatibilityChecker.isSdkAcceptsProjectSettingHardwareIds(sdkId, project);
    }

    public static IStatus checkLanguage(String sdkId, IProject project) {
        LangSdkKind sdkLangKind;
        LangSdkKind projectLangKind = LangSdkKind.getByValue((String)new ProjectContextSettings(project).getLang2Context());
        LangSdkDescriptor sdkLang = LangSdkDescriptors.getLangSdkDescriptorBySdkId((String)sdkId);
        LangSdkKind langSdkKind = sdkLangKind = sdkLang != null ? sdkLang.getKind() : LangSdkKind.UNKNOWN;
        if (projectLangKind == sdkLangKind || LangSdkKind.UNKNOWN == projectLangKind || LangSdkKind.UNKNOWN == sdkLangKind || LangSdkKind.ALL == sdkLangKind) {
            return Status.OK_STATUS;
        }
        return SdkAttachStatuses.ERROR_SDK_LANGUAGE;
    }

    public static IStatus checkPlatform(IProject project, String sdkId) {
        String projectPlatformTarget = new ProjectContextSettings(project).getPlatform2Context();
        String sdkPlatformTarget = (String)PlatformSdkDescriptors.getPlatformSdkDescriptorsIds((String)sdkId).get("com.nxp.s32ds.cle.runtime.sdk.registry.platform.target");
        return sdkPlatformTarget.isEmpty() || sdkPlatformTarget.equalsIgnoreCase(projectPlatformTarget) ? Status.OK_STATUS : SdkAttachStatuses.ERROR_SDK_PLATFORM;
    }

    public static IStatus checkPlatformHost(IProject project, String sdkId) {
        String sdkPlatformHost = (String)PlatformSdkDescriptors.getPlatformSdkDescriptorsIds((String)sdkId).get("com.nxp.s32ds.cle.runtime.sdk.registry.platform.host");
        return sdkPlatformHost.isEmpty() || Platform.getOS().toLowerCase().startsWith(sdkPlatformHost) ? Status.OK_STATUS : SdkAttachStatuses.ERROR_SDK_PLATFORM;
    }
}

