/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.imports;

import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkDescriptorBuilder;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkEnvironmentUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkBasePathValidator;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.SdkDescriptorUtils;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkType;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.resource.ResourceSdkCore;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.resource.ResourceSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.symbol.SymbolSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkKind;
import com.nxp.s32ds.ext.rcp.registry.EntityDescriptor;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class McalSdkImporter {
    private static final String MCAL_CONFIG_INCLUDE_DIR = "include";
    private static final String MCAL_CONFIG_SOURCES_DIR = "src";
    private static final String MCAL_CONFIGURATOR_SUFFIX = "_config.xml";
    private static final String MCAL_GENERATED_TAG = "mcalgen";
    private static final String MCAL_CONFIG_MODULE_NAME = "CONFIG";
    private static final String COMMON_MODULE_CONFIG_KEY = "";
    private static Map<String, Set<String>> config2McalModule = new HashMap<String, Set<String>>();

    private McalSdkImporter() {
    }

    public static IStatus performImportMcalSdkByConfiguration(SdkDescriptor mcalSdkDescriptor, String mcalConfigPath, String sdkName, String sdkVersion) {
        String mcalSdkBasePath = mcalSdkDescriptor.getBasePath();
        String mcalConfiguratorPath = Paths.get(mcalSdkBasePath, String.valueOf(mcalSdkDescriptor.getName()) + MCAL_CONFIGURATOR_SUFFIX).toString();
        String mcalConfiguratorXml = McalSdkImporter.loadXml(mcalConfiguratorPath);
        if (mcalConfiguratorXml == null) {
            return Status.CANCEL_STATUS;
        }
        IStatus status = McalConfiguratorParser.initConfig2McalModuleMap(mcalConfiguratorXml, mcalConfiguratorPath);
        if (!status.isOK()) {
            McalSdkImporter.reportError(status.getMessage());
            return Status.CANCEL_STATUS;
        }
        String mcalConfigSdkName = String.valueOf(mcalSdkDescriptor.getName()) + "_CONFIG";
        SdkDescriptor mcalConfigSdk = McalSdkImporter.createMcalConfigSdk(mcalConfigPath, mcalConfigSdkName, mcalSdkDescriptor.getVersion());
        if (mcalConfigSdk == null) {
            return Status.CANCEL_STATUS;
        }
        SdkDescriptor mcalGeneratedSdk = McalSdkImporter.createMcalSdkByConfigurator(mcalSdkDescriptor, mcalConfigSdk);
        if (mcalGeneratedSdk == null) {
            return Status.CANCEL_STATUS;
        }
        if (McalSdkImporter.createImportMcalSdk(sdkName, sdkVersion, mcalSdkBasePath, mcalSdkDescriptor, mcalGeneratedSdk, mcalConfigSdk) == null) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public static IStatus checkMcalConfigDirectory(String mcalConfigPath) {
        if (mcalConfigPath == null || mcalConfigPath.isEmpty()) {
            IStatus errorStatus = SdkCoreActivator.getInstance().createError(NLS.bind((String)Messages.McalSdkImporter_mcal_config_path_not_valid, (Object)mcalConfigPath));
            McalSdkImporter.reportError(errorStatus);
            return errorStatus;
        }
        File mcalConfigDir = new File(mcalConfigPath);
        if (!mcalConfigDir.exists() || !mcalConfigDir.isDirectory()) {
            IStatus errorStatus = SdkCoreActivator.getInstance().createError(NLS.bind((String)Messages.McalSdkImporter_mcal_config_path_incorrect, (Object)mcalConfigPath));
            McalSdkImporter.reportError(errorStatus);
            return errorStatus;
        }
        return Status.OK_STATUS;
    }

    public static IStatus checkMcalDescriptorBasePath(String basePath) {
        return new SdkBasePathValidator().validate(basePath);
    }

    public static IStatus checkMcalConfigDirectoryStructure(String mcalConfigPath) {
        if (Paths.get(mcalConfigPath, new String[0]).getFileName() == null) {
            return SdkCoreActivator.getInstance().createError(NLS.bind((String)Messages.McalSdkImporter_mcal_config_path_incorrect, (Object)mcalConfigPath));
        }
        File mcalConfigHeadersDir = Paths.get(mcalConfigPath, MCAL_CONFIG_INCLUDE_DIR).toFile();
        if (!mcalConfigHeadersDir.exists() || !mcalConfigHeadersDir.isDirectory()) {
            return SdkCoreActivator.getInstance().createError(NLS.bind((String)Messages.McalSdkImporter_mcal_config_path_incorrect, (Object)mcalConfigHeadersDir));
        }
        File mcalConfigSourcesDir = Paths.get(mcalConfigPath, MCAL_CONFIG_SOURCES_DIR).toFile();
        if (!mcalConfigSourcesDir.exists() || !mcalConfigSourcesDir.isDirectory()) {
            return SdkCoreActivator.getInstance().createError(NLS.bind((String)Messages.McalSdkImporter_mcal_config_path_incorrect, (Object)mcalConfigSourcesDir));
        }
        return Status.OK_STATUS;
    }

    private static SdkDescriptor createMcalSdkByConfigurator(SdkDescriptor mcalSdk, SdkDescriptor mcalConfigSdk) {
        String sdkVersion;
        String sdkName = String.valueOf(mcalSdk.getName()) + "_GEN";
        String sdkId = SdkDescriptorUtils.makeId((String)sdkName, (String)(sdkVersion = mcalSdk.getVersion()));
        SdkDescriptor mcalGeneratedSdkDescriptor = SdkDescriptors.getSdkDescriptor((String)sdkId);
        if (mcalGeneratedSdkDescriptor != null) {
            return mcalGeneratedSdkDescriptor;
        }
        String mcalSdkBasePath = mcalSdk.getBasePath();
        SdkDescriptorBuilder builder = new SdkDescriptorBuilder();
        HashMap<String, String> sdkAttributes = new HashMap<String, String>();
        sdkAttributes.put("name", sdkName);
        sdkAttributes.put("version", sdkVersion);
        sdkAttributes.put("basePath", mcalSdkBasePath);
        sdkAttributes.put("targetFolderName", mcalSdk.getName());
        sdkAttributes.put("tags", MCAL_GENERATED_TAG);
        builder.createHeader(sdkAttributes, SdkType.INTERNAL);
        builder.setEnvironment(sdkId.toUpperCase(), mcalSdkBasePath, false);
        SymbolSdkDescriptors.getSymbolSdkDescriptorsBySdkId((String)mcalSdk.getId()).forEach(symbol -> {
            SdkDescriptorBuilder sdkDescriptorBuilder2 = builder.addSymbol(symbol.getName(), symbol.getKind());
        });
        Set<String> modules = McalSdkImporter.getModulesByConfigurator(mcalConfigSdk.getId());
        ResourceSdkKind.validValues().stream().flatMap(resourceType -> McalSdkImporter.getPathsByConfigurator(mcalSdk, resourceType, modules).stream()).forEach(resource -> {
            SdkDescriptorBuilder sdkDescriptorBuilder2 = builder.addResource(resource.getPath(), resource.getKind(), resource.isCopy());
        });
        builder.buildAndRegister();
        SdkDescriptor createdSdkDescriptor = SdkDescriptors.getSdkDescriptor((String)sdkId);
        if (createdSdkDescriptor != null) {
            SdkEnvironmentUtils.createEnvironment(createdSdkDescriptor);
            return createdSdkDescriptor;
        }
        return null;
    }

    private static List<ResourceSdkDescriptor> getPathsByConfigurator(SdkDescriptor mcalSdk, ResourceSdkKind resourceType, Set<String> modules) {
        ArrayList<ResourceSdkDescriptor> result = new ArrayList<ResourceSdkDescriptor>();
        List resources = ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndType((String)mcalSdk.getId(), (ResourceSdkKind)resourceType);
        for (ResourceSdkDescriptor mcalSdkResource : resources) {
            for (String moduleName : modules) {
                if (!mcalSdkResource.getPath().contains(moduleName)) continue;
                result.add(mcalSdkResource);
            }
        }
        return result;
    }

    private static Set<String> getModulesByConfigurator(String mcalConfigSdkId) {
        HashSet<String> result = new HashSet<String>();
        ResourceSdkDescriptors.getHeaderFileSdkDescriptors((String)mcalConfigSdkId).stream().map(d -> Paths.get(d.getPath(), new String[0])).forEach(p -> {
            result.addAll(config2McalModule.getOrDefault(p.getFileName().toString(), Collections.emptySet()));
            result.addAll(config2McalModule.getOrDefault(COMMON_MODULE_CONFIG_KEY, Collections.emptySet()));
        });
        return result;
    }

    private static SdkDescriptor createMcalConfigSdk(final String mcalConfigPath, String sdkName, String sdkVersion) {
        IStatus status = McalSdkImporter.checkMcalConfigDirectory(mcalConfigPath);
        if (!status.isOK()) {
            return null;
        }
        String generatedSdkName = McalSdkImporter.getGeneratedSdkName(sdkName);
        String sdkId = SdkDescriptorUtils.makeId((String)generatedSdkName, (String)sdkVersion);
        SdkDescriptor mcalConfigSdk = SdkDescriptors.getSdkDescriptor((String)sdkId);
        if (mcalConfigSdk != null) {
            return mcalConfigSdk;
        }
        final SdkDescriptorBuilder builder = new SdkDescriptorBuilder();
        HashMap<String, String> sdkAttributes = new HashMap<String, String>();
        sdkAttributes.put("name", generatedSdkName);
        sdkAttributes.put("version", sdkVersion);
        sdkAttributes.put("basePath", mcalConfigPath);
        sdkAttributes.put("targetFolderName", MCAL_CONFIG_MODULE_NAME);
        sdkAttributes.put("tags", MCAL_GENERATED_TAG);
        builder.createHeader(sdkAttributes, SdkType.INTERNAL);
        builder.setEnvironment(sdkId.toUpperCase(), mcalConfigPath, false);
        Path configPath = Paths.get(mcalConfigPath, new String[0]);
        try {
            Files.walkFileTree(configPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes ba) throws IOException {
                    String resourcePath;
                    String string = resourcePath = path.isAbsolute() ? Paths.get(mcalConfigPath, new String[0]).relativize(path).toString() : path.toString();
                    if (ResourceSdkCore.headerFilesMatcher.matches(path)) {
                        builder.addResource(resourcePath, ResourceSdkKind.HEADER_FILE, false);
                    } else if (ResourceSdkCore.sourceFilesMatcher.matches(path)) {
                        builder.addResource(resourcePath, ResourceSdkKind.SOURCE_FILE, false);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path path, IOException exc) throws IOException {
                    return FileVisitResult.SKIP_SUBTREE;
                }
            });
        }
        catch (IOException ioe) {
            SdkCoreActivator.getInstance().logError(NLS.bind((String)Messages.McalSdkImporter_error_parse_folder, (Object)configPath), ioe);
        }
        builder.buildAndRegister();
        mcalConfigSdk = SdkDescriptors.getSdkDescriptor((String)sdkId);
        if (mcalConfigSdk != null) {
            SdkEnvironmentUtils.createEnvironment(mcalConfigSdk);
            return mcalConfigSdk;
        }
        return mcalConfigSdk;
    }

    private static String getGeneratedSdkName(String sdkName) {
        StringBuilder sdkNumName = new StringBuilder(sdkName).append('_');
        List mcalConfigSdksNames = SdkDescriptors.getSdkDescriptors().stream().filter(sdk -> sdk.getName().startsWith(sdkName)).map(EntityDescriptor::getName).sorted((name1, name2) -> name1.compareTo((String)name2)).collect(Collectors.toList());
        if (!mcalConfigSdksNames.isEmpty()) {
            String name = (String)mcalConfigSdksNames.get(mcalConfigSdksNames.size() - 1);
            return sdkNumName.append(Integer.parseInt(name.substring(name.lastIndexOf(95) + 1)) + 1).toString();
        }
        return sdkNumName.append(0).toString();
    }

    private static SdkDescriptor createImportMcalSdk(String sdkName, String sdkVersion, String sdkBasePath, SdkDescriptor mcalBaseSdk, SdkDescriptor mcalGeneratedSdk, SdkDescriptor mcalConfigSdk) {
        boolean isImportMcalSdkDirCreated;
        String sdkId = SdkDescriptorUtils.makeId((String)sdkName, (String)sdkVersion);
        if (SdkDescriptors.getSdkDescriptor((String)sdkId) != null) {
            return null;
        }
        Path importMcalSdkPath = Paths.get(sdkBasePath, new String[0]).resolve(sdkName);
        File importMcalSdkDir = importMcalSdkPath.toFile();
        if (!(importMcalSdkDir.exists() && importMcalSdkDir.isDirectory() || (isImportMcalSdkDirCreated = importMcalSdkDir.mkdirs()))) {
            McalSdkImporter.reportError(NLS.bind((String)Messages.McalSdkImporter_error_create_base_path_folder, (Object)importMcalSdkPath));
            return null;
        }
        String importMcalSdkBasePath = importMcalSdkPath.toString();
        SdkDescriptorBuilder builder = new SdkDescriptorBuilder();
        HashMap<String, String> sdkAttributes = new HashMap<String, String>();
        sdkAttributes.put("name", sdkName);
        sdkAttributes.put("version", sdkVersion);
        sdkAttributes.put("basePath", importMcalSdkBasePath);
        sdkAttributes.put("isLoadedByUser", String.valueOf(true));
        builder.createHeader(sdkAttributes, SdkType.EXTERNAL);
        builder.setEnvironment(sdkId.toUpperCase(), importMcalSdkBasePath, false);
        builder.addModule(mcalBaseSdk.getId(), mcalBaseSdk.getName(), mcalGeneratedSdk.getId(), mcalGeneratedSdk.getDescription());
        builder.addModule(MCAL_CONFIG_MODULE_NAME, MCAL_CONFIG_MODULE_NAME, mcalConfigSdk.getId(), mcalConfigSdk.getDescription());
        builder.buildAndRegister();
        SdkDescriptor importMcalSdk = SdkDescriptors.getSdkDescriptor((String)sdkId);
        if (importMcalSdk != null) {
            SdkEnvironmentUtils.createEnvironment(importMcalSdk);
            return importMcalSdk;
        }
        return null;
    }

    private static String loadXml(String path) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader br = Files.newBufferedReader(Paths.get(path, new String[0]));){
                StringBuilder sb = new StringBuilder();
                br.lines().forEach(sb::append);
                return sb.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            McalSdkImporter.reportError(NLS.bind((String)Messages.McalSdkImporter_mcal_descriptor_read_error, (Object)path), ioe);
            return null;
        }
    }

    private static void reportError(String message) {
        McalSdkImporter.reportError(message, null);
    }

    private static void reportError(String message, Throwable e) {
        SdkCoreActivator.getInstance().logError(message, e);
    }

    private static void reportError(IStatus errorStatus) {
        SdkCoreActivator.getInstance().log(errorStatus);
    }

    private static class McalConfiguratorParser {
        private static final String MCAL_CONFIG_ROOT_ELEMENT = "mcal_config";
        private static final String MCAL_CONFIG_CONFIG_ELEMENT = "config";
        private static final String MCAL_CONFIG_CONFIG_ELEMENT_NAME_ATTRIBUTE = "name";
        private static final String MCAL_CONFIG_CONFIG_ELEMENT_MODULE_ATTRIBUTE = "module";

        private McalConfiguratorParser() {
        }

        private static IStatus initConfig2McalModuleMap(String mcalConfiguratorXml, String mcalConfiguratorPath) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (ByteArrayInputStream stream = new ByteArrayInputStream(mcalConfiguratorXml.getBytes(StandardCharsets.UTF_8));){
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                    documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", McalSdkImporter.COMMON_MODULE_CONFIG_KEY);
                    documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", McalSdkImporter.COMMON_MODULE_CONFIG_KEY);
                    DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
                    parser.setErrorHandler(new DefaultHandler());
                    Element mcalConfiguratorRootElement = parser.parse(stream).getDocumentElement();
                    if (!MCAL_CONFIG_ROOT_ELEMENT.equals(mcalConfiguratorRootElement.getTagName())) {
                        return SdkCoreActivator.getInstance().createError(NLS.bind((String)Messages.McalSdkImporter_mcal_descriptor_invalid_structure, (Object)mcalConfiguratorXml));
                    }
                    NodeList configElements = mcalConfiguratorRootElement.getElementsByTagName(MCAL_CONFIG_CONFIG_ELEMENT);
                    int count = configElements.getLength();
                    if (count == 0) {
                        return SdkCoreActivator.getInstance().createError(NLS.bind((String)Messages.McalSdkImporter_mcal_descriptor_missed_sdk_node, (Object)mcalConfiguratorXml));
                    }
                    int i = 0;
                    while (i < configElements.getLength()) {
                        Element configElement = (Element)configElements.item(i);
                        String configName = configElement.getAttribute(MCAL_CONFIG_CONFIG_ELEMENT_NAME_ATTRIBUTE);
                        String moduleName = configElement.getAttribute(MCAL_CONFIG_CONFIG_ELEMENT_MODULE_ATTRIBUTE);
                        config2McalModule.computeIfAbsent(configName, s -> new HashSet()).add(moduleName);
                        ++i;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                return SdkCoreActivator.getInstance().createError(NLS.bind((String)Messages.McalSdkImporter_mcal_descriptor_parse_error, (Object)mcalConfiguratorPath, (Object)e));
            }
            return Status.OK_STATUS;
        }
    }
}

