/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.load.parsers;

import com.nxp.s32ds.cle.cdt.sdk.core.load.LoadSdkException;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.fragment.FragmentsHelper;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.fragment.FragmentsHolder;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.parsers.AbstractSdkDescriptorParser;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.parsers.SdkDescriptorParsers;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.variable.VariablesHelper;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.variable.VariablesHolder;
import com.nxp.s32ds.cle.ide.sdk.core.utils.register.SdkDescriptorsRegitsrationHelper;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.SdkDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.SdkDescriptorUtils;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkType;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SdkDescriptorParser {
    private MultiStatus errorStatuses = SdkCoreActivator.getInstance().createMultiStatus(0, Messages.SdkDescriptorParser_error_load_sdks);

    public List<SdkDescriptor> reloadSdksFromDescriptor(String sdkDescriptorXml, SdkDescriptor sdkDescriptor, String descriptorPath, SdkType type, boolean isSdkLoadedByUser) throws LoadSdkException {
        String existingSdkXml = SdkManagementUtils.getSdksString(Collections.singletonList(sdkDescriptor));
        String sdkToReloadId = sdkDescriptor.getId();
        try {
            SdkDescriptorsRegitsrationHelper.unregisterSdkDescriptors((String)sdkToReloadId);
            return SdkDescriptorParser.loadSdksFromManifest(sdkDescriptorXml, descriptorPath, null, null, type, isSdkLoadedByUser, sdkToReloadId);
        }
        catch (LoadSdkException lse) {
            SdkDescriptorParser.loadSdksFromManifest(existingSdkXml, descriptorPath, null, null, type, isSdkLoadedByUser, sdkToReloadId);
            throw lse;
        }
    }

    public List<SdkDescriptor> loadSdksFromDescriptor(String descriptorXml, String descriptorPath, SdkType type, boolean isSdkLoadedByUser) throws LoadSdkException {
        return this.loadSdksFromDescriptor(descriptorXml, descriptorPath, type, isSdkLoadedByUser, (IProgressMonitor)new NullProgressMonitor());
    }

    public List<SdkDescriptor> loadSdksFromDescriptor(String descriptorXml, String descriptorPath, SdkType type, boolean isSdkLoadedByUser, IProgressMonitor progressMonitor) throws LoadSdkException {
        return SdkDescriptorParser.loadSdksFromManifest(descriptorXml, descriptorPath, null, null, type, isSdkLoadedByUser, progressMonitor);
    }

    public List<SdkDescriptor> loadSdks(String descriptorXml, String descriptorPath, IProject project, String alterEnvValue, SdkType type) throws LoadSdkException {
        return SdkDescriptorParser.loadSdksFromManifest(descriptorXml, descriptorPath, project, alterEnvValue, type, false);
    }

    private static List<SdkDescriptor> loadSdksFromManifest(String descriptorXml, String descriptorPath, IProject project, String alterEnvValue, SdkType type, boolean isLoadedByUser) throws LoadSdkException {
        return SdkDescriptorParser.loadSdksFromManifest(descriptorXml, descriptorPath, project, alterEnvValue, type, isLoadedByUser, (IProgressMonitor)new NullProgressMonitor());
    }

    private static List<SdkDescriptor> loadSdksFromManifest(String descriptorXml, String descriptorPath, IProject project, String alterEnvValue, SdkType type, boolean isLoadedByUser, IProgressMonitor progressMonitor) throws LoadSdkException {
        return SdkDescriptorParser.loadSdksFromManifest(descriptorXml, descriptorPath, project, alterEnvValue, type, isLoadedByUser, null, progressMonitor);
    }

    private static List<SdkDescriptor> loadSdksFromManifest(String descriptorXml, String descriptorPath, IProject project, String alterEnvValue, SdkType type, boolean isLoadedByUser, String sdkToLoadId) throws LoadSdkException {
        return SdkDescriptorParser.loadSdksFromManifest(descriptorXml, descriptorPath, project, alterEnvValue, type, isLoadedByUser, sdkToLoadId, (IProgressMonitor)new NullProgressMonitor());
    }

    private static List<SdkDescriptor> loadSdksFromManifest(String descriptorXml, String descriptorPath, IProject project, String alterEnvValue, SdkType type, boolean isLoadedByUser, String sdkToLoadId, IProgressMonitor progressMonitor) throws LoadSdkException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)ProgressCounter.TotalWork.getValue());
        ArrayList<SdkDescriptor> result = new ArrayList<SdkDescriptor>();
        try {
            Element rootElement = SdkDescriptorParser.getRootElement(descriptorXml);
            subMonitor.worked(ProgressCounter.GetRootElement.getValue());
            FragmentsHolder globalFragments = FragmentsHelper.loadFragments(rootElement);
            FragmentsHelper.performSdkFragmentsSubstitution(rootElement, globalFragments);
            subMonitor.worked(ProgressCounter.PerformSubstitution.getValue());
            Collection<Element> sdkElements = SdkDescriptorParser.getSdkElementsToProcess(rootElement);
            int len = sdkElements.size();
            for (Element sdkElement : sdkElements) {
                VariablesHolder sdkVariables = VariablesHelper.getMergedVariables(new VariablesHolder(sdkElement), new VariablesHolder(rootElement));
                FragmentsHolder sdkFragments = FragmentsHelper.getMergedFragments(sdkElement, globalFragments);
                NodeList templateElements = sdkElement.getElementsByTagName("template");
                subMonitor.worked(ProgressCounter.PreprocessingElement.getValue() / len);
                if (templateElements.getLength() == 1) {
                    String sdkTemplatePath = SdkDescriptorParser.getSdkTemplatePath((Element)templateElements.item(0), sdkVariables, descriptorPath);
                    String templateSdkXml = SdkDescriptorParser.loadSourceXml(new File(sdkTemplatePath));
                    subMonitor.worked(ProgressCounter.PreprocessingElement.getValue() / len);
                    result.addAll(SdkDescriptorParser.loadSdksFromTemplate(templateSdkXml, project, alterEnvValue, type, sdkVariables, sdkFragments, descriptorPath, isLoadedByUser, sdkToLoadId));
                    subMonitor.worked(ProgressCounter.LoadSDKFromTemplate.getValue() / len);
                } else {
                    SdkDescriptor parsedSdk;
                    AbstractSdkDescriptorParser parser = SdkDescriptorParsers.getParser(type, project, alterEnvValue, sdkVariables, sdkFragments, descriptorPath, isLoadedByUser);
                    subMonitor.worked(ProgressCounter.PreprocessingElement.getValue() / len);
                    if ((sdkToLoadId == null || sdkToLoadId.equals(SdkDescriptorUtils.makeId((Element)sdkElement))) && (parsedSdk = parser.parseSdkElement(sdkElement, (IProgressMonitor)subMonitor.split(ProgressCounter.ParseSDK.getValue() / len))) != null) {
                        result.add(parsedSdk);
                    }
                }
                subMonitor.worked(ProgressCounter.EndPreprocessing.getValue() / len);
            }
        }
        catch (LoadSdkException sle) {
            SdkCoreActivator.getInstance().logError(sle.getMessage(), (Throwable)((Object)sle));
            throw sle;
        }
        catch (CoreException ce) {
            throw new LoadSdkException(Messages.SdkDescriptorParser_error_load_sdks_invalid_xml_structure, ce);
        }
        subMonitor.done();
        return result;
    }

    public Map<String, Element> getElementsFromFragmentedManifest(String descriptorXml, String descriptorPath) throws LoadSdkException {
        HashMap<String, Element> fragmentedElements = new HashMap<String, Element>();
        try {
            Element rootElement = SdkDescriptorParser.getRootElement(descriptorXml);
            FragmentsHolder globalFragments = FragmentsHelper.loadFragments(rootElement);
            FragmentsHelper.performSdkFragmentsSubstitution(rootElement, globalFragments);
            Collection<Element> sdkElements = SdkDescriptorParser.getSdkElementsToProcess(rootElement);
            for (Element sdkElement : sdkElements) {
                VariablesHolder sdkVariables = VariablesHelper.getMergedVariables(new VariablesHolder(sdkElement), new VariablesHolder(rootElement));
                FragmentsHolder sdkFragments = FragmentsHelper.getMergedFragments(sdkElement, globalFragments);
                NodeList templateElements = sdkElement.getElementsByTagName("template");
                if (templateElements.getLength() != 1) continue;
                String sdkTemplatePath = SdkDescriptorParser.getSdkTemplatePath((Element)templateElements.item(0), sdkVariables, descriptorPath);
                String templateSdkXml = SdkDescriptorParser.loadSourceXml(new File(sdkTemplatePath));
                SdkDescriptorParser.storeElementsFromTemplate(templateSdkXml, sdkVariables, sdkFragments, fragmentedElements);
            }
        }
        catch (LoadSdkException sle) {
            SdkCoreActivator.getInstance().logError(sle.getMessage(), (Throwable)((Object)sle));
            throw sle;
        }
        catch (CoreException ce) {
            throw new LoadSdkException(Messages.SdkDescriptorParser_error_load_sdks_invalid_xml_structure, ce);
        }
        return fragmentedElements;
    }

    private static void storeElementsFromTemplate(String sourceXml, VariablesHolder templateSdkVariables, FragmentsHolder templateSdkFragments, Map<String, Element> fragmentedElements) throws LoadSdkException {
        Element rootElement = SdkDescriptorParser.getRootElement(sourceXml);
        FragmentsHolder globalFragments = FragmentsHelper.getMergedFragments(rootElement, templateSdkFragments);
        NodeList sdkNodes = rootElement.getElementsByTagName("sdk");
        int i = 0;
        while (i < sdkNodes.getLength()) {
            Element sdkElement = (Element)sdkNodes.item(i);
            FragmentsHolder sdkFragments = FragmentsHelper.getMergedFragments(sdkElement, globalFragments);
            String sdkId = SdkDescriptorParser.getSdkId(sdkElement, templateSdkVariables, sdkFragments);
            SdkDescriptorParser.parseSdkElement(sdkElement, templateSdkVariables);
            if (sdkId != null) {
                fragmentedElements.put(sdkId, sdkElement);
            }
            ++i;
        }
    }

    private static String getSdkId(Element sdkElement, VariablesHolder sdkVariables, FragmentsHolder fragments) {
        FragmentsHelper.performSdkFragmentsSubstitution(sdkElement, fragments);
        VariablesHelper.performSdkVariablesSubstitution(sdkElement, sdkVariables);
        return SdkDescriptorUtils.makeId((Element)sdkElement);
    }

    private static Collection<Element> getSdkElementsToProcess(Element rootElement) {
        ArrayList<Element> sdkElementsToProcess = new ArrayList<Element>();
        NodeList sdkNodes = rootElement.getElementsByTagName("sdk");
        int i = 0;
        while (i < sdkNodes.getLength()) {
            Element sdkElement = (Element)sdkNodes.item(i);
            sdkElementsToProcess.add(sdkElement);
            ++i;
        }
        return sdkElementsToProcess;
    }

    private static String getSdkTemplatePath(Element templateElement, VariablesHolder sdkVariables, String descriptorPath) throws CoreException {
        VariablesHelper.performSdkVariablesSubstitution(templateElement, sdkVariables);
        String path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(templateElement.getAttribute("path"), false);
        if (Objects.nonNull(descriptorPath) && !descriptorPath.isEmpty()) {
            path = Paths.get(descriptorPath, new String[0]).getParent().resolve(Paths.get(path, new String[0])).normalize().toString();
        }
        return path;
    }

    private static List<SdkDescriptor> loadSdksFromTemplate(String sourceXml, IProject project, String alterEnvValue, SdkType type, VariablesHolder templateSdkVariables, FragmentsHolder templateSdkFragments, String sdkDescriptorPath, boolean isSdkLoadedByUser, String sdkToLoadId) throws LoadSdkException {
        Element rootElement = SdkDescriptorParser.getRootElement(sourceXml);
        FragmentsHolder globalFragments = FragmentsHelper.getMergedFragments(rootElement, templateSdkFragments);
        ArrayList<SdkDescriptor> result = new ArrayList<SdkDescriptor>();
        NodeList sdkNodes = rootElement.getElementsByTagName("sdk");
        int i = 0;
        while (i < sdkNodes.getLength()) {
            SdkDescriptor parsedSdk;
            Element sdkElement = (Element)sdkNodes.item(i);
            FragmentsHolder sdkFragments = FragmentsHelper.getMergedFragments(sdkElement, globalFragments);
            if ((sdkToLoadId == null || sdkToLoadId.equals(SdkDescriptorParser.getSdkId(sdkElement, templateSdkVariables, sdkFragments))) && (parsedSdk = SdkDescriptorParser.parseSdkElement(sdkElement, project, alterEnvValue, type, templateSdkVariables, sdkFragments, sdkDescriptorPath, isSdkLoadedByUser)) != null) {
                result.add(parsedSdk);
            }
            ++i;
        }
        return result;
    }

    private static Element getRootElement(String sourceXml) throws LoadSdkException {
        if (sourceXml == null || sourceXml.length() == 0) {
            throw new LoadSdkException(Messages.SdkDescriptorParser_error_load_sdks_empty_descriptor);
        }
        Element root = null;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayInputStream bais = new ByteArrayInputStream(sourceXml.getBytes(StandardCharsets.UTF_8));){
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
                parser.setErrorHandler(new DefaultHandler());
                root = parser.parse(bais).getDocumentElement();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new LoadSdkException(Messages.SdkDescriptorParser_error_load_sdks_invalid_xml_structure, e);
        }
        if (!"sdks".equals(root.getNodeName())) {
            throw new LoadSdkException(Messages.SdkDescriptorParser_error_load_sdks_invalid_root_tag);
        }
        return root;
    }

    private static SdkDescriptor parseSdkElement(Element sdkElement, IProject project, String alterEnvValue, SdkType type, VariablesHolder sdkVariables, FragmentsHolder fragments, String sdkDescriptorPath, boolean isLoadedByUser) {
        SdkDescriptor parsedSdk = null;
        try {
            AbstractSdkDescriptorParser parser = SdkDescriptorParsers.getParser(type, project, alterEnvValue, sdkVariables, fragments, sdkDescriptorPath, isLoadedByUser);
            parsedSdk = parser.parseSdkElement(sdkElement);
            if (parsedSdk == null) {
                SdkCoreActivator.getInstance().logError(NLS.bind((String)Messages.SdkDescriptorParser_error_load_sdk, (Object)sdkElement.getAttribute("name"), (Object)sdkElement.getAttribute("version")));
            }
        }
        catch (LoadSdkException sle) {
            SdkCoreActivator.getInstance().logError(sle.getMessage(), (Throwable)((Object)sle));
        }
        return parsedSdk;
    }

    public Map<String, SdkDescriptor> loadSdksHeaders(String sourceXml) throws LoadSdkException {
        if (sourceXml == null || sourceXml.trim().isEmpty()) {
            throw new LoadSdkException(Messages.SdkDescriptorParser_error_load_sdks_empty_descriptor);
        }
        HashMap<String, SdkDescriptor> result = new HashMap<String, SdkDescriptor>();
        NodeList sdkNodes = SdkDescriptorParser.getRootElement(sourceXml).getElementsByTagName("sdk");
        int i = 0;
        while (i < sdkNodes.getLength()) {
            Element sdkNode = (Element)sdkNodes.item(i);
            result.put(SdkDescriptorParser.getSdkId(sdkNode), (SdkDescriptor)new SdkDescriptorImplementation(sdkNode));
            ++i;
        }
        return result;
    }

    public List<String> loadSdkIdsFromHeaders(String sourceXml) throws LoadSdkException {
        if (sourceXml == null || sourceXml.trim().isEmpty()) {
            throw new LoadSdkException(Messages.SdkDescriptorParser_error_load_sdks_empty_descriptor);
        }
        LinkedList<String> sdkIds = new LinkedList<String>();
        NodeList sdkNodes = SdkDescriptorParser.getRootElement(sourceXml).getElementsByTagName("sdk");
        int i = 0;
        while (i < sdkNodes.getLength()) {
            Element sdkNode = (Element)sdkNodes.item(i);
            sdkIds.add(SdkDescriptorParser.getSdkId(sdkNode));
            ++i;
        }
        return sdkIds;
    }

    public SdkDescriptor loadImportingSdk(String sourceXml, String sdkId, IProject project, String alterEnvValue, Map<String, String> changedAttributes) throws LoadSdkException {
        NodeList sdkNodes = SdkDescriptorParser.getRootElement(sourceXml).getElementsByTagName("sdk");
        if (sdkNodes == null || sdkNodes.getLength() == 0) {
            throw new LoadSdkException(Messages.SdkDescriptorParser_error_load_sdks_invalid_xml_structure);
        }
        SdkDescriptor sdk = null;
        int i = 0;
        while (i < sdkNodes.getLength()) {
            Element element = (Element)sdkNodes.item(i);
            String elementSdkId = SdkDescriptorParser.getSdkId(element);
            if (elementSdkId.equals(sdkId)) {
                element.removeAttribute("id");
                element.setAttribute("name", changedAttributes.get("name"));
                element.setAttribute("version", changedAttributes.get("version"));
                element.setAttribute("basePath", alterEnvValue);
                sdk = SdkDescriptorParsers.getParser(SdkType.IMPORTED, project, alterEnvValue, null).parseSdkElement(element);
                break;
            }
            ++i;
        }
        if (sdk == null) {
            throw new LoadSdkException("Unable to load SDK due to error.");
        }
        return SdkDescriptors.getSdkDescriptor((String)sdk.getId());
    }

    public MultiStatus getParsingErrors() {
        return !this.errorStatuses.isOK() ? this.errorStatuses : SdkCoreActivator.getInstance().createMultiStatus();
    }

    private static String loadSourceXml(File sourceXmlFile) throws LoadSdkException {
        String sourceXml = null;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(sourceXmlFile));){
                sourceXml = SdkManagementUtils.getSdksManifestXml(bis);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            throw new LoadSdkException("Unable to load SDK manifest due to error.", ioe);
        }
        return sourceXml;
    }

    private static String getSdkId(Element sdkElement) {
        String sdkId = sdkElement.getAttribute("id");
        return !sdkId.isEmpty() ? sdkId : SdkDescriptorUtils.makeId((Element)sdkElement);
    }

    private static void parseSdkElement(Element sdkElement, VariablesHolder sdkVariables) {
        SdkDescriptorParser.parseSubElement(sdkElement, sdkVariables, "symbols", "symbol");
        SdkDescriptorParser.parseSubElement(sdkElement, sdkVariables, "modules", "module");
    }

    private static void parseSubElement(Element sdkElement, VariablesHolder sdkVariables, String elementTag, String elementSubTag) {
        SdkDescriptorParser.getChildElements(sdkElement, elementTag).stream().flatMap(modulesEl -> SdkDescriptorParser.getChildElements(modulesEl, elementSubTag).stream()).forEach(moduleElement -> VariablesHelper.performSdkVariablesSubstitution(moduleElement, sdkVariables));
    }

    public static Collection<Element> getChildElements(Element parentElement, String ... childElementNames) {
        ArrayList<Element> elements = new ArrayList<Element>();
        List<String> filterNames = Arrays.asList(childElementNames);
        NodeList nodeList = parentElement.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (filterNames.contains(node.getNodeName()) || filterNames.isEmpty()) {
                elements.add((Element)Element.class.cast(node));
            }
            ++i;
        }
        return elements;
    }

    private static enum ProgressCounter {
        TotalWork(100),
        GetRootElement(5),
        PerformSubstitution(5),
        PreprocessingElement(5),
        LoadSDKFromTemplate(80),
        ParseSDK(80),
        EndPreprocessing(5);

        private final int value;

        private ProgressCounter(int work) {
            this.value = work;
        }

        public int getValue() {
            return this.value;
        }
    }
}

